/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiExpressionPattern;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PsiMethodCallPattern
extends PsiExpressionPattern<PsiMethodCallExpression, PsiMethodCallPattern> {
    PsiMethodCallPattern() {
        super(PsiMethodCallExpression.class);
    }

    public PsiMethodCallPattern withArguments(final ElementPattern<? extends PsiExpression> ... arguments) {
        return (PsiMethodCallPattern)this.with((PatternCondition)new PatternCondition<PsiMethodCallExpression>("withArguments"){

            public boolean accepts(@NotNull PsiMethodCallExpression callExpression, ProcessingContext context) {
                PsiExpression[] actualArguments = callExpression.getArgumentList().getExpressions();
                if (arguments.length != actualArguments.length) {
                    return false;
                }
                for (int i = 0; i < actualArguments.length; ++i) {
                    if (arguments[i].accepts((Object)actualArguments[i], context)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public PsiMethodCallPattern withQualifier(final ElementPattern<? extends PsiExpression> qualifier) {
        return (PsiMethodCallPattern)this.with((PatternCondition)new PatternCondition<PsiMethodCallExpression>("withQualifier"){

            public boolean accepts(@NotNull PsiMethodCallExpression psiMethodCallExpression, ProcessingContext context) {
                return qualifier.accepts((Object)psiMethodCallExpression.getMethodExpression().getQualifierExpression(), context);
            }
        });
    }
}

