/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiManager;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaSdk
extends SdkType
implements JavaSdkType {
    public static JavaSdk getInstance() {
        return (JavaSdk)((Object)SdkType.EP_NAME.findExtension(JavaSdk.class));
    }

    public JavaSdk(@NotNull String name) {
        super(name);
    }

    public boolean isRelevantForFile(@NotNull Project project, @NotNull VirtualFile file) {
        return PsiManager.getInstance((Project)project).findFile(file) instanceof PsiClassOwner;
    }

    @NotNull
    public final Sdk createJdk(@NotNull String jdkName, @NotNull String jreHome) {
        return this.createJdk(jdkName, jreHome, true);
    }

    @NotNull
    public abstract Sdk createJdk(@NotNull String var1, @NotNull String var2, boolean var3);

    @Nullable
    public abstract JavaSdkVersion getVersion(@NotNull Sdk var1);

    public abstract boolean isOfVersionOrHigher(@NotNull Sdk var1, @NotNull JavaSdkVersion var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean checkForJdk(@NotNull File file) {
        return JdkUtil.checkForJdk((File)file);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean checkForJre(@NotNull String file) {
        return JdkUtil.checkForJre((String)file);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public abstract JavaSdkVersion getVersion(@NotNull String var1);
}

