/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentUtil {
    public static DeploymentUtil getInstance() {
        return (DeploymentUtil)ServiceManager.getService(DeploymentUtil.class);
    }

    public static String trimForwardSlashes(@NotNull String path) {
        while (path.length() != 0 && (path.charAt(0) == '/' || path.charAt(0) == File.separatorChar)) {
            path = path.substring(1);
        }
        return path;
    }

    public static String concatPaths(String ... paths) {
        StringBuilder builder = new StringBuilder();
        for (String path : paths) {
            if (path.length() == 0) continue;
            int len = builder.length();
            if (len > 0 && builder.charAt(len - 1) != '/' && builder.charAt(len - 1) != File.separatorChar) {
                builder.append('/');
            }
            builder.append(len != 0 ? DeploymentUtil.trimForwardSlashes(path) : path);
        }
        return builder.toString();
    }

    public static String appendToPath(@NotNull String basePath, @NotNull String relativePath) {
        boolean startsWithSlash;
        boolean endsWithSlash = StringUtil.endsWithChar((CharSequence)basePath, (char)'/') || StringUtil.endsWithChar((CharSequence)basePath, (char)'\\');
        boolean bl = startsWithSlash = StringUtil.startsWithChar((CharSequence)relativePath, (char)'/') || StringUtil.startsWithChar((CharSequence)relativePath, (char)'\\');
        String tail = endsWithSlash && startsWithSlash ? DeploymentUtil.trimForwardSlashes(relativePath) : (!endsWithSlash && !startsWithSlash && basePath.length() > 0 && relativePath.length() > 0 ? "/" + relativePath : relativePath);
        return basePath + tail;
    }

    @Nullable
    public abstract String getConfigFileErrorMessage(ConfigFile var1);
}

