/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.JvmExceptionOccurrenceFilter;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AdvancedExceptionFilter
extends ExceptionFilter {
    AdvancedExceptionFilter(@NotNull GlobalSearchScope scope) {
        super(scope);
    }

    @Override
    @NotNull
    List<Filter.ResultItem> getExceptionClassNameItems(ExceptionInfo prevLineException) {
        ExceptionInfoCache.ClassResolveInfo info = this.myCache.resolveClass(prevLineException.getExceptionClassName());
        ArrayList classMap = new ArrayList();
        info.myClasses.forEach((key, value) -> {
            PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)value, PsiClass.class);
            if (psiClass != null && (DumbService.isDumb((Project)psiClass.getProject()) || InheritanceUtil.isInheritor(psiClass, "java.lang.Throwable"))) {
                classMap.add(psiClass);
            }
        });
        ArrayList<Filter.ResultItem> exceptionResults = new ArrayList<Filter.ResultItem>();
        if (!classMap.isEmpty()) {
            JvmExceptionOccurrenceFilter.EP_NAME.forEachExtensionSafe(filter2 -> {
                Filter.ResultItem res = filter2.applyFilter(prevLineException.getExceptionClassName(), classMap, prevLineException.getClassNameOffset());
                ContainerUtil.addIfNotNull((Collection)exceptionResults, (Object)res);
            });
        }
        return exceptionResults;
    }
}

