/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiNameValuePair;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotationInvocationHandler
implements InvocationHandler {
    @NotNull
    private final Class<? extends Annotation> myType;
    @NotNull
    private final PsiAnnotation myAnnotation;

    AnnotationInvocationHandler(@NotNull Class<? extends Annotation> type, @NotNull PsiAnnotation annotation) {
        this.myType = type;
        this.myAnnotation = annotation;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        assert (method.getParameterCount() == 0) : Arrays.toString(method.getParameterTypes());
        String member = method.getName();
        if (member.equals("toString")) {
            return this.toStringImpl();
        }
        if (member.equals("annotationType")) {
            return this.myType;
        }
        Pair<Object, String> pair = AnnotationInvocationHandler.attributeValueOrError(this.myAnnotation, this.myType, member);
        Object value = pair.first;
        if (value == null) {
            String error = (String)pair.second;
            String message = member + ". (Unable to find attribute in '" + this.myAnnotation.getText() + "': " + error + ")";
            throw new IncompleteAnnotationException(this.myType, message);
        }
        return value;
    }

    @NotNull
    private static Pair<Object, String> attributeValueOrError(@NotNull PsiAnnotation annotation, Class<? extends Annotation> type, @Nullable @NonNls String attributeName) {
        Method method;
        PsiAnnotationMemberValue value;
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute(annotation, attributeName);
        PsiAnnotationMemberValue psiAnnotationMemberValue = value = attribute == null ? null : attribute.getValue();
        if (value != null) {
            Object result = JavaPsiFacade.getInstance(annotation.getProject()).getConstantEvaluationHelper().computeConstantExpression(value);
            if (result == null) {
                return Pair.create(null, (Object)("Unable to evaluate annotation value '" + value.getText() + "'"));
            }
            return Pair.create((Object)result, null);
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        try {
            method = type.getMethod(attributeName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return Pair.create(null, (Object)("Method not found: " + attributeName));
        }
        Object defaultValue = method.getDefaultValue();
        if (defaultValue == null) {
            return Pair.create(null, (Object)("No default value is specified for method " + attributeName));
        }
        return Pair.create((Object)defaultValue, null);
    }

    private String toStringImpl() {
        PsiNameValuePair[] attributes;
        StringBuilder result = new StringBuilder(128);
        result.append('@');
        result.append(this.myType.getName());
        result.append('(');
        boolean firstMember = true;
        for (PsiNameValuePair e : attributes = this.myAnnotation.getParameterList().getAttributes()) {
            if (firstMember) {
                firstMember = false;
            } else {
                result.append(", ");
            }
            result.append(e.getName());
            result.append('=');
            PsiAnnotationMemberValue value = e.getValue();
            result.append(value == null ? "null" : value.getText());
        }
        result.append(')');
        return result.toString();
    }
}

