/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\b\u0006\u001a.\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a:\u0010\u0005\u001a\u00020\f\"\u0004\b\u0000\u0010\u00072\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u001a\u0010\u0019\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a#\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0016\"\u00020\u0006\u00a2\u0006\u0002\u0010\u001d\u001a\u0012\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u0012\u0010 \u001a\u00020\u0006*\u00020\u00062\u0006\u0010!\u001a\u00020\u0006\u001a\u0010\u0010\u0005\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00060\"\u001a\n\u0010#\u001a\u00020\u0006*\u00020\u0006\u001a\u0010\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\u001a\n\u0010&\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010'\u001a\u00020\u0006*\u00020\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"CR", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "LF", "Ljava/util/regex/Pattern;", "combineAsCamelCase", "", "T", "objectList", "", "mapFunction", "Lkotlin/Function1;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toLineSeparator", "separator", "input", "toStrings", "", "objects", "", "", "([Ljava/lang/Object;)Ljava/util/List;", "appendCamelCase", "word", "appendCapitalized", "words", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "word1", "word2", "capitalizeAndAppend", "suffix", "", "toSystemLineSeparator", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "usLocaleCapitalize", "usLocaleDecapitalize", "android.sdktools.common"})
@JvmName(name="StringHelper")
public final class StringHelper {
    private static final CharMatcher CR = CharMatcher.is((char)'\r');
    private static final Pattern LF = Pattern.compile("\n", 16);

    @NotNull
    public static final StringBuilder appendCapitalized(@NotNull StringBuilder $this$appendCapitalized, @NotNull String word) {
        CharSequence charSequence = word;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return $this$appendCapitalized;
        }
        int c = word.charAt(0);
        if (c >= 55296 && c <= 56319) {
            String string = word;
            int n = 0;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            c = string2.codePointAt(n);
            int charCount = Character.charCount(c);
            String string3 = word;
            int n2 = 0;
            boolean bl3 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n2, charCount);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string5;
            Locale locale = Locale.US;
            bl3 = false;
            String string6 = string3;
            boolean bl4 = false;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toUpperCase(locale)");
            String upperString = string8;
            $this$appendCapitalized.append(upperString);
            $this$appendCapitalized.append(word, charCount, word.length());
        } else {
            char c2;
            int result = Character.toUpperCase(c);
            char upperChar = '\u0000';
            if (result != -1) {
                c2 = (char)result;
            } else {
                String string = word;
                int n = 0;
                int n3 = 1;
                boolean bl5 = false;
                String string9 = string;
                if (string9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.substring(n, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = string10;
                Locale locale = Locale.US;
                n3 = 0;
                String string11 = string;
                boolean bl6 = false;
                String string12 = string11;
                if (string12 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string13 = string12.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.String).toUpperCase(locale)");
                c2 = string13.charAt(0);
            }
            upperChar = c2;
            $this$appendCapitalized.append(upperChar);
            $this$appendCapitalized.append(word, 1, word.length());
        }
        return $this$appendCapitalized;
    }

    @NotNull
    public static final String usLocaleCapitalize(@NotNull String $this$usLocaleCapitalize) {
        StringBuilder sb = new StringBuilder($this$usLocaleCapitalize.length());
        StringHelper.appendCapitalized(sb, $this$usLocaleCapitalize);
        return sb.toString();
    }

    @NotNull
    public static final String usLocaleDecapitalize(@NotNull String $this$usLocaleDecapitalize) {
        CharSequence charSequence = $this$usLocaleDecapitalize;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return $this$usLocaleDecapitalize;
        }
        StringBuilder sb = new StringBuilder($this$usLocaleDecapitalize.length());
        String string = $this$usLocaleDecapitalize;
        int n = 0;
        int n2 = 1;
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        Locale locale = Locale.US;
        n2 = 0;
        String string4 = string;
        boolean bl3 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
        sb.append(string6);
        string = $this$usLocaleDecapitalize;
        int n3 = 1;
        n2 = 0;
        String string7 = string;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n3);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        sb.append(string8);
        return sb.toString();
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, @NotNull String word) {
        StringBuilder sb = new StringBuilder($this$appendCapitalized.length() + word.length());
        sb.append($this$appendCapitalized);
        StringHelper.appendCapitalized(sb, word);
        return sb.toString();
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, @NotNull String word1, @NotNull String word2) {
        StringBuilder sb = new StringBuilder($this$appendCapitalized.length() + word1.length() + word2.length());
        sb.append($this$appendCapitalized);
        StringHelper.appendCapitalized(sb, word1);
        StringHelper.appendCapitalized(sb, word2);
        return sb.toString();
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, String ... words) {
        int length = $this$appendCapitalized.length();
        int max = words.length;
        for (int i2 = 0; i2 < max; ++i2) {
            length += words[i2].length();
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append($this$appendCapitalized);
        for (String word : words) {
            StringHelper.appendCapitalized(sb, word);
        }
        return sb.toString();
    }

    @NotNull
    public static final String capitalizeAndAppend(@NotNull String $this$capitalizeAndAppend, @NotNull String suffix) {
        StringBuilder sb = new StringBuilder($this$capitalizeAndAppend.length() + suffix.length());
        StringHelper.appendCapitalized(sb, $this$capitalizeAndAppend);
        sb.append(suffix);
        return sb.toString();
    }

    @NotNull
    public static final StringBuilder appendCamelCase(@NotNull StringBuilder $this$appendCamelCase, @NotNull String word) {
        CharSequence charSequence = $this$appendCamelCase;
        boolean bl = false;
        if (charSequence.length() == 0) {
            $this$appendCamelCase.append(word);
        } else {
            StringHelper.appendCapitalized($this$appendCamelCase, word);
        }
        return $this$appendCamelCase;
    }

    @NotNull
    public static final String combineAsCamelCase(@NotNull Iterable<String> $this$combineAsCamelCase) {
        int count = 0;
        for (String s : $this$combineAsCamelCase) {
            count += s.length();
        }
        StringBuilder sb = new StringBuilder(count);
        boolean first = true;
        for (String str : $this$combineAsCamelCase) {
            if (first) {
                sb.append(str);
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb, str);
        }
        return sb.toString();
    }

    @NotNull
    public static final <T> String combineAsCamelCase(@NotNull Collection<? extends T> objectList, @NotNull Function1<? super T, String> mapFunction) {
        StringBuilder sb = new StringBuilder(objectList.size() * 20);
        StringHelper.combineAsCamelCase(sb, objectList, mapFunction);
        return sb.toString();
    }

    public static final <T> void combineAsCamelCase(@NotNull StringBuilder sb, @NotNull Collection<? extends T> objectList, @NotNull Function1<? super T, String> mapFunction) {
        boolean first = true;
        for (T obj : objectList) {
            if (first) {
                sb.append((String)mapFunction.invoke(obj));
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb, (String)mapFunction.invoke(obj));
        }
    }

    @NotNull
    public static final List<String> toStrings(Object ... objects) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object path : objects) {
            if (path instanceof String) {
                builder.add(path);
                continue;
            }
            if (path instanceof Collection) {
                for (Object item : (Collection)path) {
                    if (item instanceof String) {
                        builder.add(item);
                        continue;
                    }
                    builder.add((Object)path.toString());
                }
                continue;
            }
            builder.add((Object)path.toString());
        }
        return (List)builder.build();
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String $this$tokenizeCommandLineToEscaped) {
        return new TokenizedCommandLine($this$tokenizeCommandLineToEscaped, false, 0, null, 12, null).toTokenList();
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String $this$tokenizeCommandLineToRaw) {
        return new TokenizedCommandLine($this$tokenizeCommandLineToRaw, true, 0, null, 12, null).toTokenList();
    }

    @NotNull
    public static final String toSystemLineSeparator(@NotNull String $this$toSystemLineSeparator) {
        return StringHelper.toLineSeparator(System.lineSeparator(), $this$toSystemLineSeparator);
    }

    private static final String toLineSeparator(String separator, String input) {
        String unixStyle = CR.matchesAnyOf((CharSequence)input) ? CR.removeFrom((CharSequence)input) : input;
        return Intrinsics.areEqual((Object)separator, (Object)"\n") ? unixStyle : LF.matcher(unixStyle).replaceAll("\r\n");
    }
}

