/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.test;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.streams.psi.impl.JavaChainTransformerImpl;
import com.intellij.debugger.streams.psi.impl.JavaStreamChainBuilder;
import com.intellij.debugger.streams.psi.impl.PackageChainDetector;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightJavaCodeInsightTestCase;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class StreamChainBuilderTestCase
extends LightJavaCodeInsightTestCase {
    private final StreamChainBuilder myBuilder = new JavaStreamChainBuilder(new JavaChainTransformerImpl(), PackageChainDetector.Companion.forJavaStreams("java.util.stream"));

    @NotNull
    protected String getTestDataPath() {
        return new File(PluginPathManager.getPluginHomePath((String)"stream-debugger") + "/testData/" + this.getRelativeTestPath()).getAbsolutePath();
    }

    @NotNull
    protected PsiElement configureAndGetElementAtCaret() {
        String name = File.separator + this.getTestName(false) + this.getFileExtension();
        this.configureByFile(name);
        PsiFile file = this.getFile();
        int offset = this.getEditor().getCaretModel().getCurrentCaret().getOffset();
        PsiElement elementAtCaret = DebuggerUtilsEx.findElementAt((PsiFile)file, (int)offset);
        StreamChainBuilderTestCase.assertNotNull((Object)elementAtCaret);
        return elementAtCaret;
    }

    @NotNull
    protected StreamChainBuilder getChainBuilder() {
        return this.myBuilder;
    }

    protected List<StreamChain> buildChains() {
        return (List)ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement elementAtCaret = this.configureAndGetElementAtCaret();
            StreamChainBuilderTestCase.assertNotNull((Object)elementAtCaret);
            StreamChainBuilder builder = this.getChainBuilder();
            StreamChainBuilderTestCase.assertTrue((boolean)builder.isChainExists(elementAtCaret));
            return builder.build(elementAtCaret);
        });
    }

    protected String getFileExtension() {
        return ".java";
    }

    @NotNull
    protected abstract String getRelativeTestPath();
}

