/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.debugger.streams.psi.ChainTransformer;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTypes;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.wrapper.CallArgument;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.debugger.streams.wrapper.impl.CallArgumentImpl;
import com.intellij.debugger.streams.wrapper.impl.IntermediateStreamCallImpl;
import com.intellij.debugger.streams.wrapper.impl.QualifierExpressionImpl;
import com.intellij.debugger.streams.wrapper.impl.StreamChainImpl;
import com.intellij.debugger.streams.wrapper.impl.TerminatorStreamCallImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JavaChainTransformerImpl
implements ChainTransformer.Java {
    @Override
    @NotNull
    public StreamChain transform(@NotNull List<PsiMethodCallExpression> streamExpressions, @NotNull PsiElement context) {
        PsiMethodCallExpression firstCall = streamExpressions.get(0);
        PsiExpression qualifierExpression = firstCall.getMethodExpression().getQualifierExpression();
        PsiType qualifierType = qualifierExpression == null ? null : qualifierExpression.getType();
        GenericType typeAfterQualifier = qualifierType == null ? JavaChainTransformerImpl.getGenericTypeOfThis(qualifierExpression) : JavaTypes.INSTANCE.fromStreamPsiType(qualifierType);
        QualifierExpressionImpl qualifier = qualifierExpression == null ? new QualifierExpressionImpl("", TextRange.EMPTY_RANGE, typeAfterQualifier) : new QualifierExpressionImpl(qualifierExpression.getText(), qualifierExpression.getTextRange(), typeAfterQualifier);
        List<IntermediateStreamCall> intermediateCalls = JavaChainTransformerImpl.createIntermediateCalls(typeAfterQualifier, streamExpressions.subList(0, streamExpressions.size() - 1));
        GenericType typeBefore = intermediateCalls.isEmpty() ? qualifier.getTypeAfter() : intermediateCalls.get(intermediateCalls.size() - 1).getTypeAfter();
        TerminatorStreamCall terminationCall = JavaChainTransformerImpl.createTerminationCall(typeBefore, streamExpressions.get(streamExpressions.size() - 1));
        return new StreamChainImpl(qualifier, intermediateCalls, terminationCall, context);
    }

    @NotNull
    private static GenericType getGenericTypeOfThis(PsiExpression expression) {
        PsiClass klass = ClassUtils.getContainingClass((PsiElement)expression);
        return klass == null ? JavaTypes.INSTANCE.getANY() : JavaTypes.INSTANCE.fromPsiClass(klass);
    }

    @NotNull
    private static List<IntermediateStreamCall> createIntermediateCalls(@NotNull GenericType producerAfterType, @NotNull List<PsiMethodCallExpression> expressions) {
        ArrayList<IntermediateStreamCall> result = new ArrayList<IntermediateStreamCall>();
        GenericType typeBefore = producerAfterType;
        for (PsiMethodCallExpression callExpression : expressions) {
            String name = JavaChainTransformerImpl.resolveMethodName(callExpression);
            List<CallArgument> args = JavaChainTransformerImpl.resolveArguments(callExpression);
            GenericType type = JavaChainTransformerImpl.resolveType(callExpression);
            result.add(new IntermediateStreamCallImpl(name, args, typeBefore, type, callExpression.getTextRange()));
            typeBefore = type;
        }
        return result;
    }

    @NotNull
    private static TerminatorStreamCall createTerminationCall(@NotNull GenericType typeBefore, @NotNull PsiMethodCallExpression expression) {
        String name = JavaChainTransformerImpl.resolveMethodName(expression);
        List<CallArgument> args = JavaChainTransformerImpl.resolveArguments(expression);
        GenericType resultType = JavaChainTransformerImpl.resolveTerminationCallType(expression);
        return new TerminatorStreamCallImpl(name, args, typeBefore, resultType, expression.getTextRange());
    }

    @NotNull
    private static List<CallArgument> resolveArguments(@NotNull PsiMethodCallExpression methodCall) {
        PsiExpressionList list2 = methodCall.getArgumentList();
        return (List)StreamEx.of((Object[])list2.getExpressions()).zipWith((Stream)StreamEx.of((Object[])list2.getExpressionTypes()), (expression, type) -> new CallArgumentImpl(GenericsUtil.getVariableTypeByExpressionType((PsiType)type).getCanonicalText(), expression.getText())).collect(Collectors.toList());
    }

    @NotNull
    private static String resolveMethodName(@NotNull PsiMethodCallExpression methodCall) {
        String name = methodCall.getMethodExpression().getReferenceName();
        Objects.requireNonNull(name, "Method reference must be not null" + methodCall.getText());
        return name;
    }

    @NotNull
    private static PsiType extractType(@NotNull PsiMethodCallExpression expression) {
        PsiType returnType = expression.getType();
        Objects.requireNonNull(returnType, "Method return type must be not null" + expression.getText());
        return returnType;
    }

    @NotNull
    private static GenericType resolveType(@NotNull PsiMethodCallExpression call2) {
        return JavaTypes.INSTANCE.fromStreamPsiType(JavaChainTransformerImpl.extractType(call2));
    }

    @NotNull
    private static GenericType resolveTerminationCallType(@NotNull PsiMethodCallExpression call2) {
        return JavaTypes.INSTANCE.fromPsiType(JavaChainTransformerImpl.extractType(call2));
    }
}

