/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.Split;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class MinimizedPanel<T>
extends JPanel
implements SideModel.Listener<T> {
    private final SideModel<T> myModel;
    private final Side mySide;
    private final Component myFiller;
    private boolean myHasVisibleButtons;

    MinimizedPanel(@NotNull Side side, @NotNull SideModel<T> model2) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(IdeBorderFactory.createBorder((int)(side.isLeft() ? 4 : 1)));
        this.setBackground((Color)JBColor.white);
        this.setOpaque(false);
        this.myModel = model2;
        this.mySide = side;
        this.myFiller = Box.createVerticalGlue();
        model2.addListener(this);
    }

    @Override
    public void modelChanged(@NotNull SideModel<T> model2, @NotNull SideModel.EventType unused) {
        this.removeAll();
        this.myHasVisibleButtons = false;
        model2.getTopTools(this.mySide).forEach(this::addButton);
        this.add(this.myFiller);
        model2.getBottomTools(this.mySide).forEach(this::addButton);
        this.setVisible(this.myHasVisibleButtons);
        this.revalidate();
        this.repaint();
    }

    private void addButton(@NotNull AttachedToolWindow tool) {
        AbstractButton button2 = tool.getMinimizedButton();
        button2.setVisible(true);
        this.myHasVisibleButtons |= tool.isMinimized() || tool.isAutoHide();
        this.add(button2);
    }

    public int drag(@NotNull AttachedToolWindow<T> tool, int position) {
        AbstractButton button2 = tool.getMinimizedButton();
        if (!this.isOpaque()) {
            this.enableMinimizeButtonDragAndDrop(true);
            button2.setVisible(true);
        }
        int insertIndex = this.findInsertIndex(position, button2);
        int index = this.getComponentIndex(button2);
        if (index == insertIndex) {
            return insertIndex;
        }
        if (index >= 0) {
            this.remove(index);
        }
        this.add((Component)button2, insertIndex);
        this.revalidate();
        this.repaint();
        return insertIndex;
    }

    public void dragExit(@NotNull AttachedToolWindow<T> tool) {
        tool.getMinimizedButton().setVisible(false);
        this.enableMinimizeButtonDragAndDrop(false);
        this.revalidate();
        this.repaint();
    }

    public void dragDrop(@NotNull AttachedToolWindow<T> tool, int position) {
        int index = this.drag(tool, position);
        tool.getMinimizedButton().setVisible(false);
        int fillerIndex = this.getComponentIndex(this.myFiller);
        Split newSplit = index > fillerIndex ? Split.BOTTOM : Split.TOP;
        int toolIndex = newSplit.isBottom() ? index - fillerIndex - 1 : index;
        this.myModel.changeToolSettingsAfterDragAndDrop(tool, this.mySide, newSplit, toolIndex);
        this.enableMinimizeButtonDragAndDrop(false);
    }

    private void enableMinimizeButtonDragAndDrop(boolean enable) {
        this.setOpaque(enable);
        this.setVisible(enable || this.myHasVisibleButtons);
        this.revalidate();
        this.repaint();
    }

    private int findInsertIndex(int position, @NotNull Component draggedButton) {
        int index = 0;
        int y = 0;
        int extraFillerHeight = draggedButton.getParent() == this ? draggedButton.getHeight() : 0;
        for (Component component : this.getComponents()) {
            if (component == draggedButton) continue;
            if (component instanceof Box.Filler) {
                if (position < y + (component.getHeight() + extraFillerHeight) / 2) {
                    return index;
                }
                ++index;
                y += extraFillerHeight;
            }
            if (position < (y += component.getHeight())) {
                return index;
            }
            ++index;
        }
        return index - 1;
    }

    private int getComponentIndex(@NotNull Component component) {
        for (int index = 0; index < this.getComponentCount(); ++index) {
            if (this.getComponent(index) != component) continue;
            return index;
        }
        return -1;
    }
}

