/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.axis;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AxisComponentModel
extends AspectModel<Aspect> {
    @NotNull
    protected final Range myRange;
    @NotNull
    protected final Range myMarkerRange;
    @NotNull
    protected final BaseAxisFormatter myFormatter;
    @NotNull
    protected String myLabel;
    protected boolean myFirstUpdate = true;

    protected AxisComponentModel(@NotNull BaseBuilder<? extends AxisComponentModel> builder) {
        this.myRange = builder.myRange;
        this.myMarkerRange = builder.myMarkerRange;
        this.myFormatter = builder.myFormatter;
        this.myLabel = builder.myLabel;
        this.myRange.addDependency(this).onChange(Range.Aspect.RANGE, this::updateImmediately);
    }

    public abstract void updateImmediately();

    public void reset() {
        this.myFirstUpdate = true;
        this.updateImmediately();
    }

    @NotNull
    public String getLabel() {
        return this.myLabel;
    }

    @NotNull
    public Range getRange() {
        return this.myRange;
    }

    @NotNull
    public Range getMarkerRange() {
        return this.myMarkerRange;
    }

    public double getDataRange() {
        return this.myRange.getLength();
    }

    @NotNull
    public BaseAxisFormatter getFormatter() {
        return this.myFormatter;
    }

    public double getZero() {
        return this.myRange.getMin();
    }

    public static abstract class BaseBuilder<T extends AxisComponentModel> {
        @NotNull
        protected final Range myRange;
        @NotNull
        protected final BaseAxisFormatter myFormatter;
        @NotNull
        protected Range myMarkerRange = new Range(0.0, Double.MAX_VALUE);
        @Nullable
        protected Range myGlobalRange;
        @NotNull
        protected String myLabel = "";

        public BaseBuilder(@NotNull Range range, @NotNull BaseAxisFormatter formatter) {
            this.myRange = range;
            this.myFormatter = formatter;
        }

        @NotNull
        public BaseBuilder<T> setLabel(@NotNull String label2) {
            this.myLabel = label2;
            return this;
        }

        @NotNull
        public BaseBuilder<T> setMarkerRange(@NotNull Range range) {
            this.myMarkerRange = range;
            return this;
        }

        @NotNull
        public abstract T build();
    }

    public static enum Aspect {
        AXIS;

    }
}

