/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Verifier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlStringUtil {
    private XmlStringUtil() {
    }

    @NotNull
    public static String wrapInCDATA(@NotNull String str) {
        StringBuilder sb = new StringBuilder();
        int cur = 0;
        int len = str.length();
        while (cur < len) {
            int next = StringUtil.indexOf((CharSequence)str, "]]>", cur);
            next = next < 0 ? len : next + 1;
            sb.append("<![CDATA[").append(str.subSequence(cur, next)).append("]]>");
            cur = next;
        }
        return sb.toString();
    }

    @Contract(value="null->null; !null->!null")
    public static String escapeString(@Nullable String str) {
        return XmlStringUtil.escapeString(str, false);
    }

    @Contract(value="null,_->null; !null,_->!null")
    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace) {
        return XmlStringUtil.escapeString(str, escapeWhiteSpace, true);
    }

    @Contract(value="null,_,_->null; !null,_,_->!null")
    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace, boolean convertNoBreakSpace) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    entity = escapeWhiteSpace ? "&#10;" : null;
                    break;
                }
                case '\r': {
                    entity = escapeWhiteSpace ? "&#13;" : null;
                    break;
                }
                case '\t': {
                    entity = escapeWhiteSpace ? "&#9;" : null;
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\u00a0': {
                    entity = convertNoBreakSpace ? "&nbsp;" : null;
                    break;
                }
                default: {
                    entity = null;
                }
            }
            buffer = XmlStringUtil.appendEscapedSymbol(str, buffer, i, entity, ch);
        }
        return buffer == null ? str : buffer.toString();
    }

    @Nullable
    public static StringBuilder appendEscapedSymbol(@NotNull String str, StringBuilder buffer, int i, String entity, char ch) {
        if (buffer == null) {
            if (entity != null) {
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str, 0, i);
                buffer.append(entity);
            }
        } else if (entity == null) {
            buffer.append(ch);
        } else {
            buffer.append(entity);
        }
        return buffer;
    }

    @NotNull
    public static String wrapInHtml(@Nls @NotNull CharSequence result) {
        return "<html>" + result + "</html>";
    }

    @NotNull
    public static String wrapInHtmlLines(CharSequence ... lines) {
        StringBuilder sb = new StringBuilder("<html>");
        for (int i = 0; i < lines.length; ++i) {
            CharSequence sequence = lines[i];
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append("<nobr>").append(sequence).append("</nobr>");
        }
        return sb.append("</html>").toString();
    }

    @NotNull
    public static String wrapInHtmlTag(@Nls @NotNull String text, @NonNls @NotNull String tagWord) {
        return String.format("<%s>%s</%s>", tagWord, text, tagWord);
    }

    @NotNull
    public static String wrapInHtmlTagWithAttributes(@Nls @NotNull String text, @NonNls @NotNull String tagWord, @NonNls @NotNull String attributes) {
        return String.format("<%s %s>%s</%s>", tagWord, attributes, text, tagWord);
    }

    @NotNull
    public static String formatLink(@NonNls @NotNull String targetUrl, @Nls @NotNull String text) {
        return XmlStringUtil.wrapInHtmlTagWithAttributes(text, "a", "href=\"" + targetUrl + "\"");
    }

    public static boolean isWrappedInHtml(@NotNull String tooltip) {
        return StringUtil.startsWithIgnoreCase(tooltip, "<html>") && StringUtil.endsWithIgnoreCase(tooltip, "</html>");
    }

    @NotNull
    public static String stripHtml(@NotNull String toolTip) {
        toolTip = StringUtil.trimStart(toolTip, "<html>");
        toolTip = StringUtil.trimStart(toolTip, "<body>");
        toolTip = StringUtil.trimEnd(toolTip, "</html>");
        toolTip = StringUtil.trimEnd(toolTip, "</body>");
        return toolTip;
    }

    @NotNull
    public static String convertToHtmlContent(@NotNull String text) {
        return XmlStringUtil.isWrappedInHtml(text) ? XmlStringUtil.stripHtml(text) : XmlStringUtil.escapeString(text);
    }

    @NotNull
    public static String escapeIllegalXmlChars(@NotNull String text) {
        StringBuilder b = null;
        int lastPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            int c = text.codePointAt(i);
            if (Character.isSupplementaryCodePoint(c)) {
                ++i;
            }
            if (c != 35 && Verifier.isXMLCharacter((int)c)) continue;
            if (b == null) {
                b = new StringBuilder(text.length() + 5);
            }
            b.append(text, lastPos, i).append('#');
            if (c != 35) {
                b.append(Integer.toHexString(c));
            }
            b.append('#');
            lastPos = i + 1;
        }
        return b == null ? text : b.append(text, lastPos, text.length()).toString();
    }

    @NotNull
    public static String unescapeIllegalXmlChars(@NotNull String text) {
        StringBuilder b = null;
        int lastPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            int charCode;
            int numberEnd;
            char c = text.charAt(i);
            if (c != '#' || (numberEnd = text.indexOf(35, i + 1)) <= 0) continue;
            try {
                charCode = numberEnd == i + 1 ? 35 : Integer.parseInt(text.substring(i + 1, numberEnd), 16);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (b == null) {
                b = new StringBuilder(text.length());
            }
            b.append(text, lastPos, i);
            b.append((char)charCode);
            i = numberEnd;
            lastPos = i + 1;
        }
        return b == null ? text : b.append(text, lastPos, text.length()).toString();
    }
}

