/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringSearcher {
    private final String myPattern;
    private final char[] myPatternArray;
    private final int myPatternLength;
    private final int[] mySearchTable = new int[128];
    private final boolean myCaseSensitive;
    private final boolean myLowercaseTransform;
    private final boolean myForwardDirection;
    private final boolean myJavaIdentifier;
    private final boolean myHandleEscapeSequences;

    public int getPatternLength() {
        return this.myPatternLength;
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection) {
        this(pattern, caseSensitive, forwardDirection, false);
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection, boolean handleEscapeSequences) {
        this(pattern, caseSensitive, forwardDirection, handleEscapeSequences, true);
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection, boolean handleEscapeSequences, boolean lookForJavaIdentifiersOnlyIfPossible) {
        char[] chars;
        this.myHandleEscapeSequences = handleEscapeSequences;
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("pattern is empty");
        }
        this.myPattern = pattern;
        this.myCaseSensitive = caseSensitive;
        this.myForwardDirection = forwardDirection;
        char[] cArray = chars = this.myCaseSensitive ? this.myPattern.toCharArray() : StringUtil.toLowerCase(this.myPattern).toCharArray();
        if (chars.length != this.myPattern.length()) {
            this.myLowercaseTransform = false;
            chars = StringUtil.toUpperCase(this.myPattern).toCharArray();
        } else {
            this.myLowercaseTransform = true;
        }
        this.myPatternArray = chars;
        this.myPatternLength = this.myPatternArray.length;
        Arrays.fill(this.mySearchTable, -1);
        this.myJavaIdentifier = lookForJavaIdentifiersOnlyIfPossible && Character.isJavaIdentifierPart(pattern.charAt(0)) && Character.isJavaIdentifierPart(pattern.charAt(pattern.length() - 1));
    }

    @NotNull
    public String getPattern() {
        return this.myPattern;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isJavaIdentifier() {
        return this.myJavaIdentifier;
    }

    public boolean isHandleEscapeSequences() {
        return this.myHandleEscapeSequences;
    }

    public int scan(@NotNull CharSequence text) {
        return this.scan(text, 0, text.length());
    }

    public int scan(@NotNull CharSequence text, int _start, int _end) {
        return this.scan(text, null, _start, _end);
    }

    public int @NotNull [] findAllOccurrences(@NotNull CharSequence text) {
        int end = text.length();
        TIntArrayList result = new TIntArrayList();
        for (int index = 0; index < end && (index = this.scan(text, index, end)) >= 0; ++index) {
            result.add(index);
        }
        return result.toNativeArray();
    }

    public boolean processOccurrences(@NotNull CharSequence text, @NotNull TIntProcedure consumer) {
        int end = text.length();
        for (int index = 0; index < end && (index = this.scan(text, index, end)) >= 0; ++index) {
            if (consumer.execute(index)) continue;
            return false;
        }
        return true;
    }

    public int scan(@NotNull CharSequence text, char @Nullable [] textArray, int _start, int _end) {
        if (_start > _end) {
            throw new AssertionError((Object)("start > end, " + _start + ">" + _end));
        }
        int textLength = text.length();
        if (_end > textLength) {
            throw new AssertionError((Object)("end > length, " + _end + ">" + textLength));
        }
        if (this.myForwardDirection) {
            int step;
            if (this.myPatternLength == 1) {
                return StringUtil.indexOf(text, this.myPatternArray[0], _start, _end, this.myCaseSensitive);
            }
            int end = _end - this.myPatternLength;
            for (int start = _start; start <= end; start += step) {
                int index;
                int i = this.myPatternLength - 1;
                char lastChar = this.normalizedCharAt(text, textArray, start + i);
                if (this.isSameChar(this.myPatternArray[i], lastChar)) {
                    --i;
                    while (i >= 0) {
                        char c;
                        char c2 = c = textArray != null ? textArray[start + i] : text.charAt(start + i);
                        if (!this.isSameChar(this.myPatternArray[i], c)) break;
                        --i;
                    }
                    if (i < 0) {
                        return start;
                    }
                }
                int n = step = lastChar < '\u0080' ? this.mySearchTable[lastChar] : 1;
                if (step > 0) continue;
                for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[index] != lastChar; --index) {
                }
                this.mySearchTable[lastChar] = step = this.myPatternLength - index - 1;
            }
        } else {
            int step;
            for (int start = 1; start <= _end - this.myPatternLength + 1; start += step) {
                int index;
                int i = this.myPatternLength - 1;
                char lastChar = this.normalizedCharAt(text, textArray, _end - (start + i));
                if (this.isSameChar(this.myPatternArray[this.myPatternLength - 1 - i], lastChar)) {
                    --i;
                    while (i >= 0) {
                        char c;
                        char c3 = c = textArray != null ? textArray[_end - (start + i)] : text.charAt(_end - (start + i));
                        if (!this.isSameChar(this.myPatternArray[this.myPatternLength - 1 - i], c)) break;
                        --i;
                    }
                    if (i < 0) {
                        return _end - start - this.myPatternLength + 1;
                    }
                }
                int n = step = lastChar < '\u0080' ? this.mySearchTable[lastChar] : 1;
                if (step > 0) continue;
                for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[this.myPatternLength - 1 - index] != lastChar; --index) {
                }
                this.mySearchTable[lastChar] = step = this.myPatternLength - index - 1;
            }
        }
        return -1;
    }

    private char normalizedCharAt(@NotNull CharSequence text, char @Nullable [] textArray, int index) {
        char lastChar;
        char c = lastChar = textArray != null ? textArray[index] : text.charAt(index);
        if (this.myCaseSensitive) {
            return lastChar;
        }
        return this.myLowercaseTransform ? StringUtil.toLowerCase(lastChar) : StringUtil.toUpperCase(lastChar);
    }

    private boolean isSameChar(char charInPattern, char charInText) {
        boolean sameChar;
        boolean bl = sameChar = charInPattern == charInText;
        if (!sameChar && !this.myCaseSensitive) {
            return StringUtil.charsEqualIgnoreCase(charInPattern, charInText);
        }
        return sameChar;
    }

    public String toString() {
        return "pattern " + this.myPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringSearcher searcher = (StringSearcher)o;
        if (this.myCaseSensitive != searcher.myCaseSensitive) {
            return false;
        }
        if (this.myLowercaseTransform != searcher.myLowercaseTransform) {
            return false;
        }
        if (this.myForwardDirection != searcher.myForwardDirection) {
            return false;
        }
        if (this.myJavaIdentifier != searcher.myJavaIdentifier) {
            return false;
        }
        if (this.myHandleEscapeSequences != searcher.myHandleEscapeSequences) {
            return false;
        }
        return this.myPattern.equals(searcher.myPattern);
    }

    public int hashCode() {
        int result = this.myPattern.hashCode();
        result = 31 * result + (this.myCaseSensitive ? 1 : 0);
        result = 31 * result + (this.myLowercaseTransform ? 1 : 0);
        result = 31 * result + (this.myForwardDirection ? 1 : 0);
        result = 31 * result + (this.myJavaIdentifier ? 1 : 0);
        result = 31 * result + (this.myHandleEscapeSequences ? 1 : 0);
        return result;
    }
}

