/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import org.jetbrains.annotations.NotNull;

final class IntObjectHashMap {
    private int size;
    private int[] keys = new int[4];
    private Object[] values = new Object[this.keys.length];
    private Object specialZeroValue;
    private boolean hasZeroValue;

    IntObjectHashMap() {
    }

    int size() {
        return this.size + (this.hasZeroValue ? 1 : 0);
    }

    void put(int key, @NotNull Object value) {
        Object previousValue;
        if (key == 0) {
            this.specialZeroValue = value;
            this.hasZeroValue = true;
            return;
        }
        if (this.size >= 2 * this.values.length / 3) {
            this.rehash();
        }
        if ((previousValue = IntObjectHashMap.doPut(this.keys, this.values, key, value)) == null) {
            ++this.size;
        }
    }

    private static Object doPut(@NotNull int[] keys, @NotNull Object[] values, int key, @NotNull Object value) {
        int index = IntObjectHashMap.hashIndex(keys, key);
        Object obj = values[index];
        values[index] = value;
        if (keys[index] == 0) {
            keys[index] = key;
        }
        return obj;
    }

    private static int hashIndex(@NotNull int[] keys, int key) {
        int candidate;
        int hash = (int)((long)key * 2654435769L & Integer.MAX_VALUE);
        int index = hash & keys.length - 1;
        while ((candidate = keys[index]) != 0) {
            if (candidate == key) {
                return index;
            }
            if (index == 0) {
                index = keys.length;
            }
            --index;
        }
        return index;
    }

    private void rehash() {
        int[] newKeys = new int[this.keys.length << 1];
        Object[] newValues = new Object[newKeys.length];
        for (int i = this.keys.length - 1; i >= 0; --i) {
            int key = this.keys[i];
            if (key == 0) continue;
            IntObjectHashMap.doPut(newKeys, newValues, key, this.values[i]);
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    public Object get(int key) {
        return key == 0 ? this.specialZeroValue : this.values[IntObjectHashMap.hashIndex(this.keys, key)];
    }
}

