/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.externalizer;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;

public final class StringCollectionExternalizer<C extends Collection<String>>
implements DataExternalizer<C> {
    @NotNull
    public static final StringCollectionExternalizer<List<String>> STRING_LIST_EXTERNALIZER = new StringCollectionExternalizer<List>(ArrayList::new);
    @NotNull
    private final IntFunction<? extends C> myGenerator;

    public StringCollectionExternalizer(@NotNull IntFunction<? extends C> generator) {
        this.myGenerator = generator;
    }

    @Override
    public void save(@NotNull DataOutput out, C collection) throws IOException {
        IOUtil.writeStringList(out, collection);
    }

    @Override
    public C read(@NotNull DataInput in) throws IOException {
        return IOUtil.readStringCollection(in, this.myGenerator);
    }
}

