/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.StorageLockContext;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentEnumeratorDelegate<Data>
implements DataEnumeratorEx<Data>,
Closeable,
Forceable {
    @NotNull
    protected final PersistentEnumeratorBase<Data> myEnumerator;

    public PersistentEnumeratorDelegate(@NotNull Path file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        this(file, dataDescriptor, initialSize, null);
    }

    public PersistentEnumeratorDelegate(@NotNull Path file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext) throws IOException {
        this.myEnumerator = PersistentEnumeratorDelegate.useBtree() ? new PersistentBTreeEnumerator<Data>(file, dataDescriptor, initialSize, lockContext) : new PersistentEnumerator<Data>(file, dataDescriptor, initialSize);
    }

    public PersistentEnumeratorDelegate(@NotNull File file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version) throws IOException {
        this(file.toPath(), dataDescriptor, initialSize, lockContext, version);
    }

    public PersistentEnumeratorDelegate(@NotNull Path file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version) throws IOException {
        this.myEnumerator = PersistentEnumeratorDelegate.createDefaultEnumerator(file, dataDescriptor, initialSize, lockContext, version);
    }

    @NotNull
    static <Data> PersistentEnumeratorBase<Data> createDefaultEnumerator(@NotNull Path file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version) throws IOException {
        return PersistentEnumeratorDelegate.useBtree() ? new PersistentBTreeEnumerator<Data>(file, dataDescriptor, initialSize, lockContext, version) : new PersistentEnumerator<Data>(file, dataDescriptor, initialSize, null, version);
    }

    @ApiStatus.Internal
    public static int getVersion() {
        return PersistentEnumeratorDelegate.useBtree() ? PersistentBTreeEnumerator.VERSION : 6;
    }

    @ApiStatus.Internal
    public static boolean useBtree() {
        String property = System.getProperty("idea.use.btree");
        return !"false".equals(property);
    }

    @Override
    public void close() throws IOException {
        PersistentEnumeratorBase<Data> enumerator = this.myEnumerator;
        if (enumerator != null) {
            enumerator.close();
        }
    }

    public boolean isClosed() {
        return this.myEnumerator.isClosed();
    }

    @Override
    public boolean isDirty() {
        return this.myEnumerator.isDirty();
    }

    public final void markDirty() throws IOException {
        this.myEnumerator.markDirty(true);
    }

    public boolean isCorrupted() {
        return this.myEnumerator.isCorrupted();
    }

    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }

    @Override
    public void force() {
        this.myEnumerator.force();
    }

    @Override
    public Data valueOf(int id) throws IOException {
        return this.myEnumerator.valueOf(id);
    }

    @Override
    public int enumerate(Data name) throws IOException {
        return this.myEnumerator.enumerate(name);
    }

    @Override
    public int tryEnumerate(Data name) throws IOException {
        return this.myEnumerator.tryEnumerate(name);
    }

    public Collection<Data> getAllDataObjects(@Nullable PersistentEnumeratorBase.DataFilter filter) throws IOException {
        return this.myEnumerator.getAllDataObjects(filter);
    }
}

