/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.Bits;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.IntToIntBtree;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentBTreeEnumerator<Data>
extends PersistentEnumeratorBase<Data> {
    private static final int BTREE_PAGE_SIZE = SystemProperties.getIntProperty("idea.btree.page.size", 32768);
    private static final int DEFAULT_BTREE_PAGE_SIZE = 32768;
    private static final int RECORD_SIZE = 4;
    private static final int VALUE_PAGE_SIZE = 0x100000;
    private static final int INTERNAL_PAGE_SIZE = 4096;
    private int myLogicalFileLength;
    private int myDataPageStart;
    private int myFirstPageStart;
    private int myDataPageOffset;
    private int myDuplicatedValuesPageStart;
    private int myDuplicatedValuesPageOffset;
    private static final int COLLISION_OFFSET = 4;
    private int myValuesCount;
    private int myCollisions;
    private int myExistingKeysEnumerated;
    private IntToIntBtree myBTree;
    private final boolean myInlineKeysNoMapping;
    private boolean myExternalKeysNoMapping;
    private static final int MAX_DATA_SEGMENT_LENGTH = 128;
    protected static final int VERSION;
    private static final int KEY_SHIFT = 1;
    private final int[] myResultBuf = new int[1];

    public PersistentBTreeEnumerator(@NotNull Path file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        this(file, dataDescriptor, initialSize, null);
    }

    public PersistentBTreeEnumerator(@NotNull Path file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext) throws IOException {
        this(file, dataDescriptor, initialSize, lockContext, 0);
    }

    public PersistentBTreeEnumerator(@NotNull Path file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version) throws IOException {
        super(file, new ResizeableMappedFile(file, initialSize, lockContext, 0x100000, true, IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER), dataDescriptor, initialSize, new PersistentEnumeratorBase.Version(VERSION + version), new RecordBufferHandler(), false);
        this.myInlineKeysNoMapping = dataDescriptor instanceof InlineKeyDescriptor;
        boolean bl = this.myExternalKeysNoMapping = !(dataDescriptor instanceof InlineKeyDescriptor);
        if (this.myBTree == null) {
            try {
                this.lockStorageWrite();
                this.storeVars(false);
                this.initBtree(false);
                this.storeBTreeVars(false);
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable e) {
                LOG.info(e);
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new PersistentEnumeratorBase.CorruptedException(file);
            }
            finally {
                this.unlockStorageWrite();
            }
        }
    }

    @NotNull
    private static Path indexFile(@NotNull Path file) {
        return file.resolveSibling(file.getFileName() + "_i");
    }

    private void initBtree(boolean initial) throws IOException {
        this.myBTree = new IntToIntBtree(BTREE_PAGE_SIZE, PersistentBTreeEnumerator.indexFile(this.myFile), this.myStorage.getPagedFileStorage().getStorageLockContext(), initial);
    }

    private void storeVars(boolean toDisk) {
        this.myLogicalFileLength = this.store(20, this.myLogicalFileLength, toDisk);
        this.myDataPageStart = this.store(24, this.myDataPageStart, toDisk);
        this.myDataPageOffset = this.store(28, this.myDataPageOffset, toDisk);
        this.myFirstPageStart = this.store(32, this.myFirstPageStart, toDisk);
        this.myDuplicatedValuesPageStart = this.store(36, this.myDuplicatedValuesPageStart, toDisk);
        this.myDuplicatedValuesPageOffset = this.store(40, this.myDuplicatedValuesPageOffset, toDisk);
        this.myValuesCount = this.store(44, this.myValuesCount, toDisk);
        this.myCollisions = this.store(48, this.myCollisions, toDisk);
        this.myExistingKeysEnumerated = this.store(52, this.myExistingKeysEnumerated, toDisk);
        this.storeBTreeVars(toDisk);
    }

    private void storeBTreeVars(boolean toDisk) {
        IntToIntBtree tree = this.myBTree;
        if (tree != null) {
            int BTREE_DATA_START = 56;
            tree.persistVars(new IntToIntBtree.BtreeDataStorage(){

                @Override
                public int persistInt(int offset, int value, boolean toDisk) {
                    return PersistentBTreeEnumerator.this.store(56 + offset, value, toDisk);
                }
            }, toDisk);
        }
    }

    private int store(int offset, int value, boolean toDisk) {
        assert (offset + 4 < 128);
        if (toDisk) {
            if (this.myFirstPageStart == -1 || this.myStorage.getInt(offset) != value) {
                this.myStorage.putInt(offset, value);
            }
        } else {
            value = this.myStorage.getInt(offset);
        }
        return value;
    }

    @Override
    protected void setupEmptyFile() throws IOException {
        this.myLogicalFileLength = 128;
        this.myDataPageStart = -1;
        this.myFirstPageStart = -1;
        this.myDuplicatedValuesPageStart = -1;
        this.initBtree(true);
        this.storeVars(true);
    }

    @Override
    protected void doClose() throws IOException {
        try {
            super.doClose();
        }
        finally {
            IntToIntBtree tree = this.myBTree;
            if (tree != null) {
                tree.doClose();
            }
        }
    }

    private int allocPage() {
        int pageStart = this.myLogicalFileLength;
        this.myLogicalFileLength += 4096 - pageStart % 4096;
        return pageStart;
    }

    @Override
    public boolean processAllDataObject(final @NotNull Processor<? super Data> processor, final @Nullable PersistentEnumeratorBase.DataFilter filter) throws IOException {
        if (this.myInlineKeysNoMapping) {
            return this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                @Override
                public boolean process(int record) {
                    if (filter == null || filter.accept(record)) {
                        Object data = ((InlineKeyDescriptor)PersistentBTreeEnumerator.this.myDataDescriptor).fromInt(this.getCurrentKey());
                        return processor.process(data);
                    }
                    return true;
                }
            });
        }
        return super.processAllDataObject(processor, filter);
    }

    @Override
    public boolean traverseAllRecords(final @NotNull PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        try {
            this.lockStorageWrite();
            boolean bl = this.myBTree.processMappings(new IntToIntBtree.KeyValueProcessor(){

                @Override
                public boolean process(int key, int value) throws IOException {
                    p.setCurrentKey(key);
                    if (value > 0 || PersistentBTreeEnumerator.this.myInlineKeysNoMapping) {
                        return p.process(value);
                    }
                    int rec = -value;
                    while (rec != 0) {
                        int id = PersistentBTreeEnumerator.this.myStorage.getInt(rec);
                        if (!p.process(id)) {
                            return false;
                        }
                        rec = PersistentBTreeEnumerator.this.myStorage.getInt(rec + 4);
                    }
                    return true;
                }
            });
            return bl;
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException corruptedException = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            corruptedException.initCause(e);
            throw corruptedException;
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    protected int addrToIndex(int addr) {
        assert (this.myExternalKeysNoMapping);
        return addr + 1;
    }

    @Override
    protected int indexToAddr(int idx) {
        if (this.myExternalKeysNoMapping) {
            IntToIntBtree.myAssert(idx > 0);
            return idx - 1;
        }
        int anInt = this.myStorage.getInt(idx);
        return anInt;
    }

    @Override
    protected int setupValueId(int hashCode, int dataOff) {
        if (this.myExternalKeysNoMapping) {
            return this.addrToIndex(dataOff);
        }
        @NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler = this.getRecordHandler();
        byte[] buf = recordHandler.getRecordBuffer(this);
        int pos = recordHandler.recordWriteOffset(this, buf);
        this.myStorage.ensureSize(pos + buf.length);
        if (!this.myInlineKeysNoMapping) {
            this.myStorage.putInt(pos, dataOff);
        }
        return pos;
    }

    @Override
    public void setRecordHandler(@NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler) {
        this.myExternalKeysNoMapping = false;
        super.setRecordHandler(recordHandler);
    }

    @Override
    public Data getValue(int keyId, int processingKey) throws IOException {
        if (this.myInlineKeysNoMapping) {
            return (Data)((InlineKeyDescriptor)this.myDataDescriptor).fromInt(processingKey);
        }
        return super.getValue(keyId, processingKey);
    }

    long getNonNegativeValue(Data key) throws IOException {
        assert (this.myInlineKeysNoMapping);
        try {
            this.lockStorageRead();
            boolean hasMapping = this.myBTree.get(((InlineKeyDescriptor)this.myDataDescriptor).toInt(key), this.myResultBuf);
            if (!hasMapping) {
                long l = 0L;
                return l;
            }
            long l = this.keyIdToNonNegativeOffset(this.myResultBuf[0]);
            return l;
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException exception = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    long keyIdToNonNegativeOffset(int value) {
        if (value >= 0) {
            return value;
        }
        return this.myStorage.getLong(-value);
    }

    void putNonNegativeValue(Data key, long value) throws IOException {
        assert (value >= 0L);
        assert (this.myInlineKeysNoMapping);
        try {
            this.lockStorageWrite();
            int intKey = ((InlineKeyDescriptor)this.myDataDescriptor).toInt(key);
            this.markDirty(true);
            if (value < Integer.MAX_VALUE) {
                this.myBTree.put(intKey, (int)value);
            } else {
                boolean hasMapping = this.myBTree.get(intKey, this.myResultBuf);
                if (hasMapping && this.myResultBuf[0] < 0) {
                    this.myStorage.putLong(-this.myResultBuf[0], value);
                    return;
                }
                int pos = this.nextLongValueRecord();
                this.myStorage.putLong(pos, value);
                this.myBTree.put(intKey, -pos);
            }
        }
        catch (IllegalStateException e) {
            PersistentEnumeratorBase.CorruptedException exception = new PersistentEnumeratorBase.CorruptedException(this.myFile);
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    private int nextLongValueRecord() {
        assert (this.myInlineKeysNoMapping);
        if (this.myDuplicatedValuesPageStart == -1 || this.myDuplicatedValuesPageOffset == 4096) {
            int existingOffset;
            this.myDuplicatedValuesPageStart = this.allocPage();
            this.myDuplicatedValuesPageOffset = existingOffset = this.myDuplicatedValuesPageStart % 4096;
            this.myDuplicatedValuesPageStart -= existingOffset;
        }
        int duplicatedValueOff = this.myDuplicatedValuesPageOffset;
        this.myDuplicatedValuesPageOffset += 8;
        return this.myDuplicatedValuesPageStart + duplicatedValueOff;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int enumerateImpl(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                int newValueId;
                int n;
                block36: {
                    int valueHC;
                    block37: {
                        if (onlyCheckForExisting) {
                            this.lockStorageRead();
                        } else {
                            this.lockStorageWrite();
                        }
                        valueHC = this.myDataDescriptor.getHashCode(value);
                        boolean hasMapping = this.myBTree.get(valueHC, this.myResultBuf);
                        if (!hasMapping && onlyCheckForExisting) {
                            int n2 = 0;
                            return n2;
                        }
                        int indexNodeValueAddress = hasMapping ? this.myResultBuf[0] : 0;
                        int collisionAddress = 0;
                        boolean hasExistingData = false;
                        if (!this.myInlineKeysNoMapping) {
                            int address;
                            if (indexNodeValueAddress > 0) {
                                if (this.isKeyAtIndex(value, indexNodeValueAddress)) {
                                    if (!saveNewValue) {
                                        ++this.myExistingKeysEnumerated;
                                        int n3 = indexNodeValueAddress;
                                        return n3;
                                    }
                                    hasExistingData = true;
                                }
                                collisionAddress = indexNodeValueAddress;
                            } else if (indexNodeValueAddress < 0) {
                                collisionAddress = -indexNodeValueAddress;
                                while (true) {
                                    if (this.isKeyAtIndex(value, address = this.myStorage.getInt(collisionAddress))) {
                                        if (!saveNewValue) {
                                            n = address;
                                            return n;
                                        }
                                        hasExistingData = true;
                                        break;
                                    }
                                    int newCollisionAddress = this.myStorage.getInt(collisionAddress + 4);
                                    if (newCollisionAddress == 0) break;
                                    collisionAddress = newCollisionAddress;
                                }
                            }
                            if (onlyCheckForExisting) {
                                address = 0;
                                return address;
                            }
                        } else if (hasMapping) {
                            if (!saveNewValue) {
                                int address = indexNodeValueAddress;
                                return address;
                            }
                            hasExistingData = true;
                        }
                        newValueId = this.writeData(value, valueHC);
                        ++this.myValuesCount;
                        if (IOStatistics.DEBUG && (this.myValuesCount & 0xFFFF) == 0) {
                            IOStatistics.dump("Index " + this.myFile + ", values " + this.myValuesCount + ", existing keys enumerated:" + this.myExistingKeysEnumerated + ", storage size:" + this.myStorage.length());
                            this.myBTree.dumpStatistics();
                        }
                        if (collisionAddress == 0) break block37;
                        if (hasExistingData) {
                            if (indexNodeValueAddress > 0) {
                                this.myBTree.put(valueHC, newValueId);
                                break block36;
                            } else {
                                this.myStorage.putInt(collisionAddress, newValueId);
                            }
                            break block36;
                        } else {
                            int duplicatedValueOff;
                            if (indexNodeValueAddress > 0) {
                                duplicatedValueOff = this.nextDuplicatedValueRecord();
                                this.myBTree.put(valueHC, -duplicatedValueOff);
                                this.myStorage.putInt(duplicatedValueOff, indexNodeValueAddress);
                                collisionAddress = duplicatedValueOff;
                                ++this.myCollisions;
                            }
                            ++this.myCollisions;
                            duplicatedValueOff = this.nextDuplicatedValueRecord();
                            this.myStorage.putInt(collisionAddress + 4, duplicatedValueOff);
                            this.myStorage.putInt(duplicatedValueOff, newValueId);
                            this.myStorage.putInt(duplicatedValueOff + 4, 0);
                        }
                        break block36;
                    }
                    this.myBTree.put(valueHC, newValueId);
                }
                n = newValueId;
                return n;
            }
            catch (IllegalStateException e) {
                PersistentEnumeratorBase.CorruptedException exception = new PersistentEnumeratorBase.CorruptedException(this.myFile);
                exception.initCause(e);
                throw exception;
            }
            finally {
                if (onlyCheckForExisting) {
                    this.unlockStorageRead();
                } else {
                    this.unlockStorageWrite();
                }
            }
        }
    }

    @Override
    boolean canReEnumerate() {
        return true;
    }

    @Override
    public Data valueOf(int idx) throws IOException {
        assert (!this.myInlineKeysNoMapping) : "No valueOf for inline keys with no mapping option";
        return super.valueOf(idx);
    }

    private int nextDuplicatedValueRecord() {
        assert (!this.myInlineKeysNoMapping);
        if (this.myDuplicatedValuesPageStart == -1 || this.myDuplicatedValuesPageOffset == 4096) {
            int existingOffset;
            this.myDuplicatedValuesPageStart = this.allocPage();
            this.myDuplicatedValuesPageOffset = existingOffset = this.myDuplicatedValuesPageStart % 4096;
            this.myDuplicatedValuesPageStart -= existingOffset;
        }
        int duplicatedValueOff = this.myDuplicatedValuesPageOffset;
        this.myDuplicatedValuesPageOffset += 8;
        return this.myDuplicatedValuesPageStart + duplicatedValueOff;
    }

    @Override
    protected void doFlush() throws IOException {
        this.myBTree.doFlush();
        this.storeVars(true);
        super.doFlush();
    }

    static {
        assert (0x100000 % BTREE_PAGE_SIZE == 0) : "Page size should be divisor of 1048576";
        VERSION = 8 + IntToIntBtree.version() + BTREE_PAGE_SIZE + 4096 + 128;
    }

    private static class RecordBufferHandler
    extends PersistentEnumeratorBase.RecordBufferHandler<PersistentBTreeEnumerator<?>> {
        private ThreadLocal<byte[]> myBuffer;

        private RecordBufferHandler() {
        }

        @Override
        int recordWriteOffset(@NotNull PersistentBTreeEnumerator<?> enumerator, byte @NotNull [] buf) {
            PersistentBTreeEnumerator<?> persistentBTreeEnumerator;
            if (((PersistentBTreeEnumerator)enumerator).myFirstPageStart == -1) {
                ((PersistentBTreeEnumerator)enumerator).myFirstPageStart = (((PersistentBTreeEnumerator)enumerator).myDataPageStart = ((PersistentBTreeEnumerator)enumerator).allocPage());
                int existingOffset = ((PersistentBTreeEnumerator)enumerator).myDataPageStart % 4096;
                ((PersistentBTreeEnumerator)enumerator).myDataPageOffset = existingOffset;
                persistentBTreeEnumerator = enumerator;
                ((PersistentBTreeEnumerator)persistentBTreeEnumerator).myDataPageStart = ((PersistentBTreeEnumerator)persistentBTreeEnumerator).myDataPageStart - existingOffset;
            }
            if (((PersistentBTreeEnumerator)enumerator).myDataPageOffset + buf.length + 4 > 4096) {
                assert (((PersistentBTreeEnumerator)enumerator).myDataPageOffset + 4 <= 4096);
                int prevDataPageStart = ((PersistentBTreeEnumerator)enumerator).myDataPageStart + 4096 - 4;
                ((PersistentBTreeEnumerator)enumerator).myDataPageStart = ((PersistentBTreeEnumerator)enumerator).allocPage();
                enumerator.myStorage.putInt(prevDataPageStart, ((PersistentBTreeEnumerator)enumerator).myDataPageStart);
                ((PersistentBTreeEnumerator)enumerator).myDataPageOffset = 0;
            }
            int recordWriteOffset = ((PersistentBTreeEnumerator)enumerator).myDataPageOffset;
            assert (recordWriteOffset + buf.length + 4 <= 4096);
            persistentBTreeEnumerator = enumerator;
            ((PersistentBTreeEnumerator)persistentBTreeEnumerator).myDataPageOffset = ((PersistentBTreeEnumerator)persistentBTreeEnumerator).myDataPageOffset + buf.length;
            return recordWriteOffset + ((PersistentBTreeEnumerator)enumerator).myDataPageStart;
        }

        @Override
        byte @NotNull [] getRecordBuffer(@NotNull PersistentBTreeEnumerator<?> enumerator) {
            if (this.myBuffer == null) {
                this.myBuffer = ThreadLocal.withInitial(() -> ((PersistentBTreeEnumerator)enumerator).myInlineKeysNoMapping ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[4]);
            }
            return this.myBuffer.get();
        }

        @Override
        void setupRecord(@NotNull PersistentBTreeEnumerator<?> enumerator, int hashCode, int dataOffset, byte[] buf) {
            if (!((PersistentBTreeEnumerator)enumerator).myInlineKeysNoMapping) {
                Bits.putInt(buf, 0, dataOffset);
            }
        }
    }
}

