/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.KeyDescriptor;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingEnumerator<Data>
implements DataEnumerator<Data> {
    private static final int STRIPE_POWER = 4;
    private static final int STRIPE_COUNT = 16;
    private static final int STRIPE_MASK = 15;
    private final SLRUMap<Integer, Integer>[] myHashcodeToIdCache = new SLRUMap[16];
    private final SLRUMap<Integer, Data>[] myIdToStringCache = new SLRUMap[16];
    private final Lock[] myStripeLocks = new Lock[16];
    private final DataEnumerator<Data> myBase;
    private final KeyDescriptor<Data> myDataDescriptor;

    public CachingEnumerator(@NotNull DataEnumerator<Data> base, @NotNull KeyDescriptor<Data> dataDescriptor) {
        this.myBase = base;
        this.myDataDescriptor = dataDescriptor;
        int protectedSize = 8192;
        int probationalSize = 8192;
        for (int i = 0; i < 16; ++i) {
            this.myHashcodeToIdCache[i] = new SLRUMap(protectedSize / 16, probationalSize / 16);
            this.myIdToStringCache[i] = new SLRUMap(protectedSize / 16, probationalSize / 16);
            this.myStripeLocks[i] = new ReentrantLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enumerate(@Nullable Data value) throws IOException {
        int stripe;
        int valueHashCode;
        if (value == null) {
            valueHashCode = -1;
            stripe = -1;
        } else {
            valueHashCode = this.myDataDescriptor.getHashCode(value);
            stripe = Math.abs(valueHashCode) & 0xF;
        }
        Lock lock1 = null;
        if (value != null) {
            Integer cachedId;
            lock1 = this.myStripeLocks[stripe];
            lock1.lock();
            try {
                cachedId = this.myHashcodeToIdCache[stripe].get(valueHashCode);
            }
            finally {
                lock1.unlock();
            }
            if (cachedId != null) {
                int stripe2 = CachingEnumerator.idStripe(cachedId);
                Lock lock2 = this.myStripeLocks[stripe2];
                lock2.lock();
                try {
                    Data s = this.myIdToStringCache[stripe2].get(cachedId);
                    if (s != null && this.myDataDescriptor.isEqual(value, s)) {
                        int n = cachedId;
                        return n;
                    }
                }
                finally {
                    lock2.unlock();
                }
            }
        }
        int enumerate = this.myBase.enumerate(value);
        if (stripe != -1) {
            Integer enumeratedInteger;
            lock1.lock();
            try {
                enumeratedInteger = enumerate;
                this.myHashcodeToIdCache[stripe].put(valueHashCode, enumeratedInteger);
            }
            finally {
                lock1.unlock();
            }
            int stripe2 = CachingEnumerator.idStripe(enumerate);
            Lock lock2 = this.myStripeLocks[stripe2];
            lock2.lock();
            try {
                this.myIdToStringCache[stripe2].put(enumeratedInteger, value);
            }
            finally {
                lock2.unlock();
            }
        }
        return enumerate;
    }

    private static int idStripe(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return Math.abs(h ^ h >>> 7 ^ h >>> 4) & 0xF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Data valueOf(int idx) throws IOException {
        Data s;
        int stripe = CachingEnumerator.idStripe(idx);
        Lock lock = this.myStripeLocks[stripe];
        lock.lock();
        try {
            s = this.myIdToStringCache[stripe].get(idx);
            if (s != null) {
                Data Data = s;
                return Data;
            }
        }
        finally {
            lock.unlock();
        }
        s = this.myBase.valueOf(idx);
        if (s != null) {
            lock.lock();
            try {
                this.myIdToStringCache[stripe].put(idx, s);
            }
            finally {
                lock.unlock();
            }
        }
        return s;
    }

    void close() {
        this.clear();
    }

    private void clear() {
        for (int i = 0; i < this.myIdToStringCache.length; ++i) {
            this.myStripeLocks[i].lock();
            try {
                this.myIdToStringCache[i].clear();
                this.myHashcodeToIdCache[i].clear();
                continue;
            }
            finally {
                this.myStripeLocks[i].unlock();
            }
        }
    }
}

