/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class CollectionDataExternalizer<K>
implements DataExternalizer<Collection<K>> {
    private final DataExternalizer<K> myDataExternalizer;

    public CollectionDataExternalizer(@NotNull DataExternalizer<K> dataExternalizer) {
        this.myDataExternalizer = dataExternalizer;
    }

    @Override
    public void save(@NotNull DataOutput out, @NotNull Collection<K> value) throws IOException {
        DataInputOutputUtil.writeINT(out, value.size());
        for (K key : value) {
            this.myDataExternalizer.save(out, key);
        }
    }

    @Override
    @NotNull
    public Collection<K> read(@NotNull DataInput in) throws IOException {
        int size = DataInputOutputUtil.readINT(in);
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(this.myDataExternalizer.read(in));
        }
        ArrayList<K> list = new ArrayList<K>(size);
        for (int idx = 0; idx < size; ++idx) {
            list.add(this.myDataExternalizer.read(in));
        }
        return list;
    }
}

