/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.execution;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public final class ParametersListUtil {
    public static final Function<String, List<String>> DEFAULT_LINE_PARSER = text -> ParametersListUtil.parse(text, true);
    public static final Function<List<String>, String> DEFAULT_LINE_JOINER = strings -> StringUtil.join(strings, " ");
    public static final Function<String, List<String>> COLON_LINE_PARSER = text -> {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer((String)text, ";", false);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    };
    public static final Function<List<String>, String> COLON_LINE_JOINER = strings -> StringUtil.join(strings, ";");

    @NotNull
    public static String join(@NotNull List<? extends CharSequence> parameters) {
        return ParametersListUtil.join(parameters, ParametersListUtil::escape);
    }

    @NotNull
    public static <T extends CharSequence> String join(@NotNull List<? extends T> parameters, @NotNull Function<? super T, ? extends CharSequence> escapeFunction) {
        return StringUtil.join(parameters, escapeFunction, " ");
    }

    @NotNull
    public static String join(String ... parameters) {
        return ParametersListUtil.join(Arrays.asList(parameters));
    }

    public static String @NotNull [] parseToArray(@NotNull String string) {
        List<String> params = ParametersListUtil.parse(string);
        return ArrayUtilRt.toStringArray(params);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString) {
        return ParametersListUtil.parse(parameterString, false);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes) {
        return ParametersListUtil.parse(parameterString, keepQuotes, false);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes, boolean supportSingleQuotes) {
        return ParametersListUtil.parse(parameterString, keepQuotes, supportSingleQuotes, false);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes, boolean supportSingleQuotes, boolean keepEmptyParameters) {
        if (!keepEmptyParameters) {
            parameterString = parameterString.trim();
        }
        ArrayList<String> params = new ArrayList<String>();
        if (parameterString.isEmpty()) {
            return params;
        }
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        TIntHashSet possibleQuoteChars = new TIntHashSet();
        possibleQuoteChars.add(34);
        if (supportSingleQuotes) {
            possibleQuoteChars.add(39);
        }
        char currentQuote = '\u0000';
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (inQuotes ? currentQuote == ch : possibleQuoteChars.contains((int)ch)) {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    currentQuote = ch;
                    nonEmpty = true;
                    if (!keepQuotes) continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (!keepEmptyParameters && token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1) {
                char nextchar = parameterString.charAt(i + 1);
                if (inQuotes ? currentQuote == nextchar : possibleQuoteChars.contains((int)nextchar)) {
                    escapedQuote = true;
                    if (!keepQuotes) continue;
                }
            }
            token.append(ch);
        }
        if (keepEmptyParameters || token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        return params;
    }

    @NotNull
    public static String escape(@NotNull CharSequence argument) {
        StringBuilder builder = new StringBuilder(argument);
        StringUtil.escapeQuotes(builder);
        if (builder.length() == 0 || StringUtil.indexOf((CharSequence)builder, ' ') >= 0 || StringUtil.indexOf((CharSequence)builder, '|') >= 0) {
            int numTrailingBackslashes = builder.length() - StringUtil.trimTrailing(builder, '\\').length();
            StringUtil.quote(builder);
            StringUtil.repeatSymbol(builder, '\\', numTrailingBackslashes);
        }
        return builder.toString();
    }
}

