/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.RefValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import org.jetbrains.annotations.NotNull;

final class SoftValueHashMap<K, V>
extends RefValueHashMap<K, V> {
    SoftValueHashMap(@NotNull TObjectHashingStrategy<K> strategy) {
        super(strategy);
    }

    @Override
    protected RefValueHashMap.MyReference<K, V> createReference(@NotNull K key, V value, @NotNull ReferenceQueue<? super V> queue) {
        return new MySoftReference<K, V>(key, value, queue);
    }

    private static class MySoftReference<K, T>
    extends SoftReference<T>
    implements RefValueHashMap.MyReference<K, T> {
        private final K key;

        MySoftReference(@NotNull K key, T referent, @NotNull ReferenceQueue<? super T> q) {
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            return this.key;
        }
    }
}

