/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SingletonIteratorBase;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartHashSet<T>
extends THashSet<T> {
    private T theElement;

    public SmartHashSet() {
    }

    public SmartHashSet(@NotNull TObjectHashingStrategy<T> strategy) {
        super(strategy);
    }

    public SmartHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public SmartHashSet(int initialCapacity, @NotNull TObjectHashingStrategy<T> strategy) {
        super(initialCapacity, strategy);
    }

    public SmartHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SmartHashSet(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<T> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public SmartHashSet(@NotNull @NotNull Collection<? extends @NotNull T> collection) {
        this(collection, ContainerUtil.canonicalStrategy());
    }

    public SmartHashSet(@NotNull @NotNull Collection<? extends @NotNull T> collection, @NotNull TObjectHashingStrategy<T> strategy) {
        super(collection.size() == 1 ? Collections.emptyList() : collection, strategy);
        if (collection.size() == 1) {
            T element = collection.iterator().next();
            if (element == null) {
                throw new IllegalArgumentException("Null elements are not permitted but got: " + collection);
            }
            this.theElement = element;
        }
    }

    public boolean contains(@NotNull Object obj) {
        T theElement = this.theElement;
        if (theElement != null) {
            return this.eq(theElement, obj);
        }
        return !super.isEmpty() && super.contains(obj);
    }

    public boolean add(@NotNull T obj) {
        T theElement = this.theElement;
        if (theElement != null) {
            if (this.eq(theElement, obj)) {
                return false;
            }
            super.add(theElement);
            this.theElement = null;
        } else if (super.isEmpty()) {
            this.theElement = obj;
            return true;
        }
        return super.add(obj);
    }

    private boolean eq(T obj, T theElement) {
        return theElement == obj || this._hashingStrategy.equals(theElement, obj);
    }

    public boolean equals(@Nullable Object other) {
        T theElement = this.theElement;
        if (theElement != null) {
            return other instanceof Set && ((Set)other).size() == 1 && this.eq(theElement, ((Set)other).iterator().next());
        }
        return super.equals(other);
    }

    public int hashCode() {
        T theElement = this.theElement;
        if (theElement != null) {
            return this._hashingStrategy.computeHashCode(theElement);
        }
        return super.hashCode();
    }

    public void clear() {
        this.theElement = null;
        super.clear();
    }

    public int size() {
        if (this.theElement != null) {
            return 1;
        }
        return super.size();
    }

    public boolean isEmpty() {
        return this.theElement == null && super.isEmpty();
    }

    public boolean remove(@NotNull Object obj) {
        T theElement = this.theElement;
        if (theElement != null) {
            if (this.eq(theElement, obj)) {
                this.theElement = null;
                return true;
            }
            return false;
        }
        return super.remove(obj);
    }

    @NotNull
    public Iterator<T> iterator() {
        if (this.theElement != null) {
            return new SingletonIteratorBase<T>(){

                @Override
                protected void checkCoModification() {
                    if (SmartHashSet.this.theElement == null) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                protected T getElement() {
                    return SmartHashSet.this.theElement;
                }

                @Override
                public void remove() {
                    this.checkCoModification();
                    SmartHashSet.this.clear();
                }
            };
        }
        return super.iterator();
    }

    public boolean forEach(@NotNull TObjectProcedure<T> procedure) {
        T theElement = this.theElement;
        if (theElement != null) {
            return procedure.execute(theElement);
        }
        return super.forEach(procedure);
    }

    public Object @NotNull [] toArray() {
        T theElement = this.theElement;
        if (theElement != null) {
            return new Object[]{theElement};
        }
        return super.toArray();
    }

    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        T theElement = this.theElement;
        if (theElement != null) {
            if (a.length == 0) {
                a = ArrayUtil.newArray(ArrayUtil.getComponentType(a), 1);
            }
            a[0] = theElement;
            if (a.length > 1) {
                a[1] = null;
            }
            return a;
        }
        return super.toArray((Object[])a);
    }
}

