/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Functions;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LockFreeCopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
ConcurrentList<E> {
    private volatile Object @NotNull [] array;
    private static final AtomicFieldUpdater<LockFreeCopyOnWriteArrayList, Object[]> ARRAY_UPDATER = AtomicFieldUpdater.forFieldOfType(LockFreeCopyOnWriteArrayList.class, Object[].class);

    LockFreeCopyOnWriteArrayList() {
        this.array = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    LockFreeCopyOnWriteArrayList(@NotNull Collection<? extends E> c) {
        this.array = c.isEmpty() ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : c.toArray();
    }

    Object @NotNull [] getArray() {
        return this.array;
    }

    private boolean replaceArray(Object @NotNull [] oldArray, Object @NotNull [] newArray) {
        return ARRAY_UPDATER.compareAndSet(this, oldArray, newArray);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static int indexOf(Object o, Object @NotNull [] elements, int index, int fence) {
        return ArrayUtilRt.indexOf(elements, o, index, fence);
    }

    private static int lastIndexOf(Object o, Object @NotNull [] elements, int index) {
        if (o == null) {
            for (int i = index; i >= 0; --i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length);
    }

    public int indexOf(E e, int index) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.indexOf(e, elements, index, elements.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.lastIndexOf(o, elements, elements.length - 1);
    }

    public int lastIndexOf(E e, int index) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.lastIndexOf(e, elements, index);
    }

    @Override
    public Object @NotNull [] toArray() {
        Object[] elements = this.array;
        if (elements.length == 0) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        return Arrays.copyOf(elements, elements.length, Object[].class);
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        Object[] elements = this.array;
        int len = elements.length;
        if (a.length < len) {
            return Arrays.copyOf(elements, len, a.getClass());
        }
        System.arraycopy(elements, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        return a;
    }

    private E get(Object @NotNull [] a, int index) {
        return (E)a[index];
    }

    @Override
    public E get(int index) {
        return this.get(this.array, index);
    }

    @Override
    public E set(int index, E element) throws IndexOutOfBoundsException {
        E oldValue;
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements, newElements = (oldValue = this.get(elements = this.array, index)) == element ? elements : LockFreeCopyOnWriteArrayList.createArraySet(elements, index, element))) {
        }
        return oldValue;
    }

    private static Object @NotNull [] createArraySet(Object @NotNull [] elements, int index, Object element) {
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len, Object[].class);
        newElements[index] = element;
        return newElements;
    }

    @Override
    public boolean add(E e) {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayAdd(elements, e))) {
        }
        return true;
    }

    private static <E> Object @NotNull [] createArrayAdd(Object @NotNull [] elements, E e) {
        int len = elements.length;
        Object[] newElements = new Object[len + 1];
        if (len != 0) {
            System.arraycopy(elements, 0, newElements, 0, len);
        }
        newElements[len] = e;
        return newElements;
    }

    @Override
    public void add(int index, E element) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayAdd(elements, index, element))) {
        }
    }

    private static <E> Object @NotNull [] createArrayAdd(Object @NotNull [] elements, int index, E element) {
        int numMoved;
        int len = elements.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        Object[] newElements = new Object[len + 1];
        if (index != 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if ((numMoved = len - index) != 0) {
            System.arraycopy(elements, index, newElements, index + 1, numMoved);
        }
        newElements[index] = element;
        return newElements;
    }

    @Override
    public E remove(int index) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements, index))) {
        }
        E oldValue = this.get(elements, index);
        return oldValue;
    }

    private static Object @NotNull [] createArrayRemove(Object @NotNull [] elements, int index) {
        int numMoved;
        Object[] newElements;
        int len = elements.length;
        Object[] objectArray = newElements = len == 1 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[len - 1];
        if (index != 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if ((numMoved = len - index - 1) != 0) {
            System.arraycopy(elements, index + 1, newElements, index, numMoved);
        }
        return newElements;
    }

    @Override
    public boolean remove(Object o) {
        Object[] newElements;
        Object[] elements;
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements = this.array, o)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private static Object @Nullable [] createArrayRemove(Object @NotNull [] elements, Object o) {
        int i;
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        int newLen = len - 1;
        Object[] newElements = newLen == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[newLen];
        for (i = newLen; i != 0; --i) {
            Object element = elements[i];
            if (Objects.equals(o, element)) {
                System.arraycopy(elements, 0, newElements, 0, i);
                break;
            }
            newElements[i - 1] = element;
        }
        if (i == 0 && !Objects.equals(o, elements[0])) {
            return null;
        }
        return newElements;
    }

    @Override
    public boolean addIfAbsent(E e) {
        Object[] newElements;
        Object[] elements;
        do {
            elements = this.array;
            int len = elements.length;
            newElements = new Object[len + 1];
            for (int i = 0; i < len; ++i) {
                if (Objects.equals(e, elements[i])) {
                    return false;
                }
                newElements[i] = elements[i];
            }
            newElements[len] = e;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        Object[] elements = this.array;
        int len = elements.length;
        for (Object e : c) {
            if (LockFreeCopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        if (c.isEmpty()) {
            return false;
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemoveAll(elements = this.array, c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private static Object @Nullable [] createArrayRemoveAll(Object @NotNull [] elements, @NotNull Collection<?> c) {
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        int newLen = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (c.contains(element)) continue;
            temp[newLen++] = element;
        }
        if (newLen == len) {
            return null;
        }
        return Arrays.copyOf(temp, newLen, Object[].class);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRetainAll(elements = this.array, c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private static Object @Nullable [] createArrayRetainAll(Object @NotNull [] elements, @NotNull Collection<?> c) {
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        int newLength = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (!c.contains(element)) continue;
            temp[newLength++] = element;
        }
        if (newLength == len) {
            return null;
        }
        return Arrays.copyOf(temp, newLength, Object[].class);
    }

    @Override
    public int addAllAbsent(@NotNull Collection<? extends E> c) {
        int added;
        ArrayList<E> toAddList;
        Object[] newElements;
        Object[] elements;
        if (c.isEmpty()) {
            return 0;
        }
        do {
            elements = this.array;
            Set existing = ContainerUtil.map2Set(elements, Functions.identity());
            toAddList = new ArrayList<E>(c.size());
            for (E e : c) {
                if (existing.contains(e)) continue;
                toAddList.add(e);
            }
            added = toAddList.size();
            if (added != 0) continue;
            return 0;
        } while (!this.replaceArray(elements, newElements = ArrayUtil.mergeArrays(elements, toAddList.toArray())));
        return added;
    }

    @Override
    public void clear() {
        this.array = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        Object[] newElements;
        Object[] elements;
        if (c.isEmpty()) {
            return false;
        }
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, cs))) {
        }
        return true;
    }

    private static Object @NotNull [] createArrayAddAll(Object @NotNull [] elements, Object @NotNull [] cs) {
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        System.arraycopy(cs, 0, newElements, len, cs.length);
        return newElements;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, index, cs))) {
        }
        return true;
    }

    private static Object @NotNull [] createArrayAddAll(Object @NotNull [] elements, int index, Object @NotNull [] cs) {
        Object[] newElements;
        int len = elements.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        int numMoved = len - index;
        if (numMoved == 0) {
            newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        } else {
            newElements = new Object[len + cs.length];
            System.arraycopy(elements, 0, newElements, 0, index);
            System.arraycopy(elements, index, newElements, index + cs.length, numMoved);
        }
        System.arraycopy(cs, 0, newElements, index, cs.length);
        return newElements;
    }

    @NotNull
    public String toString() {
        return Arrays.toString(this.array);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        for (Object element : this.array) {
            if (it.hasNext() && Objects.equals(element, it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this.array) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Object[] elements = this.array;
        return elements.length == 0 ? Collections.emptyIterator() : new COWIterator(elements, 0);
    }

    @Override
    public void forEach(@NotNull Consumer<? super E> action) {
        Object[] snapshot;
        for (Object element : snapshot = this.array) {
            action.accept(element);
        }
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        Object[] elements = this.array;
        int len = elements.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return elements.length == 0 ? Collections.emptyListIterator() : new COWIterator(elements, index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private class COWIterator
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;
        private int lastRet = -1;

        private COWIterator(Object[] elements, int initialCursor) {
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastRet = --this.cursor;
            return this.snapshot[this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new NoSuchElementException();
            }
            Object e = this.snapshot[this.lastRet];
            this.lastRet = -1;
            LockFreeCopyOnWriteArrayList.this.remove(e);
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

