/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.containers.CharSequenceHashingStrategy;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CollectionFactory {
    private static final Hash.Strategy<File> FILE_HASH_STRATEGY = new Hash.Strategy<File>(){

        public int hashCode(File o) {
            return FileUtil.fileHashCode(o);
        }

        public boolean equals(File a, File b) {
            return FileUtil.filesEqual(a, b);
        }
    };

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakIdentityMap() {
        return new ConcurrentWeakHashMap(TObjectHashingStrategy.IDENTITY);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        return ContainerUtil.createWeakMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        return ContainerUtil.createConcurrentWeakKeyWeakValueMap(ContainerUtil.canonicalStrategy());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, ContainerUtil.canonicalStrategy());
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, loadFactor, (Hash.Strategy)(caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new ObjectOpenCustomHashSet(expectedSize, loadFactor, (Hash.Strategy)(caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap((Hash.Strategy)(caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE));
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet((Hash.Strategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap((Hash.Strategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashSet<String>();
        }
        return CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize) {
        return CollectionFactory.createFilePathSet(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize, boolean isFileSystemCaseSensitive) {
        if (isFileSystemCaseSensitive) {
            return new HashSet<String>(expectedSize);
        }
        return new ObjectOpenCustomHashSet(expectedSize, (Hash.Strategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths, boolean isFileSystemCaseSensitive) {
        if (isFileSystemCaseSensitive) {
            return new HashSet<String>(paths);
        }
        return new ObjectOpenCustomHashSet(paths, (Hash.Strategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashMap();
        }
        return CollectionFactory.createCaseInsensitiveStringMap();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize) {
        return CollectionFactory.createFilePathMap(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize, boolean isFileSystemCaseSensitive) {
        if (isFileSystemCaseSensitive) {
            return new HashMap(expectedSize);
        }
        return new Object2ObjectOpenCustomHashMap(expectedSize, (Hash.Strategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<File, V> createFileMap() {
        return new Object2ObjectOpenCustomHashMap(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createFileSet() {
        return new ObjectOpenCustomHashSet(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createFileLinkedSet() {
        return new ObjectLinkedOpenCustomHashSet(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<String> createFilePathLinkedSet() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new ObjectLinkedOpenHashSet();
        }
        return new ObjectLinkedOpenCustomHashSet((Hash.Strategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathLinkedMap() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new Object2ObjectLinkedOpenHashMap();
        }
        return new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<String, V> createCanonicalFilePathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<String>(){

            public int hashCode(String value) {
                return FileUtil.pathHashCode(value);
            }

            public boolean equals(String val1, String val2) {
                return FileUtil.pathsEqual(val1, val2);
            }
        });
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap() {
        return new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<File>(){

            public int hashCode(File value) {
                return FileUtil.fileHashCode(value);
            }

            public boolean equals(File val1, File val2) {
                return FileUtil.filesEqual(val1, val2);
            }
        });
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths) {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashSet<String>(paths);
        }
        return new ObjectOpenCustomHashSet(paths, (Hash.Strategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }
}

