/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SingletonIterator;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SingletonSet<E>
implements Set<E> {
    private final E theElement;

    public SingletonSet(E e) {
        this.theElement = e;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object elem) {
        return this.getStrategy().equals(this.theElement, elem);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new SingletonIterator<E>(this.theElement);
    }

    @Override
    public Object @NotNull [] toArray() {
        return new Object[]{this.theElement};
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        if (a.length == 0) {
            a = ArrayUtil.newArray(ArrayUtil.getComponentType(a), 1);
        }
        a[0] = this.theElement;
        if (a.length > 1) {
            a[1] = null;
        }
        return a;
    }

    @Override
    public boolean add(E t) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new IncorrectOperationException();
    }

    @Override
    public void clear() {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @NotNull
    protected TObjectHashingStrategy<E> getStrategy() {
        return ContainerUtil.canonicalStrategy();
    }

    @NotNull
    public static <T> Set<T> withCustomStrategy(T o, @NotNull TObjectHashingStrategy<T> strategy) {
        return new CustomStrategySingletonSet(o, strategy);
    }

    private static class CustomStrategySingletonSet<E>
    extends SingletonSet<E> {
        @NotNull
        private final TObjectHashingStrategy<E> strategy;

        private CustomStrategySingletonSet(E e, @NotNull TObjectHashingStrategy<E> strategy) {
            super(e);
            this.strategy = strategy;
        }

        @Override
        @NotNull
        protected TObjectHashingStrategy<E> getStrategy() {
            return this.strategy;
        }
    }
}

