/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;

public class Range<T extends Comparable<? super T>> {
    @NotNull
    private final T myFrom;
    @NotNull
    private final T myTo;

    public Range(@NotNull T from, @NotNull T to) {
        this.myFrom = from;
        this.myTo = to;
    }

    public boolean isWithin(@NotNull T object) {
        return this.isWithin(object, true);
    }

    public boolean isWithin(@NotNull T object, boolean includingEndpoints) {
        if (includingEndpoints) {
            return object.compareTo(this.myFrom) >= 0 && object.compareTo(this.myTo) <= 0;
        }
        return object.compareTo(this.myFrom) > 0 && object.compareTo(this.myTo) < 0;
    }

    @NotNull
    public T getFrom() {
        return this.myFrom;
    }

    @NotNull
    public T getTo() {
        return this.myTo;
    }

    public String toString() {
        return "(" + this.myFrom + "," + this.myTo + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (!this.myFrom.equals(range.myFrom)) {
            return false;
        }
        return this.myTo.equals(range.myTo);
    }

    public int hashCode() {
        int result = this.myFrom.hashCode();
        result = 31 * result + this.myTo.hashCode();
        return result;
    }
}

