/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LazyInitializer {
    private static final Object UNINITIALIZED_VALUE = new Object();

    public static final class MutableNotNullValue<T>
    extends NullableValue<T> {
        private final Supplier<? extends T> supplier;

        public MutableNotNullValue(@NotNull Supplier<? extends T> supplier) {
            this.supplier = supplier;
        }

        @Override
        @NotNull
        public T get() {
            return super.get();
        }

        @Override
        public void set(@NotNull T value) {
            super.set(value);
        }

        @Override
        @NotNull
        public final T initialize() {
            return this.supplier.get();
        }
    }

    public static abstract class NotNullValue<T>
    extends NullableValue<T> {
        @Override
        @NotNull
        public T get() {
            return super.get();
        }

        @Override
        @NotNull
        public abstract T initialize();
    }

    public static abstract class NullableValue<T> {
        private volatile T value = LazyInitializer.access$000();

        @Nullable
        public abstract T initialize();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public T get() {
            T v = this.value;
            if (v != UNINITIALIZED_VALUE) {
                return this.value;
            }
            NullableValue nullableValue = this;
            synchronized (nullableValue) {
                v = this.value;
                if (v != UNINITIALIZED_VALUE) {
                    return this.value;
                }
                this.value = v = this.initialize();
            }
            this.onInitialized(this.value);
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void set(T value) {
            NullableValue nullableValue = this;
            synchronized (nullableValue) {
                this.value = value;
            }
        }

        public final boolean isNotNull() {
            return this.get() != null;
        }

        protected void onInitialized(T value) {
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

