/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.Pluralizer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Strings {
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(ArrayUtilRt.EMPTY_CHAR_ARRAY);

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return Strings.compare(c1, c2, ignoreCase) == 0;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ENGLISH);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        return Strings.indexOf(sequence, infix) >= 0;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        return Strings.indexOf(s, c, start, end) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        return value.indexOf(ch) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        return chars.length() > value.length() ? Strings.containsAnyChar(value, chars, 0, value.length()) : Strings.containsAnyChar(chars, value, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        return Strings.indexOf(s, c, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        return Strings.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        return Strings.indexOf(sequence, infix, 0);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        return Strings.indexOf(sequence, infix, start, sequence.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start, int end) {
        for (int i = start; i <= end - infix.length(); ++i) {
            if (!Strings.startsWith(sequence, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!Strings.charsMatch(s.charAt(i), c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(char @NotNull [] s, char c, int start, int end, boolean caseSensitive) {
        end = Math.min(end, s.length);
        for (int i = Math.max(start, 0); i < end; ++i) {
            boolean ignoreCase;
            boolean bl = ignoreCase = !caseSensitive;
            if (!Strings.charsMatch(s[i], c, ignoreCase)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        return Strings.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        return Strings.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        return Strings.indexOfAny((CharSequence)s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!Strings.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        return Strings.indexOfIgnoreCase((CharSequence)where, (CharSequence)what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where, @NotNull CharSequence what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!Strings.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !Strings.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && Strings.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        int sourceCount = where.length();
        for (int i = Math.max(fromIndex, 0); i < sourceCount; ++i) {
            if (!Strings.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return Strings.charsMatch(a, b, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalize(@NotNull String s) {
        if (s.isEmpty()) {
            return s;
        }
        if (s.length() == 1) {
            return Strings.toUpperCase(s);
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Strings.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        int tl = text.length();
        if (startIndex < 0 || startIndex > tl) {
            throw new IllegalArgumentException("Index is out of bounds: " + startIndex + ", length: " + tl);
        }
        int l1 = tl - startIndex;
        int l2 = prefix.length();
        if (l1 < l2) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        return StringUtilRt.endsWith(text, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return !Strings.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return StringUtilRt.isEmpty(cs);
    }

    @Contract(pure=true)
    @NotNull
    public static String pluralize(@NotNull String word) {
        String plural = Pluralizer.PLURALIZER.plural(word);
        if (plural != null) {
            return plural;
        }
        if (word.endsWith("s")) {
            return Pluralizer.restoreCase(word, word + "es");
        }
        return Pluralizer.restoreCase(word, word + "s");
    }

    @Contract(pure=true)
    @Nullable
    public static String unpluralize(@NotNull String word) {
        String singular = Pluralizer.PLURALIZER.singular(word);
        if (singular != null) {
            return singular;
        }
        if (word.endsWith("es")) {
            return Strings.nullize(Strings.trimEnd(word, "es", true));
        }
        if (word.endsWith("s")) {
            return Strings.nullize(Strings.trimEnd(word, "s", true));
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s) {
        return StringUtilRt.notNullize(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        return StringUtilRt.notNullize(s, defaultValue);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s) {
        return Strings.nullize(s, false);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, @Nullable String defaultValue) {
        boolean empty = Strings.isEmpty(s) || Objects.equals(s, defaultValue);
        return empty ? null : s;
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        boolean empty = nullizeSpaces ? Strings.isEmptyOrSpaces(s) : Strings.isEmpty(s);
        return empty ? null : s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return StringUtilRt.isEmptyOrSpaces(s);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        return Strings.trimEnd(s, suffix, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        boolean bl = endsWith = ignoreCase ? Strings.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, char suffix) {
        if (Strings.endsWithChar(s, suffix)) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        return Strings.stringHashCode(chars, from, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(char @NotNull [] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + Strings.toLowerCase(chars[off]);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        return Strings.stringHashCodeInsensitive(chars, from, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + Strings.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        return Strings.stringHashCodeInsensitive(chars, 0, chars.length());
    }
}

