/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileFilter;
import org.jetbrains.annotations.NotNull;

public final class FileFilters {
    private FileFilters() {
    }

    public static FileFilter withExtension(final @NotNull String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileUtilRt.extensionEquals(pathname.getPath(), extension);
            }
        };
    }

    public static FileFilter filesWithExtension(final @NotNull String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileUtilRt.extensionEquals(pathname.getPath(), extension) && pathname.isFile();
            }
        };
    }
}

