/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectNode;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ObjectTree {
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();
    private final Set<Disposable> myRootObjects = new ReferenceOpenHashSet();
    private final Map<Disposable, ObjectNode> myObject2NodeMap = new Reference2ObjectOpenHashMap();
    private final Map<Disposable, Object> myDisposedObjects = ContainerUtil.createWeakMap(100, 0.5f, ContainerUtil.identityStrategy());
    private final List<ObjectNode> myExecutedNodes = new ArrayList<ObjectNode>();
    private final List<Disposable> myExecutedUnregisteredObjects = new ArrayList<Disposable>();
    final Object treeLock = new Object();

    ObjectTree() {
    }

    private ObjectNode getNode(@NotNull Disposable object) {
        return this.myObject2NodeMap.get(object);
    }

    void putNode(@NotNull Disposable object, @Nullable(value="null means remove") @Nullable(value="null means remove") ObjectNode node) {
        if (node == null) {
            this.myObject2NodeMap.remove(object);
        } else {
            this.myObject2NodeMap.put(object, node);
        }
    }

    @NotNull
    final List<ObjectNode> getNodesInExecution() {
        return this.myExecutedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final RuntimeException register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == child) {
            return new IllegalArgumentException("Cannot register to itself: " + parent);
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode childNode;
            Object wasDisposed = this.getDisposalInfo(parent);
            if (wasDisposed != null) {
                return new IncorrectOperationException("Sorry but parent: " + parent + " has already been disposed (see the cause for stacktrace) so the child: " + child + " will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            if (this.isDisposing(parent)) {
                return new IncorrectOperationException("Sorry but parent: " + parent + " is being disposed so the child: " + child + " will never be disposed");
            }
            this.myDisposedObjects.remove(child);
            ObjectNode parentNode = this.getNode(parent);
            if (parentNode == null) {
                parentNode = this.createNodeFor(parent, null);
            }
            if ((childNode = this.getNode(child)) == null) {
                childNode = this.createNodeFor(child, parentNode);
            } else {
                ObjectNode oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            RuntimeException e = ObjectTree.checkWasNotAddedAlready(parentNode, childNode);
            if (e != null) {
                return e;
            }
            parentNode.addChild(childNode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDisposalInfo(@NotNull Disposable object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myDisposedObjects.get(object);
        }
    }

    private static RuntimeException checkWasNotAddedAlready(@NotNull ObjectNode childNode, @NotNull ObjectNode parentNode) {
        for (ObjectNode node = childNode; node != null; node = node.getParent()) {
            if (node != parentNode) continue;
            return new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
        return null;
    }

    @NotNull
    private ObjectNode createNodeFor(@NotNull Disposable object, @Nullable ObjectNode parentNode) {
        ObjectNode newNode = new ObjectNode(this, parentNode, object);
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void executeAll(@NotNull Disposable object, boolean processUnregistered, boolean onlyChildren) {
        block14: {
            boolean needTrace;
            ObjectNode node;
            Object object2 = this.treeLock;
            synchronized (object2) {
                node = this.getNode(object);
            }
            boolean bl = needTrace = (node != null || processUnregistered) && Disposer.isDebugMode() && ourTopmostDisposeTrace.get() == null;
            if (needTrace) {
                ourTopmostDisposeTrace.set(ThrowableInterner.intern(new Throwable()));
            }
            try {
                if (node == null) {
                    if (processUnregistered) {
                        this.rememberDisposedTrace(object);
                        this.executeUnregistered(object);
                    }
                    break block14;
                }
                ObjectNode parent = node.getParent();
                SmartList exceptions = new SmartList();
                node.execute(exceptions, onlyChildren);
                if (parent != null && !onlyChildren) {
                    Object object3 = this.treeLock;
                    synchronized (object3) {
                        parent.removeChild(node);
                    }
                }
                ObjectTree.handleExceptions(exceptions);
            }
            finally {
                if (needTrace) {
                    ourTopmostDisposeTrace.remove();
                }
            }
        }
    }

    private static void handleExceptions(@NotNull List<? extends Throwable> exceptions) {
        if (!exceptions.isEmpty()) {
            for (Throwable throwable : exceptions) {
                if (throwable instanceof ProcessCanceledException) continue;
                ObjectTree.getLogger().error(throwable);
            }
            ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
            if (pce != null) {
                throw pce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposing(@NotNull Disposable disposable) {
        List<ObjectNode> guard;
        List<ObjectNode> list = guard = this.getNodesInExecution();
        synchronized (list) {
            for (ObjectNode node : guard) {
                if (node.getObject() != disposable) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull Consumer<? super T> action) {
        List<T> list = recursiveGuard;
        synchronized (list) {
            if (ArrayUtil.indexOf(recursiveGuard, object, (t, t2) -> t == t2) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.accept(object);
        }
        finally {
            list = recursiveGuard;
            synchronized (list) {
                int i = ArrayUtil.lastIndexOf(recursiveGuard, object, (t, t2) -> t == t2);
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull Disposable disposable) {
        ObjectTree.executeActionWithRecursiveGuard(disposable, this.myExecutedUnregisteredObjects, Disposable::dispose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertNoReferenceKeptInTree(@NotNull Disposable disposable) {
        Object object = this.treeLock;
        synchronized (object) {
            for (Map.Entry<Disposable, ObjectNode> entry : this.myObject2NodeMap.entrySet()) {
                Disposable key = entry.getKey();
                assert (key != disposable);
                ObjectNode node = entry.getValue();
                node.assertNoReferencesKept(disposable);
            }
        }
    }

    void removeRootObject(@NotNull Disposable object) {
        this.myRootObjects.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertIsEmpty(boolean throwError) {
        Object object = this.treeLock;
        synchronized (object) {
            for (Disposable object2 : this.myRootObjects) {
                ObjectNode objectNode;
                if (object2 == null || (objectNode = this.getNode(object2)) == null) continue;
                while (objectNode.getParent() != null) {
                    objectNode = objectNode.getParent();
                }
                Throwable trace = objectNode.getTrace();
                RuntimeException exception = new RuntimeException("Memory leak detected: '" + object2 + "' of " + object2.getClass() + "\nSee the cause for the corresponding Disposer.register() stacktrace:\n", trace);
                if (throwError) {
                    throw exception;
                }
                ObjectTree.getLogger().error(exception);
            }
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(ObjectTree.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberDisposedTrace(@NotNull Disposable object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            Throwable trace = ourTopmostDisposeTrace.get();
            this.myDisposedObjects.put(object, trace != null ? trace : Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDisposedObjectTraces() {
        Object object = this.treeLock;
        synchronized (object) {
            this.myDisposedObjects.clear();
            for (ObjectNode value : this.myObject2NodeMap.values()) {
                value.clearTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <D extends Disposable> D findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull D object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            ObjectNode parentNode = this.getNode(parentDisposable);
            if (parentNode == null) {
                return null;
            }
            return parentNode.findChildEqualTo(object);
        }
    }
}

