/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.lang.UrlClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static <E extends Throwable> void runWithClassLoader(@Nullable ClassLoader classLoader, @NotNull ThrowableRunnable<E> runnable) throws E {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithClassLoader(@Nullable ClassLoader classLoader, @NotNull ThrowableComputable<T, E> computable) throws E {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = computable.compute();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Deprecated
    public static <T> T runWithClassLoader(ClassLoader classLoader, Computable<T> computable) {
        return (T)ClassLoaderUtil.computeWithClassLoader(classLoader, () -> computable.compute());
    }

    @Nullable
    public static ClassLoader getPlatformLoaderParentIfOnJdk9() {
        if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
            try {
                return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void addPlatformLoaderParentIfOnJdk9(@NotNull UrlClassLoader.Builder builder) {
        builder.parent(ClassLoaderUtil.getPlatformLoaderParentIfOnJdk9());
    }
}

