/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeDisposable
implements Disposable {
    private final List<Disposable> myDisposables = new ArrayList<Disposable>();
    private boolean disposed;
    private boolean isDisposing;

    public void add(@NotNull Disposable disposable) {
        assert (!this.disposed) : "Already disposed";
        this.myDisposables.add(disposable);
    }

    public void remove(@NotNull Disposable disposable) {
        if (!this.isDisposing) {
            for (int i = this.myDisposables.size() - 1; i >= 0; --i) {
                Disposable d = this.myDisposables.get(i);
                if (d != disposable) continue;
                this.myDisposables.remove(i);
            }
        }
    }

    @Override
    public void dispose() {
        this.isDisposing = true;
        for (int i = this.myDisposables.size() - 1; i >= 0; --i) {
            Disposable disposable = this.myDisposables.get(i);
            Disposer.dispose(disposable);
        }
        this.isDisposing = false;
        this.myDisposables.clear();
        this.disposed = true;
    }
}

