/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.pico.DefaultPicoContainer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;

final class ComponentParameter {
    ComponentParameter() {
    }

    public static ComponentAdapter resolveAdapter(@NotNull DefaultPicoContainer container, @Nullable ComponentAdapter excludeAdapter, @NotNull Class<?> expectedType) {
        if (excludeAdapter == null) {
            return container.getComponentAdapter(expectedType);
        }
        ComponentAdapter result = ComponentParameter.getTargetAdapter(container, expectedType, excludeAdapter.getComponentKey());
        return result == null ? null : (expectedType.isAssignableFrom(result.getComponentImplementation()) ? result : null);
    }

    private static ComponentAdapter getTargetAdapter(@NotNull DefaultPicoContainer container, Class<?> expectedType, @NotNull Object excludeKey) {
        ComponentAdapter byKey = container.getComponentAdapter(expectedType);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return byKey;
        }
        List<ComponentAdapter> found = container.getComponentAdaptersOfType(expectedType);
        ComponentAdapter exclude = null;
        for (ComponentAdapter work : found) {
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
        }
        found.remove(exclude);
        if (found.size() == 0) {
            return container.getParent() == null ? null : container.getParent().getComponentAdapterOfType(expectedType);
        }
        if (found.size() == 1) {
            return found.get(0);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(expectedType, foundClasses);
    }
}

