/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.ExtensionInstantiationException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public abstract class KeyedExtensionFactory<T, KeyT> {
    private final Class<T> myInterfaceClass;
    private final ExtensionPointName<KeyedFactoryEPBean> myEpName;
    private final PicoContainer myPicoContainer;

    public KeyedExtensionFactory(@NotNull Class<T> interfaceClass, @NonNls @NotNull ExtensionPointName<KeyedFactoryEPBean> epName, @NotNull PicoContainer picoContainer) {
        this.myInterfaceClass = interfaceClass;
        this.myEpName = epName;
        this.myPicoContainer = picoContainer;
    }

    @NotNull
    public T get() {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                Object keyArg;
                String key;
                List epBeans = KeyedExtensionFactory.this.myEpName.getExtensionList();
                Object result = KeyedExtensionFactory.this.getByKey(epBeans, key = KeyedExtensionFactory.this.getKey(keyArg = args[0]), method, args);
                if (result == null) {
                    result = KeyedExtensionFactory.this.getByKey(epBeans, null, method, args);
                }
                return result;
            }
        };
        return (T)Proxy.newProxyInstance(this.myInterfaceClass.getClassLoader(), new Class[]{this.myInterfaceClass}, handler);
    }

    public T getByKey(@NotNull KeyT key) {
        return KeyedExtensionFactory.findByKey(this.getKey(key), this.myEpName, this.myPicoContainer);
    }

    @Nullable
    public static <T> T findByKey(@NotNull String key, @NotNull ExtensionPointName<KeyedFactoryEPBean> point, @NotNull PicoContainer picoContainer) {
        for (KeyedFactoryEPBean epBean : point.getExtensionList()) {
            if (!key.equals(epBean.key) || epBean.implementationClass == null) continue;
            try {
                return epBean.instantiateClass(epBean.implementationClass, picoContainer);
            }
            catch (ExtensionInstantiationException | ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExtensionInstantiationException(e, epBean.getPluginDescriptor());
            }
        }
        return null;
    }

    private T getByKey(List<? extends KeyedFactoryEPBean> epBeans, String key, Method method, Object[] args) {
        Object result = null;
        for (KeyedFactoryEPBean keyedFactoryEPBean : epBeans) {
            if (!Comparing.strEqual((String)keyedFactoryEPBean.key, (String)key, (boolean)true)) continue;
            try {
                if (keyedFactoryEPBean.implementationClass != null) {
                    result = keyedFactoryEPBean.instantiateClass(keyedFactoryEPBean.implementationClass, this.myPicoContainer);
                } else {
                    Object factory = keyedFactoryEPBean.instantiateClass(keyedFactoryEPBean.factoryClass, this.myPicoContainer);
                    result = method.invoke(factory, args);
                }
                if (result == null) continue;
                break;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof ControlFlowException && t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new ExtensionInstantiationException(e, keyedFactoryEPBean.getPluginDescriptor());
            }
            catch (ExtensionInstantiationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                throw new ExtensionInstantiationException(e, keyedFactoryEPBean.getPluginDescriptor());
            }
            catch (Exception e) {
                throw new ExtensionInstantiationException(e, keyedFactoryEPBean.getPluginDescriptor());
            }
        }
        return (T)result;
    }

    @NotNull
    public abstract String getKey(@NotNull KeyT var1);
}

