/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAdapter;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointChangeListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.pico.DefaultPicoContainer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ExtensionPointImpl<@NotNull T>
implements ExtensionPoint<T>,
Iterable<T> {
    private static final ExtensionPointListener<?>[] EMPTY_ARRAY = new ExtensionPointListener[0];
    static final Logger LOG = Logger.getInstance(ExtensionPointImpl.class);
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private static final ArrayFactory<ExtensionPointListener<?>> LISTENER_ARRAY_FACTORY;
    private final String myName;
    private final String myClassName;
    private volatile List<T> myExtensionsCache;
    private volatile T @Nullable [] myExtensionsCacheAsArray;
    private ComponentManager componentManager;
    @NotNull
    protected final PluginDescriptor pluginDescriptor;
    @NotNull
    private volatile List<ExtensionComponentAdapter> myAdapters = Collections.emptyList();
    private volatile boolean adaptersIsSorted = true;
    private ExtensionPointListener<T> @NotNull [] myListeners = EMPTY_ARRAY;
    @Nullable
    private Class<T> myExtensionClass;
    private final boolean isDynamic;
    private final AtomicReference<ConcurrentMap<?, Map<?, ?>>> keyMapperToCacheRef = new AtomicReference();
    private static Runnable CHECK_CANCELED;

    ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, @Nullable Class<T> extensionClass, boolean dynamic) {
        this.myName = name;
        this.myClassName = className;
        this.pluginDescriptor = pluginDescriptor;
        this.myExtensionClass = extensionClass;
        this.isDynamic = dynamic;
    }

    final void setComponentManager(@NotNull ComponentManager value) {
        this.componentManager = value;
    }

    @NotNull
    final <CACHE_KEY, V> @NotNull ConcurrentMap<@NotNull CACHE_KEY, V> getCacheMap() {
        ConcurrentMap<?, Map<?, ?>> keyMapperToCache = this.keyMapperToCacheRef.get();
        if (keyMapperToCache == null) {
            keyMapperToCache = this.keyMapperToCacheRef.updateAndGet(prev -> prev == null ? new ConcurrentHashMap() : prev);
        }
        return keyMapperToCache;
    }

    @NotNull
    public final String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public final String getClassName() {
        return this.myClassName;
    }

    @Override
    public final boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        this.doRegisterExtension(extension, order, this.getPluginDescriptor(), null);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull Disposable parentDisposable) {
        this.registerExtension(extension, this.getPluginDescriptor(), parentDisposable);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull Disposable parentDisposable) {
        this.doRegisterExtension(extension, LoadingOrder.ANY, pluginDescriptor, parentDisposable);
    }

    @Override
    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull Disposable parentDisposable) {
        this.doRegisterExtension(extension, order, this.getPluginDescriptor(), parentDisposable);
    }

    public final ComponentManager getComponentManager() {
        return this.componentManager;
    }

    private synchronized void doRegisterExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull PluginDescriptor pluginDescriptor, @Nullable Disposable parentDisposable) {
        this.assertNotReadOnlyMode();
        this.checkExtensionType(extension, this.getExtensionClass(), null);
        for (ExtensionComponentAdapter adapter : this.myAdapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ((ObjectComponentAdapter)adapter).componentInstance != extension) continue;
            LOG.error("Extension was already added: " + extension);
            return;
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, pluginDescriptor, order);
        this.addExtensionAdapter(adapter);
        this.notifyListeners(false, Collections.singletonList(adapter), this.myListeners);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> {
                ExtensionPointImpl extensionPointImpl = this;
                synchronized (extensionPointImpl) {
                    int index = ContainerUtil.indexOfIdentity(this.myAdapters, (Object)adapter);
                    if (index < 0) {
                        LOG.error("Extension to be removed not found: " + adapter.componentInstance);
                    }
                    ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.myAdapters);
                    list.remove(index);
                    this.myAdapters = list;
                    this.clearCache();
                    this.notifyListeners(true, Collections.singletonList(adapter), this.myListeners);
                }
            });
        }
    }

    public final synchronized void registerExtensions(@NotNull List<? extends T> extensions) {
        for (ExtensionComponentAdapter extensionComponentAdapter : this.myAdapters) {
            if (!(extensionComponentAdapter instanceof ObjectComponentAdapter) || !ContainerUtil.containsIdentity(extensions, (Object)extensionComponentAdapter)) continue;
            LOG.error("Extension was already added: " + ((ObjectComponentAdapter)extensionComponentAdapter).componentInstance);
            return;
        }
        ArrayList<ExtensionComponentAdapter> newAdapters = new ArrayList<ExtensionComponentAdapter>(extensions.size());
        for (T extension : extensions) {
            newAdapters.add(new ObjectComponentAdapter(extension, this.getPluginDescriptor(), LoadingOrder.ANY));
        }
        if (this.myAdapters == Collections.emptyList()) {
            this.myAdapters = newAdapters;
        } else {
            ArrayList<ExtensionComponentAdapter> arrayList = new ArrayList<ExtensionComponentAdapter>(this.myAdapters.size() + newAdapters.size());
            arrayList.addAll(this.myAdapters);
            arrayList.addAll(ExtensionPointImpl.findInsertionIndexForAnyOrder(this.myAdapters), newAdapters);
            this.myAdapters = arrayList;
        }
        this.clearCache();
        this.notifyListeners(false, newAdapters, this.myListeners);
    }

    private static int findInsertionIndexForAnyOrder(@NotNull List<ExtensionComponentAdapter> adapters) {
        ExtensionComponentAdapter lastAdapter;
        int index;
        for (index = adapters.size(); index > 0 && (lastAdapter = adapters.get(index - 1)).getOrder() == LoadingOrder.LAST; --index) {
        }
        return index;
    }

    private void checkExtensionType(@NotNull T extension, @NotNull Class<T> extensionClass, @Nullable ExtensionComponentAdapter adapter) {
        if (!extensionClass.isInstance(extension)) {
            String message = "Extension " + extension.getClass() + " does not implement " + extensionClass;
            if (adapter != null) {
                message = message + " (adapter=" + adapter + ")";
            }
            throw new ExtensionException(message, extension.getClass());
        }
    }

    @Override
    @NotNull
    public final List<T> getExtensionList() {
        List<T> result = this.myExtensionsCache;
        return result != null ? result : this.calcExtensionList();
    }

    private synchronized List<T> calcExtensionList() {
        ImmutableList result = this.myExtensionsCache;
        if (result == null) {
            Object[] array = this.processAdapters();
            this.myExtensionsCacheAsArray = array;
            this.myExtensionsCache = result = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList((Object[])array);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T @NotNull [] getExtensions() {
        Object[] array = this.myExtensionsCacheAsArray;
        if (array == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array = this.myExtensionsCacheAsArray;
                if (array == null) {
                    array = this.processAdapters();
                    this.myExtensionsCacheAsArray = array;
                    this.myExtensionsCache = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList((Object[])array);
                }
            }
        }
        return array.length == 0 ? array : (Object[])array.clone();
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public final Iterator<T> iterator() {
        List<T> result = this.myExtensionsCache;
        return result == null ? this.createIterator() : result.iterator();
    }

    public final void processWithPluginDescriptor(boolean shouldBeSorted, @NotNull BiConsumer<? super T, ? super PluginDescriptor> consumer) {
        if (this.isInReadOnlyMode()) {
            for (T extension : this.myExtensionsCache) {
                consumer.accept(extension, this.pluginDescriptor);
            }
            return;
        }
        for (ExtensionComponentAdapter adapter : shouldBeSorted ? this.getThreadSafeAdapterList(true) : this.myAdapters) {
            T extension = this.processAdapter(adapter);
            if (extension == null) continue;
            consumer.accept(extension, adapter.getPluginDescriptor());
        }
    }

    public final void processImplementations(boolean shouldBeSorted, @NotNull BiConsumer<Supplier<T>, ? super PluginDescriptor> consumer) {
        if (this.isInReadOnlyMode()) {
            for (Object extension : this.myExtensionsCache) {
                consumer.accept(() -> extension, this.pluginDescriptor);
            }
            return;
        }
        for (ExtensionComponentAdapter adapter : shouldBeSorted ? this.getSortedAdapters() : this.myAdapters) {
            consumer.accept(() -> adapter.createInstance(this.componentManager), adapter.getPluginDescriptor());
        }
    }

    @NotNull
    private List<ExtensionComponentAdapter> getThreadSafeAdapterList(boolean failIfListenerAdded) {
        CHECK_CANCELED.run();
        if (!this.isDynamic && this.myListeners.length > 0) {
            String message = "Listeners not allowed for extension point " + this.getName();
            if (failIfListenerAdded) {
                LOG.error(message);
            } else {
                LOG.warn(message);
                this.getExtensionList();
            }
        }
        return this.getSortedAdapters();
    }

    @NotNull
    private Iterator<T> createIterator() {
        final List<ExtensionComponentAdapter> adapters = this.getThreadSafeAdapterList(true);
        final int size = adapters.size();
        if (size == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < size;
            }

            @Override
            @Nullable
            public T next() {
                do {
                    Object extension;
                    if ((extension = ExtensionPointImpl.this.processAdapter((ExtensionComponentAdapter)adapters.get(this.currentIndex++))) == null) continue;
                    return extension;
                } while (this.hasNext());
                return null;
            }
        };
    }

    @Override
    public final Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1281);
    }

    @Override
    @NotNull
    public final Stream<T> extensions() {
        List<T> result = this.myExtensionsCache;
        return result == null ? StreamSupport.stream(this.spliterator(), false) : result.stream();
    }

    @Override
    public final int size() {
        List<T> cache = this.myExtensionsCache;
        return cache == null ? this.myAdapters.size() : cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<ExtensionComponentAdapter> getSortedAdapters() {
        if (this.adaptersIsSorted) {
            return this.myAdapters;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            if (this.adaptersIsSorted) {
                return this.myAdapters;
            }
            if (this.myAdapters.size() > 1) {
                ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.myAdapters);
                LoadingOrder.sort(list);
                this.myAdapters = list;
            }
            this.adaptersIsSorted = true;
        }
        return this.myAdapters;
    }

    private T @NotNull [] processAdapters() {
        this.assertNotReadOnlyMode();
        CHECK_CANCELED.run();
        long startTime = StartUpMeasurer.getCurrentTime();
        List<ExtensionComponentAdapter> adapters = this.getSortedAdapters();
        int totalSize = adapters.size();
        Class<T> extensionClass = this.getExtensionClass();
        Object[] result = ArrayUtil.newArray(extensionClass, (int)totalSize);
        if (totalSize == 0) {
            return result;
        }
        ObjectOpenHashSet duplicates = this instanceof BeanExtensionPoint ? null : new ObjectOpenHashSet(totalSize);
        ExtensionPointListener<T>[] listeners = this.myListeners;
        int extensionIndex = 0;
        for (int i = 0; i < adapters.size(); ++i) {
            Object extension = this.processAdapter(adapters.get(i), listeners, result, duplicates, extensionClass, adapters);
            if (extension == null) continue;
            result[extensionIndex++] = extension;
        }
        if (extensionIndex != result.length) {
            result = Arrays.copyOf(result, extensionIndex);
        }
        ActivityCategory category = ExtensionPointImpl.getActivityCategory((DefaultPicoContainer)this.componentManager.getPicoContainer());
        StartUpMeasurer.addCompletedActivity((long)startTime, extensionClass, (ActivityCategory)category, null, (long)StartUpMeasurer.MEASURE_THRESHOLD);
        return result;
    }

    @NotNull
    public abstract ExtensionPointImpl<T> cloneFor(@NotNull ComponentManager var1);

    @NotNull
    private static ActivityCategory getActivityCategory(@NotNull DefaultPicoContainer picoContainer) {
        DefaultPicoContainer parent = picoContainer.getParent();
        if (parent == null) {
            return ActivityCategory.APP_EXTENSION;
        }
        if (parent.getParent() == null) {
            return ActivityCategory.PROJECT_EXTENSION;
        }
        return ActivityCategory.MODULE_EXTENSION;
    }

    @Nullable
    private synchronized T processAdapter(@NotNull ExtensionComponentAdapter adapter) {
        try {
            return adapter.createInstance(this.componentManager);
        }
        catch (ExtensionNotApplicableException ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    @Nullable
    private T processAdapter(@NotNull ExtensionComponentAdapter adapter, ExtensionPointListener<T> @Nullable [] listeners, T @Nullable [] result, @Nullable ObjectOpenHashSet<T> duplicates, @NotNull Class<T> extensionClassForCheck, @NotNull List<? extends ExtensionComponentAdapter> adapters) {
        try {
            Object duplicate;
            boolean isNotifyThatAdded = listeners != null && listeners.length != 0 && !adapter.isInstanceCreated() && !this.isDynamic;
            Object extension = adapter.createInstance(this.componentManager);
            if (duplicates != null && !duplicates.add(extension)) {
                duplicate = duplicates.get(extension);
                assert (result != null);
            } else {
                this.checkExtensionType(extension, extensionClassForCheck, adapter);
                if (isNotifyThatAdded) {
                    this.notifyListeners(false, Collections.singletonList(adapter), listeners);
                }
                return extension;
            }
            LOG.error("Duplicate extension found:\n                   " + extension + ";\n  prev extension:  " + duplicate + ";\n  adapter:         " + adapter + ";\n  extension class: " + extensionClassForCheck + ";\n  result:          " + Arrays.asList(result) + ";\n  adapters:        " + adapters);
        }
        catch (ExtensionNotApplicableException ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    public final synchronized void removeUnloadableExtensions() {
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        for (int i = adapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            try {
                adapter.getImplementationClass();
                continue;
            }
            catch (Throwable e) {
                if (adapters == this.myAdapters) {
                    adapters = new ArrayList<ExtensionComponentAdapter>(adapters);
                }
                adapters.remove(i);
                this.clearCache();
            }
        }
        this.myAdapters = adapters;
    }

    @ApiStatus.Internal
    public final synchronized void maskAll(final @NotNull List<T> list, @NotNull Disposable parentDisposable, final boolean fireEvents) {
        if (POINTS_IN_READONLY_MODE == null) {
            POINTS_IN_READONLY_MODE = Collections.newSetFromMap(new IdentityHashMap());
        } else {
            this.assertNotReadOnlyMode();
        }
        final List<T> oldList = this.myExtensionsCache;
        final Object[] oldArray = this.myExtensionsCacheAsArray;
        this.myExtensionsCache = ContainerUtil.immutableList(list);
        this.myExtensionsCacheAsArray = list.toArray(ArrayUtil.newArray(this.getExtensionClass(), (int)0));
        POINTS_IN_READONLY_MODE.add(this);
        ExtensionPointListener<T>[] listeners = this.myListeners;
        if (fireEvents && listeners.length > 0) {
            if (oldList != null) {
                this.doNotifyListeners(true, oldList, listeners);
            }
            this.doNotifyListeners(false, list, this.myListeners);
        }
        this.clearUserCache();
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    POINTS_IN_READONLY_MODE.remove(ExtensionPointImpl.this);
                    ExtensionPointImpl.this.myExtensionsCache = oldList;
                    ExtensionPointImpl.access$502(ExtensionPointImpl.this, oldArray);
                    ExtensionPointListener[] listeners = ExtensionPointImpl.this.myListeners;
                    if (fireEvents && listeners.length > 0) {
                        ExtensionPointImpl.this.doNotifyListeners(true, list, listeners);
                        if (oldList != null) {
                            ExtensionPointImpl.this.doNotifyListeners(false, oldList, listeners);
                        }
                    }
                    ExtensionPointImpl.this.clearUserCache();
                }
            }
        });
    }

    private void doNotifyListeners(boolean isRemoved, @NotNull List<T> extensions, @NotNull @NotNull ExtensionPointListener<T> @NotNull [] listeners) {
        for (ExtensionPointListener<T> listener : listeners) {
            if (listener instanceof ExtensionPointAdapter) {
                try {
                    ((ExtensionPointAdapter)listener).extensionListChanged();
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    continue;
                }
            }
            for (T extension : extensions) {
                try {
                    if (isRemoved) {
                        listener.extensionRemoved(extension, this.pluginDescriptor);
                        continue;
                    }
                    listener.extensionAdded(extension, this.pluginDescriptor);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public final synchronized void unregisterExtensions(@NotNull Predicate<? super T> filter) {
        this.getExtensionList();
        this.unregisterExtensions((clsName, adapter) -> {
            Object extension = adapter.createInstance(this.componentManager);
            return !filter.test((T)extension);
        }, false);
    }

    @Override
    public final synchronized void unregisterExtension(@NotNull T extension) {
        if (!this.unregisterExtensions((className, adapter) -> !adapter.isInstanceCreated() || adapter.createInstance(this.componentManager) != extension, true)) {
            LOG.warn("Extension to be removed not found: " + extension);
        }
    }

    @Override
    public final void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        String classNameToUnregister = extensionClass.getCanonicalName();
        if (!this.unregisterExtensions((className, adapter) -> !className.equals(classNameToUnregister), true)) {
            LOG.warn("Extension to be removed not found: " + extensionClass);
        }
    }

    @Override
    public final boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch) {
        ArrayList<Runnable> listenerCallbacks = new ArrayList<Runnable>();
        ArrayList<Runnable> priorityListenerCallbacks = new ArrayList<Runnable>();
        boolean result = this.unregisterExtensions(extensionClassFilter, stopAfterFirstMatch, priorityListenerCallbacks, listenerCallbacks);
        for (Runnable callback : priorityListenerCallbacks) {
            callback.run();
        }
        for (Runnable callback : listenerCallbacks) {
            callback.run();
        }
        return result;
    }

    final synchronized boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch, @NotNull List<Runnable> priorityListenerCallbacks, @NotNull List<Runnable> listenerCallbacks) {
        boolean found = false;
        Object[] listeners = this.myListeners;
        ArrayList<ExtensionComponentAdapter> removedAdapters = null;
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        for (int i = adapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            if (extensionClassFilter.test(adapter.getAssignableToClassName(), adapter)) continue;
            this.clearCache();
            if (adapters == this.myAdapters) {
                adapters = new ArrayList<ExtensionComponentAdapter>(adapters);
            }
            adapters.remove(i);
            if (listeners.length != 0) {
                if (removedAdapters == null) {
                    removedAdapters = new ArrayList<ExtensionComponentAdapter>();
                }
                removedAdapters.add(adapter);
            }
            found = true;
            if (stopAfterFirstMatch) break;
        }
        this.myAdapters = adapters;
        if (removedAdapters != null) {
            ArrayList<ExtensionComponentAdapter> finalRemovedAdapters = removedAdapters;
            List priorityListeners = ContainerUtil.filter((Object[])listeners, listener -> listener instanceof ExtensionPointPriorityListener);
            List regularListeners = ContainerUtil.filter((Object[])listeners, listener -> !(listener instanceof ExtensionPointPriorityListener));
            if (!priorityListeners.isEmpty()) {
                priorityListenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, priorityListeners.toArray(new ExtensionPointListener[priorityListeners.size()])));
            }
            if (!regularListeners.isEmpty()) {
                listenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, regularListeners.toArray(new ExtensionPointListener[regularListeners.size()])));
            }
        }
        return found;
    }

    abstract void unregisterExtensions(@NotNull ComponentManager var1, @NotNull PluginDescriptor var2, @NotNull List<Element> var3, @NotNull List<Runnable> var4, @NotNull List<Runnable> var5);

    private void notifyListeners(boolean isRemoved, @NotNull List<ExtensionComponentAdapter> adapters, @NotNull @NotNull ExtensionPointListener<T> @NotNull [] listeners) {
        for (ExtensionPointListener listener : listeners) {
            if (listener instanceof ExtensionPointAdapter) {
                try {
                    ((ExtensionPointAdapter)listener).extensionListChanged();
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    continue;
                }
            }
            for (ExtensionComponentAdapter adapter : adapters) {
                if (isRemoved && !adapter.isInstanceCreated()) continue;
                Object extension = adapter.createInstance(this.componentManager);
                try {
                    if (isRemoved) {
                        listener.extensionRemoved(extension, adapter.getPluginDescriptor());
                        continue;
                    }
                    listener.extensionAdded(extension, adapter.getPluginDescriptor());
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public final synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        boolean isAdded = this.addListener(listener);
        if (isAdded && invokeForLoadedExtensions) {
            this.notifyListeners(false, this.myAdapters, new ExtensionPointListener[]{listener});
        }
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> this.removeExtensionPointListener(listener));
        }
    }

    @NotNull
    private static <T> ArrayFactory<ExtensionPointListener<T>> listenerArrayFactory() {
        return LISTENER_ARRAY_FACTORY;
    }

    private boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (ArrayUtilRt.indexOf((Object[])this.myListeners, listener, (int)0, (int)this.myListeners.length) != -1) {
            return false;
        }
        this.myListeners = listener instanceof ExtensionPointPriorityListener ? (ExtensionPointListener[])ArrayUtil.prepend(listener, (Object[])this.myListeners, ExtensionPointImpl.listenerArrayFactory()) : (ExtensionPointListener[])ArrayUtil.append((Object[])this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
        return true;
    }

    @Override
    public final void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        this.addExtensionPointListener(listener, true, null);
    }

    @Override
    public final void addExtensionPointListener(final @NotNull ExtensionPointChangeListener listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        this.addExtensionPointListener(new ExtensionPointAdapter<T>(){

            @Override
            public void extensionListChanged() {
                listener.extensionListChanged();
            }
        }, invokeForLoadedExtensions, parentDisposable);
    }

    @Override
    public final void addChangeListener(final @NotNull Runnable listener, @Nullable Disposable parentDisposable) {
        ExtensionPointAdapter listenerAdapter = new ExtensionPointAdapter<T>(){

            @Override
            public void extensionListChanged() {
                listener.run();
            }
        };
        this.myListeners = (ExtensionPointListener[])ArrayUtil.append((Object[])this.myListeners, (Object)listenerAdapter, ExtensionPointImpl.listenerArrayFactory());
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> this.removeExtensionPointListener(listenerAdapter));
        }
    }

    @Override
    public final synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        this.myListeners = (ExtensionPointListener[])ArrayUtil.remove((Object[])this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
    }

    public final synchronized void reset() {
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        this.myAdapters = Collections.emptyList();
        this.clearCache();
        if (!adapters.isEmpty() && this.myListeners.length > 0) {
            this.notifyListeners(true, adapters, this.myListeners);
        }
        this.myListeners = EMPTY_ARRAY;
        this.myExtensionClass = null;
    }

    @NotNull
    public final Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.pluginDescriptor.getPluginClassLoader();
                this.myExtensionClass = extensionClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw this.componentManager.createError(e, this.pluginDescriptor.getPluginId());
            }
        }
        return extensionClass;
    }

    public final String toString() {
        return this.getName();
    }

    final synchronized void addExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.myAdapters.size() + 1);
        list.addAll(this.myAdapters);
        list.add(adapter);
        this.myAdapters = list;
        this.clearCache();
    }

    final void clearUserCache() {
        ConcurrentMap<?, Map<?, ?>> map = this.keyMapperToCacheRef.get();
        if (map != null) {
            map.clear();
        }
    }

    private void clearCache() {
        this.myExtensionsCache = null;
        this.myExtensionsCacheAsArray = null;
        this.adaptersIsSorted = false;
        this.clearUserCache();
        this.assertNotReadOnlyMode();
    }

    private void assertNotReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    @NotNull
    protected abstract ExtensionComponentAdapter createAdapterAndRegisterInPicoContainerIfNeeded(@NotNull Element var1, @NotNull PluginDescriptor var2, @NotNull ComponentManager var3);

    final synchronized void createAndRegisterAdapter(@NotNull Element extensionElement, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager) {
        this.addExtensionAdapter(this.createAdapterAndRegisterInPicoContainerIfNeeded(extensionElement, pluginDescriptor, componentManager));
    }

    final synchronized void registerExtensions(@NotNull List<Element> extensionElements, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable List<Runnable> listenerCallbacks) {
        List<ExtensionComponentAdapter> adapters;
        if (this.componentManager != componentManager) {
            LOG.error("The same point on different levels (pointName=" + this.getName() + ")");
        }
        if ((adapters = this.myAdapters) == Collections.emptyList()) {
            this.myAdapters = adapters = new ArrayList<ExtensionComponentAdapter>(extensionElements.size());
            this.adaptersIsSorted = false;
        } else {
            ((ArrayList)adapters).ensureCapacity(adapters.size() + extensionElements.size());
        }
        int oldSize = adapters.size();
        for (Element extensionElement : extensionElements) {
            adapters.add(this.createAdapterAndRegisterInPicoContainerIfNeeded(extensionElement, pluginDescriptor, componentManager));
        }
        int newSize = adapters.size();
        this.clearCache();
        ExtensionPointListener[] listeners = this.myListeners;
        if (listenerCallbacks == null || listeners.length == 0) {
            return;
        }
        List addedAdapters = Collections.emptyList();
        for (ExtensionPointListener<T> extensionPointListener : listeners) {
            if (extensionPointListener instanceof ExtensionPointAdapter) continue;
            List<ExtensionComponentAdapter> newlyAddedUnsortedList = adapters.subList(oldSize, newSize);
            Set newlyAddedSet = Collections.newSetFromMap(new IdentityHashMap(newlyAddedUnsortedList.size()));
            newlyAddedSet.addAll(newlyAddedUnsortedList);
            addedAdapters = new ArrayList(newlyAddedSet.size());
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                if (!newlyAddedSet.contains(adapter)) continue;
                addedAdapters.add(adapter);
            }
            break;
        }
        List finalAddedAdapters = addedAdapters;
        listenerCallbacks.add(() -> this.notifyListeners(false, finalAddedAdapters, listeners));
    }

    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        for (ExtensionPointListener<T> listener : this.myListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    @Nullable
    public final <V extends T> V findExtension(@NotNull Class<V> aClass, boolean isRequired, @NotNull ThreeState strictMatch) {
        List<T> extensionsCache;
        if (strictMatch != ThreeState.NO) {
            V result = this.findExtensionByExactClass(aClass);
            if (result != null) {
                return result;
            }
            if (strictMatch == ThreeState.YES) {
                return null;
            }
        }
        if ((extensionsCache = this.myExtensionsCache) == null) {
            for (ExtensionComponentAdapter adapter : this.getThreadSafeAdapterList(false)) {
                try {
                    if (!aClass.isAssignableFrom(adapter.getImplementationClass())) continue;
                    return (V)this.processAdapter(adapter);
                }
                catch (ClassNotFoundException e) {
                    this.componentManager.logError(e, adapter.getPluginDescriptor().getPluginId());
                }
            }
        } else {
            for (Object extension : extensionsCache) {
                if (!aClass.isInstance(extension)) continue;
                return (V)extension;
            }
        }
        if (isRequired) {
            String message = "could not find extension implementation " + aClass;
            if (this.isInReadOnlyMode()) {
                message = message + " (point in read-only mode)";
            }
            throw new IllegalArgumentException(message);
        }
        return null;
    }

    @Nullable
    private T findExtensionByExactClass(@NotNull Class<? extends T> aClass) {
        List<T> extensionsCache = this.myExtensionsCache;
        if (extensionsCache == null) {
            for (ExtensionComponentAdapter adapter : this.getThreadSafeAdapterList(false)) {
                Object classOrName = adapter.myImplementationClassOrName;
                if (!(classOrName instanceof String ? classOrName.equals(aClass.getName()) : classOrName == aClass)) continue;
                return this.processAdapter(adapter);
            }
        } else {
            for (T extension : extensionsCache) {
                if (aClass != extension.getClass()) continue;
                return extension;
            }
        }
        return null;
    }

    private synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    public static void setCheckCanceledAction(@NotNull Runnable checkCanceled) {
        CHECK_CANCELED = () -> {
            block2: {
                try {
                    checkCanceled.run();
                }
                catch (ProcessCanceledException e) {
                    if (ExtensionPointImpl.isInsideClassInitializer(e.getStackTrace())) break block2;
                    throw e;
                }
            }
        };
    }

    private static boolean isInsideClassInitializer(StackTraceElement @NotNull [] trace) {
        return Arrays.stream(trace).anyMatch(s -> "<clinit>".equals(s.getMethodName()));
    }

    static /* synthetic */ Object[] access$502(ExtensionPointImpl x0, Object[] x1) {
        x0.myExtensionsCacheAsArray = x1;
        return x1;
    }

    static {
        LISTENER_ARRAY_FACTORY = n -> n == 0 ? EMPTY_ARRAY : new ExtensionPointListener[n];
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        @NotNull
        private final T componentInstance;

        private ObjectComponentAdapter(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull LoadingOrder loadingOrder) {
            super(extension.getClass().getName(), pluginDescriptor, null, loadingOrder);
            this.componentInstance = extension;
        }

        @Override
        boolean isInstanceCreated() {
            return true;
        }

        @NotNull
        public <I> I createInstance(@Nullable ComponentManager componentManager) {
            return (I)this.componentInstance;
        }
    }
}

