/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public interface ComponentManager
extends UserDataHolder,
Disposable,
AreaInstance {
    @Deprecated
    @Nullable
    default public BaseComponent getComponent(@NotNull String name) {
        return null;
    }

    public <T> T getComponent(@NotNull Class<T> var1);

    @Deprecated
    default public <T> T getComponent(@NotNull Class<T> interfaceClass, T defaultImplementationIfAbsent) {
        T component = this.getComponent(interfaceClass);
        return component == null ? defaultImplementationIfAbsent : component;
    }

    default public boolean hasComponent(@NotNull Class<?> interfaceClass) {
        return this.getPicoContainer().getComponentAdapter(interfaceClass) != null;
    }

    @Deprecated
    default public <T> T @NotNull [] getComponents(@NotNull Class<T> baseClass) {
        return ArrayUtil.toObjectArray(this.getComponentInstancesOfType(baseClass, false), baseClass);
    }

    @NotNull
    public PicoContainer getPicoContainer();

    @NotNull
    public MessageBus getMessageBus();

    public boolean isDisposed();

    @Deprecated
    default public boolean isDisposedOrDisposeInProgress() {
        return this.isDisposed();
    }

    @Deprecated
    default public <T> T @NotNull [] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        return this.getExtensionArea().getExtensionPoint(extensionPointName).getExtensions();
    }

    @NotNull
    public Condition<?> getDisposed();

    @Deprecated
    default public <T> T getService(@NotNull Class<T> serviceClass, boolean createIfNeeded) {
        if (createIfNeeded) {
            return this.getService(serviceClass);
        }
        return this.getServiceIfCreated(serviceClass);
    }

    default public <T> T getService(@NotNull Class<T> serviceClass) {
        return (T)this.getPicoContainer().getComponentInstance(serviceClass.getName());
    }

    @Nullable
    default public <T> T getServiceIfCreated(@NotNull Class<T> serviceClass) {
        return this.getService(serviceClass);
    }

    @Override
    @NotNull
    default public ExtensionsArea getExtensionArea() {
        throw new AbstractMethodError();
    }

    @ApiStatus.Internal
    default public <T> T instantiateClass(@NotNull Class<T> aClass, @Nullable PluginId pluginId) {
        return (T)ReflectionUtil.newInstance(aClass, (boolean)false);
    }

    @ApiStatus.Internal
    default public <T> T instantiateClassWithConstructorInjection(@NotNull Class<T> aClass, @NotNull Object key, @NotNull PluginId pluginId) {
        return (T)new CachingConstructorInjectionComponentAdapter(key, aClass).getComponentInstance(this.getPicoContainer());
    }

    @ApiStatus.Internal
    default public void logError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        throw this.createError(error, pluginId);
    }

    @ApiStatus.Internal
    @NotNull
    default public RuntimeException createError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        ExceptionUtilRt.rethrowUnchecked((Throwable)error);
        return new RuntimeException(error);
    }

    @ApiStatus.Internal
    @NotNull
    default public RuntimeException createError(@NotNull String message, @NotNull PluginId pluginId) {
        return new RuntimeException(message);
    }

    @ApiStatus.Internal
    @NotNull
    default public <T> T instantiateExtensionWithPicoContainerOnlyIfNeeded(@Nullable String name, @Nullable PluginDescriptor pluginDescriptor) {
        try {
            return (T)ReflectionUtil.newInstance(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    default public <T> List<T> getComponentInstancesOfType(@NotNull Class<T> baseClass) {
        return this.getComponentInstancesOfType(baseClass, false);
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    default public <T> List<T> getComponentInstancesOfType(@NotNull Class<T> baseClass, boolean createIfNotYet) {
        throw new UnsupportedOperationException();
    }
}

