/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.compat.annotation.UnsupportedAppUsage;
import android.system.ErrnoException;
import android.system.Int32Ref;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructGroupReq;
import android.system.StructLinger;
import android.system.StructPollfd;
import android.system.StructTimeval;
import com.android.internal.lang.System_Delegate;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import libcore.io.AsynchronousCloseMonitor;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.util.ArrayUtils;

public class IoBridge {
    public static final int JAVA_MCAST_JOIN_GROUP = 19;
    public static final int JAVA_MCAST_LEAVE_GROUP = 20;
    public static final int JAVA_IP_MULTICAST_TTL = 17;
    public static final int JAVA_IP_TTL = 25;

    private IoBridge() {
    }

    public static int available(FileDescriptor fd) throws IOException {
        try {
            Int32Ref available = new Int32Ref(0);
            Libcore.os.ioctlInt(fd, OsConstants.FIONREAD, available);
            if (available.value < 0) {
                available.value = 0;
            }
            return available.value;
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.ENOTTY) {
                return 0;
            }
            throw errnoException.rethrowAsIOException();
        }
    }

    public static void bind(FileDescriptor fd, InetAddress address, int port) throws SocketException {
        Inet6Address inet6Address;
        if (address instanceof Inet6Address && (inet6Address = (Inet6Address)address).getScopeId() == 0 && inet6Address.isLinkLocalAddress()) {
            NetworkInterface nif = NetworkInterface.getByInetAddress(address);
            if (nif == null) {
                throw new SocketException("Can't bind to a link-local address without a scope id: " + address);
            }
            try {
                address = Inet6Address.getByAddress(address.getHostName(), address.getAddress(), nif.getIndex());
            }
            catch (UnknownHostException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        try {
            Libcore.os.bind(fd, address, port);
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EADDRINUSE || errnoException.errno == OsConstants.EADDRNOTAVAIL || errnoException.errno == OsConstants.EPERM || errnoException.errno == OsConstants.EACCES) {
                throw new BindException(errnoException.getMessage(), (Throwable)errnoException);
            }
            throw new SocketException(errnoException.getMessage(), errnoException);
        }
    }

    public static void connect(FileDescriptor fd, InetAddress inetAddress, int port) throws SocketException {
        try {
            IoBridge.connect(fd, inetAddress, port, 0);
        }
        catch (SocketTimeoutException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static void connect(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs) throws SocketException, SocketTimeoutException {
        try {
            IoBridge.connectErrno(fd, inetAddress, port, timeoutMs);
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EHOSTUNREACH) {
                throw new NoRouteToHostException("Host unreachable");
            }
            if (errnoException.errno == OsConstants.EADDRNOTAVAIL) {
                throw new NoRouteToHostException("Address not available");
            }
            throw new ConnectException(IoBridge.createMessageForException(fd, inetAddress, port, timeoutMs, errnoException), (Throwable)errnoException);
        }
        catch (SocketException ex) {
            throw ex;
        }
        catch (SocketTimeoutException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }

    private static void connectErrno(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs) throws ErrnoException, IOException {
        if (timeoutMs <= 0) {
            Libcore.os.connect(fd, inetAddress, port);
            return;
        }
        IoUtils.setBlocking(fd, false);
        long finishTimeNanos = System_Delegate.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        try {
            Libcore.os.connect(fd, inetAddress, port);
            IoUtils.setBlocking(fd, true);
            return;
        }
        catch (ErrnoException errnoException) {
            int remainingTimeoutMs;
            if (errnoException.errno != OsConstants.EINPROGRESS) {
                throw errnoException;
            }
            do {
                if ((remainingTimeoutMs = (int)TimeUnit.NANOSECONDS.toMillis(finishTimeNanos - System_Delegate.nanoTime())) > 0) continue;
                throw new SocketTimeoutException(IoBridge.createMessageForException(fd, inetAddress, port, timeoutMs, null));
            } while (!IoBridge.isConnected(fd, inetAddress, port, timeoutMs, remainingTimeoutMs));
            IoUtils.setBlocking(fd, true);
            return;
        }
    }

    private static String createMessageForException(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs, Exception causeOrNull) {
        InetSocketAddress localAddress = null;
        try {
            localAddress = IoBridge.getLocalInetSocketAddress(fd);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder("failed to connect").append(" to ").append(inetAddress).append(" (port ").append(port).append(")");
        if (localAddress != null) {
            sb.append(" from ").append(localAddress.getAddress()).append(" (port ").append(localAddress.getPort()).append(")");
        }
        if (timeoutMs > 0) {
            sb.append(" after ").append(timeoutMs).append("ms");
        }
        if (causeOrNull != null) {
            sb.append(": ").append(causeOrNull.getMessage());
        }
        return sb.toString();
    }

    public static void closeAndSignalBlockedThreads(FileDescriptor fd) throws IOException {
        if (fd == null || !fd.valid()) {
            return;
        }
        FileDescriptor oldFd = fd.release$();
        AsynchronousCloseMonitor.signalBlockedThreads(oldFd);
        try {
            Libcore.os.close(oldFd);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    @UnsupportedAppUsage
    public static boolean isConnected(FileDescriptor fd, InetAddress inetAddress, int port, int timeoutMs, int remainingTimeoutMs) throws IOException {
        try {
            StructPollfd[] pollFds = new StructPollfd[]{new StructPollfd()};
            pollFds[0].fd = fd;
            pollFds[0].events = (short)OsConstants.POLLOUT;
            int rc = Libcore.os.poll(pollFds, remainingTimeoutMs);
            if (rc == 0) {
                return false;
            }
            int connectError = Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_ERROR);
            if (connectError == 0) {
                return true;
            }
            throw new ErrnoException("isConnected", connectError);
        }
        catch (ErrnoException errnoException) {
            if (!fd.valid()) {
                throw new SocketException("Socket closed");
            }
            ErrnoException cause = errnoException;
            String detail = IoBridge.createMessageForException(fd, inetAddress, port, timeoutMs, cause);
            if (cause.errno == OsConstants.ETIMEDOUT) {
                SocketTimeoutException e = new SocketTimeoutException(detail);
                e.initCause(cause);
                throw e;
            }
            throw new ConnectException(detail, (Throwable)cause);
        }
    }

    public static Object getSocketOption(FileDescriptor fd, int option) throws SocketException {
        try {
            return IoBridge.getSocketOptionErrno(fd, option);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private static Object getSocketOptionErrno(FileDescriptor fd, int option) throws ErrnoException, SocketException {
        switch (option) {
            case 16: 
            case 31: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_IF);
            }
            case 18: {
                return !IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_LOOP));
            }
            case 17: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_HOPS);
            }
            case 25: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_UNICAST_HOPS);
            }
            case 3: {
                return Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_TCLASS);
            }
            case 32: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_BROADCAST));
            }
            case 8: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_KEEPALIVE));
            }
            case 128: {
                StructLinger linger = Libcore.os.getsockoptLinger(fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER);
                if (!linger.isOn()) {
                    return false;
                }
                return linger.l_linger;
            }
            case 4099: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_OOBINLINE));
            }
            case 4098: {
                return Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF);
            }
            case 4: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_REUSEADDR));
            }
            case 4097: {
                return Libcore.os.getsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDBUF);
            }
            case 4102: {
                return (int)Libcore.os.getsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO).toMillis();
            }
            case 1: {
                return IoBridge.booleanFromInt(Libcore.os.getsockoptInt(fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY));
            }
            case 15: {
                return ((InetSocketAddress)Libcore.os.getsockname(fd)).getAddress();
            }
        }
        throw new SocketException("Unknown socket option: " + option);
    }

    private static boolean booleanFromInt(int i) {
        return i != 0;
    }

    private static int booleanToInt(boolean b) {
        return b ? 1 : 0;
    }

    public static void setSocketOption(FileDescriptor fd, int option, Object value) throws SocketException {
        try {
            IoBridge.setSocketOptionErrno(fd, option, value);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private static void setSocketOptionErrno(FileDescriptor fd, int option, Object value) throws ErrnoException, SocketException {
        switch (option) {
            case 16: {
                NetworkInterface nif = NetworkInterface.getByInetAddress((InetAddress)value);
                if (nif == null) {
                    throw new SocketException("bad argument for IP_MULTICAST_IF : address not bound to any interface");
                }
                Libcore.os.setsockoptIpMreqn(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_IF, nif.getIndex());
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_IF, nif.getIndex());
                return;
            }
            case 31: {
                Libcore.os.setsockoptIpMreqn(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_IF, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_IF, (Integer)value);
                return;
            }
            case 18: {
                int enable = IoBridge.booleanToInt((Boolean)value == false);
                Libcore.os.setsockoptByte(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_LOOP, enable);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_LOOP, enable);
                return;
            }
            case 17: {
                Libcore.os.setsockoptByte(fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_TTL, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_MULTICAST_HOPS, (Integer)value);
                return;
            }
            case 25: {
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IP, OsConstants.IP_TTL, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_UNICAST_HOPS, (Integer)value);
                return;
            }
            case 3: {
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IP, OsConstants.IP_TOS, (Integer)value);
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_IPV6, OsConstants.IPV6_TCLASS, (Integer)value);
                return;
            }
            case 32: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_BROADCAST, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 8: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_KEEPALIVE, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 128: {
                boolean on = false;
                int seconds = 0;
                if (value instanceof Integer) {
                    on = true;
                    seconds = Math.min((Integer)value, 65535);
                }
                StructLinger linger = new StructLinger(IoBridge.booleanToInt(on), seconds);
                Libcore.os.setsockoptLinger(fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER, linger);
                return;
            }
            case 4099: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_OOBINLINE, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 4098: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF, (Integer)value);
                return;
            }
            case 4: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_REUSEADDR, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 4097: {
                Libcore.os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDBUF, (Integer)value);
                return;
            }
            case 4102: {
                int millis = (Integer)value;
                StructTimeval tv = StructTimeval.fromMillis(millis);
                Libcore.os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, tv);
                return;
            }
            case 1: {
                Libcore.os.setsockoptInt(fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY, IoBridge.booleanToInt((Boolean)value));
                return;
            }
            case 19: 
            case 20: {
                StructGroupReq groupReq = (StructGroupReq)value;
                int level = groupReq.gr_group instanceof Inet4Address ? OsConstants.IPPROTO_IP : OsConstants.IPPROTO_IPV6;
                int op = option == 19 ? OsConstants.MCAST_JOIN_GROUP : OsConstants.MCAST_LEAVE_GROUP;
                Libcore.os.setsockoptGroupReq(fd, level, op, groupReq);
                return;
            }
        }
        throw new SocketException("Unknown socket option: " + option);
    }

    public static FileDescriptor open(String path, int flags) throws FileNotFoundException {
        FileDescriptor fd = null;
        try {
            fd = Libcore.os.open(path, flags, 438);
            if (OsConstants.S_ISDIR(Libcore.os.fstat((FileDescriptor)fd).st_mode)) {
                throw new ErrnoException("open", OsConstants.EISDIR);
            }
            return fd;
        }
        catch (ErrnoException errnoException) {
            try {
                if (fd != null) {
                    IoBridge.closeAndSignalBlockedThreads(fd);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileNotFoundException ex = new FileNotFoundException(path + ": " + errnoException.getMessage());
            ex.initCause(errnoException);
            throw ex;
        }
    }

    public static int read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws IOException {
        ArrayUtils.throwsIfOutOfBounds(bytes.length, byteOffset, byteCount);
        if (byteCount == 0) {
            return 0;
        }
        try {
            int readCount = Libcore.os.read(fd, bytes, byteOffset, byteCount);
            if (readCount == 0) {
                return -1;
            }
            return readCount;
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                return 0;
            }
            throw errnoException.rethrowAsIOException();
        }
    }

    public static void write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws IOException {
        ArrayUtils.throwsIfOutOfBounds(bytes.length, byteOffset, byteCount);
        if (byteCount == 0) {
            return;
        }
        try {
            while (byteCount > 0) {
                int bytesWritten = Libcore.os.write(fd, bytes, byteOffset, byteCount);
                byteCount -= bytesWritten;
                byteOffset += bytesWritten;
            }
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static int sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetAddress inetAddress, int port) throws IOException {
        int result;
        boolean isDatagram;
        boolean bl = isDatagram = inetAddress != null;
        if (!isDatagram && byteCount <= 0) {
            return 0;
        }
        try {
            result = Libcore.os.sendto(fd, bytes, byteOffset, byteCount, flags, inetAddress, port);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterSendto(isDatagram, errnoException);
        }
        return result;
    }

    public static int sendto(FileDescriptor fd, ByteBuffer buffer, int flags, InetAddress inetAddress, int port) throws IOException {
        int result;
        boolean isDatagram;
        boolean bl = isDatagram = inetAddress != null;
        if (!isDatagram && buffer.remaining() == 0) {
            return 0;
        }
        try {
            result = Libcore.os.sendto(fd, buffer, flags, inetAddress, port);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterSendto(isDatagram, errnoException);
        }
        return result;
    }

    private static int maybeThrowAfterSendto(boolean isDatagram, ErrnoException errnoException) throws IOException {
        if (isDatagram) {
            if (errnoException.errno == OsConstants.ECONNREFUSED) {
                throw new PortUnreachableException("ICMP Port Unreachable");
            }
        } else if (errnoException.errno == OsConstants.EAGAIN) {
            return 0;
        }
        throw errnoException.rethrowAsIOException();
    }

    public static int recvfrom(boolean isRead, FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, DatagramPacket packet, boolean isConnected) throws IOException {
        int result;
        try {
            InetSocketAddress srcAddress = packet != null ? new InetSocketAddress() : null;
            result = Libcore.os.recvfrom(fd, bytes, byteOffset, byteCount, flags, srcAddress);
            result = IoBridge.postRecvfrom(isRead, packet, srcAddress, result);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterRecvfrom(isRead, isConnected, errnoException);
        }
        return result;
    }

    public static int recvfrom(boolean isRead, FileDescriptor fd, ByteBuffer buffer, int flags, DatagramPacket packet, boolean isConnected) throws IOException {
        int result;
        try {
            InetSocketAddress srcAddress = packet != null ? new InetSocketAddress() : null;
            result = Libcore.os.recvfrom(fd, buffer, flags, srcAddress);
            result = IoBridge.postRecvfrom(isRead, packet, srcAddress, result);
        }
        catch (ErrnoException errnoException) {
            result = IoBridge.maybeThrowAfterRecvfrom(isRead, isConnected, errnoException);
        }
        return result;
    }

    private static int postRecvfrom(boolean isRead, DatagramPacket packet, InetSocketAddress srcAddress, int byteCount) {
        if (isRead && byteCount == 0) {
            return -1;
        }
        if (packet != null) {
            packet.setReceivedLength(byteCount);
            packet.setPort(srcAddress.getPort());
            if (!srcAddress.getAddress().equals(packet.getAddress())) {
                packet.setAddress(srcAddress.getAddress());
            }
        }
        return byteCount;
    }

    private static int maybeThrowAfterRecvfrom(boolean isRead, boolean isConnected, ErrnoException errnoException) throws SocketException, SocketTimeoutException {
        if (isRead) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                return 0;
            }
            throw errnoException.rethrowAsSocketException();
        }
        if (isConnected && errnoException.errno == OsConstants.ECONNREFUSED) {
            throw new PortUnreachableException("ICMP Port Unreachable", (Throwable)errnoException);
        }
        if (errnoException.errno == OsConstants.EAGAIN) {
            SocketTimeoutException e = new SocketTimeoutException();
            e.initCause(errnoException);
            throw e;
        }
        throw errnoException.rethrowAsSocketException();
    }

    public static FileDescriptor socket(int domain, int type, int protocol) throws SocketException {
        try {
            FileDescriptor fd = Libcore.os.socket(domain, type, protocol);
            return fd;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    public static void poll(FileDescriptor fd, int events, int timeout) throws SocketException, SocketTimeoutException {
        StructPollfd[] pollFds = new StructPollfd[]{new StructPollfd()};
        pollFds[0].fd = fd;
        pollFds[0].events = (short)events;
        try {
            int ret = Os.poll(pollFds, timeout);
            if (ret == 0) {
                throw new SocketTimeoutException("Poll timed out");
            }
        }
        catch (ErrnoException e) {
            e.rethrowAsSocketException();
        }
    }

    public static InetSocketAddress getLocalInetSocketAddress(FileDescriptor fd) throws SocketException {
        try {
            SocketAddress socketAddress = Libcore.os.getsockname(fd);
            if (socketAddress != null && !(socketAddress instanceof InetSocketAddress)) {
                throw new SocketException("Socket assumed to be pending closure: Expected sockname to be an InetSocketAddress, got " + socketAddress.getClass());
            }
            return (InetSocketAddress)socketAddress;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }
}

