/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.pm.FeatureInfo;
import android.os.CarrierAssociatedAppEntry;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Process;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.os.incremental.IncrementalManager;
import android.os.storage.StorageManager;
import android.permission.PermissionManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimingsTraceLog;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SystemConfig {
    static final String TAG = "SystemConfig";
    static SystemConfig sInstance;
    private static final int ALLOW_FEATURES = 1;
    private static final int ALLOW_LIBS = 2;
    private static final int ALLOW_PERMISSIONS = 4;
    private static final int ALLOW_APP_CONFIGS = 8;
    private static final int ALLOW_PRIVAPP_PERMISSIONS = 16;
    private static final int ALLOW_OEM_PERMISSIONS = 32;
    private static final int ALLOW_HIDDENAPI_WHITELISTING = 64;
    private static final int ALLOW_ASSOCIATIONS = 128;
    private static final int ALLOW_ALL = -1;
    private static final String SKU_PROPERTY = "ro.boot.product.hardware.sku";
    private static final String VENDOR_SKU_PROPERTY = "ro.boot.product.vendor.sku";
    int[] mGlobalGids;
    final SparseArray<ArraySet<String>> mSystemPermissions = new SparseArray();
    final ArrayList<PermissionManager.SplitPermissionInfo> mSplitPermissions = new ArrayList();
    final ArrayMap<String, SharedLibraryEntry> mSharedLibraries = new ArrayMap();
    final ArrayMap<String, FeatureInfo> mAvailableFeatures = new ArrayMap();
    final ArraySet<String> mUnavailableFeatures = new ArraySet();
    final ArrayMap<String, PermissionEntry> mPermissions = new ArrayMap();
    final ArraySet<String> mAllowInPowerSaveExceptIdle = new ArraySet();
    final ArraySet<String> mAllowInPowerSave = new ArraySet();
    final ArraySet<String> mAllowInDataUsageSave = new ArraySet();
    final ArraySet<String> mAllowUnthrottledLocation = new ArraySet();
    final ArraySet<String> mAllowIgnoreLocationSettings = new ArraySet();
    final ArraySet<String> mAllowImplicitBroadcasts = new ArraySet();
    final ArraySet<String> mLinkedApps = new ArraySet();
    final ArraySet<String> mSystemUserWhitelistedApps = new ArraySet();
    final ArraySet<String> mSystemUserBlacklistedApps = new ArraySet();
    final ArraySet<ComponentName> mDefaultVrComponents = new ArraySet();
    final ArraySet<ComponentName> mBackupTransportWhitelist = new ArraySet();
    final ArrayMap<String, ArrayMap<String, Boolean>> mPackageComponentEnabledState = new ArrayMap();
    final ArraySet<String> mHiddenApiPackageWhitelist = new ArraySet();
    final ArraySet<String> mDisabledUntilUsedPreinstalledCarrierApps = new ArraySet();
    final ArrayMap<String, List<CarrierAssociatedAppEntry>> mDisabledUntilUsedPreinstalledCarrierAssociatedApps = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mPrivAppPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mPrivAppDenyPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mVendorPrivAppPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mVendorPrivAppDenyPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mProductPrivAppPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mProductPrivAppDenyPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mSystemExtPrivAppPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mSystemExtPrivAppDenyPermissions = new ArrayMap();
    final ArrayMap<String, ArrayMap<String, Boolean>> mOemPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mAllowedAssociations = new ArrayMap();
    private final ArraySet<String> mBugreportWhitelistedPackages = new ArraySet();
    private final ArraySet<String> mAppDataIsolationWhitelistedApps = new ArraySet();
    private ArrayMap<String, Set<String>> mPackageToUserTypeWhitelist = new ArrayMap();
    private ArrayMap<String, Set<String>> mPackageToUserTypeBlacklist = new ArrayMap();
    private final ArraySet<String> mRollbackWhitelistedPackages = new ArraySet();
    private final ArraySet<String> mWhitelistedStagedInstallers = new ArraySet();
    private Map<String, Map<String, String>> mNamedActors = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemConfig getInstance() {
        if (!SystemConfig.isSystemProcess()) {
            Slog.wtf(TAG, "SystemConfig is being accessed by a process other than system_server.");
        }
        Class<SystemConfig> clazz = SystemConfig.class;
        synchronized (SystemConfig.class) {
            if (sInstance == null) {
                sInstance = new SystemConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public int[] getGlobalGids() {
        return this.mGlobalGids;
    }

    public SparseArray<ArraySet<String>> getSystemPermissions() {
        return this.mSystemPermissions;
    }

    public ArrayList<PermissionManager.SplitPermissionInfo> getSplitPermissions() {
        return this.mSplitPermissions;
    }

    public ArrayMap<String, SharedLibraryEntry> getSharedLibraries() {
        return this.mSharedLibraries;
    }

    public ArrayMap<String, FeatureInfo> getAvailableFeatures() {
        return this.mAvailableFeatures;
    }

    public ArrayMap<String, PermissionEntry> getPermissions() {
        return this.mPermissions;
    }

    public ArraySet<String> getAllowImplicitBroadcasts() {
        return this.mAllowImplicitBroadcasts;
    }

    public ArraySet<String> getAllowInPowerSaveExceptIdle() {
        return this.mAllowInPowerSaveExceptIdle;
    }

    public ArraySet<String> getAllowInPowerSave() {
        return this.mAllowInPowerSave;
    }

    public ArraySet<String> getAllowInDataUsageSave() {
        return this.mAllowInDataUsageSave;
    }

    public ArraySet<String> getAllowUnthrottledLocation() {
        return this.mAllowUnthrottledLocation;
    }

    public ArraySet<String> getAllowIgnoreLocationSettings() {
        return this.mAllowIgnoreLocationSettings;
    }

    public ArraySet<String> getLinkedApps() {
        return this.mLinkedApps;
    }

    public ArraySet<String> getSystemUserWhitelistedApps() {
        return this.mSystemUserWhitelistedApps;
    }

    public ArraySet<String> getSystemUserBlacklistedApps() {
        return this.mSystemUserBlacklistedApps;
    }

    public ArraySet<String> getHiddenApiWhitelistedApps() {
        return this.mHiddenApiPackageWhitelist;
    }

    public ArraySet<ComponentName> getDefaultVrComponents() {
        return this.mDefaultVrComponents;
    }

    public ArraySet<ComponentName> getBackupTransportWhitelist() {
        return this.mBackupTransportWhitelist;
    }

    public ArrayMap<String, Boolean> getComponentsEnabledStates(String packageName) {
        return this.mPackageComponentEnabledState.get(packageName);
    }

    public ArraySet<String> getDisabledUntilUsedPreinstalledCarrierApps() {
        return this.mDisabledUntilUsedPreinstalledCarrierApps;
    }

    public ArrayMap<String, List<CarrierAssociatedAppEntry>> getDisabledUntilUsedPreinstalledCarrierAssociatedApps() {
        return this.mDisabledUntilUsedPreinstalledCarrierAssociatedApps;
    }

    public ArraySet<String> getPrivAppPermissions(String packageName) {
        return this.mPrivAppPermissions.get(packageName);
    }

    public ArraySet<String> getPrivAppDenyPermissions(String packageName) {
        return this.mPrivAppDenyPermissions.get(packageName);
    }

    public ArraySet<String> getVendorPrivAppPermissions(String packageName) {
        return this.mVendorPrivAppPermissions.get(packageName);
    }

    public ArraySet<String> getVendorPrivAppDenyPermissions(String packageName) {
        return this.mVendorPrivAppDenyPermissions.get(packageName);
    }

    public ArraySet<String> getProductPrivAppPermissions(String packageName) {
        return this.mProductPrivAppPermissions.get(packageName);
    }

    public ArraySet<String> getProductPrivAppDenyPermissions(String packageName) {
        return this.mProductPrivAppDenyPermissions.get(packageName);
    }

    public ArraySet<String> getSystemExtPrivAppPermissions(String packageName) {
        return this.mSystemExtPrivAppPermissions.get(packageName);
    }

    public ArraySet<String> getSystemExtPrivAppDenyPermissions(String packageName) {
        return this.mSystemExtPrivAppDenyPermissions.get(packageName);
    }

    public Map<String, Boolean> getOemPermissions(String packageName) {
        Map oemPermissions = this.mOemPermissions.get(packageName);
        if (oemPermissions != null) {
            return oemPermissions;
        }
        return Collections.emptyMap();
    }

    public ArrayMap<String, ArraySet<String>> getAllowedAssociations() {
        return this.mAllowedAssociations;
    }

    public ArraySet<String> getBugreportWhitelistedPackages() {
        return this.mBugreportWhitelistedPackages;
    }

    public Set<String> getRollbackWhitelistedPackages() {
        return this.mRollbackWhitelistedPackages;
    }

    public Set<String> getWhitelistedStagedInstallers() {
        return this.mWhitelistedStagedInstallers;
    }

    public ArraySet<String> getAppDataIsolationWhitelistedApps() {
        return this.mAppDataIsolationWhitelistedApps;
    }

    public ArrayMap<String, Set<String>> getAndClearPackageToUserTypeWhitelist() {
        ArrayMap<String, Set<String>> r = this.mPackageToUserTypeWhitelist;
        this.mPackageToUserTypeWhitelist = new ArrayMap(0);
        return r;
    }

    public ArrayMap<String, Set<String>> getAndClearPackageToUserTypeBlacklist() {
        ArrayMap<String, Set<String>> r = this.mPackageToUserTypeBlacklist;
        this.mPackageToUserTypeBlacklist = new ArrayMap(0);
        return r;
    }

    public Map<String, Map<String, String>> getNamedActors() {
        return this.mNamedActors != null ? this.mNamedActors : Collections.emptyMap();
    }

    @VisibleForTesting
    public SystemConfig(boolean readPermissions) {
        if (readPermissions) {
            Slog.w(TAG, "Constructing a test SystemConfig");
            this.readAllPermissions();
        } else {
            Slog.w(TAG, "Constructing an empty test SystemConfig");
        }
    }

    SystemConfig() {
        TimingsTraceLog log = new TimingsTraceLog(TAG, 524288L);
        log.traceBegin("readAllPermissions");
        try {
            this.readAllPermissions();
        }
        finally {
            log.traceEnd();
        }
    }

    private void readAllPermissions() {
        this.readPermissions(Environment.buildPath(Environment.getRootDirectory(), "etc", "sysconfig"), -1);
        this.readPermissions(Environment.buildPath(Environment.getRootDirectory(), "etc", "permissions"), -1);
        int vendorPermissionFlag = 147;
        if (_Original_Build.VERSION.FIRST_SDK_INT <= 27) {
            vendorPermissionFlag |= 0xC;
        }
        this.readPermissions(Environment.buildPath(Environment.getVendorDirectory(), "etc", "sysconfig"), vendorPermissionFlag);
        this.readPermissions(Environment.buildPath(Environment.getVendorDirectory(), "etc", "permissions"), vendorPermissionFlag);
        String vendorSkuProperty = SystemProperties.get(VENDOR_SKU_PROPERTY, "");
        if (!vendorSkuProperty.isEmpty()) {
            String vendorSkuDir = "sku_" + vendorSkuProperty;
            this.readPermissions(Environment.buildPath(Environment.getVendorDirectory(), "etc", "sysconfig", vendorSkuDir), vendorPermissionFlag);
            this.readPermissions(Environment.buildPath(Environment.getVendorDirectory(), "etc", "permissions", vendorSkuDir), vendorPermissionFlag);
        }
        int odmPermissionFlag = vendorPermissionFlag;
        this.readPermissions(Environment.buildPath(Environment.getOdmDirectory(), "etc", "sysconfig"), odmPermissionFlag);
        this.readPermissions(Environment.buildPath(Environment.getOdmDirectory(), "etc", "permissions"), odmPermissionFlag);
        String skuProperty = SystemProperties.get(SKU_PROPERTY, "");
        if (!skuProperty.isEmpty()) {
            String skuDir = "sku_" + skuProperty;
            this.readPermissions(Environment.buildPath(Environment.getOdmDirectory(), "etc", "sysconfig", skuDir), odmPermissionFlag);
            this.readPermissions(Environment.buildPath(Environment.getOdmDirectory(), "etc", "permissions", skuDir), odmPermissionFlag);
        }
        int oemPermissionFlag = 161;
        this.readPermissions(Environment.buildPath(Environment.getOemDirectory(), "etc", "sysconfig"), oemPermissionFlag);
        this.readPermissions(Environment.buildPath(Environment.getOemDirectory(), "etc", "permissions"), oemPermissionFlag);
        this.readPermissions(Environment.buildPath(Environment.getProductDirectory(), "etc", "sysconfig"), -1);
        this.readPermissions(Environment.buildPath(Environment.getProductDirectory(), "etc", "permissions"), -1);
        this.readPermissions(Environment.buildPath(Environment.getSystemExtDirectory(), "etc", "sysconfig"), -1);
        this.readPermissions(Environment.buildPath(Environment.getSystemExtDirectory(), "etc", "permissions"), -1);
        if (!SystemConfig.isSystemProcess()) {
            return;
        }
        for (File f : FileUtils.listFilesOrEmpty(Environment.getApexDirectory())) {
            if (f.isFile() || f.getPath().contains("@")) continue;
            this.readPermissions(Environment.buildPath(f, "etc", "permissions"), 2);
        }
    }

    @VisibleForTesting
    public void readPermissions(File libraryDir, int permissionFlag) {
        if (!libraryDir.exists() || !libraryDir.isDirectory()) {
            if (permissionFlag == -1) {
                Slog.w(TAG, "No directory " + libraryDir + ", skipping");
            }
            return;
        }
        if (!libraryDir.canRead()) {
            Slog.w(TAG, "Directory " + libraryDir + " cannot be read");
            return;
        }
        File platformFile = null;
        for (File f : libraryDir.listFiles()) {
            if (!f.isFile()) continue;
            if (f.getPath().endsWith("etc/permissions/platform.xml")) {
                platformFile = f;
                continue;
            }
            if (!f.getPath().endsWith(".xml")) {
                Slog.i(TAG, "Non-xml file " + f + " in " + libraryDir + " directory, ignoring");
                continue;
            }
            if (!f.canRead()) {
                Slog.w(TAG, "Permissions library file " + f + " cannot be read");
                continue;
            }
            this.readPermissionsFromXml(f, permissionFlag);
        }
        if (platformFile != null) {
            this.readPermissionsFromXml(platformFile, permissionFlag);
        }
    }

    private void logNotAllowedInPartition(String name, File permFile, XmlPullParser parser) {
        Slog.w(TAG, "<" + name + "> not allowed in partition of " + permFile + " at " + parser.getPositionDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPermissionsFromXml(File permFile, int permissionFlag) {
        FileReader permReader = null;
        try {
            permReader = new FileReader(permFile);
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "Couldn't find or open permissions file " + permFile);
            return;
        }
        Slog.i(TAG, "Reading permissions from " + permFile);
        boolean lowRam = ActivityManager.isLowRamDeviceStatic();
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((Reader)permReader);
            do {
                type = parser.next();
                if (type == 2) break;
            } while (type != 1);
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            if (!parser.getName().equals("permissions") && !parser.getName().equals("config")) {
                throw new XmlPullParserException("Unexpected start tag in " + permFile + ": found " + parser.getName() + ", expected 'permissions' or 'config'");
            }
            boolean allowAll = permissionFlag == -1;
            boolean allowLibs = (permissionFlag & 2) != 0;
            boolean allowFeatures = (permissionFlag & 1) != 0;
            boolean allowPermissions = (permissionFlag & 4) != 0;
            boolean allowAppConfigs = (permissionFlag & 8) != 0;
            boolean allowPrivappPermissions = (permissionFlag & 0x10) != 0;
            boolean allowOemPermissions = (permissionFlag & 0x20) != 0;
            boolean allowApiWhitelisting = (permissionFlag & 0x40) != 0;
            boolean allowAssociations = (permissionFlag & 0x80) != 0;
            while (true) {
                XmlUtils.nextElement(parser);
                if (parser.getEventType() == 1) {
                    break;
                }
                String name = parser.getName();
                if (name == null) {
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                switch (name) {
                    case "group": {
                        if (allowAll) {
                            String gidStr = parser.getAttributeValue(null, "gid");
                            if (gidStr != null) {
                                int gid = Process.getGidForName(gidStr);
                                this.mGlobalGids = ArrayUtils.appendInt(this.mGlobalGids, gid);
                            } else {
                                Slog.w(TAG, "<" + name + "> without gid in " + permFile + " at " + parser.getPositionDescription());
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "permission": {
                        if (allowPermissions) {
                            String perm = parser.getAttributeValue(null, "name");
                            if (perm == null) {
                                Slog.w(TAG, "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            perm = perm.intern();
                            this.readPermission(parser, perm);
                            break;
                        }
                        this.logNotAllowedInPartition(name, permFile, parser);
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "assign-permission": {
                        if (allowPermissions) {
                            String perm = parser.getAttributeValue(null, "name");
                            if (perm == null) {
                                Slog.w(TAG, "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            String uidStr = parser.getAttributeValue(null, "uid");
                            if (uidStr == null) {
                                Slog.w(TAG, "<" + name + "> without uid in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            int uid = Process.getUidForName(uidStr);
                            if (uid < 0) {
                                Slog.w(TAG, "<" + name + "> with unknown uid \"" + uidStr + "  in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            perm = perm.intern();
                            ArraySet<String> perms = this.mSystemPermissions.get(uid);
                            if (perms == null) {
                                perms = new ArraySet();
                                this.mSystemPermissions.put(uid, perms);
                            }
                            perms.add(perm);
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "split-permission": {
                        if (allowPermissions) {
                            this.readSplitPermission(parser, permFile);
                            break;
                        }
                        this.logNotAllowedInPartition(name, permFile, parser);
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "library": {
                        if (allowLibs) {
                            String lname = parser.getAttributeValue(null, "name");
                            String lfile = parser.getAttributeValue(null, "file");
                            String ldependency = parser.getAttributeValue(null, "dependency");
                            if (lname == null) {
                                Slog.w(TAG, "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                            } else if (lfile == null) {
                                Slog.w(TAG, "<" + name + "> without file in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                SharedLibraryEntry entry = new SharedLibraryEntry(lname, lfile, ldependency == null ? new String[]{} : ldependency.split(":"));
                                this.mSharedLibraries.put(lname, entry);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "feature": {
                        if (allowFeatures) {
                            boolean allowed;
                            String fname = parser.getAttributeValue(null, "name");
                            int fversion = XmlUtils.readIntAttribute(parser, "version", 0);
                            if (!lowRam) {
                                allowed = true;
                            } else {
                                String notLowRam = parser.getAttributeValue(null, "notLowRam");
                                boolean bl = allowed = !"true".equals(notLowRam);
                            }
                            if (fname == null) {
                                Slog.w(TAG, "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                            } else if (allowed) {
                                this.addFeature(fname, fversion);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "unavailable-feature": {
                        if (allowFeatures) {
                            String fname = parser.getAttributeValue(null, "name");
                            if (fname == null) {
                                Slog.w(TAG, "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mUnavailableFeatures.add(fname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "allow-in-power-save-except-idle": {
                        if (allowAll) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowInPowerSaveExceptIdle.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "allow-in-power-save": {
                        if (allowAll) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowInPowerSave.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "allow-in-data-usage-save": {
                        if (allowAll) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowInDataUsageSave.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "allow-unthrottled-location": {
                        if (allowAll) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowUnthrottledLocation.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "allow-ignore-location-settings": {
                        if (allowAll) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowIgnoreLocationSettings.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "allow-implicit-broadcast": {
                        if (allowAll) {
                            String action = parser.getAttributeValue(null, "action");
                            if (action == null) {
                                Slog.w(TAG, "<" + name + "> without action in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowImplicitBroadcasts.add(action);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "app-link": {
                        if (allowAppConfigs) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mLinkedApps.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "system-user-whitelisted-app": {
                        if (allowAppConfigs) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mSystemUserWhitelistedApps.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "system-user-blacklisted-app": {
                        if (allowAppConfigs) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mSystemUserBlacklistedApps.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "default-enabled-vr-app": {
                        if (allowAppConfigs) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            String clsname = parser.getAttributeValue(null, "class");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else if (clsname == null) {
                                Slog.w(TAG, "<" + name + "> without class in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mDefaultVrComponents.add(new ComponentName(pkgname, clsname));
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "component-override": {
                        this.readComponentOverrides(parser, permFile);
                        break;
                    }
                    case "backup-transport-whitelisted-service": {
                        if (allowFeatures) {
                            String serviceName = parser.getAttributeValue(null, "service");
                            if (serviceName == null) {
                                Slog.w(TAG, "<" + name + "> without service in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                ComponentName cn = ComponentName.unflattenFromString(serviceName);
                                if (cn == null) {
                                    Slog.w(TAG, "<" + name + "> with invalid service name " + serviceName + " in " + permFile + " at " + parser.getPositionDescription());
                                } else {
                                    this.mBackupTransportWhitelist.add(cn);
                                }
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "disabled-until-used-preinstalled-carrier-associated-app": {
                        if (allowAppConfigs) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            String carrierPkgname = parser.getAttributeValue(null, "carrierAppPackage");
                            if (pkgname == null || carrierPkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package or carrierAppPackage in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                List<CarrierAssociatedAppEntry> associatedPkgs;
                                int addedInSdk = -1;
                                String addedInSdkStr = parser.getAttributeValue(null, "addedInSdk");
                                if (!TextUtils.isEmpty(addedInSdkStr)) {
                                    try {
                                        addedInSdk = Integer.parseInt(addedInSdkStr);
                                    }
                                    catch (NumberFormatException e) {
                                        Slog.w(TAG, "<" + name + "> addedInSdk not an integer in " + permFile + " at " + parser.getPositionDescription());
                                        XmlUtils.skipCurrentTag(parser);
                                        break;
                                    }
                                }
                                if ((associatedPkgs = this.mDisabledUntilUsedPreinstalledCarrierAssociatedApps.get(carrierPkgname)) == null) {
                                    associatedPkgs = new ArrayList<CarrierAssociatedAppEntry>();
                                    this.mDisabledUntilUsedPreinstalledCarrierAssociatedApps.put(carrierPkgname, associatedPkgs);
                                }
                                associatedPkgs.add(new CarrierAssociatedAppEntry(pkgname, addedInSdk));
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "disabled-until-used-preinstalled-carrier-app": {
                        if (allowAppConfigs) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mDisabledUntilUsedPreinstalledCarrierApps.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "privapp-permissions": {
                        if (allowPrivappPermissions) {
                            boolean vendor = permFile.toPath().startsWith(Environment.getVendorDirectory().toPath() + "/") || permFile.toPath().startsWith(Environment.getOdmDirectory().toPath() + "/");
                            boolean product = permFile.toPath().startsWith(Environment.getProductDirectory().toPath() + "/");
                            boolean systemExt = permFile.toPath().startsWith(Environment.getSystemExtDirectory().toPath() + "/");
                            if (vendor) {
                                this.readPrivAppPermissions(parser, this.mVendorPrivAppPermissions, this.mVendorPrivAppDenyPermissions);
                                break;
                            }
                            if (product) {
                                this.readPrivAppPermissions(parser, this.mProductPrivAppPermissions, this.mProductPrivAppDenyPermissions);
                                break;
                            }
                            if (systemExt) {
                                this.readPrivAppPermissions(parser, this.mSystemExtPrivAppPermissions, this.mSystemExtPrivAppDenyPermissions);
                                break;
                            }
                            this.readPrivAppPermissions(parser, this.mPrivAppPermissions, this.mPrivAppDenyPermissions);
                            break;
                        }
                        this.logNotAllowedInPartition(name, permFile, parser);
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "oem-permissions": {
                        if (allowOemPermissions) {
                            this.readOemPermissions(parser);
                            break;
                        }
                        this.logNotAllowedInPartition(name, permFile, parser);
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "hidden-api-whitelisted-app": {
                        if (allowApiWhitelisting) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mHiddenApiPackageWhitelist.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "allow-association": {
                        if (allowAssociations) {
                            String target = parser.getAttributeValue(null, "target");
                            if (target == null) {
                                Slog.w(TAG, "<" + name + "> without target in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            String allowed = parser.getAttributeValue(null, "allowed");
                            if (allowed == null) {
                                Slog.w(TAG, "<" + name + "> without allowed in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            target = target.intern();
                            allowed = allowed.intern();
                            ArraySet<String> associations = this.mAllowedAssociations.get(target);
                            if (associations == null) {
                                associations = new ArraySet();
                                this.mAllowedAssociations.put(target, associations);
                            }
                            Slog.i(TAG, "Adding association: " + target + " <- " + allowed);
                            associations.add(allowed);
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "app-data-isolation-whitelisted-app": {
                        String pkgname = parser.getAttributeValue(null, "package");
                        if (pkgname == null) {
                            Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                        } else {
                            this.mAppDataIsolationWhitelistedApps.add(pkgname);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "bugreport-whitelisted": {
                        String pkgname = parser.getAttributeValue(null, "package");
                        if (pkgname == null) {
                            Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                        } else {
                            this.mBugreportWhitelistedPackages.add(pkgname);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "install-in-user-type": {
                        this.readInstallInUserType(parser, this.mPackageToUserTypeWhitelist, this.mPackageToUserTypeBlacklist);
                        break;
                    }
                    case "named-actor": {
                        String namespace = TextUtils.safeIntern(parser.getAttributeValue(null, "namespace"));
                        String actorName = parser.getAttributeValue(null, "name");
                        String pkgName = TextUtils.safeIntern(parser.getAttributeValue(null, "package"));
                        if (TextUtils.isEmpty(namespace)) {
                            Slog.wtf(TAG, "<" + name + "> without namespace in " + permFile + " at " + parser.getPositionDescription());
                        } else if (TextUtils.isEmpty(actorName)) {
                            Slog.wtf(TAG, "<" + name + "> without actor name in " + permFile + " at " + parser.getPositionDescription());
                        } else if (TextUtils.isEmpty(pkgName)) {
                            Slog.wtf(TAG, "<" + name + "> without package name in " + permFile + " at " + parser.getPositionDescription());
                        } else {
                            Map<String, String> nameToPkgMap;
                            if ("android".equalsIgnoreCase(namespace)) {
                                throw new IllegalStateException("Defining " + actorName + " as " + pkgName + " for the android namespace is not allowed");
                            }
                            if (this.mNamedActors == null) {
                                this.mNamedActors = new ArrayMap<String, Map<String, String>>();
                            }
                            if ((nameToPkgMap = this.mNamedActors.get(namespace)) == null) {
                                nameToPkgMap = new ArrayMap<String, String>();
                                this.mNamedActors.put(namespace, nameToPkgMap);
                            } else if (nameToPkgMap.containsKey(actorName)) {
                                String existing = nameToPkgMap.get(actorName);
                                throw new IllegalStateException("Duplicate actor definition for " + namespace + "/" + actorName + "; defined as both " + existing + " and " + pkgName);
                            }
                            nameToPkgMap.put(actorName, pkgName);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "rollback-whitelisted-app": {
                        String pkgname = parser.getAttributeValue(null, "package");
                        if (pkgname == null) {
                            Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                        } else {
                            this.mRollbackWhitelistedPackages.add(pkgname);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case "whitelisted-staged-installer": {
                        if (allowAppConfigs) {
                            String pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w(TAG, "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mWhitelistedStagedInstallers.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    default: {
                        Slog.w(TAG, "Tag " + name + " is unknown in " + permFile + " at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                    }
                }
            }
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Got exception parsing permissions.", e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Got exception parsing permissions.", e);
        }
        finally {
            IoUtils.closeQuietly(permReader);
        }
        if (StorageManager.isFileEncryptedNativeOnly()) {
            this.addFeature("android.software.file_based_encryption", 0);
            this.addFeature("android.software.securely_removes_users", 0);
        }
        if (StorageManager.hasAdoptable()) {
            this.addFeature("android.software.adoptable_storage", 0);
        }
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.addFeature("android.hardware.ram.low", 0);
        } else {
            this.addFeature("android.hardware.ram.normal", 0);
        }
        if (IncrementalManager.isFeatureEnabled()) {
            this.addFeature("android.software.incremental_delivery", 0);
        }
        this.addFeature("android.software.app_enumeration", 0);
        if (_Original_Build.VERSION.FIRST_SDK_INT >= 29) {
            this.addFeature("android.software.ipsec_tunnels", 0);
        }
        for (String featureName : this.mUnavailableFeatures) {
            this.removeFeature(featureName);
        }
    }

    private void addFeature(String name, int version) {
        FeatureInfo fi = this.mAvailableFeatures.get(name);
        if (fi == null) {
            fi = new FeatureInfo();
            fi.name = name;
            fi.version = version;
            this.mAvailableFeatures.put(name, fi);
        } else {
            fi.version = Math.max(fi.version, version);
        }
    }

    private void removeFeature(String name) {
        if (this.mAvailableFeatures.remove(name) != null) {
            Slog.d(TAG, "Removed unavailable feature " + name);
        }
    }

    void readPermission(XmlPullParser parser, String name) throws IOException, XmlPullParserException {
        int type;
        if (this.mPermissions.containsKey(name)) {
            throw new IllegalStateException("Duplicate permission definition for " + name);
        }
        boolean perUser = XmlUtils.readBooleanAttribute(parser, "perUser", false);
        PermissionEntry perm = new PermissionEntry(name, perUser);
        this.mPermissions.put(name, perm);
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("group".equals(tagName)) {
                String gidStr = parser.getAttributeValue(null, "gid");
                if (gidStr != null) {
                    int gid = Process.getGidForName(gidStr);
                    perm.gids = ArrayUtils.appendInt(perm.gids, gid);
                } else {
                    Slog.w(TAG, "<group> without gid at " + parser.getPositionDescription());
                }
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readPrivAppPermissions(XmlPullParser parser, ArrayMap<String, ArraySet<String>> grantMap, ArrayMap<String, ArraySet<String>> denyMap) throws IOException, XmlPullParserException {
        String packageName = parser.getAttributeValue(null, "package");
        if (TextUtils.isEmpty(packageName)) {
            Slog.w(TAG, "package is required for <privapp-permissions> in " + parser.getPositionDescription());
            return;
        }
        ArraySet<String> permissions = grantMap.get(packageName);
        if (permissions == null) {
            permissions = new ArraySet();
        }
        ArraySet<String> denyPermissions = denyMap.get(packageName);
        int depth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            String permName;
            String name = parser.getName();
            if ("permission".equals(name)) {
                permName = parser.getAttributeValue(null, "name");
                if (TextUtils.isEmpty(permName)) {
                    Slog.w(TAG, "name is required for <permission> in " + parser.getPositionDescription());
                    continue;
                }
                permissions.add(permName);
                continue;
            }
            if (!"deny-permission".equals(name)) continue;
            permName = parser.getAttributeValue(null, "name");
            if (TextUtils.isEmpty(permName)) {
                Slog.w(TAG, "name is required for <deny-permission> in " + parser.getPositionDescription());
                continue;
            }
            if (denyPermissions == null) {
                denyPermissions = new ArraySet();
            }
            denyPermissions.add(permName);
        }
        grantMap.put(packageName, permissions);
        if (denyPermissions != null) {
            denyMap.put(packageName, denyPermissions);
        }
    }

    private void readInstallInUserType(XmlPullParser parser, Map<String, Set<String>> doInstallMap, Map<String, Set<String>> nonInstallMap) throws IOException, XmlPullParserException {
        String packageName = parser.getAttributeValue(null, "package");
        if (TextUtils.isEmpty(packageName)) {
            Slog.w(TAG, "package is required for <install-in-user-type> in " + parser.getPositionDescription());
            return;
        }
        Set<String> userTypesYes = doInstallMap.get(packageName);
        Set<String> userTypesNo = nonInstallMap.get(packageName);
        int depth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            String userType;
            String name = parser.getName();
            if ("install-in".equals(name)) {
                userType = parser.getAttributeValue(null, "user-type");
                if (TextUtils.isEmpty(userType)) {
                    Slog.w(TAG, "user-type is required for <install-in-user-type> in " + parser.getPositionDescription());
                    continue;
                }
                if (userTypesYes == null) {
                    userTypesYes = new ArraySet<String>();
                    doInstallMap.put(packageName, userTypesYes);
                }
                userTypesYes.add(userType);
                continue;
            }
            if ("do-not-install-in".equals(name)) {
                userType = parser.getAttributeValue(null, "user-type");
                if (TextUtils.isEmpty(userType)) {
                    Slog.w(TAG, "user-type is required for <install-in-user-type> in " + parser.getPositionDescription());
                    continue;
                }
                if (userTypesNo == null) {
                    userTypesNo = new ArraySet<String>();
                    nonInstallMap.put(packageName, userTypesNo);
                }
                userTypesNo.add(userType);
                continue;
            }
            Slog.w(TAG, "unrecognized tag in <install-in-user-type> in " + parser.getPositionDescription());
        }
    }

    void readOemPermissions(XmlPullParser parser) throws IOException, XmlPullParserException {
        String packageName = parser.getAttributeValue(null, "package");
        if (TextUtils.isEmpty(packageName)) {
            Slog.w(TAG, "package is required for <oem-permissions> in " + parser.getPositionDescription());
            return;
        }
        ArrayMap<String, Boolean> permissions = this.mOemPermissions.get(packageName);
        if (permissions == null) {
            permissions = new ArrayMap();
        }
        int depth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            String permName;
            String name = parser.getName();
            if ("permission".equals(name)) {
                permName = parser.getAttributeValue(null, "name");
                if (TextUtils.isEmpty(permName)) {
                    Slog.w(TAG, "name is required for <permission> in " + parser.getPositionDescription());
                    continue;
                }
                permissions.put(permName, Boolean.TRUE);
                continue;
            }
            if (!"deny-permission".equals(name)) continue;
            permName = parser.getAttributeValue(null, "name");
            if (TextUtils.isEmpty(permName)) {
                Slog.w(TAG, "name is required for <deny-permission> in " + parser.getPositionDescription());
                continue;
            }
            permissions.put(permName, Boolean.FALSE);
        }
        this.mOemPermissions.put(packageName, permissions);
    }

    private void readSplitPermission(XmlPullParser parser, File permFile) throws IOException, XmlPullParserException {
        String splitPerm = parser.getAttributeValue(null, "name");
        if (splitPerm == null) {
            Slog.w(TAG, "<split-permission> without name in " + permFile + " at " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
            return;
        }
        String targetSdkStr = parser.getAttributeValue(null, "targetSdk");
        int targetSdk = 10001;
        if (!TextUtils.isEmpty(targetSdkStr)) {
            try {
                targetSdk = Integer.parseInt(targetSdkStr);
            }
            catch (NumberFormatException e) {
                Slog.w(TAG, "<split-permission> targetSdk not an integer in " + permFile + " at " + parser.getPositionDescription());
                XmlUtils.skipCurrentTag(parser);
                return;
            }
        }
        int depth = parser.getDepth();
        ArrayList<String> newPermissions = new ArrayList<String>();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            String name = parser.getName();
            if ("new-permission".equals(name)) {
                String newName = parser.getAttributeValue(null, "name");
                if (TextUtils.isEmpty(newName)) {
                    Slog.w(TAG, "name is required for <new-permission> in " + parser.getPositionDescription());
                    continue;
                }
                newPermissions.add(newName);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        if (!newPermissions.isEmpty()) {
            this.mSplitPermissions.add(new PermissionManager.SplitPermissionInfo(splitPerm, newPermissions, targetSdk));
        }
    }

    private void readComponentOverrides(XmlPullParser parser, File permFile) throws IOException, XmlPullParserException {
        String pkgname = parser.getAttributeValue(null, "package");
        if (pkgname == null) {
            Slog.w(TAG, "<component-override> without package in " + permFile + " at " + parser.getPositionDescription());
            return;
        }
        pkgname = pkgname.intern();
        int depth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            if (!"component".equals(parser.getName())) continue;
            String clsname = parser.getAttributeValue(null, "class");
            String enabled = parser.getAttributeValue(null, "enabled");
            if (clsname == null) {
                Slog.w(TAG, "<component> without class in " + permFile + " at " + parser.getPositionDescription());
                return;
            }
            if (enabled == null) {
                Slog.w(TAG, "<component> without enabled in " + permFile + " at " + parser.getPositionDescription());
                return;
            }
            if (clsname.startsWith(".")) {
                clsname = pkgname + clsname;
            }
            clsname = clsname.intern();
            ArrayMap<String, Boolean> componentEnabledStates = this.mPackageComponentEnabledState.get(pkgname);
            if (componentEnabledStates == null) {
                componentEnabledStates = new ArrayMap();
                this.mPackageComponentEnabledState.put(pkgname, componentEnabledStates);
            }
            componentEnabledStates.put(clsname, !"false".equals(enabled));
        }
    }

    private static boolean isSystemProcess() {
        return Process.myUid() == 1000;
    }

    public static class PermissionEntry {
        public final String name;
        public int[] gids;
        public boolean perUser;

        PermissionEntry(String name, boolean perUser) {
            this.name = name;
            this.perUser = perUser;
        }
    }

    public static class SharedLibraryEntry {
        public final String name;
        public final String filename;
        public final String[] dependencies;

        SharedLibraryEntry(String name, String filename, String[] dependencies) {
            this.name = name;
            this.filename = filename;
            this.dependencies = dependencies;
        }
    }
}

