/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.bars.CustomBar;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.resources.IconLoader;
import com.android.resources.Density;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;

public class StatusBar
extends CustomBar {
    private final int mSimulatedPlatformVersion;
    private static final String ATTR_COLOR = "statusBarColor";
    public static final String ATTR_TRANSLUCENT = "windowTranslucentStatus";

    public StatusBar(Context context, AttributeSet attrs) {
        this((BridgeContext)context, Density.getEnum((int)((BridgeContext)context).getMetrics().densityDpi), ((BridgeContext)context).getConfiguration().getLayoutDirection() == 1, (context.getApplicationInfo().flags & 0x400000) != 0, context.getApplicationInfo().targetSdkVersion);
    }

    public StatusBar(BridgeContext context, Density density, boolean isRtl, boolean rtlEnabled, int simulatedPlatformVersion) {
        super(context, 0, "status_bar.xml", simulatedPlatformVersion);
        this.mSimulatedPlatformVersion = simulatedPlatformVersion;
        this.setGravity(8388663);
        int color2 = this.getBarColor(ATTR_COLOR, ATTR_TRANSLUCENT);
        this.setBackgroundColor(color2 == 0 ? Config.getStatusBarColor(simulatedPlatformVersion) : color2);
        ArrayList<ImageView> icons = new ArrayList<ImageView>(2);
        TextView clockView = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child instanceof ImageView) {
                icons.add((ImageView)child);
                continue;
            }
            if (!(child instanceof TextView)) continue;
            clockView = (TextView)child;
        }
        if (icons.size() != 2 || clockView == null) {
            Bridge.getLog().error("broken", "Unable to initialize statusbar", null, null);
            return;
        }
        this.loadIcon((ImageView)icons.get(0), "stat_sys_wifi_signal_4_fully." + Config.getWifiIconType(simulatedPlatformVersion), density);
        this.loadIcon((ImageView)icons.get(1), "stat_sys_battery_100.png", density);
        clockView.setText(Config.getTime(simulatedPlatformVersion));
        clockView.setTextColor(Config.getTimeColor(simulatedPlatformVersion));
    }

    @Override
    protected ImageView loadIcon(ImageView imageView, String iconName, Density density) {
        if (!iconName.endsWith(".xml")) {
            return super.loadIcon(imageView, iconName, density);
        }
        IconLoader iconLoader = new IconLoader(iconName, Density.XHIGH, this.mSimulatedPlatformVersion, null);
        InputStream stream = iconLoader.getIcon();
        if (stream != null) {
            try {
                BridgeXmlBlockParser parser = new BridgeXmlBlockParser(ParserFactory.create(stream, iconName), (BridgeContext)this.mContext, ResourceNamespace.ANDROID);
                imageView.setImageDrawable(Drawable.createFromXml(this.mContext.getResources(), parser));
            }
            catch (XmlPullParserException e) {
                Bridge.getLog().error("broken", "Unable to draw wifi icon", (Throwable)e, null, null);
            }
            catch (IOException e) {
                Bridge.getLog().error("broken", "Unable to draw wifi icon", (Throwable)e, null, null);
            }
        }
        return imageView;
    }

    @Override
    protected TextView getStyleableTextView() {
        return null;
    }
}

