/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class StateMachine {
    private String mName;
    private static final int SM_QUIT_CMD = -1;
    private static final int SM_INIT_CMD = -2;
    public static final boolean HANDLED = true;
    public static final boolean NOT_HANDLED = false;
    private SmHandler mSmHandler;
    private HandlerThread mSmThread;

    private void initStateMachine(String name, Looper looper) {
        this.mName = name;
        this.mSmHandler = new SmHandler(looper, this);
    }

    @UnsupportedAppUsage
    protected StateMachine(String name) {
        this.mSmThread = new HandlerThread(name);
        this.mSmThread.start();
        Looper looper = this.mSmThread.getLooper();
        this.initStateMachine(name, looper);
    }

    @UnsupportedAppUsage
    protected StateMachine(String name, Looper looper) {
        this.initStateMachine(name, looper);
    }

    @UnsupportedAppUsage
    protected StateMachine(String name, Handler handler) {
        this.initStateMachine(name, handler.getLooper());
    }

    protected void onPreHandleMessage(Message msg) {
    }

    protected void onPostHandleMessage(Message msg) {
    }

    public void addState(State state, State parent) {
        this.mSmHandler.addState(state, parent);
    }

    @UnsupportedAppUsage
    public void addState(State state) {
        this.mSmHandler.addState(state, null);
    }

    public void removeState(State state) {
        this.mSmHandler.removeState(state);
    }

    @UnsupportedAppUsage
    public void setInitialState(State initialState) {
        this.mSmHandler.setInitialState(initialState);
    }

    public Message getCurrentMessage() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return null;
        }
        return smh.getCurrentMessage();
    }

    public IState getCurrentState() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return null;
        }
        return smh.getCurrentState();
    }

    @UnsupportedAppUsage
    public void transitionTo(IState destState) {
        this.mSmHandler.transitionTo(destState);
    }

    public void transitionToHaltingState() {
        this.mSmHandler.transitionTo(this.mSmHandler.mHaltingState);
    }

    public void deferMessage(Message msg) {
        this.mSmHandler.deferMessage(msg);
    }

    protected void unhandledMessage(Message msg) {
        if (this.mSmHandler.mDbg) {
            this.loge(" - unhandledMessage: msg.what=" + msg.what);
        }
    }

    protected void haltedProcessMessage(Message msg) {
    }

    protected void onHalting() {
    }

    protected void onQuitting() {
    }

    public String getName() {
        return this.mName;
    }

    public void setLogRecSize(int maxSize) {
        this.mSmHandler.mLogRecords.setSize(maxSize);
    }

    public void setLogOnlyTransitions(boolean enable) {
        this.mSmHandler.mLogRecords.setLogOnlyTransitions(enable);
    }

    public int getLogRecSize() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return 0;
        }
        return smh.mLogRecords.size();
    }

    @VisibleForTesting
    public int getLogRecMaxSize() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return 0;
        }
        return smh.mLogRecords.mMaxSize;
    }

    public int getLogRecCount() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return 0;
        }
        return smh.mLogRecords.count();
    }

    public LogRec getLogRec(int index) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return null;
        }
        return smh.mLogRecords.get(index);
    }

    public Collection<LogRec> copyLogRecs() {
        Vector<LogRec> vlr = new Vector<LogRec>();
        SmHandler smh = this.mSmHandler;
        if (smh != null) {
            for (LogRec lr : smh.mLogRecords.mLogRecVector) {
                vlr.add(lr);
            }
        }
        return vlr;
    }

    public void addLogRec(String string2) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.mLogRecords.add(this, smh.getCurrentMessage(), string2, smh.getCurrentState(), ((SmHandler)smh).mStateStack[((SmHandler)smh).mStateStackTopIndex].state, smh.mDestState);
    }

    protected boolean recordLogRec(Message msg) {
        return true;
    }

    protected String getLogRecString(Message msg) {
        return "";
    }

    protected String getWhatToString(int what) {
        return null;
    }

    public Handler getHandler() {
        return this.mSmHandler;
    }

    public Message obtainMessage() {
        return Message.obtain(this.mSmHandler);
    }

    public Message obtainMessage(int what) {
        return Message.obtain((Handler)this.mSmHandler, what);
    }

    public Message obtainMessage(int what, Object obj) {
        return Message.obtain(this.mSmHandler, what, obj);
    }

    public Message obtainMessage(int what, int arg1) {
        return Message.obtain(this.mSmHandler, what, arg1, 0);
    }

    @UnsupportedAppUsage
    public Message obtainMessage(int what, int arg1, int arg2) {
        return Message.obtain(this.mSmHandler, what, arg1, arg2);
    }

    @UnsupportedAppUsage
    public Message obtainMessage(int what, int arg1, int arg2, Object obj) {
        return Message.obtain(this.mSmHandler, what, arg1, arg2, obj);
    }

    @UnsupportedAppUsage
    public void sendMessage(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what));
    }

    @UnsupportedAppUsage
    public void sendMessage(int what, Object obj) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what, obj));
    }

    @UnsupportedAppUsage
    public void sendMessage(int what, int arg1) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what, arg1));
    }

    public void sendMessage(int what, int arg1, int arg2) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what, arg1, arg2));
    }

    @UnsupportedAppUsage
    public void sendMessage(int what, int arg1, int arg2, Object obj) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what, arg1, arg2, obj));
    }

    @UnsupportedAppUsage
    public void sendMessage(Message msg) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(msg);
    }

    public void sendMessageDelayed(int what, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what), delayMillis);
    }

    public void sendMessageDelayed(int what, Object obj, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what, obj), delayMillis);
    }

    public void sendMessageDelayed(int what, int arg1, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what, arg1), delayMillis);
    }

    public void sendMessageDelayed(int what, int arg1, int arg2, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what, arg1, arg2), delayMillis);
    }

    public void sendMessageDelayed(int what, int arg1, int arg2, Object obj, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what, arg1, arg2, obj), delayMillis);
    }

    public void sendMessageDelayed(Message msg, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(msg, delayMillis);
    }

    protected void sendMessageAtFrontOfQueue(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what));
    }

    protected void sendMessageAtFrontOfQueue(int what, Object obj) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what, obj));
    }

    protected void sendMessageAtFrontOfQueue(int what, int arg1) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what, arg1));
    }

    protected void sendMessageAtFrontOfQueue(int what, int arg1, int arg2) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what, arg1, arg2));
    }

    protected void sendMessageAtFrontOfQueue(int what, int arg1, int arg2, Object obj) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what, arg1, arg2, obj));
    }

    protected void sendMessageAtFrontOfQueue(Message msg) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(msg);
    }

    protected void removeMessages(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.removeMessages(what);
    }

    protected void removeDeferredMessages(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        Iterator iterator = smh.mDeferredMessages.iterator();
        while (iterator.hasNext()) {
            Message msg = (Message)iterator.next();
            if (msg.what != what) continue;
            iterator.remove();
        }
    }

    protected boolean hasDeferredMessages(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return false;
        }
        for (Message msg : smh.mDeferredMessages) {
            if (msg.what != what) continue;
            return true;
        }
        return false;
    }

    protected boolean hasMessages(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return false;
        }
        return smh.hasMessages(what);
    }

    protected boolean isQuit(Message msg) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return msg.what == -1;
        }
        return smh.isQuit(msg);
    }

    public void quit() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.quit();
    }

    public void quitNow() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.quitNow();
    }

    public boolean isDbg() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return false;
        }
        return smh.isDbg();
    }

    public void setDbg(boolean dbg) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.setDbg(dbg);
    }

    @UnsupportedAppUsage
    public void start() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.completeConstruction();
    }

    @UnsupportedAppUsage
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(this.getName() + ":");
        pw.println(" total records=" + this.getLogRecCount());
        for (int i = 0; i < this.getLogRecSize(); ++i) {
            pw.println(" rec[" + i + "]: " + this.getLogRec(i).toString());
            pw.flush();
        }
        pw.println("curState=" + this.getCurrentState().getName());
    }

    public String toString() {
        String name = "(null)";
        String state = "(null)";
        try {
            name = this.mName.toString();
            state = this.mSmHandler.getCurrentState().getName().toString();
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        return "name=" + name + " state=" + state;
    }

    protected void logAndAddLogRec(String s) {
        this.addLogRec(s);
        this.log(s);
    }

    protected void log(String s) {
        Log.d(this.mName, s);
    }

    protected void logd(String s) {
        Log.d(this.mName, s);
    }

    protected void logv(String s) {
        Log.v(this.mName, s);
    }

    protected void logi(String s) {
        Log.i(this.mName, s);
    }

    protected void logw(String s) {
        Log.w(this.mName, s);
    }

    protected void loge(String s) {
        Log.e(this.mName, s);
    }

    protected void loge(String s, Throwable e) {
        Log.e(this.mName, s, e);
    }

    private static class SmHandler
    extends Handler {
        private boolean mHasQuit = false;
        private boolean mDbg = false;
        private static final Object mSmHandlerObj = new Object();
        private Message mMsg;
        private LogRecords mLogRecords = new LogRecords();
        private boolean mIsConstructionCompleted;
        private StateInfo[] mStateStack;
        private int mStateStackTopIndex = -1;
        private StateInfo[] mTempStateStack;
        private int mTempStateStackCount;
        private HaltingState mHaltingState = new HaltingState();
        private QuittingState mQuittingState = new QuittingState();
        private StateMachine mSm;
        private HashMap<State, StateInfo> mStateInfo = new HashMap();
        private State mInitialState;
        private State mDestState;
        private boolean mTransitionInProgress = false;
        private ArrayList<Message> mDeferredMessages = new ArrayList();

        @Override
        public void handleMessage(Message msg) {
            if (!this.mHasQuit) {
                if (this.mSm != null && msg.what != -2 && msg.what != -1) {
                    this.mSm.onPreHandleMessage(msg);
                }
                if (this.mDbg) {
                    this.mSm.log("handleMessage: E msg.what=" + msg.what);
                }
                this.mMsg = msg;
                State msgProcessedState = null;
                if (this.mIsConstructionCompleted || this.mMsg.what == -1) {
                    msgProcessedState = this.processMsg(msg);
                } else if (!this.mIsConstructionCompleted && this.mMsg.what == -2 && this.mMsg.obj == mSmHandlerObj) {
                    this.mIsConstructionCompleted = true;
                    this.invokeEnterMethods(0);
                } else {
                    throw new RuntimeException("StateMachine.handleMessage: The start method not called, received msg: " + msg);
                }
                this.performTransitions(msgProcessedState, msg);
                if (this.mDbg && this.mSm != null) {
                    this.mSm.log("handleMessage: X");
                }
                if (this.mSm != null && msg.what != -2 && msg.what != -1) {
                    this.mSm.onPostHandleMessage(msg);
                }
            }
        }

        private void performTransitions(State msgProcessedState, Message msg) {
            State destState;
            boolean recordLogMsg;
            State orgState = this.mStateStack[this.mStateStackTopIndex].state;
            boolean bl = recordLogMsg = this.mSm.recordLogRec(this.mMsg) && msg.obj != mSmHandlerObj;
            if (this.mLogRecords.logOnlyTransitions()) {
                if (this.mDestState != null) {
                    this.mLogRecords.add(this.mSm, this.mMsg, this.mSm.getLogRecString(this.mMsg), msgProcessedState, orgState, this.mDestState);
                }
            } else if (recordLogMsg) {
                this.mLogRecords.add(this.mSm, this.mMsg, this.mSm.getLogRecString(this.mMsg), msgProcessedState, orgState, this.mDestState);
            }
            if ((destState = this.mDestState) != null) {
                while (true) {
                    if (this.mDbg) {
                        this.mSm.log("handleMessage: new destination call exit/enter");
                    }
                    StateInfo commonStateInfo = this.setupTempStateStackWithStatesToEnter(destState);
                    this.mTransitionInProgress = true;
                    this.invokeExitMethods(commonStateInfo);
                    int stateStackEnteringIndex = this.moveTempStateStackToStateStack();
                    this.invokeEnterMethods(stateStackEnteringIndex);
                    this.moveDeferredMessageAtFrontOfQueue();
                    if (destState == this.mDestState) break;
                    destState = this.mDestState;
                }
                this.mDestState = null;
            }
            if (destState != null) {
                if (destState == this.mQuittingState) {
                    this.mSm.onQuitting();
                    this.cleanupAfterQuitting();
                } else if (destState == this.mHaltingState) {
                    this.mSm.onHalting();
                }
            }
        }

        private void cleanupAfterQuitting() {
            if (this.mSm.mSmThread != null) {
                this.getLooper().quit();
                this.mSm.mSmThread = null;
            }
            this.mSm.mSmHandler = null;
            this.mSm = null;
            this.mMsg = null;
            this.mLogRecords.cleanup();
            this.mStateStack = null;
            this.mTempStateStack = null;
            this.mStateInfo.clear();
            this.mInitialState = null;
            this.mDestState = null;
            this.mDeferredMessages.clear();
            this.mHasQuit = true;
        }

        private void completeConstruction() {
            if (this.mDbg) {
                this.mSm.log("completeConstruction: E");
            }
            int maxDepth = 0;
            for (StateInfo si : this.mStateInfo.values()) {
                int depth = 0;
                StateInfo i = si;
                while (i != null) {
                    i = i.parentStateInfo;
                    ++depth;
                }
                if (maxDepth >= depth) continue;
                maxDepth = depth;
            }
            if (this.mDbg) {
                this.mSm.log("completeConstruction: maxDepth=" + maxDepth);
            }
            this.mStateStack = new StateInfo[maxDepth];
            this.mTempStateStack = new StateInfo[maxDepth];
            this.setupInitialStateStack();
            this.sendMessageAtFrontOfQueue(this.obtainMessage(-2, mSmHandlerObj));
            if (this.mDbg) {
                this.mSm.log("completeConstruction: X");
            }
        }

        private State processMsg(Message msg) {
            StateInfo curStateInfo = this.mStateStack[this.mStateStackTopIndex];
            if (this.mDbg) {
                this.mSm.log("processMsg: " + curStateInfo.state.getName());
            }
            if (this.isQuit(msg)) {
                this.transitionTo(this.mQuittingState);
            } else {
                while (!curStateInfo.state.processMessage(msg)) {
                    curStateInfo = curStateInfo.parentStateInfo;
                    if (curStateInfo == null) {
                        this.mSm.unhandledMessage(msg);
                        break;
                    }
                    if (!this.mDbg) continue;
                    this.mSm.log("processMsg: " + curStateInfo.state.getName());
                }
            }
            return curStateInfo != null ? curStateInfo.state : null;
        }

        private void invokeExitMethods(StateInfo commonStateInfo) {
            while (this.mStateStackTopIndex >= 0 && this.mStateStack[this.mStateStackTopIndex] != commonStateInfo) {
                State curState = this.mStateStack[this.mStateStackTopIndex].state;
                if (this.mDbg) {
                    this.mSm.log("invokeExitMethods: " + curState.getName());
                }
                curState.exit();
                this.mStateStack[this.mStateStackTopIndex].active = false;
                --this.mStateStackTopIndex;
            }
        }

        private void invokeEnterMethods(int stateStackEnteringIndex) {
            for (int i = stateStackEnteringIndex; i <= this.mStateStackTopIndex; ++i) {
                if (stateStackEnteringIndex == this.mStateStackTopIndex) {
                    this.mTransitionInProgress = false;
                }
                if (this.mDbg) {
                    this.mSm.log("invokeEnterMethods: " + this.mStateStack[i].state.getName());
                }
                this.mStateStack[i].state.enter();
                this.mStateStack[i].active = true;
            }
            this.mTransitionInProgress = false;
        }

        private void moveDeferredMessageAtFrontOfQueue() {
            for (int i = this.mDeferredMessages.size() - 1; i >= 0; --i) {
                Message curMsg = this.mDeferredMessages.get(i);
                if (this.mDbg) {
                    this.mSm.log("moveDeferredMessageAtFrontOfQueue; what=" + curMsg.what);
                }
                this.sendMessageAtFrontOfQueue(curMsg);
            }
            this.mDeferredMessages.clear();
        }

        private int moveTempStateStackToStateStack() {
            int startingIndex = this.mStateStackTopIndex + 1;
            int j = startingIndex;
            for (int i = this.mTempStateStackCount - 1; i >= 0; --i) {
                if (this.mDbg) {
                    this.mSm.log("moveTempStackToStateStack: i=" + i + ",j=" + j);
                }
                this.mStateStack[j] = this.mTempStateStack[i];
                ++j;
            }
            this.mStateStackTopIndex = j - 1;
            if (this.mDbg) {
                this.mSm.log("moveTempStackToStateStack: X mStateStackTop=" + this.mStateStackTopIndex + ",startingIndex=" + startingIndex + ",Top=" + this.mStateStack[this.mStateStackTopIndex].state.getName());
            }
            return startingIndex;
        }

        private StateInfo setupTempStateStackWithStatesToEnter(State destState) {
            this.mTempStateStackCount = 0;
            StateInfo curStateInfo = this.mStateInfo.get(destState);
            do {
                this.mTempStateStack[this.mTempStateStackCount++] = curStateInfo;
            } while ((curStateInfo = curStateInfo.parentStateInfo) != null && !curStateInfo.active);
            if (this.mDbg) {
                this.mSm.log("setupTempStateStackWithStatesToEnter: X mTempStateStackCount=" + this.mTempStateStackCount + ",curStateInfo: " + curStateInfo);
            }
            return curStateInfo;
        }

        private void setupInitialStateStack() {
            if (this.mDbg) {
                this.mSm.log("setupInitialStateStack: E mInitialState=" + this.mInitialState.getName());
            }
            StateInfo curStateInfo = this.mStateInfo.get(this.mInitialState);
            this.mTempStateStackCount = 0;
            while (curStateInfo != null) {
                this.mTempStateStack[this.mTempStateStackCount] = curStateInfo;
                curStateInfo = curStateInfo.parentStateInfo;
                ++this.mTempStateStackCount;
            }
            this.mStateStackTopIndex = -1;
            this.moveTempStateStackToStateStack();
        }

        private Message getCurrentMessage() {
            return this.mMsg;
        }

        private IState getCurrentState() {
            return this.mStateStack[this.mStateStackTopIndex].state;
        }

        private StateInfo addState(State state, State parent) {
            StateInfo stateInfo;
            if (this.mDbg) {
                this.mSm.log("addStateInternal: E state=" + state.getName() + ",parent=" + (parent == null ? "" : parent.getName()));
            }
            StateInfo parentStateInfo = null;
            if (parent != null && (parentStateInfo = this.mStateInfo.get(parent)) == null) {
                parentStateInfo = this.addState(parent, null);
            }
            if ((stateInfo = this.mStateInfo.get(state)) == null) {
                stateInfo = new StateInfo();
                this.mStateInfo.put(state, stateInfo);
            }
            if (stateInfo.parentStateInfo != null && stateInfo.parentStateInfo != parentStateInfo) {
                throw new RuntimeException("state already added");
            }
            stateInfo.state = state;
            stateInfo.parentStateInfo = parentStateInfo;
            stateInfo.active = false;
            if (this.mDbg) {
                this.mSm.log("addStateInternal: X stateInfo: " + stateInfo);
            }
            return stateInfo;
        }

        private void removeState(State state) {
            StateInfo stateInfo = this.mStateInfo.get(state);
            if (stateInfo == null || stateInfo.active) {
                return;
            }
            boolean isParent = this.mStateInfo.values().stream().filter(si -> si.parentStateInfo == stateInfo).findAny().isPresent();
            if (isParent) {
                return;
            }
            this.mStateInfo.remove(state);
        }

        private SmHandler(Looper looper, StateMachine sm) {
            super(looper);
            this.mSm = sm;
            this.addState(this.mHaltingState, null);
            this.addState(this.mQuittingState, null);
        }

        private void setInitialState(State initialState) {
            if (this.mDbg) {
                this.mSm.log("setInitialState: initialState=" + initialState.getName());
            }
            this.mInitialState = initialState;
        }

        private void transitionTo(IState destState) {
            if (this.mTransitionInProgress) {
                Log.wtf(this.mSm.mName, "transitionTo called while transition already in progress to " + this.mDestState + ", new target state=" + destState);
            }
            this.mDestState = (State)destState;
            if (this.mDbg) {
                this.mSm.log("transitionTo: destState=" + this.mDestState.getName());
            }
        }

        private void deferMessage(Message msg) {
            if (this.mDbg) {
                this.mSm.log("deferMessage: msg=" + msg.what);
            }
            Message newMsg = this.obtainMessage();
            newMsg.copyFrom(msg);
            this.mDeferredMessages.add(newMsg);
        }

        private void quit() {
            if (this.mDbg) {
                this.mSm.log("quit:");
            }
            this.sendMessage(this.obtainMessage(-1, mSmHandlerObj));
        }

        private void quitNow() {
            if (this.mDbg) {
                this.mSm.log("quitNow:");
            }
            this.sendMessageAtFrontOfQueue(this.obtainMessage(-1, mSmHandlerObj));
        }

        private boolean isQuit(Message msg) {
            return msg.what == -1 && msg.obj == mSmHandlerObj;
        }

        private boolean isDbg() {
            return this.mDbg;
        }

        private void setDbg(boolean dbg) {
            this.mDbg = dbg;
        }

        private class QuittingState
        extends State {
            private QuittingState() {
            }

            @Override
            public boolean processMessage(Message msg) {
                return false;
            }
        }

        private class HaltingState
        extends State {
            private HaltingState() {
            }

            @Override
            public boolean processMessage(Message msg) {
                SmHandler.this.mSm.haltedProcessMessage(msg);
                return true;
            }
        }

        private class StateInfo {
            State state;
            StateInfo parentStateInfo;
            boolean active;

            private StateInfo() {
            }

            public String toString() {
                return "state=" + this.state.getName() + ",active=" + this.active + ",parent=" + (this.parentStateInfo == null ? "null" : this.parentStateInfo.state.getName());
            }
        }
    }

    private static class LogRecords {
        private static final int DEFAULT_SIZE = 20;
        private Vector<LogRec> mLogRecVector = new Vector();
        private int mMaxSize = 20;
        private int mOldestIndex = 0;
        private int mCount = 0;
        private boolean mLogOnlyTransitions = false;

        private LogRecords() {
        }

        synchronized void setSize(int maxSize) {
            this.mMaxSize = maxSize;
            this.mOldestIndex = 0;
            this.mCount = 0;
            this.mLogRecVector.clear();
        }

        synchronized void setLogOnlyTransitions(boolean enable) {
            this.mLogOnlyTransitions = enable;
        }

        synchronized boolean logOnlyTransitions() {
            return this.mLogOnlyTransitions;
        }

        synchronized int size() {
            return this.mLogRecVector.size();
        }

        synchronized int count() {
            return this.mCount;
        }

        synchronized void cleanup() {
            this.mLogRecVector.clear();
        }

        synchronized LogRec get(int index) {
            int nextIndex = this.mOldestIndex + index;
            if (nextIndex >= this.mMaxSize) {
                nextIndex -= this.mMaxSize;
            }
            if (nextIndex >= this.size()) {
                return null;
            }
            return this.mLogRecVector.get(nextIndex);
        }

        synchronized void add(StateMachine sm, Message msg, String messageInfo, IState state, IState orgState, IState transToState) {
            ++this.mCount;
            if (this.mLogRecVector.size() < this.mMaxSize) {
                this.mLogRecVector.add(new LogRec(sm, msg, messageInfo, state, orgState, transToState));
            } else {
                LogRec pmi = this.mLogRecVector.get(this.mOldestIndex);
                ++this.mOldestIndex;
                if (this.mOldestIndex >= this.mMaxSize) {
                    this.mOldestIndex = 0;
                }
                pmi.update(sm, msg, messageInfo, state, orgState, transToState);
            }
        }
    }

    public static class LogRec {
        private StateMachine mSm;
        private long mTime;
        private int mWhat;
        private String mInfo;
        private IState mState;
        private IState mOrgState;
        private IState mDstState;

        LogRec(StateMachine sm, Message msg, String info, IState state, IState orgState, IState transToState) {
            this.update(sm, msg, info, state, orgState, transToState);
        }

        public void update(StateMachine sm, Message msg, String info, IState state, IState orgState, IState dstState) {
            this.mSm = sm;
            this.mTime = System_Delegate.currentTimeMillis();
            this.mWhat = msg != null ? msg.what : 0;
            this.mInfo = info;
            this.mState = state;
            this.mOrgState = orgState;
            this.mDstState = dstState;
        }

        public long getTime() {
            return this.mTime;
        }

        public long getWhat() {
            return this.mWhat;
        }

        public String getInfo() {
            return this.mInfo;
        }

        public IState getState() {
            return this.mState;
        }

        public IState getDestState() {
            return this.mDstState;
        }

        public IState getOriginalState() {
            return this.mOrgState;
        }

        public String toString() {
            String what;
            StringBuilder sb = new StringBuilder();
            sb.append("time=");
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(this.mTime);
            sb.append(String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c));
            sb.append(" processed=");
            sb.append(this.mState == null ? "<null>" : this.mState.getName());
            sb.append(" org=");
            sb.append(this.mOrgState == null ? "<null>" : this.mOrgState.getName());
            sb.append(" dest=");
            sb.append(this.mDstState == null ? "<null>" : this.mDstState.getName());
            sb.append(" what=");
            String string2 = what = this.mSm != null ? this.mSm.getWhatToString(this.mWhat) : "";
            if (TextUtils.isEmpty(what)) {
                sb.append(this.mWhat);
                sb.append("(0x");
                sb.append(Integer.toHexString(this.mWhat));
                sb.append(")");
            } else {
                sb.append(what);
            }
            if (!TextUtils.isEmpty(this.mInfo)) {
                sb.append(" ");
                sb.append(this.mInfo);
            }
            return sb.toString();
        }
    }
}

