/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ActivityManager;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.UidTraffic;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.INetworkStatsService;
import android.net.NetworkStats;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.BatteryStats;
import android.os.Handler;
import android.os.IBatteryPropertiesRegistrar;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.os._Original_Build;
import android.os.connectivity.CellularBatteryStats;
import android.os.connectivity.GpsBatteryStats;
import android.os.connectivity.WifiActivityEnergyInfo;
import android.os.connectivity.WifiBatteryStats;
import android.provider.Settings;
import android.telephony.CellSignalStrength;
import android.telephony.ModemActivityInfo;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.IntArray;
import android.util.KeyValueListParser;
import android.util.Log;
import android.util.LogWriter;
import android.util.LongSparseArray;
import android.util.LongSparseLongArray;
import android.util.MutableInt;
import android.util.Pools;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import com.android.internal.logging.EventLogTags;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatteryStatsHistory;
import com.android.internal.os.KernelCpuSpeedReader;
import com.android.internal.os.KernelCpuUidTimeReader;
import com.android.internal.os.KernelMemoryBandwidthStats;
import com.android.internal.os.KernelSingleUidTimeReader;
import com.android.internal.os.KernelWakelockReader;
import com.android.internal.os.KernelWakelockStats;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.RailStats;
import com.android.internal.os.RpmStats;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.FrameworkStatsLog;
import com.android.internal.util.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class BatteryStatsImpl
extends BatteryStats {
    private static final String TAG = "BatteryStatsImpl";
    private static final boolean DEBUG = false;
    public static final boolean DEBUG_ENERGY = false;
    private static final boolean DEBUG_ENERGY_CPU = false;
    private static final boolean DEBUG_MEMORY = false;
    private static final boolean DEBUG_HISTORY = false;
    private static final boolean USE_OLD_HISTORY = false;
    private static final int MAGIC = -1166707595;
    static final int VERSION = 186;
    private static final int MAX_WAKELOCKS_PER_UID = ActivityManager.isLowRamDeviceStatic() ? 40 : 200;
    private static final int NUM_WIFI_TX_LEVELS = 1;
    private static final int NUM_BT_TX_LEVELS = 1;
    @VisibleForTesting
    public static final int WAKE_LOCK_WEIGHT = 50;
    protected Clocks mClocks;
    private final AtomicFile mStatsFile;
    public final AtomicFile mCheckinFile;
    public final AtomicFile mDailyFile;
    static final int MSG_REPORT_CPU_UPDATE_NEEDED = 1;
    static final int MSG_REPORT_POWER_CHANGE = 2;
    static final int MSG_REPORT_CHARGING = 3;
    static final int MSG_REPORT_RESET_STATS = 4;
    static final long DELAY_UPDATE_WAKELOCKS = 5000L;
    private static final double MILLISECONDS_IN_HOUR = 3600000.0;
    private static final long MILLISECONDS_IN_YEAR = 31536000000L;
    private final KernelWakelockReader mKernelWakelockReader = new KernelWakelockReader();
    private final KernelWakelockStats mTmpWakelockStats = new KernelWakelockStats();
    @VisibleForTesting
    protected KernelCpuUidTimeReader.KernelCpuUidUserSysTimeReader mCpuUidUserSysTimeReader = new KernelCpuUidTimeReader.KernelCpuUidUserSysTimeReader(true);
    @VisibleForTesting
    protected KernelCpuSpeedReader[] mKernelCpuSpeedReaders;
    @VisibleForTesting
    protected KernelCpuUidTimeReader.KernelCpuUidFreqTimeReader mCpuUidFreqTimeReader = new KernelCpuUidTimeReader.KernelCpuUidFreqTimeReader(true);
    @VisibleForTesting
    protected KernelCpuUidTimeReader.KernelCpuUidActiveTimeReader mCpuUidActiveTimeReader = new KernelCpuUidTimeReader.KernelCpuUidActiveTimeReader(true);
    @VisibleForTesting
    protected KernelCpuUidTimeReader.KernelCpuUidClusterTimeReader mCpuUidClusterTimeReader = new KernelCpuUidTimeReader.KernelCpuUidClusterTimeReader(true);
    @VisibleForTesting
    protected KernelSingleUidTimeReader mKernelSingleUidTimeReader;
    private final KernelMemoryBandwidthStats mKernelMemoryBandwidthStats = new KernelMemoryBandwidthStats();
    private final LongSparseArray<SamplingTimer> mKernelMemoryStats = new LongSparseArray();
    @GuardedBy(value={"this"})
    public boolean mPerProcStateCpuTimesAvailable = true;
    @GuardedBy(value={"this"})
    private boolean mIsPerProcessStateCpuDataStale;
    @GuardedBy(value={"this"})
    @VisibleForTesting
    protected final SparseIntArray mPendingUids = new SparseIntArray();
    @GuardedBy(value={"this"})
    private long mNumSingleUidCpuTimeReads;
    @GuardedBy(value={"this"})
    private long mNumBatchedSingleUidCpuTimeReads;
    @GuardedBy(value={"this"})
    private long mCpuTimeReadsTrackingStartTime = SystemClock.uptimeMillis();
    @GuardedBy(value={"this"})
    private int mNumUidsRemoved;
    @GuardedBy(value={"this"})
    private int mNumAllUidCpuTimeReads;
    private final RpmStats mTmpRpmStats = new RpmStats();
    private static final long RPM_STATS_UPDATE_FREQ_MS = 1000L;
    private long mLastRpmStatsUpdateTimeMs = -1000L;
    private final RailStats mTmpRailStats = new RailStats();
    @GuardedBy(value={"this"})
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    protected Queue<UidToRemove> mPendingRemovedUids = new LinkedList<UidToRemove>();
    private final PlatformIdleStateCallback mPlatformIdleStateCallback;
    private final Runnable mDeferSetCharging = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            synchronized (batteryStatsImpl) {
                if (BatteryStatsImpl.this.mOnBattery) {
                    return;
                }
                boolean changed = BatteryStatsImpl.this.setChargingLocked(true);
                if (changed) {
                    long uptime = BatteryStatsImpl.this.mClocks.uptimeMillis();
                    long elapsedRealtime = BatteryStatsImpl.this.mClocks.elapsedRealtime();
                    BatteryStatsImpl.this.addHistoryRecordLocked(elapsedRealtime, uptime);
                }
            }
        }
    };
    public final RailEnergyDataCallback mRailEnergyDataCallback;
    public Handler mHandler;
    private ExternalStatsSync mExternalSync = null;
    @VisibleForTesting
    protected UserInfoProvider mUserInfoProvider = null;
    private BatteryCallback mCallback;
    final SparseIntArray mIsolatedUids = new SparseIntArray();
    final SparseArray<Uid> mUidStats = new SparseArray();
    @VisibleForTesting
    @UnsupportedAppUsage
    protected ArrayList<StopwatchTimer> mPartialTimers = new ArrayList();
    @UnsupportedAppUsage
    final ArrayList<StopwatchTimer> mFullTimers = new ArrayList();
    @UnsupportedAppUsage
    final ArrayList<StopwatchTimer> mWindowTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mDrawTimers = new ArrayList();
    final SparseArray<ArrayList<StopwatchTimer>> mSensorTimers = new SparseArray();
    final ArrayList<StopwatchTimer> mWifiRunningTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mFullWifiLockTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWifiMulticastTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWifiScanTimers = new ArrayList();
    final SparseArray<ArrayList<StopwatchTimer>> mWifiBatchedScanTimers = new SparseArray();
    final ArrayList<StopwatchTimer> mAudioTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mVideoTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mFlashlightTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mCameraTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mBluetoothScanOnTimers = new ArrayList();
    @VisibleForTesting
    protected ArrayList<StopwatchTimer> mLastPartialTimers = new ArrayList();
    protected final TimeBase mOnBatteryTimeBase = new TimeBase(true);
    protected final TimeBase mOnBatteryScreenOffTimeBase = new TimeBase(true);
    boolean mDistributeWakelockCpu;
    boolean mShuttingDown;
    final BatteryStats.HistoryEventTracker mActiveEvents = new BatteryStats.HistoryEventTracker();
    long mHistoryBaseTime;
    protected boolean mHaveBatteryLevel = false;
    protected boolean mRecordingHistory = false;
    int mNumHistoryItems;
    final Parcel mHistoryBuffer = Parcel.obtain();
    final BatteryStats.HistoryItem mHistoryLastWritten = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryLastLastWritten = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryReadTmp = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryAddTmp = new BatteryStats.HistoryItem();
    final HashMap<BatteryStats.HistoryTag, Integer> mHistoryTagPool = new HashMap();
    String[] mReadHistoryStrings;
    int[] mReadHistoryUids;
    int mReadHistoryChars;
    int mNextHistoryTagIdx = 0;
    int mNumHistoryTagChars = 0;
    int mHistoryBufferLastPos = -1;
    int mActiveHistoryStates = -1;
    int mActiveHistoryStates2 = -1;
    long mLastHistoryElapsedRealtime = 0L;
    long mTrackRunningHistoryElapsedRealtime = 0L;
    long mTrackRunningHistoryUptime = 0L;
    final BatteryStatsHistory mBatteryStatsHistory;
    final BatteryStats.HistoryItem mHistoryCur = new BatteryStats.HistoryItem();
    BatteryStats.HistoryItem mHistory;
    BatteryStats.HistoryItem mHistoryEnd;
    BatteryStats.HistoryItem mHistoryLastEnd;
    BatteryStats.HistoryItem mHistoryCache;
    BatteryStats.HistoryStepDetails mLastHistoryStepDetails = null;
    byte mLastHistoryStepLevel = 0;
    final BatteryStats.HistoryStepDetails mCurHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    final BatteryStats.HistoryStepDetails mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    final BatteryStats.HistoryStepDetails mTmpHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    long mLastStepCpuUserTime;
    long mCurStepCpuUserTime;
    long mLastStepCpuSystemTime;
    long mCurStepCpuSystemTime;
    long mLastStepStatUserTime;
    long mLastStepStatSystemTime;
    long mLastStepStatIOWaitTime;
    long mLastStepStatIrqTime;
    long mLastStepStatSoftIrqTime;
    long mLastStepStatIdleTime;
    long mCurStepStatUserTime;
    long mCurStepStatSystemTime;
    long mCurStepStatIOWaitTime;
    long mCurStepStatIrqTime;
    long mCurStepStatSoftIrqTime;
    long mCurStepStatIdleTime;
    private BatteryStats.HistoryItem mHistoryIterator;
    private boolean mReadOverflow;
    private boolean mIteratingHistory;
    int mStartCount;
    long mStartClockTime;
    String mStartPlatformVersion;
    String mEndPlatformVersion;
    long mUptime;
    long mUptimeStart;
    long mRealtime;
    long mRealtimeStart;
    int mWakeLockNesting;
    boolean mWakeLockImportant;
    public boolean mRecordAllHistory;
    boolean mNoAutoReset;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    protected int mScreenState = 0;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    protected StopwatchTimer mScreenOnTimer;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    protected StopwatchTimer mScreenDozeTimer;
    int mScreenBrightnessBin = -1;
    final StopwatchTimer[] mScreenBrightnessTimer = new StopwatchTimer[5];
    boolean mPretendScreenOff;
    boolean mInteractive;
    StopwatchTimer mInteractiveTimer;
    boolean mPowerSaveModeEnabled;
    StopwatchTimer mPowerSaveModeEnabledTimer;
    boolean mDeviceIdling;
    StopwatchTimer mDeviceIdlingTimer;
    boolean mDeviceLightIdling;
    StopwatchTimer mDeviceLightIdlingTimer;
    int mDeviceIdleMode;
    long mLastIdleTimeStart;
    long mLongestLightIdleTime;
    long mLongestFullIdleTime;
    StopwatchTimer mDeviceIdleModeLightTimer;
    StopwatchTimer mDeviceIdleModeFullTimer;
    boolean mPhoneOn;
    StopwatchTimer mPhoneOnTimer;
    int mAudioOnNesting;
    StopwatchTimer mAudioOnTimer;
    int mVideoOnNesting;
    StopwatchTimer mVideoOnTimer;
    int mFlashlightOnNesting;
    StopwatchTimer mFlashlightOnTimer;
    int mCameraOnNesting;
    StopwatchTimer mCameraOnTimer;
    private static final int USB_DATA_UNKNOWN = 0;
    private static final int USB_DATA_DISCONNECTED = 1;
    private static final int USB_DATA_CONNECTED = 2;
    int mUsbDataState = 0;
    int mGpsSignalQualityBin = -1;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    protected final StopwatchTimer[] mGpsSignalQualityTimer = new StopwatchTimer[2];
    int mPhoneSignalStrengthBin = -1;
    int mPhoneSignalStrengthBinRaw = -1;
    final StopwatchTimer[] mPhoneSignalStrengthsTimer = new StopwatchTimer[CellSignalStrength.getNumSignalStrengthLevels()];
    StopwatchTimer mPhoneSignalScanningTimer;
    int mPhoneDataConnectionType = -1;
    final StopwatchTimer[] mPhoneDataConnectionsTimer = new StopwatchTimer[NUM_DATA_CONNECTION_TYPES];
    final LongSamplingCounter[] mNetworkByteActivityCounters = new LongSamplingCounter[10];
    final LongSamplingCounter[] mNetworkPacketActivityCounters = new LongSamplingCounter[10];
    StopwatchTimer mWifiMulticastWakelockTimer;
    ControllerActivityCounterImpl mWifiActivity;
    ControllerActivityCounterImpl mBluetoothActivity;
    ControllerActivityCounterImpl mModemActivity;
    boolean mHasWifiReporting = false;
    boolean mHasBluetoothReporting = false;
    boolean mHasModemReporting = false;
    boolean mWifiOn;
    StopwatchTimer mWifiOnTimer;
    boolean mGlobalWifiRunning;
    StopwatchTimer mGlobalWifiRunningTimer;
    int mWifiState = -1;
    final StopwatchTimer[] mWifiStateTimer = new StopwatchTimer[8];
    int mWifiSupplState = -1;
    final StopwatchTimer[] mWifiSupplStateTimer = new StopwatchTimer[13];
    int mWifiSignalStrengthBin = -1;
    final StopwatchTimer[] mWifiSignalStrengthsTimer = new StopwatchTimer[5];
    StopwatchTimer mWifiActiveTimer;
    int mBluetoothScanNesting;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    protected StopwatchTimer mBluetoothScanTimer;
    int mMobileRadioPowerState = 1;
    long mMobileRadioActiveStartTime;
    StopwatchTimer mMobileRadioActiveTimer;
    StopwatchTimer mMobileRadioActivePerAppTimer;
    LongSamplingCounter mMobileRadioActiveAdjustedTime;
    LongSamplingCounter mMobileRadioActiveUnknownTime;
    LongSamplingCounter mMobileRadioActiveUnknownCount;
    int mWifiRadioPowerState = 1;
    boolean mOnBattery;
    @VisibleForTesting
    protected boolean mOnBatteryInternal;
    boolean mCharging = true;
    int mLastChargingStateLevel;
    int mDischargeStartLevel;
    int mDischargeUnplugLevel;
    int mDischargePlugLevel;
    int mDischargeCurrentLevel;
    int mCurrentBatteryLevel;
    int mLowDischargeAmountSinceCharge;
    int mHighDischargeAmountSinceCharge;
    int mDischargeScreenOnUnplugLevel;
    int mDischargeScreenOffUnplugLevel;
    int mDischargeScreenDozeUnplugLevel;
    int mDischargeAmountScreenOn;
    int mDischargeAmountScreenOnSinceCharge;
    int mDischargeAmountScreenOff;
    int mDischargeAmountScreenOffSinceCharge;
    int mDischargeAmountScreenDoze;
    int mDischargeAmountScreenDozeSinceCharge;
    private LongSamplingCounter mDischargeScreenOffCounter;
    private LongSamplingCounter mDischargeScreenDozeCounter;
    private LongSamplingCounter mDischargeCounter;
    private LongSamplingCounter mDischargeLightDozeCounter;
    private LongSamplingCounter mDischargeDeepDozeCounter;
    static final int MAX_LEVEL_STEPS = 200;
    int mInitStepMode = 0;
    int mCurStepMode = 0;
    int mModStepMode = 0;
    int mLastDischargeStepLevel;
    int mMinDischargeStepLevel;
    final BatteryStats.LevelStepTracker mDischargeStepTracker = new BatteryStats.LevelStepTracker(200);
    final BatteryStats.LevelStepTracker mDailyDischargeStepTracker = new BatteryStats.LevelStepTracker(400);
    ArrayList<BatteryStats.PackageChange> mDailyPackageChanges;
    int mLastChargeStepLevel;
    int mMaxChargeStepLevel;
    final BatteryStats.LevelStepTracker mChargeStepTracker = new BatteryStats.LevelStepTracker(200);
    final BatteryStats.LevelStepTracker mDailyChargeStepTracker = new BatteryStats.LevelStepTracker(400);
    static final int MAX_DAILY_ITEMS = 10;
    long mDailyStartTime = 0L;
    long mNextMinDailyDeadline = 0L;
    long mNextMaxDailyDeadline = 0L;
    final ArrayList<BatteryStats.DailyItem> mDailyItems = new ArrayList();
    long mLastWriteTime = 0L;
    private int mPhoneServiceState = -1;
    private int mPhoneServiceStateRaw = -1;
    private int mPhoneSimStateRaw = -1;
    private int mNumConnectivityChange;
    private int mEstimatedBatteryCapacity = -1;
    private int mMinLearnedBatteryCapacity = -1;
    private int mMaxLearnedBatteryCapacity = -1;
    private long mBatteryTimeToFullSeconds = -1L;
    private long[] mCpuFreqs;
    @VisibleForTesting
    protected PowerProfile mPowerProfile;
    @GuardedBy(value={"this"})
    final Constants mConstants;
    private final HashMap<String, SamplingTimer> mRpmStats = new HashMap();
    private final HashMap<String, SamplingTimer> mScreenOffRpmStats = new HashMap();
    private final HashMap<String, SamplingTimer> mKernelWakelockStats = new HashMap();
    String mLastWakeupReason = null;
    long mLastWakeupUptimeMs = 0L;
    private final HashMap<String, SamplingTimer> mWakeupReasonStats = new HashMap();
    static final int DELTA_TIME_MASK = 524287;
    static final int DELTA_TIME_LONG = 524287;
    static final int DELTA_TIME_INT = 524286;
    static final int DELTA_TIME_ABS = 524285;
    static final int DELTA_BATTERY_LEVEL_FLAG = 524288;
    static final int DELTA_STATE_FLAG = 0x100000;
    static final int DELTA_STATE2_FLAG = 0x200000;
    static final int DELTA_WAKELOCK_FLAG = 0x400000;
    static final int DELTA_EVENT_FLAG = 0x800000;
    static final int DELTA_BATTERY_CHARGE_FLAG = 0x1000000;
    static final int DELTA_STATE_MASK = -33554432;
    static final int STATE_BATTERY_MASK = -16777216;
    static final int STATE_BATTERY_STATUS_MASK = 7;
    static final int STATE_BATTERY_STATUS_SHIFT = 29;
    static final int STATE_BATTERY_HEALTH_MASK = 7;
    static final int STATE_BATTERY_HEALTH_SHIFT = 26;
    static final int STATE_BATTERY_PLUG_MASK = 3;
    static final int STATE_BATTERY_PLUG_SHIFT = 24;
    static final int BATTERY_DELTA_LEVEL_FLAG = 1;
    int mChangedStates = 0;
    int mChangedStates2 = 0;
    private String mInitialAcquireWakeName;
    private int mInitialAcquireWakeUid = -1;
    int mSensorNesting;
    int mGpsNesting;
    int mWifiFullLockNesting = 0;
    int mWifiScanNesting = 0;
    int mWifiMulticastNesting = 0;
    private final Pools.Pool<NetworkStats> mNetworkStatsPool = new Pools.SynchronizedPool<NetworkStats>(6);
    private final Object mWifiNetworkLock = new Object();
    @GuardedBy(value={"mWifiNetworkLock"})
    private String[] mWifiIfaces = EmptyArray.STRING;
    @GuardedBy(value={"mWifiNetworkLock"})
    private NetworkStats mLastWifiNetworkStats = new NetworkStats(0L, -1);
    private final Object mModemNetworkLock = new Object();
    @GuardedBy(value={"mModemNetworkLock"})
    private String[] mModemIfaces = EmptyArray.STRING;
    @GuardedBy(value={"mModemNetworkLock"})
    private NetworkStats mLastModemNetworkStats = new NetworkStats(0L, -1);
    private ModemActivityInfo mLastModemActivityInfo = new ModemActivityInfo(0L, 0, 0, new int[0], 0);
    private final BluetoothActivityInfoCache mLastBluetoothActivityInfo = new BluetoothActivityInfoCache();
    long mTempTotalCpuUserTimeUs;
    long mTempTotalCpuSystemTimeUs;
    long[][] mWakeLockAllocationsUs;
    public static final int BATTERY_PLUGGED_NONE = 0;
    final ReentrantLock mWriteLock = new ReentrantLock();
    @UnsupportedAppUsage
    public static final Parcelable.Creator<BatteryStatsImpl> CREATOR = new Parcelable.Creator<BatteryStatsImpl>(){

        @Override
        public BatteryStatsImpl createFromParcel(Parcel in) {
            return new BatteryStatsImpl(in);
        }

        public BatteryStatsImpl[] newArray(int size) {
            return new BatteryStatsImpl[size];
        }
    };

    public LongSparseArray<SamplingTimer> getKernelMemoryStats() {
        return this.mKernelMemoryStats;
    }

    public void postBatteryNeedsCpuUpdateMsg() {
        this.mHandler.sendEmptyMessage(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProcStateCpuTimes(boolean onBattery, boolean onBatteryScreenOff) {
        SparseIntArray uidStates;
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            if (!this.mConstants.TRACK_CPU_TIMES_BY_PROC_STATE) {
                return;
            }
            if (!this.initKernelSingleUidTimeReaderLocked()) {
                return;
            }
            if (this.mIsPerProcessStateCpuDataStale) {
                this.mPendingUids.clear();
                return;
            }
            if (this.mPendingUids.size() == 0) {
                return;
            }
            uidStates = this.mPendingUids.clone();
            this.mPendingUids.clear();
        }
        for (int i = uidStates.size() - 1; i >= 0; --i) {
            int j;
            int[] isolatedUids;
            Uid u;
            int uid = uidStates.keyAt(i);
            int procState = uidStates.valueAt(i);
            BatteryStatsImpl batteryStatsImpl2 = this;
            synchronized (batteryStatsImpl2) {
                u = this.getAvailableUidStatsLocked(uid);
                if (u == null) {
                    continue;
                }
                if (u.mChildUids == null) {
                    isolatedUids = null;
                } else {
                    isolatedUids = u.mChildUids.toArray();
                    for (j = isolatedUids.length - 1; j >= 0; --j) {
                        isolatedUids[j] = u.mChildUids.get(j);
                    }
                }
            }
            long[] cpuTimesMs = this.mKernelSingleUidTimeReader.readDeltaMs(uid);
            if (isolatedUids != null) {
                for (j = isolatedUids.length - 1; j >= 0; --j) {
                    cpuTimesMs = this.addCpuTimes(cpuTimesMs, this.mKernelSingleUidTimeReader.readDeltaMs(isolatedUids[j]));
                }
            }
            if (!onBattery || cpuTimesMs == null) continue;
            BatteryStatsImpl batteryStatsImpl3 = this;
            synchronized (batteryStatsImpl3) {
                u.addProcStateTimesMs(procState, cpuTimesMs, onBattery);
                u.addProcStateScreenOffTimesMs(procState, cpuTimesMs, onBatteryScreenOff);
                continue;
            }
        }
    }

    public void clearPendingRemovedUids() {
        long cutOffTime = this.mClocks.elapsedRealtime() - this.mConstants.UID_REMOVE_DELAY_MS;
        while (!this.mPendingRemovedUids.isEmpty() && this.mPendingRemovedUids.peek().timeAddedInQueue < cutOffTime) {
            this.mPendingRemovedUids.poll().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromAllUidsCpuTimes() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            this.copyFromAllUidsCpuTimes(this.mOnBatteryTimeBase.isRunning(), this.mOnBatteryScreenOffTimeBase.isRunning());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromAllUidsCpuTimes(boolean onBattery, boolean onBatteryScreenOff) {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            if (!this.mConstants.TRACK_CPU_TIMES_BY_PROC_STATE) {
                return;
            }
            if (!this.initKernelSingleUidTimeReaderLocked()) {
                return;
            }
            SparseArray<long[]> allUidCpuFreqTimesMs = this.mCpuUidFreqTimeReader.getAllUidCpuFreqTimeMs();
            if (this.mIsPerProcessStateCpuDataStale) {
                this.mKernelSingleUidTimeReader.setAllUidsCpuTimesMs(allUidCpuFreqTimesMs);
                this.mIsPerProcessStateCpuDataStale = false;
                this.mPendingUids.clear();
                return;
            }
            for (int i = allUidCpuFreqTimesMs.size() - 1; i >= 0; --i) {
                int procState;
                long[] cpuTimesMs;
                int uid = allUidCpuFreqTimesMs.keyAt(i);
                Uid u = this.getAvailableUidStatsLocked(this.mapUid(uid));
                if (u == null || (cpuTimesMs = allUidCpuFreqTimesMs.valueAt(i)) == null) continue;
                long[] deltaTimesMs = this.mKernelSingleUidTimeReader.computeDelta(uid, (long[])cpuTimesMs.clone());
                if (!onBattery || deltaTimesMs == null) continue;
                int idx = this.mPendingUids.indexOfKey(uid);
                if (idx >= 0) {
                    procState = this.mPendingUids.valueAt(idx);
                    this.mPendingUids.removeAt(idx);
                } else {
                    procState = u.mProcessState;
                }
                if (procState < 0 || procState >= 7) continue;
                u.addProcStateTimesMs(procState, deltaTimesMs, onBattery);
                u.addProcStateScreenOffTimesMs(procState, deltaTimesMs, onBatteryScreenOff);
            }
        }
    }

    @VisibleForTesting
    public long[] addCpuTimes(long[] timesA, long[] timesB) {
        if (timesA != null && timesB != null) {
            for (int i = timesA.length - 1; i >= 0; --i) {
                int n = i;
                timesA[n] = timesA[n] + timesB[i];
            }
            return timesA;
        }
        return timesA == null ? (Object)(timesB == null ? null : timesB) : timesA;
    }

    @GuardedBy(value={"this"})
    private boolean initKernelSingleUidTimeReaderLocked() {
        if (this.mKernelSingleUidTimeReader == null) {
            if (this.mPowerProfile == null) {
                return false;
            }
            if (this.mCpuFreqs == null) {
                this.mCpuFreqs = this.mCpuUidFreqTimeReader.readFreqs(this.mPowerProfile);
            }
            if (this.mCpuFreqs != null) {
                this.mKernelSingleUidTimeReader = new KernelSingleUidTimeReader(this.mCpuFreqs.length);
            } else {
                this.mPerProcStateCpuTimesAvailable = this.mCpuUidFreqTimeReader.allUidTimesAvailable();
                return false;
            }
        }
        this.mPerProcStateCpuTimesAvailable = this.mCpuUidFreqTimeReader.allUidTimesAvailable() && this.mKernelSingleUidTimeReader.singleUidCpuTimesAvailable();
        return true;
    }

    public Map<String, ? extends Timer> getRpmStats() {
        return this.mRpmStats;
    }

    public Map<String, ? extends Timer> getScreenOffRpmStats() {
        return this.mScreenOffRpmStats;
    }

    @UnsupportedAppUsage
    public Map<String, ? extends Timer> getKernelWakelockStats() {
        return this.mKernelWakelockStats;
    }

    public Map<String, ? extends Timer> getWakeupReasonStats() {
        return this.mWakeupReasonStats;
    }

    @Override
    public long getUahDischarge(int which) {
        return this.mDischargeCounter.getCountLocked(which);
    }

    @Override
    public long getUahDischargeScreenOff(int which) {
        return this.mDischargeScreenOffCounter.getCountLocked(which);
    }

    @Override
    public long getUahDischargeScreenDoze(int which) {
        return this.mDischargeScreenDozeCounter.getCountLocked(which);
    }

    @Override
    public long getUahDischargeLightDoze(int which) {
        return this.mDischargeLightDozeCounter.getCountLocked(which);
    }

    @Override
    public long getUahDischargeDeepDoze(int which) {
        return this.mDischargeDeepDozeCounter.getCountLocked(which);
    }

    @Override
    public int getEstimatedBatteryCapacity() {
        return this.mEstimatedBatteryCapacity;
    }

    @Override
    public int getMinLearnedBatteryCapacity() {
        return this.mMinLearnedBatteryCapacity;
    }

    @Override
    public int getMaxLearnedBatteryCapacity() {
        return this.mMaxLearnedBatteryCapacity;
    }

    public BatteryStatsImpl() {
        this(new SystemClocks());
    }

    public BatteryStatsImpl(Clocks clocks) {
        this.init(clocks);
        this.mStatsFile = null;
        this.mCheckinFile = null;
        this.mDailyFile = null;
        this.mBatteryStatsHistory = null;
        this.mHandler = null;
        this.mPlatformIdleStateCallback = null;
        this.mRailEnergyDataCallback = null;
        this.mUserInfoProvider = null;
        this.mConstants = new Constants(this.mHandler);
        this.clearHistoryLocked();
    }

    private void init(Clocks clocks) {
        this.mClocks = clocks;
    }

    public SamplingTimer getRpmTimerLocked(String name) {
        SamplingTimer rpmt = this.mRpmStats.get(name);
        if (rpmt == null) {
            rpmt = new SamplingTimer(this.mClocks, this.mOnBatteryTimeBase);
            this.mRpmStats.put(name, rpmt);
        }
        return rpmt;
    }

    public SamplingTimer getScreenOffRpmTimerLocked(String name) {
        SamplingTimer rpmt = this.mScreenOffRpmStats.get(name);
        if (rpmt == null) {
            rpmt = new SamplingTimer(this.mClocks, this.mOnBatteryScreenOffTimeBase);
            this.mScreenOffRpmStats.put(name, rpmt);
        }
        return rpmt;
    }

    public SamplingTimer getWakeupReasonTimerLocked(String name) {
        SamplingTimer timer = this.mWakeupReasonStats.get(name);
        if (timer == null) {
            timer = new SamplingTimer(this.mClocks, this.mOnBatteryTimeBase);
            this.mWakeupReasonStats.put(name, timer);
        }
        return timer;
    }

    public SamplingTimer getKernelWakelockTimerLocked(String name) {
        SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
        if (kwlt == null) {
            kwlt = new SamplingTimer(this.mClocks, this.mOnBatteryScreenOffTimeBase);
            this.mKernelWakelockStats.put(name, kwlt);
        }
        return kwlt;
    }

    public SamplingTimer getKernelMemoryTimerLocked(long bucket) {
        SamplingTimer kmt = this.mKernelMemoryStats.get(bucket);
        if (kmt == null) {
            kmt = new SamplingTimer(this.mClocks, this.mOnBatteryTimeBase);
            this.mKernelMemoryStats.put(bucket, kmt);
        }
        return kmt;
    }

    private int writeHistoryTag(BatteryStats.HistoryTag tag) {
        int idx;
        Integer idxObj = this.mHistoryTagPool.get(tag);
        if (idxObj != null) {
            idx = idxObj;
        } else {
            idx = this.mNextHistoryTagIdx++;
            BatteryStats.HistoryTag key = new BatteryStats.HistoryTag();
            key.setTo(tag);
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(key, idx);
            this.mNumHistoryTagChars += key.string.length() + 1;
        }
        return idx;
    }

    private void readHistoryTag(int index, BatteryStats.HistoryTag tag) {
        if (index < this.mReadHistoryStrings.length) {
            tag.string = this.mReadHistoryStrings[index];
            tag.uid = this.mReadHistoryUids[index];
        } else {
            tag.string = null;
            tag.uid = 0;
        }
        tag.poolIdx = index;
    }

    public void writeHistoryDelta(Parcel dest, BatteryStats.HistoryItem cur, BatteryStats.HistoryItem last) {
        boolean batteryChargeChanged;
        boolean state2IntChanged;
        int stateInt;
        boolean stateIntChanged;
        boolean batteryLevelIntChanged;
        if (last == null || cur.cmd != 0) {
            dest.writeInt(524285);
            cur.writeToParcel(dest, 0);
            return;
        }
        long deltaTime = cur.time - last.time;
        int lastBatteryLevelInt = this.buildBatteryLevelInt(last);
        int lastStateInt = this.buildStateInt(last);
        int deltaTimeToken = deltaTime < 0L || deltaTime > Integer.MAX_VALUE ? 524287 : (deltaTime >= 524285L ? 524286 : (int)deltaTime);
        int firstToken = deltaTimeToken | cur.states & 0xFE000000;
        int includeStepDetails = this.mLastHistoryStepLevel > cur.batteryLevel ? 1 : 0;
        boolean computeStepDetails = includeStepDetails != 0 || this.mLastHistoryStepDetails == null;
        int batteryLevelInt = this.buildBatteryLevelInt(cur) | includeStepDetails;
        boolean bl = batteryLevelIntChanged = batteryLevelInt != lastBatteryLevelInt;
        if (batteryLevelIntChanged) {
            firstToken |= 0x80000;
        }
        boolean bl2 = stateIntChanged = (stateInt = this.buildStateInt(cur)) != lastStateInt;
        if (stateIntChanged) {
            firstToken |= 0x100000;
        }
        boolean bl3 = state2IntChanged = cur.states2 != last.states2;
        if (state2IntChanged) {
            firstToken |= 0x200000;
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            firstToken |= 0x400000;
        }
        if (cur.eventCode != 0) {
            firstToken |= 0x800000;
        }
        boolean bl4 = batteryChargeChanged = cur.batteryChargeUAh != last.batteryChargeUAh;
        if (batteryChargeChanged) {
            firstToken |= 0x1000000;
        }
        dest.writeInt(firstToken);
        if (deltaTimeToken >= 524286) {
            if (deltaTimeToken == 524286) {
                dest.writeInt((int)deltaTime);
            } else {
                dest.writeLong(deltaTime);
            }
        }
        if (batteryLevelIntChanged) {
            dest.writeInt(batteryLevelInt);
        }
        if (stateIntChanged) {
            dest.writeInt(stateInt);
        }
        if (state2IntChanged) {
            dest.writeInt(cur.states2);
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            int wakeLockIndex = cur.wakelockTag != null ? this.writeHistoryTag(cur.wakelockTag) : 65535;
            int wakeReasonIndex = cur.wakeReasonTag != null ? this.writeHistoryTag(cur.wakeReasonTag) : 65535;
            dest.writeInt(wakeReasonIndex << 16 | wakeLockIndex);
        }
        if (cur.eventCode != 0) {
            int index = this.writeHistoryTag(cur.eventTag);
            int codeAndIndex = cur.eventCode & 0xFFFF | index << 16;
            dest.writeInt(codeAndIndex);
        }
        if (computeStepDetails) {
            if (this.mPlatformIdleStateCallback != null) {
                this.mCurHistoryStepDetails.statPlatformIdleState = this.mPlatformIdleStateCallback.getPlatformLowPowerStats();
                this.mCurHistoryStepDetails.statSubsystemPowerState = this.mPlatformIdleStateCallback.getSubsystemLowPowerStats();
            }
            this.computeHistoryStepDetails(this.mCurHistoryStepDetails, this.mLastHistoryStepDetails);
            if (includeStepDetails != 0) {
                this.mCurHistoryStepDetails.writeToParcel(dest);
            }
            cur.stepDetails = this.mCurHistoryStepDetails;
            this.mLastHistoryStepDetails = this.mCurHistoryStepDetails;
        } else {
            cur.stepDetails = null;
        }
        if (this.mLastHistoryStepLevel < cur.batteryLevel) {
            this.mLastHistoryStepDetails = null;
        }
        this.mLastHistoryStepLevel = cur.batteryLevel;
        if (batteryChargeChanged) {
            dest.writeInt(cur.batteryChargeUAh);
        }
        dest.writeDouble(cur.modemRailChargeMah);
        dest.writeDouble(cur.wifiRailChargeMah);
    }

    private int buildBatteryLevelInt(BatteryStats.HistoryItem h) {
        return h.batteryLevel << 25 & 0xFE000000 | h.batteryTemperature << 15 & 0x1FF8000 | h.batteryVoltage << 1 & 0x7FFE;
    }

    private void readBatteryLevelInt(int batteryLevelInt, BatteryStats.HistoryItem out) {
        out.batteryLevel = (byte)((batteryLevelInt & 0xFE000000) >>> 25);
        out.batteryTemperature = (short)((batteryLevelInt & 0x1FF8000) >>> 15);
        out.batteryVoltage = (char)((batteryLevelInt & 0x7FFE) >>> 1);
    }

    private int buildStateInt(BatteryStats.HistoryItem h) {
        int plugType = 0;
        if ((h.batteryPlugType & 1) != 0) {
            plugType = 1;
        } else if ((h.batteryPlugType & 2) != 0) {
            plugType = 2;
        } else if ((h.batteryPlugType & 4) != 0) {
            plugType = 3;
        }
        return (h.batteryStatus & 7) << 29 | (h.batteryHealth & 7) << 26 | (plugType & 3) << 24 | h.states & 0xFFFFFF;
    }

    private void computeHistoryStepDetails(BatteryStats.HistoryStepDetails out, BatteryStats.HistoryStepDetails last) {
        BatteryStats.HistoryStepDetails tmp = last != null ? this.mTmpHistoryStepDetails : out;
        this.requestImmediateCpuUpdate();
        if (last == null) {
            int NU = this.mUidStats.size();
            for (int i = 0; i < NU; ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.mLastStepUserTime = uid.mCurStepUserTime;
                uid.mLastStepSystemTime = uid.mCurStepSystemTime;
            }
            this.mLastStepCpuUserTime = this.mCurStepCpuUserTime;
            this.mLastStepCpuSystemTime = this.mCurStepCpuSystemTime;
            this.mLastStepStatUserTime = this.mCurStepStatUserTime;
            this.mLastStepStatSystemTime = this.mCurStepStatSystemTime;
            this.mLastStepStatIOWaitTime = this.mCurStepStatIOWaitTime;
            this.mLastStepStatIrqTime = this.mCurStepStatIrqTime;
            this.mLastStepStatSoftIrqTime = this.mCurStepStatSoftIrqTime;
            this.mLastStepStatIdleTime = this.mCurStepStatIdleTime;
            tmp.clear();
            return;
        }
        out.userTime = (int)(this.mCurStepCpuUserTime - this.mLastStepCpuUserTime);
        out.systemTime = (int)(this.mCurStepCpuSystemTime - this.mLastStepCpuSystemTime);
        out.statUserTime = (int)(this.mCurStepStatUserTime - this.mLastStepStatUserTime);
        out.statSystemTime = (int)(this.mCurStepStatSystemTime - this.mLastStepStatSystemTime);
        out.statIOWaitTime = (int)(this.mCurStepStatIOWaitTime - this.mLastStepStatIOWaitTime);
        out.statIrqTime = (int)(this.mCurStepStatIrqTime - this.mLastStepStatIrqTime);
        out.statSoftIrqTime = (int)(this.mCurStepStatSoftIrqTime - this.mLastStepStatSoftIrqTime);
        out.statIdlTime = (int)(this.mCurStepStatIdleTime - this.mLastStepStatIdleTime);
        out.appCpuUid3 = -1;
        out.appCpuUid2 = -1;
        out.appCpuUid1 = -1;
        out.appCpuUTime3 = 0;
        out.appCpuUTime2 = 0;
        out.appCpuUTime1 = 0;
        out.appCpuSTime3 = 0;
        out.appCpuSTime2 = 0;
        out.appCpuSTime1 = 0;
        int NU = this.mUidStats.size();
        for (int i = 0; i < NU; ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            int totalUTime = (int)(uid.mCurStepUserTime - uid.mLastStepUserTime);
            int totalSTime = (int)(uid.mCurStepSystemTime - uid.mLastStepSystemTime);
            int totalTime = totalUTime + totalSTime;
            uid.mLastStepUserTime = uid.mCurStepUserTime;
            uid.mLastStepSystemTime = uid.mCurStepSystemTime;
            if (totalTime <= out.appCpuUTime3 + out.appCpuSTime3) continue;
            if (totalTime <= out.appCpuUTime2 + out.appCpuSTime2) {
                out.appCpuUid3 = uid.mUid;
                out.appCpuUTime3 = totalUTime;
                out.appCpuSTime3 = totalSTime;
                continue;
            }
            out.appCpuUid3 = out.appCpuUid2;
            out.appCpuUTime3 = out.appCpuUTime2;
            out.appCpuSTime3 = out.appCpuSTime2;
            if (totalTime <= out.appCpuUTime1 + out.appCpuSTime1) {
                out.appCpuUid2 = uid.mUid;
                out.appCpuUTime2 = totalUTime;
                out.appCpuSTime2 = totalSTime;
                continue;
            }
            out.appCpuUid2 = out.appCpuUid1;
            out.appCpuUTime2 = out.appCpuUTime1;
            out.appCpuSTime2 = out.appCpuSTime1;
            out.appCpuUid1 = uid.mUid;
            out.appCpuUTime1 = totalUTime;
            out.appCpuSTime1 = totalSTime;
        }
        this.mLastStepCpuUserTime = this.mCurStepCpuUserTime;
        this.mLastStepCpuSystemTime = this.mCurStepCpuSystemTime;
        this.mLastStepStatUserTime = this.mCurStepStatUserTime;
        this.mLastStepStatSystemTime = this.mCurStepStatSystemTime;
        this.mLastStepStatIOWaitTime = this.mCurStepStatIOWaitTime;
        this.mLastStepStatIrqTime = this.mCurStepStatIrqTime;
        this.mLastStepStatSoftIrqTime = this.mCurStepStatSoftIrqTime;
        this.mLastStepStatIdleTime = this.mCurStepStatIdleTime;
    }

    public void readHistoryDelta(Parcel src, BatteryStats.HistoryItem cur) {
        int batteryLevelInt;
        int firstToken = src.readInt();
        int deltaTimeToken = firstToken & 0x7FFFF;
        cur.cmd = 0;
        cur.numReadInts = 1;
        if (deltaTimeToken < 524285) {
            cur.time += (long)deltaTimeToken;
        } else {
            if (deltaTimeToken == 524285) {
                cur.readFromParcel(src);
                return;
            }
            if (deltaTimeToken == 524286) {
                int delta = src.readInt();
                cur.time += (long)delta;
                ++cur.numReadInts;
            } else {
                long delta = src.readLong();
                cur.time += delta;
                cur.numReadInts += 2;
            }
        }
        if ((firstToken & 0x80000) != 0) {
            batteryLevelInt = src.readInt();
            this.readBatteryLevelInt(batteryLevelInt, cur);
            ++cur.numReadInts;
        } else {
            batteryLevelInt = 0;
        }
        if ((firstToken & 0x100000) != 0) {
            int stateInt = src.readInt();
            cur.states = firstToken & 0xFE000000 | stateInt & 0xFFFFFF;
            cur.batteryStatus = (byte)(stateInt >> 29 & 7);
            cur.batteryHealth = (byte)(stateInt >> 26 & 7);
            cur.batteryPlugType = (byte)(stateInt >> 24 & 3);
            switch (cur.batteryPlugType) {
                case 1: {
                    cur.batteryPlugType = 1;
                    break;
                }
                case 2: {
                    cur.batteryPlugType = (byte)2;
                    break;
                }
                case 3: {
                    cur.batteryPlugType = (byte)4;
                }
            }
            ++cur.numReadInts;
        } else {
            cur.states = firstToken & 0xFE000000 | cur.states & 0xFFFFFF;
        }
        if ((firstToken & 0x200000) != 0) {
            cur.states2 = src.readInt();
        }
        if ((firstToken & 0x400000) != 0) {
            int indexes = src.readInt();
            int wakeLockIndex = indexes & 0xFFFF;
            int wakeReasonIndex = indexes >> 16 & 0xFFFF;
            if (wakeLockIndex != 65535) {
                cur.wakelockTag = cur.localWakelockTag;
                this.readHistoryTag(wakeLockIndex, cur.wakelockTag);
            } else {
                cur.wakelockTag = null;
            }
            if (wakeReasonIndex != 65535) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                this.readHistoryTag(wakeReasonIndex, cur.wakeReasonTag);
            } else {
                cur.wakeReasonTag = null;
            }
            ++cur.numReadInts;
        } else {
            cur.wakelockTag = null;
            cur.wakeReasonTag = null;
        }
        if ((firstToken & 0x800000) != 0) {
            cur.eventTag = cur.localEventTag;
            int codeAndIndex = src.readInt();
            cur.eventCode = codeAndIndex & 0xFFFF;
            int index = codeAndIndex >> 16 & 0xFFFF;
            this.readHistoryTag(index, cur.eventTag);
            ++cur.numReadInts;
        } else {
            cur.eventCode = 0;
        }
        if ((batteryLevelInt & 1) != 0) {
            cur.stepDetails = this.mReadHistoryStepDetails;
            cur.stepDetails.readFromParcel(src);
        } else {
            cur.stepDetails = null;
        }
        if ((firstToken & 0x1000000) != 0) {
            cur.batteryChargeUAh = src.readInt();
        }
        cur.modemRailChargeMah = src.readDouble();
        cur.wifiRailChargeMah = src.readDouble();
    }

    @Override
    public void commitCurrentHistoryBatchLocked() {
        this.mHistoryLastWritten.cmd = (byte)-1;
    }

    public void createFakeHistoryEvents(long numEvents) {
        for (long i = 0L; i < numEvents; ++i) {
            this.noteLongPartialWakelockStart("name1", "historyName1", 1000);
            this.noteLongPartialWakelockFinish("name1", "historyName1", 1000);
        }
    }

    void addHistoryBufferLocked(long elapsedRealtimeMs, BatteryStats.HistoryItem cur) {
        int dataSize;
        if (!this.mHaveBatteryLevel || !this.mRecordingHistory) {
            return;
        }
        long timeDiff = this.mHistoryBaseTime + elapsedRealtimeMs - this.mHistoryLastWritten.time;
        int diffStates = this.mHistoryLastWritten.states ^ cur.states & this.mActiveHistoryStates;
        int diffStates2 = this.mHistoryLastWritten.states2 ^ cur.states2 & this.mActiveHistoryStates2;
        int lastDiffStates = this.mHistoryLastWritten.states ^ this.mHistoryLastLastWritten.states;
        int lastDiffStates2 = this.mHistoryLastWritten.states2 ^ this.mHistoryLastLastWritten.states2;
        if (!(this.mHistoryBufferLastPos < 0 || this.mHistoryLastWritten.cmd != 0 || timeDiff >= 1000L || (diffStates & lastDiffStates) != 0 || (diffStates2 & lastDiffStates2) != 0 || this.mHistoryLastWritten.wakelockTag != null && cur.wakelockTag != null || this.mHistoryLastWritten.wakeReasonTag != null && cur.wakeReasonTag != null || this.mHistoryLastWritten.stepDetails != null || this.mHistoryLastWritten.eventCode != 0 && cur.eventCode != 0 || this.mHistoryLastWritten.batteryLevel != cur.batteryLevel || this.mHistoryLastWritten.batteryStatus != cur.batteryStatus || this.mHistoryLastWritten.batteryHealth != cur.batteryHealth || this.mHistoryLastWritten.batteryPlugType != cur.batteryPlugType || this.mHistoryLastWritten.batteryTemperature != cur.batteryTemperature || this.mHistoryLastWritten.batteryVoltage != cur.batteryVoltage)) {
            this.mHistoryBuffer.setDataSize(this.mHistoryBufferLastPos);
            this.mHistoryBuffer.setDataPosition(this.mHistoryBufferLastPos);
            this.mHistoryBufferLastPos = -1;
            elapsedRealtimeMs = this.mHistoryLastWritten.time - this.mHistoryBaseTime;
            if (this.mHistoryLastWritten.wakelockTag != null) {
                cur.wakelockTag = cur.localWakelockTag;
                cur.wakelockTag.setTo(this.mHistoryLastWritten.wakelockTag);
            }
            if (this.mHistoryLastWritten.wakeReasonTag != null) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                cur.wakeReasonTag.setTo(this.mHistoryLastWritten.wakeReasonTag);
            }
            if (this.mHistoryLastWritten.eventCode != 0) {
                cur.eventCode = this.mHistoryLastWritten.eventCode;
                cur.eventTag = cur.localEventTag;
                cur.eventTag.setTo(this.mHistoryLastWritten.eventTag);
            }
            this.mHistoryLastWritten.setTo(this.mHistoryLastLastWritten);
        }
        if ((dataSize = this.mHistoryBuffer.dataSize()) >= this.mConstants.MAX_HISTORY_BUFFER) {
            long start = SystemClock.uptimeMillis();
            this.writeHistoryLocked(true);
            this.mBatteryStatsHistory.startNextFile();
            this.mHistoryBuffer.setDataSize(0);
            this.mHistoryBuffer.setDataPosition(0);
            this.mHistoryBuffer.setDataCapacity(this.mConstants.MAX_HISTORY_BUFFER / 2);
            this.mHistoryBufferLastPos = -1;
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            BatteryStats.HistoryItem newItem = new BatteryStats.HistoryItem();
            newItem.setTo(cur);
            this.startRecordingHistory(elapsedRealtime, uptime, false);
            this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)0, newItem);
            return;
        }
        if (dataSize == 0) {
            cur.currentTime = System_Delegate.currentTimeMillis();
            this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)7, cur);
        }
        this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)0, cur);
    }

    private void addHistoryBufferLocked(long elapsedRealtimeMs, byte cmd, BatteryStats.HistoryItem cur) {
        if (this.mIteratingHistory) {
            throw new IllegalStateException("Can't do this while iterating history!");
        }
        this.mHistoryBufferLastPos = this.mHistoryBuffer.dataPosition();
        this.mHistoryLastLastWritten.setTo(this.mHistoryLastWritten);
        this.mHistoryLastWritten.setTo(this.mHistoryBaseTime + elapsedRealtimeMs, cmd, cur);
        this.mHistoryLastWritten.states &= this.mActiveHistoryStates;
        this.mHistoryLastWritten.states2 &= this.mActiveHistoryStates2;
        this.writeHistoryDelta(this.mHistoryBuffer, this.mHistoryLastWritten, this.mHistoryLastLastWritten);
        this.mLastHistoryElapsedRealtime = elapsedRealtimeMs;
        cur.wakelockTag = null;
        cur.wakeReasonTag = null;
        cur.eventCode = 0;
        cur.eventTag = null;
    }

    void addHistoryRecordLocked(long elapsedRealtimeMs, long uptimeMs) {
        long diffElapsed;
        long diffUptime;
        if (this.mTrackRunningHistoryElapsedRealtime != 0L && (diffUptime = uptimeMs - this.mTrackRunningHistoryUptime) < (diffElapsed = elapsedRealtimeMs - this.mTrackRunningHistoryElapsedRealtime) - 20L) {
            long wakeElapsedTime = elapsedRealtimeMs - (diffElapsed - diffUptime);
            this.mHistoryAddTmp.setTo(this.mHistoryLastWritten);
            this.mHistoryAddTmp.wakelockTag = null;
            this.mHistoryAddTmp.wakeReasonTag = null;
            this.mHistoryAddTmp.eventCode = 0;
            this.mHistoryAddTmp.states &= Integer.MAX_VALUE;
            this.addHistoryRecordInnerLocked(wakeElapsedTime, this.mHistoryAddTmp);
        }
        this.mHistoryCur.states |= Integer.MIN_VALUE;
        this.mTrackRunningHistoryElapsedRealtime = elapsedRealtimeMs;
        this.mTrackRunningHistoryUptime = uptimeMs;
        this.addHistoryRecordInnerLocked(elapsedRealtimeMs, this.mHistoryCur);
    }

    void addHistoryRecordInnerLocked(long elapsedRealtimeMs, BatteryStats.HistoryItem cur) {
        this.addHistoryBufferLocked(elapsedRealtimeMs, cur);
    }

    public void addHistoryEventLocked(long elapsedRealtimeMs, long uptimeMs, int code, String name, int uid) {
        this.mHistoryCur.eventCode = code;
        this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
        this.mHistoryCur.eventTag.string = name;
        this.mHistoryCur.eventTag.uid = uid;
        this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
    }

    void addHistoryRecordLocked(long elapsedRealtimeMs, long uptimeMs, byte cmd, BatteryStats.HistoryItem cur) {
        BatteryStats.HistoryItem rec = this.mHistoryCache;
        if (rec != null) {
            this.mHistoryCache = rec.next;
        } else {
            rec = new BatteryStats.HistoryItem();
        }
        rec.setTo(this.mHistoryBaseTime + elapsedRealtimeMs, cmd, cur);
        this.addHistoryRecordLocked(rec);
    }

    void addHistoryRecordLocked(BatteryStats.HistoryItem rec) {
        ++this.mNumHistoryItems;
        rec.next = null;
        this.mHistoryLastEnd = this.mHistoryEnd;
        if (this.mHistoryEnd != null) {
            this.mHistoryEnd.next = rec;
            this.mHistoryEnd = rec;
        } else {
            this.mHistory = this.mHistoryEnd = rec;
        }
    }

    void clearHistoryLocked() {
        this.mHistoryBaseTime = 0L;
        this.mLastHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryUptime = 0L;
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryBuffer.setDataCapacity(this.mConstants.MAX_HISTORY_BUFFER / 2);
        this.mHistoryLastLastWritten.clear();
        this.mHistoryLastWritten.clear();
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
        this.mActiveHistoryStates = -1;
        this.mActiveHistoryStates2 = -1;
    }

    @GuardedBy(value={"this"})
    public void updateTimeBasesLocked(boolean unplugged, int screenState, long uptime, long realtime) {
        boolean updateOnBatteryScreenOffTimeBase;
        boolean screenOff = !this.isScreenOn(screenState);
        boolean updateOnBatteryTimeBase = unplugged != this.mOnBatteryTimeBase.isRunning();
        boolean bl = updateOnBatteryScreenOffTimeBase = (unplugged && screenOff) != this.mOnBatteryScreenOffTimeBase.isRunning();
        if (updateOnBatteryScreenOffTimeBase || updateOnBatteryTimeBase) {
            int i;
            if (updateOnBatteryScreenOffTimeBase) {
                this.updateKernelWakelocksLocked();
                this.updateBatteryPropertiesLocked();
            }
            if (updateOnBatteryTimeBase) {
                this.updateRpmStatsLocked();
            }
            this.mOnBatteryTimeBase.setRunning(unplugged, uptime, realtime);
            if (updateOnBatteryTimeBase) {
                for (i = this.mUidStats.size() - 1; i >= 0; --i) {
                    this.mUidStats.valueAt(i).updateOnBatteryBgTimeBase(uptime, realtime);
                }
            }
            if (updateOnBatteryScreenOffTimeBase) {
                this.mOnBatteryScreenOffTimeBase.setRunning(unplugged && screenOff, uptime, realtime);
                for (i = this.mUidStats.size() - 1; i >= 0; --i) {
                    this.mUidStats.valueAt(i).updateOnBatteryScreenOffBgTimeBase(uptime, realtime);
                }
            }
        }
    }

    private void updateBatteryPropertiesLocked() {
        try {
            IBatteryPropertiesRegistrar registrar = IBatteryPropertiesRegistrar.Stub.asInterface(ServiceManager.getService("batteryproperties"));
            if (registrar != null) {
                registrar.scheduleUpdate();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void addIsolatedUidLocked(int isolatedUid, int appUid) {
        this.mIsolatedUids.put(isolatedUid, appUid);
        Uid u = this.getUidStatsLocked(appUid);
        u.addIsolatedUid(isolatedUid);
    }

    public void scheduleRemoveIsolatedUidLocked(int isolatedUid, int appUid) {
        int curUid = this.mIsolatedUids.get(isolatedUid, -1);
        if (curUid == appUid && this.mExternalSync != null) {
            this.mExternalSync.scheduleCpuSyncDueToRemovedUid(isolatedUid);
        }
    }

    @GuardedBy(value={"this"})
    public void removeIsolatedUidLocked(int isolatedUid) {
        int idx = this.mIsolatedUids.indexOfKey(isolatedUid);
        if (idx >= 0) {
            int ownerUid = this.mIsolatedUids.valueAt(idx);
            Uid u = this.getUidStatsLocked(ownerUid);
            u.removeIsolatedUid(isolatedUid);
            this.mIsolatedUids.removeAt(idx);
        }
        this.mPendingRemovedUids.add(new UidToRemove(isolatedUid, this.mClocks.elapsedRealtime()));
    }

    public int mapUid(int uid) {
        int isolated = this.mIsolatedUids.get(uid, -1);
        return isolated > 0 ? isolated : uid;
    }

    public void noteEventLocked(int code, String name, int uid) {
        if (!this.mActiveEvents.updateState(code, name, uid = this.mapUid(uid), 0)) {
            return;
        }
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, code, name, uid);
    }

    public void noteCurrentTimeChangedLocked() {
        long currentTime = System_Delegate.currentTimeMillis();
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.recordCurrentTimeChangeLocked(currentTime, elapsedRealtime, uptime);
    }

    public void noteProcessStartLocked(String name, int uid) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid);
            u.getProcessStatsLocked(name).incStartsLocked();
        }
        if (!this.mActiveEvents.updateState(32769, name, uid, 0)) {
            return;
        }
        if (!this.mRecordAllHistory) {
            return;
        }
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32769, name, uid);
    }

    public void noteProcessCrashLocked(String name, int uid) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid);
            u.getProcessStatsLocked(name).incNumCrashesLocked();
        }
    }

    public void noteProcessAnrLocked(String name, int uid) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid);
            u.getProcessStatsLocked(name).incNumAnrsLocked();
        }
    }

    public void noteUidProcessStateLocked(int uid, int state) {
        int parentUid = this.mapUid(uid);
        if (uid != parentUid) {
            return;
        }
        FrameworkStatsLog.write(27, uid, ActivityManager.processStateAmToProto(state));
        this.getUidStatsLocked(uid).updateUidProcessStateLocked(state);
    }

    public void noteProcessFinishLocked(String name, int uid) {
        if (!this.mActiveEvents.updateState(16385, name, uid = this.mapUid(uid), 0)) {
            return;
        }
        if (!this.mRecordAllHistory) {
            return;
        }
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16385, name, uid);
    }

    public void noteSyncStartLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.getUidStatsLocked(uid).noteStartSyncLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(32772, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32772, name, uid);
    }

    public void noteSyncFinishLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.getUidStatsLocked(uid).noteStopSyncLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(16388, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16388, name, uid);
    }

    public void noteJobStartLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.getUidStatsLocked(uid).noteStartJobLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(32774, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32774, name, uid);
    }

    public void noteJobFinishLocked(String name, int uid, int stopReason) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.getUidStatsLocked(uid).noteStopJobLocked(name, elapsedRealtime, stopReason);
        if (!this.mActiveEvents.updateState(16390, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16390, name, uid);
    }

    public void noteJobsDeferredLocked(int uid, int numDeferred, long sinceLast) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteJobsDeferredLocked(numDeferred, sinceLast);
    }

    public void noteAlarmStartLocked(String name, WorkSource workSource, int uid) {
        this.noteAlarmStartOrFinishLocked(32781, name, workSource, uid);
    }

    public void noteAlarmFinishLocked(String name, WorkSource workSource, int uid) {
        this.noteAlarmStartOrFinishLocked(16397, name, workSource, uid);
    }

    private void noteAlarmStartOrFinishLocked(int historyItem, String name, WorkSource workSource, int uid) {
        if (!this.mRecordAllHistory) {
            return;
        }
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (workSource != null) {
            for (int i = 0; i < workSource.size(); ++i) {
                uid = this.mapUid(workSource.getUid(i));
                if (!this.mActiveEvents.updateState(historyItem, name, uid, 0)) continue;
                this.addHistoryEventLocked(elapsedRealtime, uptime, historyItem, name, uid);
            }
            List<WorkSource.WorkChain> workChains = workSource.getWorkChains();
            if (workChains != null) {
                for (int i = 0; i < workChains.size(); ++i) {
                    uid = this.mapUid(workChains.get(i).getAttributionUid());
                    if (!this.mActiveEvents.updateState(historyItem, name, uid, 0)) continue;
                    this.addHistoryEventLocked(elapsedRealtime, uptime, historyItem, name, uid);
                }
            }
        } else if (this.mActiveEvents.updateState(historyItem, name, uid = this.mapUid(uid), 0)) {
            this.addHistoryEventLocked(elapsedRealtime, uptime, historyItem, name, uid);
        }
    }

    public void noteWakupAlarmLocked(String packageName, int uid, WorkSource workSource, String tag) {
        if (workSource != null) {
            for (int i = 0; i < workSource.size(); ++i) {
                uid = workSource.getUid(i);
                String workSourceName = workSource.getPackageName(i);
                if (!this.isOnBattery()) continue;
                Uid.Pkg pkg = this.getPackageStatsLocked(uid, workSourceName != null ? workSourceName : packageName);
                pkg.noteWakeupAlarmLocked(tag);
            }
            List<WorkSource.WorkChain> workChains = workSource.getWorkChains();
            if (workChains != null) {
                for (int i = 0; i < workChains.size(); ++i) {
                    WorkSource.WorkChain wc = workChains.get(i);
                    uid = wc.getAttributionUid();
                    if (!this.isOnBattery()) continue;
                    Uid.Pkg pkg = this.getPackageStatsLocked(uid, packageName);
                    pkg.noteWakeupAlarmLocked(tag);
                }
            }
        } else if (this.isOnBattery()) {
            Uid.Pkg pkg = this.getPackageStatsLocked(uid, packageName);
            pkg.noteWakeupAlarmLocked(tag);
        }
    }

    private void requestWakelockCpuUpdate() {
        this.mExternalSync.scheduleCpuSyncDueToWakelockChange(5000L);
    }

    private void requestImmediateCpuUpdate() {
        this.mExternalSync.scheduleCpuSyncDueToWakelockChange(0L);
    }

    public void setRecordAllHistoryLocked(boolean enabled) {
        block6: {
            block5: {
                this.mRecordAllHistory = enabled;
                if (enabled) break block5;
                this.mActiveEvents.removeEvents(5);
                this.mActiveEvents.removeEvents(13);
                HashMap<String, SparseIntArray> active = this.mActiveEvents.getStateForEvent(1);
                if (active == null) break block6;
                long mSecRealtime = this.mClocks.elapsedRealtime();
                long mSecUptime = this.mClocks.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                    SparseIntArray uids = ent.getValue();
                    for (int j = 0; j < uids.size(); ++j) {
                        this.addHistoryEventLocked(mSecRealtime, mSecUptime, 16385, ent.getKey(), uids.keyAt(j));
                    }
                }
                break block6;
            }
            HashMap<String, SparseIntArray> active = this.mActiveEvents.getStateForEvent(1);
            if (active != null) {
                long mSecRealtime = this.mClocks.elapsedRealtime();
                long mSecUptime = this.mClocks.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                    SparseIntArray uids = ent.getValue();
                    for (int j = 0; j < uids.size(); ++j) {
                        this.addHistoryEventLocked(mSecRealtime, mSecUptime, 32769, ent.getKey(), uids.keyAt(j));
                    }
                }
            }
        }
    }

    public void setNoAutoReset(boolean enabled) {
        this.mNoAutoReset = enabled;
    }

    public void setPretendScreenOff(boolean pretendScreenOff) {
        if (this.mPretendScreenOff != pretendScreenOff) {
            this.mPretendScreenOff = pretendScreenOff;
            this.noteScreenStateLocked(pretendScreenOff ? 1 : 2);
        }
    }

    public void noteStartWakeLocked(int uid, int pid, WorkSource.WorkChain wc, String name, String historyName, int type, boolean unimportantForLogging, long elapsedRealtime, long uptime) {
        uid = this.mapUid(uid);
        if (type == 0) {
            this.aggregateLastWakeupUptimeLocked(uptime);
            if (historyName == null) {
                historyName = name;
            }
            if (this.mRecordAllHistory && this.mActiveEvents.updateState(32773, historyName, uid, 0)) {
                this.addHistoryEventLocked(elapsedRealtime, uptime, 32773, historyName, uid);
            }
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states |= 0x40000000;
                this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                this.mHistoryCur.wakelockTag.string = this.mInitialAcquireWakeName = historyName;
                this.mHistoryCur.wakelockTag.uid = this.mInitialAcquireWakeUid = uid;
                this.mWakeLockImportant = !unimportantForLogging;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            } else if (!this.mWakeLockImportant && !unimportantForLogging && this.mHistoryLastWritten.cmd == 0) {
                if (this.mHistoryLastWritten.wakelockTag != null) {
                    this.mHistoryLastWritten.wakelockTag = null;
                    this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                    this.mHistoryCur.wakelockTag.string = this.mInitialAcquireWakeName = historyName;
                    this.mHistoryCur.wakelockTag.uid = this.mInitialAcquireWakeUid = uid;
                    this.addHistoryRecordLocked(elapsedRealtime, uptime);
                }
                this.mWakeLockImportant = true;
            }
            ++this.mWakeLockNesting;
        }
        if (uid >= 0) {
            if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
                this.requestWakelockCpuUpdate();
            }
            this.getUidStatsLocked(uid).noteStartWakeLocked(pid, name, type, elapsedRealtime);
            if (wc != null) {
                FrameworkStatsLog.write(10, wc.getUids(), wc.getTags(), this.getPowerManagerWakeLockLevel(type), name, 1);
            } else {
                FrameworkStatsLog.write_non_chained(10, uid, null, this.getPowerManagerWakeLockLevel(type), name, 1);
            }
        }
    }

    public void noteStopWakeLocked(int uid, int pid, WorkSource.WorkChain wc, String name, String historyName, int type, long elapsedRealtime, long uptime) {
        uid = this.mapUid(uid);
        if (type == 0) {
            --this.mWakeLockNesting;
            if (this.mRecordAllHistory) {
                if (historyName == null) {
                    historyName = name;
                }
                if (this.mActiveEvents.updateState(16389, historyName, uid, 0)) {
                    this.addHistoryEventLocked(elapsedRealtime, uptime, 16389, historyName, uid);
                }
            }
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states &= 0xBFFFFFFF;
                this.mInitialAcquireWakeName = null;
                this.mInitialAcquireWakeUid = -1;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            }
        }
        if (uid >= 0) {
            if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
                this.requestWakelockCpuUpdate();
            }
            this.getUidStatsLocked(uid).noteStopWakeLocked(pid, name, type, elapsedRealtime);
            if (wc != null) {
                FrameworkStatsLog.write(10, wc.getUids(), wc.getTags(), this.getPowerManagerWakeLockLevel(type), name, 0);
            } else {
                FrameworkStatsLog.write_non_chained(10, uid, null, this.getPowerManagerWakeLockLevel(type), name, 0);
            }
        }
    }

    private int getPowerManagerWakeLockLevel(int battertStatsWakelockType) {
        switch (battertStatsWakelockType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 26;
            }
            case 18: {
                return 128;
            }
            case 2: {
                Slog.e(TAG, "Illegal window wakelock type observed in batterystats.");
                return -1;
            }
        }
        Slog.e(TAG, "Illegal wakelock type in batterystats: " + battertStatsWakelockType);
        return -1;
    }

    public void noteStartWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStartWakeLocked(ws.getUid(i), pid, null, name, historyName, type, unimportantForLogging, elapsedRealtime, uptime);
        }
        List<WorkSource.WorkChain> wcs = ws.getWorkChains();
        if (wcs != null) {
            for (int i = 0; i < wcs.size(); ++i) {
                WorkSource.WorkChain wc = wcs.get(i);
                this.noteStartWakeLocked(wc.getAttributionUid(), pid, wc, name, historyName, type, unimportantForLogging, elapsedRealtime, uptime);
            }
        }
    }

    public void noteChangeWakelockFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) {
        ArrayList<WorkSource.WorkChain> goneChains;
        int i;
        ArrayList<WorkSource.WorkChain> newChains;
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        ArrayList<WorkSource.WorkChain>[] wcs = WorkSource.diffChains(ws, newWs);
        int NN = newWs.size();
        for (int i2 = 0; i2 < NN; ++i2) {
            this.noteStartWakeLocked(newWs.getUid(i2), newPid, null, newName, newHistoryName, newType, newUnimportantForLogging, elapsedRealtime, uptime);
        }
        if (wcs != null && (newChains = wcs[0]) != null) {
            for (i = 0; i < newChains.size(); ++i) {
                WorkSource.WorkChain newChain = (WorkSource.WorkChain)newChains.get(i);
                this.noteStartWakeLocked(newChain.getAttributionUid(), newPid, newChain, newName, newHistoryName, newType, newUnimportantForLogging, elapsedRealtime, uptime);
            }
        }
        int NO = ws.size();
        for (i = 0; i < NO; ++i) {
            this.noteStopWakeLocked(ws.getUid(i), pid, null, name, historyName, type, elapsedRealtime, uptime);
        }
        if (wcs != null && (goneChains = wcs[1]) != null) {
            for (int i3 = 0; i3 < goneChains.size(); ++i3) {
                WorkSource.WorkChain goneChain = (WorkSource.WorkChain)goneChains.get(i3);
                this.noteStopWakeLocked(goneChain.getAttributionUid(), pid, goneChain, name, historyName, type, elapsedRealtime, uptime);
            }
        }
    }

    public void noteStopWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStopWakeLocked(ws.getUid(i), pid, null, name, historyName, type, elapsedRealtime, uptime);
        }
        List<WorkSource.WorkChain> wcs = ws.getWorkChains();
        if (wcs != null) {
            for (int i = 0; i < wcs.size(); ++i) {
                WorkSource.WorkChain wc = wcs.get(i);
                this.noteStopWakeLocked(wc.getAttributionUid(), pid, wc, name, historyName, type, elapsedRealtime, uptime);
            }
        }
    }

    public void noteLongPartialWakelockStart(String name, String historyName, int uid) {
        uid = this.mapUid(uid);
        this.noteLongPartialWakeLockStartInternal(name, historyName, uid);
    }

    public void noteLongPartialWakelockStartFromSource(String name, String historyName, WorkSource workSource) {
        int N = workSource.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(workSource.getUid(i));
            this.noteLongPartialWakeLockStartInternal(name, historyName, uid);
        }
        List<WorkSource.WorkChain> workChains = workSource.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = workChain.getAttributionUid();
                this.noteLongPartialWakeLockStartInternal(name, historyName, uid);
            }
        }
    }

    private void noteLongPartialWakeLockStartInternal(String name, String historyName, int uid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (historyName == null) {
            historyName = name;
        }
        if (!this.mActiveEvents.updateState(32788, historyName, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32788, historyName, uid);
    }

    public void noteLongPartialWakelockFinish(String name, String historyName, int uid) {
        uid = this.mapUid(uid);
        this.noteLongPartialWakeLockFinishInternal(name, historyName, uid);
    }

    public void noteLongPartialWakelockFinishFromSource(String name, String historyName, WorkSource workSource) {
        int N = workSource.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(workSource.getUid(i));
            this.noteLongPartialWakeLockFinishInternal(name, historyName, uid);
        }
        List<WorkSource.WorkChain> workChains = workSource.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = workChain.getAttributionUid();
                this.noteLongPartialWakeLockFinishInternal(name, historyName, uid);
            }
        }
    }

    private void noteLongPartialWakeLockFinishInternal(String name, String historyName, int uid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (historyName == null) {
            historyName = name;
        }
        if (!this.mActiveEvents.updateState(16404, historyName, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16404, historyName, uid);
    }

    void aggregateLastWakeupUptimeLocked(long uptimeMs) {
        if (this.mLastWakeupReason != null) {
            long deltaUptime = uptimeMs - this.mLastWakeupUptimeMs;
            SamplingTimer timer = this.getWakeupReasonTimerLocked(this.mLastWakeupReason);
            timer.add(deltaUptime * 1000L, 1);
            FrameworkStatsLog.write(36, this.mLastWakeupReason, deltaUptime * 1000L);
            this.mLastWakeupReason = null;
        }
    }

    public void noteWakeupReasonLocked(String reason) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.aggregateLastWakeupUptimeLocked(uptime);
        this.mHistoryCur.wakeReasonTag = this.mHistoryCur.localWakeReasonTag;
        this.mHistoryCur.wakeReasonTag.string = reason;
        this.mHistoryCur.wakeReasonTag.uid = 0;
        this.mLastWakeupReason = reason;
        this.mLastWakeupUptimeMs = uptime;
        this.addHistoryRecordLocked(elapsedRealtime, uptime);
    }

    public boolean startAddingCpuLocked() {
        this.mExternalSync.cancelCpuSyncDueToWakelockChange();
        return this.mOnBatteryInternal;
    }

    public void finishAddingCpuLocked(int totalUTime, int totalSTime, int statUserTime, int statSystemTime, int statIOWaitTime, int statIrqTime, int statSoftIrqTime, int statIdleTime) {
        this.mCurStepCpuUserTime += (long)totalUTime;
        this.mCurStepCpuSystemTime += (long)totalSTime;
        this.mCurStepStatUserTime += (long)statUserTime;
        this.mCurStepStatSystemTime += (long)statSystemTime;
        this.mCurStepStatIOWaitTime += (long)statIOWaitTime;
        this.mCurStepStatIrqTime += (long)statIrqTime;
        this.mCurStepStatSoftIrqTime += (long)statSoftIrqTime;
        this.mCurStepStatIdleTime += (long)statIdleTime;
    }

    public void noteProcessDiedLocked(int uid, int pid) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.mPids.remove(pid);
        }
    }

    public long getProcessWakeTime(int uid, int pid, long realtime) {
        BatteryStats.Uid.Pid p;
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null && (p = u.mPids.get(pid)) != null) {
            return p.mWakeSumMs + (p.mWakeNesting > 0 ? realtime - p.mWakeStartMs : 0L);
        }
        return 0L;
    }

    public void reportExcessiveCpuLocked(int uid, String proc, long overTime, long usedTime) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.reportExcessiveCpuLocked(proc, overTime, usedTime);
        }
    }

    public void noteStartSensorLocked(int uid, int sensor) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states |= 0x800000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mSensorNesting;
        this.getUidStatsLocked(uid).noteStartSensor(sensor, elapsedRealtime);
    }

    public void noteStopSensorLocked(int uid, int sensor) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mSensorNesting;
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states &= 0xFF7FFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteStopSensor(sensor, elapsedRealtime);
    }

    public void noteGpsChangedLocked(WorkSource oldWs, WorkSource newWs) {
        int i;
        for (i = 0; i < newWs.size(); ++i) {
            this.noteStartGpsLocked(newWs.getUid(i), null);
        }
        for (i = 0; i < oldWs.size(); ++i) {
            this.noteStopGpsLocked(oldWs.getUid(i), null);
        }
        ArrayList<WorkSource.WorkChain>[] wcs = WorkSource.diffChains(oldWs, newWs);
        if (wcs != null) {
            int i2;
            if (wcs[0] != null) {
                ArrayList<WorkSource.WorkChain> newChains = wcs[0];
                for (i2 = 0; i2 < newChains.size(); ++i2) {
                    this.noteStartGpsLocked(-1, (WorkSource.WorkChain)newChains.get(i2));
                }
            }
            if (wcs[1] != null) {
                ArrayList<WorkSource.WorkChain> goneChains = wcs[1];
                for (i2 = 0; i2 < goneChains.size(); ++i2) {
                    this.noteStopGpsLocked(-1, (WorkSource.WorkChain)goneChains.get(i2));
                }
            }
        }
    }

    private void noteStartGpsLocked(int uid, WorkSource.WorkChain workChain) {
        uid = this.getAttributionUid(uid, workChain);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states |= 0x20000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mGpsNesting;
        if (workChain == null) {
            FrameworkStatsLog.write_non_chained(6, uid, null, 1);
        } else {
            FrameworkStatsLog.write(6, workChain.getUids(), workChain.getTags(), 1);
        }
        this.getUidStatsLocked(uid).noteStartGps(elapsedRealtime);
    }

    private void noteStopGpsLocked(int uid, WorkSource.WorkChain workChain) {
        uid = this.getAttributionUid(uid, workChain);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mGpsNesting;
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states &= 0xDFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.stopAllGpsSignalQualityTimersLocked(-1);
            this.mGpsSignalQualityBin = -1;
        }
        if (workChain == null) {
            FrameworkStatsLog.write_non_chained(6, uid, null, 0);
        } else {
            FrameworkStatsLog.write(6, workChain.getUids(), workChain.getTags(), 0);
        }
        this.getUidStatsLocked(uid).noteStopGps(elapsedRealtime);
    }

    public void noteGpsSignalQualityLocked(int signalLevel) {
        if (this.mGpsNesting == 0) {
            return;
        }
        if (signalLevel < 0 || signalLevel >= 2) {
            this.stopAllGpsSignalQualityTimersLocked(-1);
            return;
        }
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mGpsSignalQualityBin != signalLevel) {
            if (this.mGpsSignalQualityBin >= 0) {
                this.mGpsSignalQualityTimer[this.mGpsSignalQualityBin].stopRunningLocked(elapsedRealtime);
            }
            if (!this.mGpsSignalQualityTimer[signalLevel].isRunningLocked()) {
                this.mGpsSignalQualityTimer[signalLevel].startRunningLocked(elapsedRealtime);
            }
            this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFF7F | signalLevel << 7;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mGpsSignalQualityBin = signalLevel;
        }
    }

    @GuardedBy(value={"this"})
    public void noteScreenStateLocked(int state) {
        int n = state = this.mPretendScreenOff ? 1 : state;
        if (state > 4) {
            switch (state) {
                case 5: {
                    state = 2;
                    break;
                }
                default: {
                    Slog.wtf(TAG, "Unknown screen state (not mapped): " + state);
                }
            }
        }
        if (this.mScreenState != state) {
            this.recordDailyStatsIfNeededLocked(true);
            int oldState = this.mScreenState;
            this.mScreenState = state;
            if (state != 0) {
                int stepState = state - 1;
                if ((stepState & 3) == stepState) {
                    this.mModStepMode |= this.mCurStepMode & 3 ^ stepState;
                    this.mCurStepMode = this.mCurStepMode & 0xFFFFFFFC | stepState;
                } else {
                    Slog.wtf(TAG, "Unexpected screen state: " + state);
                }
            }
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            boolean updateHistory = false;
            if (this.isScreenDoze(state) && !this.isScreenDoze(oldState)) {
                this.mHistoryCur.states |= 0x40000;
                this.mScreenDozeTimer.startRunningLocked(elapsedRealtime);
                updateHistory = true;
            } else if (this.isScreenDoze(oldState) && !this.isScreenDoze(state)) {
                this.mHistoryCur.states &= 0xFFFBFFFF;
                this.mScreenDozeTimer.stopRunningLocked(elapsedRealtime);
                updateHistory = true;
            }
            if (this.isScreenOn(state)) {
                this.mHistoryCur.states |= 0x100000;
                this.mScreenOnTimer.startRunningLocked(elapsedRealtime);
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].startRunningLocked(elapsedRealtime);
                }
                updateHistory = true;
            } else if (this.isScreenOn(oldState)) {
                this.mHistoryCur.states &= 0xFFEFFFFF;
                this.mScreenOnTimer.stopRunningLocked(elapsedRealtime);
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(elapsedRealtime);
                }
                updateHistory = true;
            }
            if (updateHistory) {
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            }
            this.mExternalSync.scheduleCpuSyncDueToScreenStateChange(this.mOnBatteryTimeBase.isRunning(), this.mOnBatteryScreenOffTimeBase.isRunning());
            if (this.isScreenOn(state)) {
                this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), state, this.mClocks.uptimeMillis() * 1000L, elapsedRealtime * 1000L);
                this.noteStartWakeLocked(-1, -1, null, "screen", null, 0, false, elapsedRealtime, uptime);
            } else if (this.isScreenOn(oldState)) {
                this.noteStopWakeLocked(-1, -1, null, "screen", "screen", 0, elapsedRealtime, uptime);
                this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), state, this.mClocks.uptimeMillis() * 1000L, elapsedRealtime * 1000L);
            }
            if (this.mOnBatteryInternal) {
                this.updateDischargeScreenLevelsLocked(oldState, state);
            }
        }
    }

    @UnsupportedAppUsage
    public void noteScreenBrightnessLocked(int brightness) {
        int bin = brightness / 51;
        if (bin < 0) {
            bin = 0;
        } else if (bin >= 5) {
            bin = 4;
        }
        if (this.mScreenBrightnessBin != bin) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFFF8 | bin << 0;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            if (this.mScreenState == 2) {
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(elapsedRealtime);
                }
                this.mScreenBrightnessTimer[bin].startRunningLocked(elapsedRealtime);
            }
            this.mScreenBrightnessBin = bin;
        }
    }

    @UnsupportedAppUsage
    public void noteUserActivityLocked(int uid, int event) {
        if (this.mOnBatteryInternal) {
            uid = this.mapUid(uid);
            this.getUidStatsLocked(uid).noteUserActivityLocked(event);
        }
    }

    public void noteWakeUpLocked(String reason, int reasonUid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 18, reason, reasonUid);
    }

    public void noteInteractiveLocked(boolean interactive) {
        if (this.mInteractive != interactive) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            this.mInteractive = interactive;
            if (interactive) {
                this.mInteractiveTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mInteractiveTimer.stopRunningLocked(elapsedRealtime);
            }
        }
    }

    public void noteConnectivityChangedLocked(int type, String extra) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 9, extra, type);
        ++this.mNumConnectivityChange;
    }

    private void noteMobileRadioApWakeupLocked(long elapsedRealtimeMillis, long uptimeMillis, int uid) {
        uid = this.mapUid(uid);
        this.addHistoryEventLocked(elapsedRealtimeMillis, uptimeMillis, 19, "", uid);
        this.getUidStatsLocked(uid).noteMobileRadioApWakeupLocked();
    }

    public boolean noteMobileRadioPowerStateLocked(int powerState, long timestampNs, int uid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mMobileRadioPowerState != powerState) {
            long realElapsedRealtimeMs;
            boolean active;
            boolean bl = active = powerState == 2 || powerState == 3;
            if (active) {
                if (uid > 0) {
                    this.noteMobileRadioApWakeupLocked(elapsedRealtime, uptime, uid);
                }
                this.mMobileRadioActiveStartTime = realElapsedRealtimeMs = timestampNs / 1000000L;
                this.mHistoryCur.states |= 0x2000000;
            } else {
                realElapsedRealtimeMs = timestampNs / 1000000L;
                long lastUpdateTimeMs = this.mMobileRadioActiveStartTime;
                if (realElapsedRealtimeMs < lastUpdateTimeMs) {
                    Slog.wtf(TAG, "Data connection inactive timestamp " + realElapsedRealtimeMs + " is before start time " + lastUpdateTimeMs);
                    realElapsedRealtimeMs = elapsedRealtime;
                } else if (realElapsedRealtimeMs < elapsedRealtime) {
                    this.mMobileRadioActiveAdjustedTime.addCountLocked(elapsedRealtime - realElapsedRealtimeMs);
                }
                this.mHistoryCur.states &= 0xFDFFFFFF;
            }
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mMobileRadioPowerState = powerState;
            if (active) {
                this.mMobileRadioActiveTimer.startRunningLocked(elapsedRealtime);
                this.mMobileRadioActivePerAppTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mMobileRadioActiveTimer.stopRunningLocked(realElapsedRealtimeMs);
                this.mMobileRadioActivePerAppTimer.stopRunningLocked(realElapsedRealtimeMs);
                return true;
            }
        }
        return false;
    }

    public void notePowerSaveModeLocked(boolean enabled) {
        if (this.mPowerSaveModeEnabled != enabled) {
            int stepState = enabled ? 4 : 0;
            this.mModStepMode |= this.mCurStepMode & 4 ^ stepState;
            this.mCurStepMode = this.mCurStepMode & 0xFFFFFFFB | stepState;
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mPowerSaveModeEnabled = enabled;
            if (enabled) {
                this.mHistoryCur.states2 |= Integer.MIN_VALUE;
                this.mPowerSaveModeEnabledTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mHistoryCur.states2 &= Integer.MAX_VALUE;
                this.mPowerSaveModeEnabledTimer.stopRunningLocked(elapsedRealtime);
            }
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            FrameworkStatsLog.write(20, enabled ? 1 : 0);
        }
    }

    public void noteDeviceIdleModeLocked(int mode, String activeReason, int activeUid) {
        boolean nowLightIdling;
        boolean nowIdling;
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        boolean bl = nowIdling = mode == 2;
        if (this.mDeviceIdling && !nowIdling && activeReason == null) {
            nowIdling = true;
        }
        boolean bl2 = nowLightIdling = mode == 1;
        if (this.mDeviceLightIdling && !nowLightIdling && !nowIdling && activeReason == null) {
            nowLightIdling = true;
        }
        if (activeReason != null && (this.mDeviceIdling || this.mDeviceLightIdling)) {
            this.addHistoryEventLocked(elapsedRealtime, uptime, 10, activeReason, activeUid);
        }
        if (this.mDeviceIdling != nowIdling || this.mDeviceLightIdling != nowLightIdling) {
            int statsmode = nowIdling ? 2 : (nowLightIdling ? 1 : 0);
            FrameworkStatsLog.write(22, statsmode);
        }
        if (this.mDeviceIdling != nowIdling) {
            this.mDeviceIdling = nowIdling;
            int stepState = nowIdling ? 8 : 0;
            this.mModStepMode |= this.mCurStepMode & 8 ^ stepState;
            this.mCurStepMode = this.mCurStepMode & 0xFFFFFFF7 | stepState;
            if (nowIdling) {
                this.mDeviceIdlingTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mDeviceIdlingTimer.stopRunningLocked(elapsedRealtime);
            }
        }
        if (this.mDeviceLightIdling != nowLightIdling) {
            this.mDeviceLightIdling = nowLightIdling;
            if (nowLightIdling) {
                this.mDeviceLightIdlingTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mDeviceLightIdlingTimer.stopRunningLocked(elapsedRealtime);
            }
        }
        if (this.mDeviceIdleMode != mode) {
            this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xF9FFFFFF | mode << 25;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            long lastDuration = elapsedRealtime - this.mLastIdleTimeStart;
            this.mLastIdleTimeStart = elapsedRealtime;
            if (this.mDeviceIdleMode == 1) {
                if (lastDuration > this.mLongestLightIdleTime) {
                    this.mLongestLightIdleTime = lastDuration;
                }
                this.mDeviceIdleModeLightTimer.stopRunningLocked(elapsedRealtime);
            } else if (this.mDeviceIdleMode == 2) {
                if (lastDuration > this.mLongestFullIdleTime) {
                    this.mLongestFullIdleTime = lastDuration;
                }
                this.mDeviceIdleModeFullTimer.stopRunningLocked(elapsedRealtime);
            }
            if (mode == 1) {
                this.mDeviceIdleModeLightTimer.startRunningLocked(elapsedRealtime);
            } else if (mode == 2) {
                this.mDeviceIdleModeFullTimer.startRunningLocked(elapsedRealtime);
            }
            this.mDeviceIdleMode = mode;
            FrameworkStatsLog.write(21, mode);
        }
    }

    public void notePackageInstalledLocked(String pkgName, long versionCode) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 11, pkgName, (int)versionCode);
        BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
        pc.mPackageName = pkgName;
        pc.mUpdate = true;
        pc.mVersionCode = versionCode;
        this.addPackageChange(pc);
    }

    public void notePackageUninstalledLocked(String pkgName) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 12, pkgName, 0);
        BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
        pc.mPackageName = pkgName;
        pc.mUpdate = true;
        this.addPackageChange(pc);
    }

    private void addPackageChange(BatteryStats.PackageChange pc) {
        if (this.mDailyPackageChanges == null) {
            this.mDailyPackageChanges = new ArrayList();
        }
        this.mDailyPackageChanges.add(pc);
    }

    void stopAllGpsSignalQualityTimersLocked(int except) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        for (int i = 0; i < 2; ++i) {
            if (i == except) continue;
            while (this.mGpsSignalQualityTimer[i].isRunningLocked()) {
                this.mGpsSignalQualityTimer[i].stopRunningLocked(elapsedRealtime);
            }
        }
    }

    @UnsupportedAppUsage
    public void notePhoneOnLocked() {
        if (!this.mPhoneOn) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 |= 0x800000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mPhoneOn = true;
            this.mPhoneOnTimer.startRunningLocked(elapsedRealtime);
        }
    }

    @UnsupportedAppUsage
    public void notePhoneOffLocked() {
        if (this.mPhoneOn) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 &= 0xFF7FFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mPhoneOn = false;
            this.mPhoneOnTimer.stopRunningLocked(elapsedRealtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerUsbStateReceiver(Context context) {
        IntentFilter usbStateFilter = new IntentFilter();
        usbStateFilter.addAction("android.hardware.usb.action.USB_STATE");
        context.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                boolean state = intent.getBooleanExtra("connected", false);
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                synchronized (batteryStatsImpl) {
                    BatteryStatsImpl.this.noteUsbConnectionStateLocked(state);
                }
            }
        }, usbStateFilter);
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            if (this.mUsbDataState == 0) {
                Intent usbState = context.registerReceiver(null, usbStateFilter);
                boolean initState = usbState != null && usbState.getBooleanExtra("connected", false);
                this.noteUsbConnectionStateLocked(initState);
            }
        }
    }

    private void noteUsbConnectionStateLocked(boolean connected) {
        int newState;
        int n = newState = connected ? 2 : 1;
        if (this.mUsbDataState != newState) {
            this.mUsbDataState = newState;
            this.mHistoryCur.states2 = connected ? (this.mHistoryCur.states2 |= 0x40000) : (this.mHistoryCur.states2 &= 0xFFFBFFFF);
            this.addHistoryRecordLocked(this.mClocks.elapsedRealtime(), this.mClocks.uptimeMillis());
        }
    }

    void stopAllPhoneSignalStrengthTimersLocked(int except) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        for (int i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            if (i == except) continue;
            while (this.mPhoneSignalStrengthsTimer[i].isRunningLocked()) {
                this.mPhoneSignalStrengthsTimer[i].stopRunningLocked(elapsedRealtime);
            }
        }
    }

    private int fixPhoneServiceState(int state, int signalBin) {
        if (this.mPhoneSimStateRaw == 1 && state == 1 && signalBin > 0) {
            state = 0;
        }
        return state;
    }

    private void updateAllPhoneStateLocked(int state, int simState, int strengthBin) {
        boolean scanning = false;
        boolean newHistory = false;
        this.mPhoneServiceStateRaw = state;
        this.mPhoneSimStateRaw = simState;
        this.mPhoneSignalStrengthBinRaw = strengthBin;
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (simState == 1 && state == 1 && strengthBin > 0) {
            state = 0;
        }
        if (state == 3) {
            strengthBin = -1;
        } else if (state != 0 && state == 1) {
            scanning = true;
            strengthBin = 0;
            if (!this.mPhoneSignalScanningTimer.isRunningLocked()) {
                this.mHistoryCur.states |= 0x200000;
                newHistory = true;
                this.mPhoneSignalScanningTimer.startRunningLocked(elapsedRealtime);
                FrameworkStatsLog.write(94, state, simState, strengthBin);
            }
        }
        if (!scanning && this.mPhoneSignalScanningTimer.isRunningLocked()) {
            this.mHistoryCur.states &= 0xFFDFFFFF;
            newHistory = true;
            this.mPhoneSignalScanningTimer.stopRunningLocked(elapsedRealtime);
            FrameworkStatsLog.write(94, state, simState, strengthBin);
        }
        if (this.mPhoneServiceState != state) {
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFE3F | state << 6;
            newHistory = true;
            this.mPhoneServiceState = state;
        }
        if (this.mPhoneSignalStrengthBin != strengthBin) {
            if (this.mPhoneSignalStrengthBin >= 0) {
                this.mPhoneSignalStrengthsTimer[this.mPhoneSignalStrengthBin].stopRunningLocked(elapsedRealtime);
            }
            if (strengthBin >= 0) {
                if (!this.mPhoneSignalStrengthsTimer[strengthBin].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[strengthBin].startRunningLocked(elapsedRealtime);
                }
                this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFFC7 | strengthBin << 3;
                newHistory = true;
                FrameworkStatsLog.write(40, strengthBin);
            } else {
                this.stopAllPhoneSignalStrengthTimersLocked(-1);
            }
            this.mPhoneSignalStrengthBin = strengthBin;
        }
        if (newHistory) {
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    public void notePhoneStateLocked(int state, int simState) {
        this.updateAllPhoneStateLocked(state, simState, this.mPhoneSignalStrengthBinRaw);
    }

    @UnsupportedAppUsage
    public void notePhoneSignalStrengthLocked(SignalStrength signalStrength) {
        int bin = signalStrength.getLevel();
        this.updateAllPhoneStateLocked(this.mPhoneServiceStateRaw, this.mPhoneSimStateRaw, bin);
    }

    @UnsupportedAppUsage
    public void notePhoneDataConnectionStateLocked(int dataType, boolean hasData, int serviceType) {
        int bin = 0;
        if (hasData) {
            if (dataType > 0 && dataType <= TelephonyManager.getAllNetworkTypes().length) {
                bin = dataType;
            } else {
                switch (serviceType) {
                    case 1: {
                        bin = 0;
                        break;
                    }
                    case 2: {
                        bin = DATA_CONNECTION_EMERGENCY_SERVICE;
                        break;
                    }
                    default: {
                        bin = DATA_CONNECTION_OTHER;
                    }
                }
            }
        }
        if (this.mPhoneDataConnectionType != bin) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFC1FF | bin << 9;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            if (this.mPhoneDataConnectionType >= 0) {
                this.mPhoneDataConnectionsTimer[this.mPhoneDataConnectionType].stopRunningLocked(elapsedRealtime);
            }
            this.mPhoneDataConnectionType = bin;
            this.mPhoneDataConnectionsTimer[bin].startRunningLocked(elapsedRealtime);
        }
    }

    public void noteWifiOnLocked() {
        if (!this.mWifiOn) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 |= 0x10000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mWifiOn = true;
            this.mWifiOnTimer.startRunningLocked(elapsedRealtime);
            this.scheduleSyncExternalStatsLocked("wifi-off", 2);
        }
    }

    public void noteWifiOffLocked() {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiOn) {
            this.mHistoryCur.states2 &= 0xEFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mWifiOn = false;
            this.mWifiOnTimer.stopRunningLocked(elapsedRealtime);
            this.scheduleSyncExternalStatsLocked("wifi-on", 2);
        }
    }

    @UnsupportedAppUsage
    public void noteAudioOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mAudioOnNesting == 0) {
            this.mHistoryCur.states |= 0x400000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mAudioOnTimer.startRunningLocked(elapsedRealtime);
        }
        ++this.mAudioOnNesting;
        this.getUidStatsLocked(uid).noteAudioTurnedOnLocked(elapsedRealtime);
    }

    @UnsupportedAppUsage
    public void noteAudioOffLocked(int uid) {
        if (this.mAudioOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (--this.mAudioOnNesting == 0) {
            this.mHistoryCur.states &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mAudioOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteAudioTurnedOffLocked(elapsedRealtime);
    }

    @UnsupportedAppUsage
    public void noteVideoOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mVideoOnNesting == 0) {
            this.mHistoryCur.states2 |= 0x40000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mVideoOnTimer.startRunningLocked(elapsedRealtime);
        }
        ++this.mVideoOnNesting;
        this.getUidStatsLocked(uid).noteVideoTurnedOnLocked(elapsedRealtime);
    }

    @UnsupportedAppUsage
    public void noteVideoOffLocked(int uid) {
        if (this.mVideoOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (--this.mVideoOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xBFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mVideoOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteVideoTurnedOffLocked(elapsedRealtime);
    }

    public void noteResetAudioLocked() {
        if (this.mAudioOnNesting > 0) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mAudioOnNesting = 0;
            this.mHistoryCur.states &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mAudioOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetAudioLocked(elapsedRealtime);
            }
        }
    }

    public void noteResetVideoLocked() {
        if (this.mVideoOnNesting > 0) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mAudioOnNesting = 0;
            this.mHistoryCur.states2 &= 0xBFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mVideoOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetVideoLocked(elapsedRealtime);
            }
        }
    }

    public void noteActivityResumedLocked(int uid) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteActivityResumedLocked(this.mClocks.elapsedRealtime());
    }

    public void noteActivityPausedLocked(int uid) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteActivityPausedLocked(this.mClocks.elapsedRealtime());
    }

    public void noteVibratorOnLocked(int uid, long durationMillis) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteVibratorOnLocked(durationMillis);
    }

    public void noteVibratorOffLocked(int uid) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteVibratorOffLocked();
    }

    public void noteFlashlightOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mFlashlightOnNesting++ == 0) {
            this.mHistoryCur.states2 |= 0x8000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mFlashlightOnTimer.startRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteFlashlightTurnedOnLocked(elapsedRealtime);
    }

    public void noteFlashlightOffLocked(int uid) {
        if (this.mFlashlightOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (--this.mFlashlightOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mFlashlightOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteFlashlightTurnedOffLocked(elapsedRealtime);
    }

    public void noteCameraOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mCameraOnNesting++ == 0) {
            this.mHistoryCur.states2 |= 0x200000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mCameraOnTimer.startRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteCameraTurnedOnLocked(elapsedRealtime);
    }

    public void noteCameraOffLocked(int uid) {
        if (this.mCameraOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (--this.mCameraOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xFFDFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mCameraOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteCameraTurnedOffLocked(elapsedRealtime);
    }

    public void noteResetCameraLocked() {
        if (this.mCameraOnNesting > 0) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mCameraOnNesting = 0;
            this.mHistoryCur.states2 &= 0xFFDFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mCameraOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetCameraLocked(elapsedRealtime);
            }
        }
    }

    public void noteResetFlashlightLocked() {
        if (this.mFlashlightOnNesting > 0) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mFlashlightOnNesting = 0;
            this.mHistoryCur.states2 &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mFlashlightOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetFlashlightLocked(elapsedRealtime);
            }
        }
    }

    private void noteBluetoothScanStartedLocked(WorkSource.WorkChain workChain, int uid, boolean isUnoptimized) {
        uid = this.getAttributionUid(uid, workChain);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mBluetoothScanNesting == 0) {
            this.mHistoryCur.states2 |= 0x100000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mBluetoothScanTimer.startRunningLocked(elapsedRealtime);
        }
        ++this.mBluetoothScanNesting;
        this.getUidStatsLocked(uid).noteBluetoothScanStartedLocked(elapsedRealtime, isUnoptimized);
    }

    public void noteBluetoothScanStartedFromSourceLocked(WorkSource ws, boolean isUnoptimized) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteBluetoothScanStartedLocked(null, ws.getUid(i), isUnoptimized);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                this.noteBluetoothScanStartedLocked(workChains.get(i), -1, isUnoptimized);
            }
        }
    }

    private void noteBluetoothScanStoppedLocked(WorkSource.WorkChain workChain, int uid, boolean isUnoptimized) {
        uid = this.getAttributionUid(uid, workChain);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mBluetoothScanNesting;
        if (this.mBluetoothScanNesting == 0) {
            this.mHistoryCur.states2 &= 0xFFEFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mBluetoothScanTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteBluetoothScanStoppedLocked(elapsedRealtime, isUnoptimized);
    }

    private int getAttributionUid(int uid, WorkSource.WorkChain workChain) {
        if (workChain != null) {
            return this.mapUid(workChain.getAttributionUid());
        }
        return this.mapUid(uid);
    }

    public void noteBluetoothScanStoppedFromSourceLocked(WorkSource ws, boolean isUnoptimized) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteBluetoothScanStoppedLocked(null, ws.getUid(i), isUnoptimized);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                this.noteBluetoothScanStoppedLocked(workChains.get(i), -1, isUnoptimized);
            }
        }
    }

    public void noteResetBluetoothScanLocked() {
        if (this.mBluetoothScanNesting > 0) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mBluetoothScanNesting = 0;
            this.mHistoryCur.states2 &= 0xFFEFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mBluetoothScanTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetBluetoothScanLocked(elapsedRealtime);
            }
        }
    }

    public void noteBluetoothScanResultsFromSourceLocked(WorkSource ws, int numNewResults) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.getUidStatsLocked(uid).noteBluetoothScanResultsLocked(numNewResults);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain wc = workChains.get(i);
                int uid = this.mapUid(wc.getAttributionUid());
                this.getUidStatsLocked(uid).noteBluetoothScanResultsLocked(numNewResults);
            }
        }
    }

    private void noteWifiRadioApWakeupLocked(long elapsedRealtimeMillis, long uptimeMillis, int uid) {
        uid = this.mapUid(uid);
        this.addHistoryEventLocked(elapsedRealtimeMillis, uptimeMillis, 19, "", uid);
        this.getUidStatsLocked(uid).noteWifiRadioApWakeupLocked();
    }

    public void noteWifiRadioPowerState(int powerState, long timestampNs, int uid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiRadioPowerState != powerState) {
            boolean active;
            boolean bl = active = powerState == 2 || powerState == 3;
            if (active) {
                if (uid > 0) {
                    this.noteWifiRadioApWakeupLocked(elapsedRealtime, uptime, uid);
                }
                this.mHistoryCur.states |= 0x4000000;
                this.mWifiActiveTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mHistoryCur.states &= 0xFBFFFFFF;
                this.mWifiActiveTimer.stopRunningLocked(timestampNs / 1000000L);
            }
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mWifiRadioPowerState = powerState;
        }
    }

    public void noteWifiRunningLocked(WorkSource ws) {
        if (!this.mGlobalWifiRunning) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 |= 0x20000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mGlobalWifiRunning = true;
            this.mGlobalWifiRunningTimer.startRunningLocked(elapsedRealtime);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                int uid = this.mapUid(ws.getUid(i));
                this.getUidStatsLocked(uid).noteWifiRunningLocked(elapsedRealtime);
            }
            List<WorkSource.WorkChain> workChains = ws.getWorkChains();
            if (workChains != null) {
                for (int i = 0; i < workChains.size(); ++i) {
                    int uid = this.mapUid(workChains.get(i).getAttributionUid());
                    this.getUidStatsLocked(uid).noteWifiRunningLocked(elapsedRealtime);
                }
            }
            this.scheduleSyncExternalStatsLocked("wifi-running", 2);
        } else {
            Log.w(TAG, "noteWifiRunningLocked -- called while WIFI running");
        }
    }

    public void noteWifiRunningChangedLocked(WorkSource oldWs, WorkSource newWs) {
        if (this.mGlobalWifiRunning) {
            int uid;
            int i;
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            int N = oldWs.size();
            for (int i2 = 0; i2 < N; ++i2) {
                int uid2 = this.mapUid(oldWs.getUid(i2));
                this.getUidStatsLocked(uid2).noteWifiStoppedLocked(elapsedRealtime);
            }
            List<WorkSource.WorkChain> workChains = oldWs.getWorkChains();
            if (workChains != null) {
                for (i = 0; i < workChains.size(); ++i) {
                    uid = this.mapUid(workChains.get(i).getAttributionUid());
                    this.getUidStatsLocked(uid).noteWifiStoppedLocked(elapsedRealtime);
                }
            }
            N = newWs.size();
            for (i = 0; i < N; ++i) {
                uid = this.mapUid(newWs.getUid(i));
                this.getUidStatsLocked(uid).noteWifiRunningLocked(elapsedRealtime);
            }
            workChains = newWs.getWorkChains();
            if (workChains != null) {
                for (i = 0; i < workChains.size(); ++i) {
                    uid = this.mapUid(workChains.get(i).getAttributionUid());
                    this.getUidStatsLocked(uid).noteWifiRunningLocked(elapsedRealtime);
                }
            }
        } else {
            Log.w(TAG, "noteWifiRunningChangedLocked -- called while WIFI not running");
        }
    }

    public void noteWifiStoppedLocked(WorkSource ws) {
        if (this.mGlobalWifiRunning) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 &= 0xDFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mGlobalWifiRunning = false;
            this.mGlobalWifiRunningTimer.stopRunningLocked(elapsedRealtime);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                int uid = this.mapUid(ws.getUid(i));
                this.getUidStatsLocked(uid).noteWifiStoppedLocked(elapsedRealtime);
            }
            List<WorkSource.WorkChain> workChains = ws.getWorkChains();
            if (workChains != null) {
                for (int i = 0; i < workChains.size(); ++i) {
                    int uid = this.mapUid(workChains.get(i).getAttributionUid());
                    this.getUidStatsLocked(uid).noteWifiStoppedLocked(elapsedRealtime);
                }
            }
            this.scheduleSyncExternalStatsLocked("wifi-stopped", 2);
        } else {
            Log.w(TAG, "noteWifiStoppedLocked -- called while WIFI not running");
        }
    }

    public void noteWifiStateLocked(int wifiState, String accessPoint) {
        if (this.mWifiState != wifiState) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            if (this.mWifiState >= 0) {
                this.mWifiStateTimer[this.mWifiState].stopRunningLocked(elapsedRealtime);
            }
            this.mWifiState = wifiState;
            this.mWifiStateTimer[wifiState].startRunningLocked(elapsedRealtime);
            this.scheduleSyncExternalStatsLocked("wifi-state", 2);
        }
    }

    public void noteWifiSupplicantStateChangedLocked(int supplState, boolean failedAuth) {
        if (this.mWifiSupplState != supplState) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            if (this.mWifiSupplState >= 0) {
                this.mWifiSupplStateTimer[this.mWifiSupplState].stopRunningLocked(elapsedRealtime);
            }
            this.mWifiSupplState = supplState;
            this.mWifiSupplStateTimer[supplState].startRunningLocked(elapsedRealtime);
            this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFFF0 | supplState << 0;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    void stopAllWifiSignalStrengthTimersLocked(int except) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        for (int i = 0; i < 5; ++i) {
            if (i == except) continue;
            while (this.mWifiSignalStrengthsTimer[i].isRunningLocked()) {
                this.mWifiSignalStrengthsTimer[i].stopRunningLocked(elapsedRealtime);
            }
        }
    }

    public void noteWifiRssiChangedLocked(int newRssi) {
        int strengthBin = WifiManager.calculateSignalLevel(newRssi, 5);
        if (this.mWifiSignalStrengthBin != strengthBin) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            if (this.mWifiSignalStrengthBin >= 0) {
                this.mWifiSignalStrengthsTimer[this.mWifiSignalStrengthBin].stopRunningLocked(elapsedRealtime);
            }
            if (strengthBin >= 0) {
                if (!this.mWifiSignalStrengthsTimer[strengthBin].isRunningLocked()) {
                    this.mWifiSignalStrengthsTimer[strengthBin].startRunningLocked(elapsedRealtime);
                }
                this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFF8F | strengthBin << 4;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            } else {
                this.stopAllWifiSignalStrengthTimersLocked(-1);
            }
            this.mWifiSignalStrengthBin = strengthBin;
        }
    }

    @UnsupportedAppUsage
    public void noteFullWifiLockAcquiredLocked(int uid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states |= 0x10000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mWifiFullLockNesting;
        this.getUidStatsLocked(uid).noteFullWifiLockAcquiredLocked(elapsedRealtime);
    }

    @UnsupportedAppUsage
    public void noteFullWifiLockReleasedLocked(int uid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mWifiFullLockNesting;
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states &= 0xEFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteFullWifiLockReleasedLocked(elapsedRealtime);
    }

    public void noteWifiScanStartedLocked(int uid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states |= 0x8000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mWifiScanNesting;
        this.getUidStatsLocked(uid).noteWifiScanStartedLocked(elapsedRealtime);
    }

    public void noteWifiScanStoppedLocked(int uid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mWifiScanNesting;
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteWifiScanStoppedLocked(elapsedRealtime);
    }

    public void noteWifiBatchedScanStartedLocked(int uid, int csph) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        this.getUidStatsLocked(uid).noteWifiBatchedScanStartedLocked(csph, elapsedRealtime);
    }

    public void noteWifiBatchedScanStoppedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        this.getUidStatsLocked(uid).noteWifiBatchedScanStoppedLocked(elapsedRealtime);
    }

    @UnsupportedAppUsage
    public void noteWifiMulticastEnabledLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states |= 0x10000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            if (!this.mWifiMulticastWakelockTimer.isRunningLocked()) {
                this.mWifiMulticastWakelockTimer.startRunningLocked(elapsedRealtime);
            }
        }
        ++this.mWifiMulticastNesting;
        this.getUidStatsLocked(uid).noteWifiMulticastEnabledLocked(elapsedRealtime);
    }

    @UnsupportedAppUsage
    public void noteWifiMulticastDisabledLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mWifiMulticastNesting;
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states &= 0xFFFEFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            if (this.mWifiMulticastWakelockTimer.isRunningLocked()) {
                this.mWifiMulticastWakelockTimer.stopRunningLocked(elapsedRealtime);
            }
        }
        this.getUidStatsLocked(uid).noteWifiMulticastDisabledLocked(elapsedRealtime);
    }

    public void noteFullWifiLockAcquiredFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.noteFullWifiLockAcquiredLocked(uid);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = this.mapUid(workChain.getAttributionUid());
                this.noteFullWifiLockAcquiredLocked(uid);
            }
        }
    }

    public void noteFullWifiLockReleasedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.noteFullWifiLockReleasedLocked(uid);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = this.mapUid(workChain.getAttributionUid());
                this.noteFullWifiLockReleasedLocked(uid);
            }
        }
    }

    public void noteWifiScanStartedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.noteWifiScanStartedLocked(uid);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = this.mapUid(workChain.getAttributionUid());
                this.noteWifiScanStartedLocked(uid);
            }
        }
    }

    public void noteWifiScanStoppedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            int uid = this.mapUid(ws.getUid(i));
            this.noteWifiScanStoppedLocked(uid);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain workChain = workChains.get(i);
                int uid = this.mapUid(workChain.getAttributionUid());
                this.noteWifiScanStoppedLocked(uid);
            }
        }
    }

    public void noteWifiBatchedScanStartedFromSourceLocked(WorkSource ws, int csph) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStartedLocked(ws.getUid(i), csph);
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                this.noteWifiBatchedScanStartedLocked(workChains.get(i).getAttributionUid(), csph);
            }
        }
    }

    public void noteWifiBatchedScanStoppedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStoppedLocked(ws.getUid(i));
        }
        List<WorkSource.WorkChain> workChains = ws.getWorkChains();
        if (workChains != null) {
            for (int i = 0; i < workChains.size(); ++i) {
                this.noteWifiBatchedScanStoppedLocked(workChains.get(i).getAttributionUid());
            }
        }
    }

    private static String[] includeInStringArray(String[] array2, String str) {
        if (ArrayUtils.indexOf(array2, str) >= 0) {
            return array2;
        }
        String[] newArray = new String[array2.length + 1];
        System.arraycopy(array2, 0, newArray, 0, array2.length);
        newArray[array2.length] = str;
        return newArray;
    }

    private static String[] excludeFromStringArray(String[] array2, String str) {
        int index = ArrayUtils.indexOf(array2, str);
        if (index >= 0) {
            String[] newArray = new String[array2.length - 1];
            if (index > 0) {
                System.arraycopy(array2, 0, newArray, 0, index);
            }
            if (index < array2.length - 1) {
                System.arraycopy(array2, index + 1, newArray, index, array2.length - index - 1);
            }
            return newArray;
        }
        return array2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteNetworkInterfaceType(String iface, int networkType) {
        if (TextUtils.isEmpty(iface)) {
            return;
        }
        Object object = this.mModemNetworkLock;
        synchronized (object) {
            this.mModemIfaces = ConnectivityManager.isNetworkTypeMobile(networkType) ? BatteryStatsImpl.includeInStringArray(this.mModemIfaces, iface) : BatteryStatsImpl.excludeFromStringArray(this.mModemIfaces, iface);
        }
        object = this.mWifiNetworkLock;
        synchronized (object) {
            this.mWifiIfaces = ConnectivityManager.isNetworkTypeWifi(networkType) ? BatteryStatsImpl.includeInStringArray(this.mWifiIfaces, iface) : BatteryStatsImpl.excludeFromStringArray(this.mWifiIfaces, iface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getWifiIfaces() {
        Object object = this.mWifiNetworkLock;
        synchronized (object) {
            return this.mWifiIfaces;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMobileIfaces() {
        Object object = this.mModemNetworkLock;
        synchronized (object) {
            return this.mModemIfaces;
        }
    }

    @Override
    @UnsupportedAppUsage
    public long getScreenOnTime(long elapsedRealtimeUs, int which) {
        return this.mScreenOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getScreenOnCount(int which) {
        return this.mScreenOnTimer.getCountLocked(which);
    }

    @Override
    public long getScreenDozeTime(long elapsedRealtimeUs, int which) {
        return this.mScreenDozeTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getScreenDozeCount(int which) {
        return this.mScreenDozeTimer.getCountLocked(which);
    }

    @Override
    @UnsupportedAppUsage
    public long getScreenBrightnessTime(int brightnessBin, long elapsedRealtimeUs, int which) {
        return this.mScreenBrightnessTimer[brightnessBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public Timer getScreenBrightnessTimer(int brightnessBin) {
        return this.mScreenBrightnessTimer[brightnessBin];
    }

    @Override
    public long getInteractiveTime(long elapsedRealtimeUs, int which) {
        return this.mInteractiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getPowerSaveModeEnabledTime(long elapsedRealtimeUs, int which) {
        return this.mPowerSaveModeEnabledTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getPowerSaveModeEnabledCount(int which) {
        return this.mPowerSaveModeEnabledTimer.getCountLocked(which);
    }

    @Override
    public long getDeviceIdleModeTime(int mode, long elapsedRealtimeUs, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceIdleModeLightTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
            case 2: {
                return this.mDeviceIdleModeFullTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
        }
        return 0L;
    }

    @Override
    public int getDeviceIdleModeCount(int mode, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceIdleModeLightTimer.getCountLocked(which);
            }
            case 2: {
                return this.mDeviceIdleModeFullTimer.getCountLocked(which);
            }
        }
        return 0;
    }

    @Override
    public long getLongestDeviceIdleModeTime(int mode) {
        switch (mode) {
            case 1: {
                return this.mLongestLightIdleTime;
            }
            case 2: {
                return this.mLongestFullIdleTime;
            }
        }
        return 0L;
    }

    @Override
    public long getDeviceIdlingTime(int mode, long elapsedRealtimeUs, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceLightIdlingTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
            case 2: {
                return this.mDeviceIdlingTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
        }
        return 0L;
    }

    @Override
    public int getDeviceIdlingCount(int mode, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceLightIdlingTimer.getCountLocked(which);
            }
            case 2: {
                return this.mDeviceIdlingTimer.getCountLocked(which);
            }
        }
        return 0;
    }

    @Override
    public int getNumConnectivityChange(int which) {
        return this.mNumConnectivityChange;
    }

    @Override
    public long getGpsSignalQualityTime(int strengthBin, long elapsedRealtimeUs, int which) {
        if (strengthBin < 0 || strengthBin >= 2) {
            return 0L;
        }
        return this.mGpsSignalQualityTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getGpsBatteryDrainMaMs() {
        double opVolt = this.mPowerProfile.getAveragePower("gps.voltage") / 1000.0;
        if (opVolt == 0.0) {
            return 0L;
        }
        double energyUsedMaMs = 0.0;
        boolean which = false;
        long rawRealtime = SystemClock.elapsedRealtime() * 1000L;
        for (int i = 0; i < 2; ++i) {
            energyUsedMaMs += this.mPowerProfile.getAveragePower("gps.signalqualitybased", i) * (double)(this.getGpsSignalQualityTime(i, rawRealtime, 0) / 1000L);
        }
        return (long)energyUsedMaMs;
    }

    @Override
    @UnsupportedAppUsage
    public long getPhoneOnTime(long elapsedRealtimeUs, int which) {
        return this.mPhoneOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getPhoneOnCount(int which) {
        return this.mPhoneOnTimer.getCountLocked(which);
    }

    @Override
    @UnsupportedAppUsage
    public long getPhoneSignalStrengthTime(int strengthBin, long elapsedRealtimeUs, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    @UnsupportedAppUsage
    public long getPhoneSignalScanningTime(long elapsedRealtimeUs, int which) {
        return this.mPhoneSignalScanningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public Timer getPhoneSignalScanningTimer() {
        return this.mPhoneSignalScanningTimer;
    }

    @Override
    @UnsupportedAppUsage
    public int getPhoneSignalStrengthCount(int strengthBin, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getCountLocked(which);
    }

    @Override
    public Timer getPhoneSignalStrengthTimer(int strengthBin) {
        return this.mPhoneSignalStrengthsTimer[strengthBin];
    }

    @Override
    @UnsupportedAppUsage
    public long getPhoneDataConnectionTime(int dataType, long elapsedRealtimeUs, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    @UnsupportedAppUsage
    public int getPhoneDataConnectionCount(int dataType, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getCountLocked(which);
    }

    @Override
    public Timer getPhoneDataConnectionTimer(int dataType) {
        return this.mPhoneDataConnectionsTimer[dataType];
    }

    @Override
    @UnsupportedAppUsage
    public long getMobileRadioActiveTime(long elapsedRealtimeUs, int which) {
        return this.mMobileRadioActiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getMobileRadioActiveCount(int which) {
        return this.mMobileRadioActiveTimer.getCountLocked(which);
    }

    @Override
    public long getMobileRadioActiveAdjustedTime(int which) {
        return this.mMobileRadioActiveAdjustedTime.getCountLocked(which);
    }

    @Override
    public long getMobileRadioActiveUnknownTime(int which) {
        return this.mMobileRadioActiveUnknownTime.getCountLocked(which);
    }

    @Override
    public int getMobileRadioActiveUnknownCount(int which) {
        return (int)this.mMobileRadioActiveUnknownCount.getCountLocked(which);
    }

    @Override
    public long getWifiMulticastWakelockTime(long elapsedRealtimeUs, int which) {
        return this.mWifiMulticastWakelockTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiMulticastWakelockCount(int which) {
        return this.mWifiMulticastWakelockTimer.getCountLocked(which);
    }

    @Override
    @UnsupportedAppUsage
    public long getWifiOnTime(long elapsedRealtimeUs, int which) {
        return this.mWifiOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getWifiActiveTime(long elapsedRealtimeUs, int which) {
        return this.mWifiActiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    @UnsupportedAppUsage
    public long getGlobalWifiRunningTime(long elapsedRealtimeUs, int which) {
        return this.mGlobalWifiRunningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getWifiStateTime(int wifiState, long elapsedRealtimeUs, int which) {
        return this.mWifiStateTimer[wifiState].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiStateCount(int wifiState, int which) {
        return this.mWifiStateTimer[wifiState].getCountLocked(which);
    }

    @Override
    public Timer getWifiStateTimer(int wifiState) {
        return this.mWifiStateTimer[wifiState];
    }

    @Override
    public long getWifiSupplStateTime(int state, long elapsedRealtimeUs, int which) {
        return this.mWifiSupplStateTimer[state].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiSupplStateCount(int state, int which) {
        return this.mWifiSupplStateTimer[state].getCountLocked(which);
    }

    @Override
    public Timer getWifiSupplStateTimer(int state) {
        return this.mWifiSupplStateTimer[state];
    }

    @Override
    public long getWifiSignalStrengthTime(int strengthBin, long elapsedRealtimeUs, int which) {
        return this.mWifiSignalStrengthsTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiSignalStrengthCount(int strengthBin, int which) {
        return this.mWifiSignalStrengthsTimer[strengthBin].getCountLocked(which);
    }

    @Override
    public Timer getWifiSignalStrengthTimer(int strengthBin) {
        return this.mWifiSignalStrengthsTimer[strengthBin];
    }

    @Override
    public BatteryStats.ControllerActivityCounter getBluetoothControllerActivity() {
        return this.mBluetoothActivity;
    }

    @Override
    public BatteryStats.ControllerActivityCounter getWifiControllerActivity() {
        return this.mWifiActivity;
    }

    @Override
    public BatteryStats.ControllerActivityCounter getModemControllerActivity() {
        return this.mModemActivity;
    }

    @Override
    public boolean hasBluetoothActivityReporting() {
        return this.mHasBluetoothReporting;
    }

    @Override
    public boolean hasWifiActivityReporting() {
        return this.mHasWifiReporting;
    }

    @Override
    public boolean hasModemActivityReporting() {
        return this.mHasModemReporting;
    }

    @Override
    public long getFlashlightOnTime(long elapsedRealtimeUs, int which) {
        return this.mFlashlightOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getFlashlightOnCount(int which) {
        return this.mFlashlightOnTimer.getCountLocked(which);
    }

    @Override
    public long getCameraOnTime(long elapsedRealtimeUs, int which) {
        return this.mCameraOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getBluetoothScanTime(long elapsedRealtimeUs, int which) {
        return this.mBluetoothScanTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    @UnsupportedAppUsage
    public long getNetworkActivityBytes(int type, int which) {
        if (type >= 0 && type < this.mNetworkByteActivityCounters.length) {
            return this.mNetworkByteActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    @Override
    public long getNetworkActivityPackets(int type, int which) {
        if (type >= 0 && type < this.mNetworkPacketActivityCounters.length) {
            return this.mNetworkPacketActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    @Override
    public long getStartClockTime() {
        long currentTime = System_Delegate.currentTimeMillis();
        if (currentTime > 31536000000L && this.mStartClockTime < currentTime - 31536000000L || this.mStartClockTime > currentTime) {
            this.recordCurrentTimeChangeLocked(currentTime, this.mClocks.elapsedRealtime(), this.mClocks.uptimeMillis());
            return currentTime - (this.mClocks.elapsedRealtime() - this.mRealtimeStart / 1000L);
        }
        return this.mStartClockTime;
    }

    @Override
    public String getStartPlatformVersion() {
        return this.mStartPlatformVersion;
    }

    @Override
    public String getEndPlatformVersion() {
        return this.mEndPlatformVersion;
    }

    @Override
    public int getParcelVersion() {
        return 186;
    }

    @Override
    public boolean getIsOnBattery() {
        return this.mOnBattery;
    }

    @Override
    @UnsupportedAppUsage
    public SparseArray<? extends BatteryStats.Uid> getUidStats() {
        return this.mUidStats;
    }

    private static <T extends TimeBaseObs> boolean resetIfNotNull(T t, boolean detachIfReset) {
        if (t != null) {
            return t.reset(detachIfReset);
        }
        return true;
    }

    private static <T extends TimeBaseObs> boolean resetIfNotNull(T[] t, boolean detachIfReset) {
        if (t != null) {
            boolean ret = true;
            for (int i = 0; i < t.length; ++i) {
                ret &= BatteryStatsImpl.resetIfNotNull(t[i], detachIfReset);
            }
            return ret;
        }
        return true;
    }

    private static <T extends TimeBaseObs> boolean resetIfNotNull(T[][] t, boolean detachIfReset) {
        if (t != null) {
            boolean ret = true;
            for (int i = 0; i < t.length; ++i) {
                ret &= BatteryStatsImpl.resetIfNotNull(t[i], detachIfReset);
            }
            return ret;
        }
        return true;
    }

    private static boolean resetIfNotNull(ControllerActivityCounterImpl counter, boolean detachIfReset) {
        if (counter != null) {
            counter.reset(detachIfReset);
        }
        return true;
    }

    private static <T extends TimeBaseObs> void detachIfNotNull(T t) {
        if (t != null) {
            t.detach();
        }
    }

    private static <T extends TimeBaseObs> void detachIfNotNull(T[] t) {
        if (t != null) {
            for (int i = 0; i < t.length; ++i) {
                BatteryStatsImpl.detachIfNotNull(t[i]);
            }
        }
    }

    private static <T extends TimeBaseObs> void detachIfNotNull(T[][] t) {
        if (t != null) {
            for (int i = 0; i < t.length; ++i) {
                BatteryStatsImpl.detachIfNotNull(t[i]);
            }
        }
    }

    private static void detachIfNotNull(ControllerActivityCounterImpl counter) {
        if (counter != null) {
            counter.detach();
        }
    }

    @Override
    public long[] getCpuFreqs() {
        return this.mCpuFreqs;
    }

    public BatteryStatsImpl(File systemDir, Handler handler, PlatformIdleStateCallback cb, RailEnergyDataCallback railStatsCb, UserInfoProvider userInfoProvider) {
        this(new SystemClocks(), systemDir, handler, cb, railStatsCb, userInfoProvider);
    }

    private BatteryStatsImpl(Clocks clocks, File systemDir, Handler handler, PlatformIdleStateCallback cb, RailEnergyDataCallback railStatsCb, UserInfoProvider userInfoProvider) {
        int i;
        this.init(clocks);
        if (systemDir == null) {
            this.mStatsFile = null;
            this.mBatteryStatsHistory = new BatteryStatsHistory(this, this.mHistoryBuffer);
        } else {
            this.mStatsFile = new AtomicFile(new File(systemDir, "batterystats.bin"));
            this.mBatteryStatsHistory = new BatteryStatsHistory(this, systemDir, this.mHistoryBuffer);
        }
        this.mCheckinFile = new AtomicFile(new File(systemDir, "batterystats-checkin.bin"));
        this.mDailyFile = new AtomicFile(new File(systemDir, "batterystats-daily.xml"));
        this.mHandler = new MyHandler(handler.getLooper());
        this.mConstants = new Constants(this.mHandler);
        ++this.mStartCount;
        this.mScreenOnTimer = new StopwatchTimer(this.mClocks, null, -1, null, this.mOnBatteryTimeBase);
        this.mScreenDozeTimer = new StopwatchTimer(this.mClocks, null, -1, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(this.mClocks, null, -100 - i, null, this.mOnBatteryTimeBase);
        }
        this.mInteractiveTimer = new StopwatchTimer(this.mClocks, null, -10, null, this.mOnBatteryTimeBase);
        this.mPowerSaveModeEnabledTimer = new StopwatchTimer(this.mClocks, null, -2, null, this.mOnBatteryTimeBase);
        this.mDeviceIdleModeLightTimer = new StopwatchTimer(this.mClocks, null, -11, null, this.mOnBatteryTimeBase);
        this.mDeviceIdleModeFullTimer = new StopwatchTimer(this.mClocks, null, -14, null, this.mOnBatteryTimeBase);
        this.mDeviceLightIdlingTimer = new StopwatchTimer(this.mClocks, null, -15, null, this.mOnBatteryTimeBase);
        this.mDeviceIdlingTimer = new StopwatchTimer(this.mClocks, null, -12, null, this.mOnBatteryTimeBase);
        this.mPhoneOnTimer = new StopwatchTimer(this.mClocks, null, -3, null, this.mOnBatteryTimeBase);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(this.mClocks, null, -200 - i, null, this.mOnBatteryTimeBase);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(this.mClocks, null, -199, null, this.mOnBatteryTimeBase);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(this.mClocks, null, -300 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
        }
        this.mWifiActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 1);
        this.mBluetoothActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 1);
        this.mModemActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 5);
        this.mMobileRadioActiveTimer = new StopwatchTimer(this.mClocks, null, -400, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(this.mClocks, null, -401, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mWifiMulticastWakelockTimer = new StopwatchTimer(this.mClocks, null, 23, null, this.mOnBatteryTimeBase);
        this.mWifiOnTimer = new StopwatchTimer(this.mClocks, null, -4, null, this.mOnBatteryTimeBase);
        this.mGlobalWifiRunningTimer = new StopwatchTimer(this.mClocks, null, -5, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(this.mClocks, null, -600 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(this.mClocks, null, -700 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(this.mClocks, null, -800 - i, null, this.mOnBatteryTimeBase);
        }
        this.mWifiActiveTimer = new StopwatchTimer(this.mClocks, null, -900, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 2; ++i) {
            this.mGpsSignalQualityTimer[i] = new StopwatchTimer(this.mClocks, null, -1000 - i, null, this.mOnBatteryTimeBase);
        }
        this.mAudioOnTimer = new StopwatchTimer(this.mClocks, null, -7, null, this.mOnBatteryTimeBase);
        this.mVideoOnTimer = new StopwatchTimer(this.mClocks, null, -8, null, this.mOnBatteryTimeBase);
        this.mFlashlightOnTimer = new StopwatchTimer(this.mClocks, null, -9, null, this.mOnBatteryTimeBase);
        this.mCameraOnTimer = new StopwatchTimer(this.mClocks, null, -13, null, this.mOnBatteryTimeBase);
        this.mBluetoothScanTimer = new StopwatchTimer(this.mClocks, null, -14, null, this.mOnBatteryTimeBase);
        this.mDischargeScreenOffCounter = new LongSamplingCounter(this.mOnBatteryScreenOffTimeBase);
        this.mDischargeScreenDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mDischargeLightDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mDischargeDeepDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mDischargeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mOnBatteryInternal = false;
        this.mOnBattery = false;
        long uptime = this.mClocks.uptimeMillis() * 1000L;
        long realtime = this.mClocks.elapsedRealtime() * 1000L;
        this.initTimes(uptime, realtime);
        this.mStartPlatformVersion = this.mEndPlatformVersion = _Original_Build.ID;
        this.mDischargeStartLevel = 0;
        this.mDischargeUnplugLevel = 0;
        this.mDischargePlugLevel = -1;
        this.mDischargeCurrentLevel = 0;
        this.mCurrentBatteryLevel = 0;
        this.initDischarge();
        this.clearHistoryLocked();
        this.updateDailyDeadlineLocked();
        this.mPlatformIdleStateCallback = cb;
        this.mRailEnergyDataCallback = railStatsCb;
        this.mUserInfoProvider = userInfoProvider;
        this.mDeviceIdleMode = 0;
        FrameworkStatsLog.write(21, this.mDeviceIdleMode);
    }

    @UnsupportedAppUsage
    public BatteryStatsImpl(Parcel p) {
        this(new SystemClocks(), p);
    }

    public BatteryStatsImpl(Clocks clocks, Parcel p) {
        this.init(clocks);
        this.mStatsFile = null;
        this.mCheckinFile = null;
        this.mDailyFile = null;
        this.mHandler = null;
        this.mExternalSync = null;
        this.mConstants = new Constants(this.mHandler);
        this.clearHistoryLocked();
        this.mBatteryStatsHistory = new BatteryStatsHistory(this, this.mHistoryBuffer);
        this.readFromParcel(p);
        this.mPlatformIdleStateCallback = null;
        this.mRailEnergyDataCallback = null;
    }

    public void setPowerProfileLocked(PowerProfile profile) {
        this.mPowerProfile = profile;
        int numClusters = this.mPowerProfile.getNumCpuClusters();
        this.mKernelCpuSpeedReaders = new KernelCpuSpeedReader[numClusters];
        int firstCpuOfCluster = 0;
        for (int i = 0; i < numClusters; ++i) {
            int numSpeedSteps = this.mPowerProfile.getNumSpeedStepsInCpuCluster(i);
            this.mKernelCpuSpeedReaders[i] = new KernelCpuSpeedReader(firstCpuOfCluster, numSpeedSteps);
            firstCpuOfCluster += this.mPowerProfile.getNumCoresInCpuCluster(i);
        }
        if (this.mEstimatedBatteryCapacity == -1) {
            this.mEstimatedBatteryCapacity = (int)this.mPowerProfile.getBatteryCapacity();
        }
    }

    public void setCallback(BatteryCallback cb) {
        this.mCallback = cb;
    }

    public void setRadioScanningTimeoutLocked(long timeout) {
        if (this.mPhoneSignalScanningTimer != null) {
            this.mPhoneSignalScanningTimer.setTimeout(timeout);
        }
    }

    public void setExternalStatsSyncLocked(ExternalStatsSync sync) {
        this.mExternalSync = sync;
    }

    public void updateDailyDeadlineLocked() {
        long currentTime = this.mDailyStartTime = System_Delegate.currentTimeMillis();
        Calendar calDeadline = Calendar.getInstance();
        calDeadline.setTimeInMillis(currentTime);
        calDeadline.set(6, calDeadline.get(6) + 1);
        calDeadline.set(14, 0);
        calDeadline.set(13, 0);
        calDeadline.set(12, 0);
        calDeadline.set(11, 1);
        this.mNextMinDailyDeadline = calDeadline.getTimeInMillis();
        calDeadline.set(11, 3);
        this.mNextMaxDailyDeadline = calDeadline.getTimeInMillis();
    }

    public void recordDailyStatsIfNeededLocked(boolean settled) {
        long currentTime = System_Delegate.currentTimeMillis();
        if (currentTime >= this.mNextMaxDailyDeadline) {
            this.recordDailyStatsLocked();
        } else if (settled && currentTime >= this.mNextMinDailyDeadline) {
            this.recordDailyStatsLocked();
        } else if (currentTime < this.mDailyStartTime - 86400000L) {
            this.recordDailyStatsLocked();
        }
    }

    public void recordDailyStatsLocked() {
        BatteryStats.DailyItem item = new BatteryStats.DailyItem();
        item.mStartTime = this.mDailyStartTime;
        item.mEndTime = System_Delegate.currentTimeMillis();
        boolean hasData = false;
        if (this.mDailyDischargeStepTracker.mNumStepDurations > 0) {
            hasData = true;
            item.mDischargeSteps = new BatteryStats.LevelStepTracker(this.mDailyDischargeStepTracker.mNumStepDurations, this.mDailyDischargeStepTracker.mStepDurations);
        }
        if (this.mDailyChargeStepTracker.mNumStepDurations > 0) {
            hasData = true;
            item.mChargeSteps = new BatteryStats.LevelStepTracker(this.mDailyChargeStepTracker.mNumStepDurations, this.mDailyChargeStepTracker.mStepDurations);
        }
        if (this.mDailyPackageChanges != null) {
            hasData = true;
            item.mPackageChanges = this.mDailyPackageChanges;
            this.mDailyPackageChanges = null;
        }
        this.mDailyDischargeStepTracker.init();
        this.mDailyChargeStepTracker.init();
        this.updateDailyDeadlineLocked();
        if (hasData) {
            long startTime = SystemClock.uptimeMillis();
            this.mDailyItems.add(item);
            while (this.mDailyItems.size() > 10) {
                this.mDailyItems.remove(0);
            }
            final ByteArrayOutputStream memStream = new ByteArrayOutputStream();
            try {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(memStream, StandardCharsets.UTF_8.name());
                this.writeDailyItemsLocked(out);
                final long initialTime = SystemClock.uptimeMillis() - startTime;
                BackgroundThread.getHandler().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicFile atomicFile = BatteryStatsImpl.this.mCheckinFile;
                        synchronized (atomicFile) {
                            long startTime2 = SystemClock.uptimeMillis();
                            FileOutputStream stream = null;
                            try {
                                stream = BatteryStatsImpl.this.mDailyFile.startWrite();
                                memStream.writeTo(stream);
                                stream.flush();
                                BatteryStatsImpl.this.mDailyFile.finishWrite(stream);
                                EventLogTags.writeCommitSysConfigFile("batterystats-daily", initialTime + SystemClock.uptimeMillis() - startTime2);
                            }
                            catch (IOException e) {
                                Slog.w("BatteryStats", "Error writing battery daily items", e);
                                BatteryStatsImpl.this.mDailyFile.failWrite(stream);
                            }
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeDailyItemsLocked(XmlSerializer out) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        out.startDocument(null, Boolean.valueOf(true));
        out.startTag(null, "daily-items");
        for (int i = 0; i < this.mDailyItems.size(); ++i) {
            BatteryStats.DailyItem dit = this.mDailyItems.get(i);
            out.startTag(null, "item");
            out.attribute(null, "start", Long.toString(dit.mStartTime));
            out.attribute(null, "end", Long.toString(dit.mEndTime));
            this.writeDailyLevelSteps(out, "dis", dit.mDischargeSteps, sb);
            this.writeDailyLevelSteps(out, "chg", dit.mChargeSteps, sb);
            if (dit.mPackageChanges != null) {
                for (int j = 0; j < dit.mPackageChanges.size(); ++j) {
                    BatteryStats.PackageChange pc = dit.mPackageChanges.get(j);
                    if (pc.mUpdate) {
                        out.startTag(null, "upd");
                        out.attribute(null, "pkg", pc.mPackageName);
                        out.attribute(null, "ver", Long.toString(pc.mVersionCode));
                        out.endTag(null, "upd");
                        continue;
                    }
                    out.startTag(null, "rem");
                    out.attribute(null, "pkg", pc.mPackageName);
                    out.endTag(null, "rem");
                }
            }
            out.endTag(null, "item");
        }
        out.endTag(null, "daily-items");
        out.endDocument();
    }

    private void writeDailyLevelSteps(XmlSerializer out, String tag, BatteryStats.LevelStepTracker steps, StringBuilder tmpBuilder) throws IOException {
        if (steps != null) {
            out.startTag(null, tag);
            out.attribute(null, "n", Integer.toString(steps.mNumStepDurations));
            for (int i = 0; i < steps.mNumStepDurations; ++i) {
                out.startTag(null, "s");
                tmpBuilder.setLength(0);
                steps.encodeEntryAt(i, tmpBuilder);
                out.attribute(null, "v", tmpBuilder.toString());
                out.endTag(null, "s");
            }
            out.endTag(null, tag);
        }
    }

    public void readDailyStatsLocked() {
        FileInputStream stream;
        Slog.d(TAG, "Reading daily items from " + this.mDailyFile.getBaseFile());
        this.mDailyItems.clear();
        try {
            stream = this.mDailyFile.openRead();
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)stream, StandardCharsets.UTF_8.name());
            this.readDailyItemsLocked(parser);
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void readDailyItemsLocked(XmlPullParser parser) {
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("no start tag found");
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("item")) {
                    this.readDailyItemTagLocked(parser);
                    continue;
                }
                Slog.w(TAG, "Unknown element under <daily-items>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Failed parsing daily " + (Object)((Object)e));
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
    }

    void readDailyItemTagLocked(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        BatteryStats.DailyItem dit = new BatteryStats.DailyItem();
        String attr2 = parser.getAttributeValue(null, "start");
        if (attr2 != null) {
            dit.mStartTime = Long.parseLong(attr2);
        }
        if ((attr2 = parser.getAttributeValue(null, "end")) != null) {
            dit.mEndTime = Long.parseLong(attr2);
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            BatteryStats.PackageChange pc;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("dis")) {
                this.readDailyItemTagDetailsLocked(parser, dit, false, "dis");
                continue;
            }
            if (tagName.equals("chg")) {
                this.readDailyItemTagDetailsLocked(parser, dit, true, "chg");
                continue;
            }
            if (tagName.equals("upd")) {
                if (dit.mPackageChanges == null) {
                    dit.mPackageChanges = new ArrayList();
                }
                pc = new BatteryStats.PackageChange();
                pc.mUpdate = true;
                pc.mPackageName = parser.getAttributeValue(null, "pkg");
                String verStr = parser.getAttributeValue(null, "ver");
                pc.mVersionCode = verStr != null ? Long.parseLong(verStr) : 0L;
                dit.mPackageChanges.add(pc);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("rem")) {
                if (dit.mPackageChanges == null) {
                    dit.mPackageChanges = new ArrayList();
                }
                pc = new BatteryStats.PackageChange();
                pc.mUpdate = false;
                pc.mPackageName = parser.getAttributeValue(null, "pkg");
                dit.mPackageChanges.add(pc);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <item>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        this.mDailyItems.add(dit);
    }

    void readDailyItemTagDetailsLocked(XmlPullParser parser, BatteryStats.DailyItem dit, boolean isCharge, String tag) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        String numAttr = parser.getAttributeValue(null, "n");
        if (numAttr == null) {
            Slog.w(TAG, "Missing 'n' attribute at " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
            return;
        }
        int num = Integer.parseInt(numAttr);
        BatteryStats.LevelStepTracker steps = new BatteryStats.LevelStepTracker(num);
        if (isCharge) {
            dit.mChargeSteps = steps;
        } else {
            dit.mDischargeSteps = steps;
        }
        int i = 0;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("s".equals(tagName)) {
                String valueAttr;
                if (i >= num || (valueAttr = parser.getAttributeValue(null, "v")) == null) continue;
                steps.decodeEntryAt(i, valueAttr);
                ++i;
                continue;
            }
            Slog.w(TAG, "Unknown element under <" + tag + ">: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        steps.mNumStepDurations = i;
    }

    @Override
    public BatteryStats.DailyItem getDailyItemLocked(int daysAgo) {
        int index = this.mDailyItems.size() - 1 - daysAgo;
        return index >= 0 ? this.mDailyItems.get(index) : null;
    }

    @Override
    public long getCurrentDailyStartTime() {
        return this.mDailyStartTime;
    }

    @Override
    public long getNextMinDailyDeadline() {
        return this.mNextMinDailyDeadline;
    }

    @Override
    public long getNextMaxDailyDeadline() {
        return this.mNextMaxDailyDeadline;
    }

    @Override
    public boolean startIteratingOldHistoryLocked() {
        this.mHistoryIterator = this.mHistory;
        if (this.mHistoryIterator == null) {
            return false;
        }
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryReadTmp.clear();
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        return true;
    }

    @Override
    public boolean getNextOldHistoryLocked(BatteryStats.HistoryItem out) {
        BatteryStats.HistoryItem cur;
        boolean end;
        boolean bl = end = this.mHistoryBuffer.dataPosition() >= this.mHistoryBuffer.dataSize();
        if (!end) {
            this.readHistoryDelta(this.mHistoryBuffer, this.mHistoryReadTmp);
            this.mReadOverflow |= this.mHistoryReadTmp.cmd == 6;
        }
        if ((cur = this.mHistoryIterator) == null) {
            if (!this.mReadOverflow && !end) {
                Slog.w(TAG, "Old history ends before new history!");
            }
            return false;
        }
        out.setTo(cur);
        this.mHistoryIterator = cur.next;
        if (!this.mReadOverflow) {
            if (end) {
                Slog.w(TAG, "New history ends before old history!");
            } else if (!out.same(this.mHistoryReadTmp)) {
                FastPrintWriter pw = new FastPrintWriter(new LogWriter(5, TAG));
                pw.println("Histories differ!");
                pw.println("Old history:");
                new BatteryStats.HistoryPrinter().printNextItem(pw, out, 0L, false, true);
                pw.println("New history:");
                new BatteryStats.HistoryPrinter().printNextItem(pw, this.mHistoryReadTmp, 0L, false, true);
                ((PrintWriter)pw).flush();
            }
        }
        return true;
    }

    @Override
    public void finishIteratingOldHistoryLocked() {
        this.mIteratingHistory = false;
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        this.mHistoryIterator = null;
    }

    @Override
    public int getHistoryTotalSize() {
        return this.mConstants.MAX_HISTORY_BUFFER * this.mConstants.MAX_HISTORY_FILES;
    }

    @Override
    public int getHistoryUsedSize() {
        return this.mBatteryStatsHistory.getHistoryUsedSize();
    }

    @Override
    @UnsupportedAppUsage
    public boolean startIteratingHistoryLocked() {
        this.mBatteryStatsHistory.startIteratingHistory();
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        this.mReadHistoryStrings = new String[this.mHistoryTagPool.size()];
        this.mReadHistoryUids = new int[this.mHistoryTagPool.size()];
        this.mReadHistoryChars = 0;
        for (Map.Entry<BatteryStats.HistoryTag, Integer> ent : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag tag = ent.getKey();
            int idx = ent.getValue();
            this.mReadHistoryStrings[idx] = tag.string;
            this.mReadHistoryUids[idx] = tag.uid;
            this.mReadHistoryChars += tag.string.length() + 1;
        }
        return true;
    }

    @Override
    public int getHistoryStringPoolSize() {
        return this.mReadHistoryStrings.length;
    }

    @Override
    public int getHistoryStringPoolBytes() {
        return this.mReadHistoryStrings.length * 12 + this.mReadHistoryChars * 2;
    }

    @Override
    public String getHistoryTagPoolString(int index) {
        return this.mReadHistoryStrings[index];
    }

    @Override
    public int getHistoryTagPoolUid(int index) {
        return this.mReadHistoryUids[index];
    }

    @Override
    @UnsupportedAppUsage
    public boolean getNextHistoryLocked(BatteryStats.HistoryItem out) {
        Parcel p = this.mBatteryStatsHistory.getNextParcel(out);
        if (p == null) {
            return false;
        }
        long lastRealtime = out.time;
        long lastWalltime = out.currentTime;
        this.readHistoryDelta(p, out);
        if (out.cmd != 5 && out.cmd != 7 && lastWalltime != 0L) {
            out.currentTime = lastWalltime + (out.time - lastRealtime);
        }
        return true;
    }

    @Override
    public void finishIteratingHistoryLocked() {
        this.mBatteryStatsHistory.finishIteratingHistory();
        this.mIteratingHistory = false;
        this.mReadHistoryStrings = null;
        this.mReadHistoryUids = null;
    }

    @Override
    public long getHistoryBaseTime() {
        return this.mHistoryBaseTime;
    }

    @Override
    public int getStartCount() {
        return this.mStartCount;
    }

    @UnsupportedAppUsage
    public boolean isOnBattery() {
        return this.mOnBattery;
    }

    public boolean isCharging() {
        return this.mCharging;
    }

    public boolean isScreenOn(int state) {
        return state == 2 || state == 5 || state == 6;
    }

    public boolean isScreenOff(int state) {
        return state == 1;
    }

    public boolean isScreenDoze(int state) {
        return state == 3 || state == 4;
    }

    void initTimes(long uptime, long realtime) {
        this.mStartClockTime = System_Delegate.currentTimeMillis();
        this.mOnBatteryTimeBase.init(uptime, realtime);
        this.mOnBatteryScreenOffTimeBase.init(uptime, realtime);
        this.mRealtime = 0L;
        this.mUptime = 0L;
        this.mRealtimeStart = realtime;
        this.mUptimeStart = uptime;
    }

    void initDischarge() {
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
        this.mDischargeAmountScreenOn = 0;
        this.mDischargeAmountScreenOnSinceCharge = 0;
        this.mDischargeAmountScreenOff = 0;
        this.mDischargeAmountScreenOffSinceCharge = 0;
        this.mDischargeAmountScreenDoze = 0;
        this.mDischargeAmountScreenDozeSinceCharge = 0;
        this.mDischargeStepTracker.init();
        this.mChargeStepTracker.init();
        this.mDischargeScreenOffCounter.reset(false);
        this.mDischargeScreenDozeCounter.reset(false);
        this.mDischargeLightDozeCounter.reset(false);
        this.mDischargeDeepDozeCounter.reset(false);
        this.mDischargeCounter.reset(false);
    }

    public void resetAllStatsCmdLocked() {
        this.resetAllStatsLocked();
        long mSecUptime = this.mClocks.uptimeMillis();
        long uptime = mSecUptime * 1000L;
        long mSecRealtime = this.mClocks.elapsedRealtime();
        long realtime = mSecRealtime * 1000L;
        this.mDischargeStartLevel = this.mHistoryCur.batteryLevel;
        this.pullPendingStateUpdatesLocked();
        this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
        byte by = this.mHistoryCur.batteryLevel;
        this.mCurrentBatteryLevel = by;
        this.mDischargePlugLevel = by;
        this.mDischargeUnplugLevel = by;
        this.mDischargeCurrentLevel = by;
        this.mOnBatteryTimeBase.reset(uptime, realtime);
        this.mOnBatteryScreenOffTimeBase.reset(uptime, realtime);
        if ((this.mHistoryCur.states & 0x80000) == 0) {
            if (this.isScreenOn(this.mScreenState)) {
                this.mDischargeScreenOnUnplugLevel = this.mHistoryCur.batteryLevel;
                this.mDischargeScreenDozeUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else if (this.isScreenDoze(this.mScreenState)) {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenDozeUnplugLevel = this.mHistoryCur.batteryLevel;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenDozeUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = this.mHistoryCur.batteryLevel;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenOff = 0;
            this.mDischargeAmountScreenDoze = 0;
        }
        this.initActiveHistoryEventsLocked(mSecRealtime, mSecUptime);
    }

    private void resetAllStatsLocked() {
        int i;
        long uptimeMillis = this.mClocks.uptimeMillis();
        long elapsedRealtimeMillis = this.mClocks.elapsedRealtime();
        this.mStartCount = 0;
        this.initTimes(uptimeMillis * 1000L, elapsedRealtimeMillis * 1000L);
        this.mScreenOnTimer.reset(false);
        this.mScreenDozeTimer.reset(false);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].reset(false);
        }
        this.mEstimatedBatteryCapacity = this.mPowerProfile != null ? (int)this.mPowerProfile.getBatteryCapacity() : -1;
        this.mMinLearnedBatteryCapacity = -1;
        this.mMaxLearnedBatteryCapacity = -1;
        this.mInteractiveTimer.reset(false);
        this.mPowerSaveModeEnabledTimer.reset(false);
        this.mLastIdleTimeStart = elapsedRealtimeMillis;
        this.mLongestLightIdleTime = 0L;
        this.mLongestFullIdleTime = 0L;
        this.mDeviceIdleModeLightTimer.reset(false);
        this.mDeviceIdleModeFullTimer.reset(false);
        this.mDeviceLightIdlingTimer.reset(false);
        this.mDeviceIdlingTimer.reset(false);
        this.mPhoneOnTimer.reset(false);
        this.mAudioOnTimer.reset(false);
        this.mVideoOnTimer.reset(false);
        this.mFlashlightOnTimer.reset(false);
        this.mCameraOnTimer.reset(false);
        this.mBluetoothScanTimer.reset(false);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i].reset(false);
        }
        this.mPhoneSignalScanningTimer.reset(false);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i].reset(false);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i].reset(false);
            this.mNetworkPacketActivityCounters[i].reset(false);
        }
        this.mMobileRadioActiveTimer.reset(false);
        this.mMobileRadioActivePerAppTimer.reset(false);
        this.mMobileRadioActiveAdjustedTime.reset(false);
        this.mMobileRadioActiveUnknownTime.reset(false);
        this.mMobileRadioActiveUnknownCount.reset(false);
        this.mWifiOnTimer.reset(false);
        this.mGlobalWifiRunningTimer.reset(false);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].reset(false);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].reset(false);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].reset(false);
        }
        this.mWifiMulticastWakelockTimer.reset(false);
        this.mWifiActiveTimer.reset(false);
        this.mWifiActivity.reset(false);
        for (i = 0; i < 2; ++i) {
            this.mGpsSignalQualityTimer[i].reset(false);
        }
        this.mBluetoothActivity.reset(false);
        this.mModemActivity.reset(false);
        this.mNumConnectivityChange = 0;
        for (i = 0; i < this.mUidStats.size(); ++i) {
            if (!this.mUidStats.valueAt(i).reset(uptimeMillis * 1000L, elapsedRealtimeMillis * 1000L)) continue;
            this.mUidStats.valueAt(i).detachFromTimeBase();
            this.mUidStats.remove(this.mUidStats.keyAt(i));
            --i;
        }
        if (this.mRpmStats.size() > 0) {
            for (SamplingTimer timer : this.mRpmStats.values()) {
                this.mOnBatteryTimeBase.remove(timer);
            }
            this.mRpmStats.clear();
        }
        if (this.mScreenOffRpmStats.size() > 0) {
            for (SamplingTimer timer : this.mScreenOffRpmStats.values()) {
                this.mOnBatteryScreenOffTimeBase.remove(timer);
            }
            this.mScreenOffRpmStats.clear();
        }
        if (this.mKernelWakelockStats.size() > 0) {
            for (SamplingTimer timer : this.mKernelWakelockStats.values()) {
                this.mOnBatteryScreenOffTimeBase.remove(timer);
            }
            this.mKernelWakelockStats.clear();
        }
        if (this.mKernelMemoryStats.size() > 0) {
            for (int i2 = 0; i2 < this.mKernelMemoryStats.size(); ++i2) {
                this.mOnBatteryTimeBase.remove(this.mKernelMemoryStats.valueAt(i2));
            }
            this.mKernelMemoryStats.clear();
        }
        if (this.mWakeupReasonStats.size() > 0) {
            for (SamplingTimer timer : this.mWakeupReasonStats.values()) {
                this.mOnBatteryTimeBase.remove(timer);
            }
            this.mWakeupReasonStats.clear();
        }
        this.mTmpRailStats.reset();
        this.mLastHistoryStepDetails = null;
        this.mLastStepCpuSystemTime = 0L;
        this.mLastStepCpuUserTime = 0L;
        this.mCurStepCpuSystemTime = 0L;
        this.mCurStepCpuUserTime = 0L;
        this.mCurStepCpuUserTime = 0L;
        this.mLastStepCpuUserTime = 0L;
        this.mCurStepCpuSystemTime = 0L;
        this.mLastStepCpuSystemTime = 0L;
        this.mCurStepStatUserTime = 0L;
        this.mLastStepStatUserTime = 0L;
        this.mCurStepStatSystemTime = 0L;
        this.mLastStepStatSystemTime = 0L;
        this.mCurStepStatIOWaitTime = 0L;
        this.mLastStepStatIOWaitTime = 0L;
        this.mCurStepStatIrqTime = 0L;
        this.mLastStepStatIrqTime = 0L;
        this.mCurStepStatSoftIrqTime = 0L;
        this.mLastStepStatSoftIrqTime = 0L;
        this.mCurStepStatIdleTime = 0L;
        this.mLastStepStatIdleTime = 0L;
        this.mNumAllUidCpuTimeReads = 0;
        this.mNumUidsRemoved = 0;
        this.initDischarge();
        this.clearHistoryLocked();
        this.mBatteryStatsHistory.resetAllFiles();
        this.mHandler.sendEmptyMessage(4);
    }

    private void initActiveHistoryEventsLocked(long elapsedRealtimeMs, long uptimeMs) {
        for (int i = 0; i < 22; ++i) {
            HashMap<String, SparseIntArray> active;
            if (!this.mRecordAllHistory && i == 1 || (active = this.mActiveEvents.getStateForEvent(i)) == null) continue;
            for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                SparseIntArray uids = ent.getValue();
                for (int j = 0; j < uids.size(); ++j) {
                    this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, i, ent.getKey(), uids.keyAt(j));
                }
            }
        }
    }

    void updateDischargeScreenLevelsLocked(int oldState, int newState) {
        this.updateOldDischargeScreenLevelLocked(oldState);
        this.updateNewDischargeScreenLevelLocked(newState);
    }

    private void updateOldDischargeScreenLevelLocked(int state) {
        int diff;
        if (this.isScreenOn(state)) {
            int diff2 = this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            if (diff2 > 0) {
                this.mDischargeAmountScreenOn += diff2;
                this.mDischargeAmountScreenOnSinceCharge += diff2;
            }
        } else if (this.isScreenDoze(state)) {
            int diff3 = this.mDischargeScreenDozeUnplugLevel - this.mDischargeCurrentLevel;
            if (diff3 > 0) {
                this.mDischargeAmountScreenDoze += diff3;
                this.mDischargeAmountScreenDozeSinceCharge += diff3;
            }
        } else if (this.isScreenOff(state) && (diff = this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel) > 0) {
            this.mDischargeAmountScreenOff += diff;
            this.mDischargeAmountScreenOffSinceCharge += diff;
        }
    }

    private void updateNewDischargeScreenLevelLocked(int state) {
        if (this.isScreenOn(state)) {
            this.mDischargeScreenOnUnplugLevel = this.mDischargeCurrentLevel;
            this.mDischargeScreenOffUnplugLevel = 0;
            this.mDischargeScreenDozeUnplugLevel = 0;
        } else if (this.isScreenDoze(state)) {
            this.mDischargeScreenOnUnplugLevel = 0;
            this.mDischargeScreenDozeUnplugLevel = this.mDischargeCurrentLevel;
            this.mDischargeScreenOffUnplugLevel = 0;
        } else if (this.isScreenOff(state)) {
            this.mDischargeScreenOnUnplugLevel = 0;
            this.mDischargeScreenDozeUnplugLevel = 0;
            this.mDischargeScreenOffUnplugLevel = this.mDischargeCurrentLevel;
        }
    }

    public void pullPendingStateUpdatesLocked() {
        if (this.mOnBatteryInternal) {
            this.updateDischargeScreenLevelsLocked(this.mScreenState, this.mScreenState);
        }
    }

    private NetworkStats readNetworkStatsLocked(String[] ifaces) {
        try {
            if (!ArrayUtils.isEmpty(ifaces)) {
                INetworkStatsService statsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
                if (statsService != null) {
                    return statsService.getDetailedUidStats(ifaces);
                }
                Slog.e(TAG, "Failed to get networkStatsService ");
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "failed to read network stats for ifaces: " + Arrays.toString(ifaces) + e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWifiState(WifiActivityEnergyInfo info) {
        NetworkStats delta = null;
        Object object = this.mWifiNetworkLock;
        synchronized (object) {
            NetworkStats latestStats = this.readNetworkStatsLocked(this.mWifiIfaces);
            if (latestStats != null) {
                delta = NetworkStats.subtract(latestStats, this.mLastWifiNetworkStats, null, null, this.mNetworkStatsPool.acquire());
                this.mNetworkStatsPool.release(this.mLastWifiNetworkStats);
                this.mLastWifiNetworkStats = latestStats;
            }
        }
        object = this;
        synchronized (object) {
            if (!this.mOnBatteryInternal) {
                if (delta != null) {
                    this.mNetworkStatsPool.release(delta);
                }
                return;
            }
            long elapsedRealtimeMs = this.mClocks.elapsedRealtime();
            SparseLongArray rxPackets = new SparseLongArray();
            SparseLongArray txPackets = new SparseLongArray();
            long totalTxPackets = 0L;
            long totalRxPackets = 0L;
            if (delta != null) {
                NetworkStats.Entry entry = new NetworkStats.Entry();
                int size = delta.size();
                for (int i = 0; i < size; ++i) {
                    entry = delta.getValues(i, entry);
                    if (entry.rxBytes == 0L && entry.txBytes == 0L) continue;
                    Uid u = this.getUidStatsLocked(this.mapUid(entry.uid));
                    if (entry.rxBytes != 0L) {
                        u.noteNetworkActivityLocked(2, entry.rxBytes, entry.rxPackets);
                        if (entry.set == 0) {
                            u.noteNetworkActivityLocked(8, entry.rxBytes, entry.rxPackets);
                        }
                        this.mNetworkByteActivityCounters[2].addCountLocked(entry.rxBytes);
                        this.mNetworkPacketActivityCounters[2].addCountLocked(entry.rxPackets);
                        rxPackets.put(u.getUid(), entry.rxPackets);
                        totalRxPackets += entry.rxPackets;
                    }
                    if (entry.txBytes == 0L) continue;
                    u.noteNetworkActivityLocked(3, entry.txBytes, entry.txPackets);
                    if (entry.set == 0) {
                        u.noteNetworkActivityLocked(9, entry.txBytes, entry.txPackets);
                    }
                    this.mNetworkByteActivityCounters[3].addCountLocked(entry.txBytes);
                    this.mNetworkPacketActivityCounters[3].addCountLocked(entry.txPackets);
                    txPackets.put(u.getUid(), entry.txPackets);
                    totalTxPackets += entry.txPackets;
                }
                this.mNetworkStatsPool.release(delta);
                delta = null;
            }
            if (info != null) {
                Uid uid;
                int i;
                this.mHasWifiReporting = true;
                long txTimeMs = info.getControllerTxDurationMillis();
                long rxTimeMs = info.getControllerRxDurationMillis();
                long scanTimeMs = info.getControllerScanDurationMillis();
                long idleTimeMs = info.getControllerIdleDurationMillis();
                long totalTimeMs = txTimeMs + rxTimeMs + idleTimeMs;
                long leftOverRxTimeMs = rxTimeMs;
                long leftOverTxTimeMs = txTimeMs;
                long totalWifiLockTimeMs = 0L;
                long totalScanTimeMs = 0L;
                int uidStatsSize = this.mUidStats.size();
                for (i = 0; i < uidStatsSize; ++i) {
                    uid = this.mUidStats.valueAt(i);
                    totalScanTimeMs += uid.mWifiScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                    totalWifiLockTimeMs += uid.mFullWifiLockTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                }
                for (i = 0; i < uidStatsSize; ++i) {
                    long wifiLockTimeSinceMarkMs;
                    uid = this.mUidStats.valueAt(i);
                    long scanTimeSinceMarkMs = uid.mWifiScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                    if (scanTimeSinceMarkMs > 0L) {
                        uid.mWifiScanTimer.setMark(elapsedRealtimeMs);
                        long scanRxTimeSinceMarkMs = scanTimeSinceMarkMs;
                        long scanTxTimeSinceMarkMs = scanTimeSinceMarkMs;
                        if (totalScanTimeMs > rxTimeMs) {
                            scanRxTimeSinceMarkMs = rxTimeMs * scanRxTimeSinceMarkMs / totalScanTimeMs;
                        }
                        if (totalScanTimeMs > txTimeMs) {
                            scanTxTimeSinceMarkMs = txTimeMs * scanTxTimeSinceMarkMs / totalScanTimeMs;
                        }
                        ControllerActivityCounterImpl activityCounter = uid.getOrCreateWifiControllerActivityLocked();
                        activityCounter.getRxTimeCounter().addCountLocked(scanRxTimeSinceMarkMs);
                        activityCounter.getTxTimeCounters()[0].addCountLocked(scanTxTimeSinceMarkMs);
                        leftOverRxTimeMs -= scanRxTimeSinceMarkMs;
                        leftOverTxTimeMs -= scanTxTimeSinceMarkMs;
                    }
                    if ((wifiLockTimeSinceMarkMs = uid.mFullWifiLockTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L) <= 0L) continue;
                    uid.mFullWifiLockTimer.setMark(elapsedRealtimeMs);
                    long myIdleTimeMs = wifiLockTimeSinceMarkMs * idleTimeMs / totalWifiLockTimeMs;
                    uid.getOrCreateWifiControllerActivityLocked().getIdleTimeCounter().addCountLocked(myIdleTimeMs);
                }
                for (i = 0; i < txPackets.size(); ++i) {
                    uid = this.getUidStatsLocked(txPackets.keyAt(i));
                    long myTxTimeMs = txPackets.valueAt(i) * leftOverTxTimeMs / totalTxPackets;
                    uid.getOrCreateWifiControllerActivityLocked().getTxTimeCounters()[0].addCountLocked(myTxTimeMs);
                }
                for (i = 0; i < rxPackets.size(); ++i) {
                    uid = this.getUidStatsLocked(rxPackets.keyAt(i));
                    long myRxTimeMs = rxPackets.valueAt(i) * leftOverRxTimeMs / totalRxPackets;
                    uid.getOrCreateWifiControllerActivityLocked().getRxTimeCounter().addCountLocked(myRxTimeMs);
                }
                this.mWifiActivity.getRxTimeCounter().addCountLocked(info.getControllerRxDurationMillis());
                this.mWifiActivity.getTxTimeCounters()[0].addCountLocked(info.getControllerTxDurationMillis());
                this.mWifiActivity.getScanTimeCounter().addCountLocked(info.getControllerScanDurationMillis());
                this.mWifiActivity.getIdleTimeCounter().addCountLocked(info.getControllerIdleDurationMillis());
                double opVolt = this.mPowerProfile.getAveragePower("wifi.controller.voltage") / 1000.0;
                if (opVolt != 0.0) {
                    this.mWifiActivity.getPowerCounter().addCountLocked((long)((double)info.getControllerEnergyUsedMicroJoules() / opVolt));
                }
                long monitoredRailChargeConsumedMaMs = (long)((double)this.mTmpRailStats.getWifiTotalEnergyUseduWs() / opVolt);
                this.mWifiActivity.getMonitoredRailChargeConsumedMaMs().addCountLocked(monitoredRailChargeConsumedMaMs);
                this.mHistoryCur.wifiRailChargeMah += (double)monitoredRailChargeConsumedMaMs / 3600000.0;
                this.addHistoryRecordLocked(this.mClocks.elapsedRealtime(), this.mClocks.uptimeMillis());
                this.mTmpRailStats.resetWifiTotalEnergyUsed();
            }
        }
    }

    private ModemActivityInfo getDeltaModemActivityInfo(ModemActivityInfo activityInfo) {
        if (activityInfo == null) {
            return null;
        }
        int[] txTimeMs = new int[5];
        for (int i = 0; i < 5; ++i) {
            txTimeMs[i] = activityInfo.getTransmitPowerInfo().get(i).getTimeInMillis() - this.mLastModemActivityInfo.getTransmitPowerInfo().get(i).getTimeInMillis();
        }
        ModemActivityInfo deltaInfo = new ModemActivityInfo(activityInfo.getTimestamp(), activityInfo.getSleepTimeMillis() - this.mLastModemActivityInfo.getSleepTimeMillis(), activityInfo.getIdleTimeMillis() - this.mLastModemActivityInfo.getIdleTimeMillis(), txTimeMs, activityInfo.getReceiveTimeMillis() - this.mLastModemActivityInfo.getReceiveTimeMillis());
        this.mLastModemActivityInfo = activityInfo;
        return deltaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMobileRadioState(ModemActivityInfo activityInfo) {
        ModemActivityInfo deltaInfo = this.getDeltaModemActivityInfo(activityInfo);
        this.addModemTxPowerToHistory(deltaInfo);
        NetworkStats delta = null;
        Object object = this.mModemNetworkLock;
        synchronized (object) {
            NetworkStats latestStats = this.readNetworkStatsLocked(this.mModemIfaces);
            if (latestStats != null) {
                delta = NetworkStats.subtract(latestStats, this.mLastModemNetworkStats, null, null, this.mNetworkStatsPool.acquire());
                this.mNetworkStatsPool.release(this.mLastModemNetworkStats);
                this.mLastModemNetworkStats = latestStats;
            }
        }
        object = this;
        synchronized (object) {
            if (!this.mOnBatteryInternal) {
                if (delta != null) {
                    this.mNetworkStatsPool.release(delta);
                }
                return;
            }
            if (deltaInfo != null) {
                this.mHasModemReporting = true;
                this.mModemActivity.getIdleTimeCounter().addCountLocked(deltaInfo.getIdleTimeMillis());
                this.mModemActivity.getSleepTimeCounter().addCountLocked(deltaInfo.getSleepTimeMillis());
                this.mModemActivity.getRxTimeCounter().addCountLocked(deltaInfo.getReceiveTimeMillis());
                for (int lvl = 0; lvl < 5; ++lvl) {
                    this.mModemActivity.getTxTimeCounters()[lvl].addCountLocked(deltaInfo.getTransmitPowerInfo().get(lvl).getTimeInMillis());
                }
                double opVolt = this.mPowerProfile.getAveragePower("modem.controller.voltage") / 1000.0;
                if (opVolt != 0.0) {
                    double energyUsed = (double)deltaInfo.getSleepTimeMillis() * this.mPowerProfile.getAveragePower("modem.controller.sleep") + (double)deltaInfo.getIdleTimeMillis() * this.mPowerProfile.getAveragePower("modem.controller.idle") + (double)deltaInfo.getReceiveTimeMillis() * this.mPowerProfile.getAveragePower("modem.controller.rx");
                    List<ModemActivityInfo.TransmitPower> txPowerInfo = deltaInfo.getTransmitPowerInfo();
                    for (int i = 0; i < Math.min(txPowerInfo.size(), CellSignalStrength.getNumSignalStrengthLevels()); ++i) {
                        energyUsed += (double)txPowerInfo.get(i).getTimeInMillis() * this.mPowerProfile.getAveragePower("modem.controller.tx", i);
                    }
                    this.mModemActivity.getPowerCounter().addCountLocked((long)energyUsed);
                    long monitoredRailChargeConsumedMaMs = (long)((double)this.mTmpRailStats.getCellularTotalEnergyUseduWs() / opVolt);
                    this.mModemActivity.getMonitoredRailChargeConsumedMaMs().addCountLocked(monitoredRailChargeConsumedMaMs);
                    this.mHistoryCur.modemRailChargeMah += (double)monitoredRailChargeConsumedMaMs / 3600000.0;
                    this.addHistoryRecordLocked(this.mClocks.elapsedRealtime(), this.mClocks.uptimeMillis());
                    this.mTmpRailStats.resetCellularTotalEnergyUsed();
                }
            }
            long elapsedRealtimeMs = this.mClocks.elapsedRealtime();
            long radioTime = this.mMobileRadioActivePerAppTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L);
            this.mMobileRadioActivePerAppTimer.setMark(elapsedRealtimeMs);
            long totalRxPackets = 0L;
            long totalTxPackets = 0L;
            if (delta != null) {
                NetworkStats.Entry entry = new NetworkStats.Entry();
                int size = delta.size();
                for (int i = 0; i < size; ++i) {
                    entry = delta.getValues(i, entry);
                    if (entry.rxPackets == 0L && entry.txPackets == 0L) continue;
                    totalRxPackets += entry.rxPackets;
                    totalTxPackets += entry.txPackets;
                    Uid u = this.getUidStatsLocked(this.mapUid(entry.uid));
                    u.noteNetworkActivityLocked(0, entry.rxBytes, entry.rxPackets);
                    u.noteNetworkActivityLocked(1, entry.txBytes, entry.txPackets);
                    if (entry.set == 0) {
                        u.noteNetworkActivityLocked(6, entry.rxBytes, entry.rxPackets);
                        u.noteNetworkActivityLocked(7, entry.txBytes, entry.txPackets);
                    }
                    this.mNetworkByteActivityCounters[0].addCountLocked(entry.rxBytes);
                    this.mNetworkByteActivityCounters[1].addCountLocked(entry.txBytes);
                    this.mNetworkPacketActivityCounters[0].addCountLocked(entry.rxPackets);
                    this.mNetworkPacketActivityCounters[1].addCountLocked(entry.txPackets);
                }
                long totalPackets = totalRxPackets + totalTxPackets;
                if (totalPackets > 0L) {
                    for (int i = 0; i < size; ++i) {
                        entry = delta.getValues(i, entry);
                        if (entry.rxPackets == 0L && entry.txPackets == 0L) continue;
                        Uid u = this.getUidStatsLocked(this.mapUid(entry.uid));
                        long appPackets = entry.rxPackets + entry.txPackets;
                        long appRadioTime = radioTime * appPackets / totalPackets;
                        u.noteMobileRadioActiveTimeLocked(appRadioTime);
                        radioTime -= appRadioTime;
                        totalPackets -= appPackets;
                        if (deltaInfo == null) continue;
                        ControllerActivityCounterImpl activityCounter = u.getOrCreateModemControllerActivityLocked();
                        if (totalRxPackets > 0L && entry.rxPackets > 0L) {
                            long rxMs = entry.rxPackets * (long)deltaInfo.getReceiveTimeMillis() / totalRxPackets;
                            activityCounter.getRxTimeCounter().addCountLocked(rxMs);
                        }
                        if (totalTxPackets <= 0L || entry.txPackets <= 0L) continue;
                        for (int lvl = 0; lvl < 5; ++lvl) {
                            long txMs = entry.txPackets * (long)deltaInfo.getTransmitPowerInfo().get(lvl).getTimeInMillis();
                            activityCounter.getTxTimeCounters()[lvl].addCountLocked(txMs /= totalTxPackets);
                        }
                    }
                }
                if (radioTime > 0L) {
                    this.mMobileRadioActiveUnknownTime.addCountLocked(radioTime);
                    this.mMobileRadioActiveUnknownCount.addCountLocked(1L);
                }
                this.mNetworkStatsPool.release(delta);
                delta = null;
            }
        }
    }

    private synchronized void addModemTxPowerToHistory(ModemActivityInfo activityInfo) {
        if (activityInfo == null) {
            return;
        }
        List<ModemActivityInfo.TransmitPower> txPowerInfo = activityInfo.getTransmitPowerInfo();
        if (txPowerInfo == null || txPowerInfo.size() != 5) {
            return;
        }
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        int levelMaxTimeSpent = 0;
        for (int i = 1; i < txPowerInfo.size(); ++i) {
            if (txPowerInfo.get(i).getTimeInMillis() <= txPowerInfo.get(levelMaxTimeSpent).getTimeInMillis()) continue;
            levelMaxTimeSpent = i;
        }
        if (levelMaxTimeSpent == 4) {
            this.mHistoryCur.states2 |= 0x80000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    public void updateBluetoothStateLocked(BluetoothActivityEnergyInfo info) {
        UidTraffic traffic;
        int i;
        if (info == null || !this.mOnBatteryInternal) {
            return;
        }
        this.mHasBluetoothReporting = true;
        long elapsedRealtimeMs = this.mClocks.elapsedRealtime();
        long rxTimeMs = info.getControllerRxTimeMillis() - this.mLastBluetoothActivityInfo.rxTimeMs;
        long txTimeMs = info.getControllerTxTimeMillis() - this.mLastBluetoothActivityInfo.txTimeMs;
        long idleTimeMs = info.getControllerIdleTimeMillis() - this.mLastBluetoothActivityInfo.idleTimeMs;
        long totalScanTimeMs = 0L;
        int uidCount = this.mUidStats.size();
        for (int i2 = 0; i2 < uidCount; ++i2) {
            Uid u = this.mUidStats.valueAt(i2);
            if (u.mBluetoothScanTimer == null) continue;
            totalScanTimeMs += u.mBluetoothScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
        }
        boolean normalizeScanRxTime = totalScanTimeMs > rxTimeMs;
        boolean normalizeScanTxTime = totalScanTimeMs > txTimeMs;
        long leftOverRxTimeMs = rxTimeMs;
        long leftOverTxTimeMs = txTimeMs;
        for (int i3 = 0; i3 < uidCount; ++i3) {
            long scanTimeSinceMarkMs;
            Uid u = this.mUidStats.valueAt(i3);
            if (u.mBluetoothScanTimer == null || (scanTimeSinceMarkMs = u.mBluetoothScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L) <= 0L) continue;
            u.mBluetoothScanTimer.setMark(elapsedRealtimeMs);
            long scanTimeRxSinceMarkMs = scanTimeSinceMarkMs;
            long scanTimeTxSinceMarkMs = scanTimeSinceMarkMs;
            if (normalizeScanRxTime) {
                scanTimeRxSinceMarkMs = rxTimeMs * scanTimeRxSinceMarkMs / totalScanTimeMs;
            }
            if (normalizeScanTxTime) {
                scanTimeTxSinceMarkMs = txTimeMs * scanTimeTxSinceMarkMs / totalScanTimeMs;
            }
            ControllerActivityCounterImpl counter = u.getOrCreateBluetoothControllerActivityLocked();
            counter.getRxTimeCounter().addCountLocked(scanTimeRxSinceMarkMs);
            counter.getTxTimeCounters()[0].addCountLocked(scanTimeTxSinceMarkMs);
            leftOverRxTimeMs -= scanTimeRxSinceMarkMs;
            leftOverTxTimeMs -= scanTimeTxSinceMarkMs;
        }
        long totalTxBytes = 0L;
        long totalRxBytes = 0L;
        UidTraffic[] uidTraffic = info.getUidTraffic();
        int numUids = uidTraffic != null ? uidTraffic.length : 0;
        for (i = 0; i < numUids; ++i) {
            traffic = uidTraffic[i];
            long rxBytes = traffic.getRxBytes() - this.mLastBluetoothActivityInfo.uidRxBytes.get(traffic.getUid());
            long txBytes = traffic.getTxBytes() - this.mLastBluetoothActivityInfo.uidTxBytes.get(traffic.getUid());
            this.mNetworkByteActivityCounters[4].addCountLocked(rxBytes);
            this.mNetworkByteActivityCounters[5].addCountLocked(txBytes);
            Uid u = this.getUidStatsLocked(this.mapUid(traffic.getUid()));
            u.noteNetworkActivityLocked(4, rxBytes, 0L);
            u.noteNetworkActivityLocked(5, txBytes, 0L);
            totalRxBytes += rxBytes;
            totalTxBytes += txBytes;
        }
        if (!(totalTxBytes == 0L && totalRxBytes == 0L || leftOverRxTimeMs == 0L && leftOverTxTimeMs == 0L)) {
            for (i = 0; i < numUids; ++i) {
                traffic = uidTraffic[i];
                int uid = traffic.getUid();
                long rxBytes = traffic.getRxBytes() - this.mLastBluetoothActivityInfo.uidRxBytes.get(uid);
                long txBytes = traffic.getTxBytes() - this.mLastBluetoothActivityInfo.uidTxBytes.get(uid);
                Uid u = this.getUidStatsLocked(this.mapUid(uid));
                ControllerActivityCounterImpl counter = u.getOrCreateBluetoothControllerActivityLocked();
                if (totalRxBytes > 0L && rxBytes > 0L) {
                    long timeRxMs = leftOverRxTimeMs * rxBytes / totalRxBytes;
                    counter.getRxTimeCounter().addCountLocked(timeRxMs);
                }
                if (totalTxBytes <= 0L || txBytes <= 0L) continue;
                long timeTxMs = leftOverTxTimeMs * txBytes / totalTxBytes;
                counter.getTxTimeCounters()[0].addCountLocked(timeTxMs);
            }
        }
        this.mBluetoothActivity.getRxTimeCounter().addCountLocked(rxTimeMs);
        this.mBluetoothActivity.getTxTimeCounters()[0].addCountLocked(txTimeMs);
        this.mBluetoothActivity.getIdleTimeCounter().addCountLocked(idleTimeMs);
        double opVolt = this.mPowerProfile.getAveragePower("bluetooth.controller.voltage") / 1000.0;
        if (opVolt != 0.0) {
            this.mBluetoothActivity.getPowerCounter().addCountLocked((long)((double)(info.getControllerEnergyUsed() - this.mLastBluetoothActivityInfo.energy) / opVolt));
        }
        this.mLastBluetoothActivityInfo.set(info);
    }

    public void updateRpmStatsLocked() {
        if (this.mPlatformIdleStateCallback == null) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        if (now - this.mLastRpmStatsUpdateTimeMs >= 1000L) {
            this.mPlatformIdleStateCallback.fillLowPowerStats(this.mTmpRpmStats);
            this.mLastRpmStatsUpdateTimeMs = now;
        }
        for (Map.Entry<String, RpmStats.PowerStatePlatformSleepState> entry : this.mTmpRpmStats.mPlatformLowPowerStats.entrySet()) {
            String pName = entry.getKey();
            long pTimeUs = entry.getValue().mTimeMs * 1000L;
            int pCount = entry.getValue().mCount;
            this.getRpmTimerLocked(pName).update(pTimeUs, pCount);
            for (Map.Entry<String, RpmStats.PowerStateElement> voter : entry.getValue().mVoters.entrySet()) {
                String vName = pName + "." + voter.getKey();
                long vTimeUs = voter.getValue().mTimeMs * 1000L;
                int vCount = voter.getValue().mCount;
                this.getRpmTimerLocked(vName).update(vTimeUs, vCount);
            }
        }
        for (Map.Entry<String, Object> entry : this.mTmpRpmStats.mSubsystemLowPowerStats.entrySet()) {
            String subsysName = entry.getKey();
            for (Map.Entry<String, RpmStats.PowerStateElement> sstate : ((RpmStats.PowerStateSubsystem)entry.getValue()).mStates.entrySet()) {
                String name = subsysName + "." + sstate.getKey();
                long timeUs = sstate.getValue().mTimeMs * 1000L;
                int count = sstate.getValue().mCount;
                this.getRpmTimerLocked(name).update(timeUs, count);
            }
        }
    }

    public void updateRailStatsLocked() {
        if (this.mRailEnergyDataCallback == null || !this.mTmpRailStats.isRailStatsAvailable()) {
            return;
        }
        this.mRailEnergyDataCallback.fillRailDataStats(this.mTmpRailStats);
    }

    public void updateKernelWakelocksLocked() {
        KernelWakelockStats wakelockStats = this.mKernelWakelockReader.readKernelWakelockStats(this.mTmpWakelockStats);
        if (wakelockStats == null) {
            Slog.w(TAG, "Couldn't get kernel wake lock stats");
            return;
        }
        for (Map.Entry ent : wakelockStats.entrySet()) {
            String name = (String)ent.getKey();
            KernelWakelockStats.Entry kws = (KernelWakelockStats.Entry)ent.getValue();
            SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
            if (kwlt == null) {
                kwlt = new SamplingTimer(this.mClocks, this.mOnBatteryScreenOffTimeBase);
                this.mKernelWakelockStats.put(name, kwlt);
            }
            kwlt.update(kws.mTotalTime, kws.mCount);
            kwlt.setUpdateVersion(kws.mVersion);
        }
        int numWakelocksSetStale = 0;
        for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
            SamplingTimer st = ent.getValue();
            if (st.getUpdateVersion() == wakelockStats.kernelWakelockVersion) continue;
            st.endSample();
            ++numWakelocksSetStale;
        }
        if (wakelockStats.isEmpty()) {
            Slog.wtf(TAG, "All kernel wakelocks had time of zero");
        }
        if (numWakelocksSetStale == this.mKernelWakelockStats.size()) {
            Slog.wtf(TAG, "All kernel wakelocks were set stale. new version=" + wakelockStats.kernelWakelockVersion);
        }
    }

    public void updateKernelMemoryBandwidthLocked() {
        this.mKernelMemoryBandwidthStats.updateStats();
        LongSparseLongArray bandwidthEntries = this.mKernelMemoryBandwidthStats.getBandwidthEntries();
        int bandwidthEntryCount = bandwidthEntries.size();
        for (int i = 0; i < bandwidthEntryCount; ++i) {
            SamplingTimer timer;
            int index = this.mKernelMemoryStats.indexOfKey(bandwidthEntries.keyAt(i));
            if (index >= 0) {
                timer = this.mKernelMemoryStats.valueAt(index);
            } else {
                timer = new SamplingTimer(this.mClocks, this.mOnBatteryTimeBase);
                this.mKernelMemoryStats.put(bandwidthEntries.keyAt(i), timer);
            }
            timer.update(bandwidthEntries.valueAt(i), 1);
        }
    }

    public boolean isOnBatteryLocked() {
        return this.mOnBatteryTimeBase.isRunning();
    }

    public boolean isOnBatteryScreenOffLocked() {
        return this.mOnBatteryScreenOffTimeBase.isRunning();
    }

    @GuardedBy(value={"this"})
    public void updateCpuTimeLocked(boolean onBattery, boolean onBatteryScreenOff) {
        if (this.mPowerProfile == null) {
            return;
        }
        if (this.mCpuFreqs == null) {
            this.mCpuFreqs = this.mCpuUidFreqTimeReader.readFreqs(this.mPowerProfile);
        }
        ArrayList<StopwatchTimer> partialTimersToConsider = null;
        if (onBatteryScreenOff) {
            partialTimersToConsider = new ArrayList<StopwatchTimer>();
            for (int i = this.mPartialTimers.size() - 1; i >= 0; --i) {
                StopwatchTimer timer = this.mPartialTimers.get(i);
                if (!timer.mInList || timer.mUid == null || timer.mUid.mUid == 1000) continue;
                partialTimersToConsider.add(timer);
            }
        }
        this.markPartialTimersAsEligible();
        if (!onBattery) {
            this.mCpuUidUserSysTimeReader.readDelta(null);
            this.mCpuUidFreqTimeReader.readDelta(null);
            this.mNumAllUidCpuTimeReads += 2;
            if (this.mConstants.TRACK_CPU_ACTIVE_CLUSTER_TIME) {
                this.mCpuUidActiveTimeReader.readDelta(null);
                this.mCpuUidClusterTimeReader.readDelta(null);
                this.mNumAllUidCpuTimeReads += 2;
            }
            for (int cluster = this.mKernelCpuSpeedReaders.length - 1; cluster >= 0; --cluster) {
                this.mKernelCpuSpeedReaders[cluster].readDelta();
            }
            return;
        }
        this.mUserInfoProvider.refreshUserIds();
        SparseLongArray updatedUids = this.mCpuUidFreqTimeReader.perClusterTimesAvailable() ? null : new SparseLongArray();
        this.readKernelUidCpuTimesLocked(partialTimersToConsider, updatedUids, onBattery);
        if (updatedUids != null) {
            this.updateClusterSpeedTimes(updatedUids, onBattery);
        }
        this.readKernelUidCpuFreqTimesLocked(partialTimersToConsider, onBattery, onBatteryScreenOff);
        this.mNumAllUidCpuTimeReads += 2;
        if (this.mConstants.TRACK_CPU_ACTIVE_CLUSTER_TIME) {
            this.readKernelUidCpuActiveTimesLocked(onBattery);
            this.readKernelUidCpuClusterTimesLocked(onBattery);
            this.mNumAllUidCpuTimeReads += 2;
        }
    }

    @VisibleForTesting
    public void markPartialTimersAsEligible() {
        if (ArrayUtils.referenceEquals(this.mPartialTimers, this.mLastPartialTimers)) {
            for (int i = this.mPartialTimers.size() - 1; i >= 0; --i) {
                this.mPartialTimers.get((int)i).mInList = true;
            }
        } else {
            for (int i = this.mLastPartialTimers.size() - 1; i >= 0; --i) {
                this.mLastPartialTimers.get((int)i).mInList = false;
            }
            this.mLastPartialTimers.clear();
            int numPartialTimers = this.mPartialTimers.size();
            for (int i = 0; i < numPartialTimers; ++i) {
                StopwatchTimer timer = this.mPartialTimers.get(i);
                timer.mInList = true;
                this.mLastPartialTimers.add(timer);
            }
        }
    }

    @VisibleForTesting
    public void updateClusterSpeedTimes(SparseLongArray updatedUids, boolean onBattery) {
        long totalCpuClustersTimeMs = 0L;
        long[][] clusterSpeedTimesMs = new long[this.mKernelCpuSpeedReaders.length][];
        for (int cluster = 0; cluster < this.mKernelCpuSpeedReaders.length; ++cluster) {
            clusterSpeedTimesMs[cluster] = this.mKernelCpuSpeedReaders[cluster].readDelta();
            if (clusterSpeedTimesMs[cluster] == null) continue;
            for (int speed = clusterSpeedTimesMs[cluster].length - 1; speed >= 0; --speed) {
                totalCpuClustersTimeMs += clusterSpeedTimesMs[cluster][speed];
            }
        }
        if (totalCpuClustersTimeMs != 0L) {
            int updatedUidsCount = updatedUids.size();
            for (int i = 0; i < updatedUidsCount; ++i) {
                Uid u = this.getUidStatsLocked(updatedUids.keyAt(i));
                long appCpuTimeUs = updatedUids.valueAt(i);
                int numClusters = this.mPowerProfile.getNumCpuClusters();
                if (u.mCpuClusterSpeedTimesUs == null || u.mCpuClusterSpeedTimesUs.length != numClusters) {
                    u.mCpuClusterSpeedTimesUs = new LongSamplingCounter[numClusters][];
                }
                for (int cluster = 0; cluster < clusterSpeedTimesMs.length; ++cluster) {
                    int speedsInCluster = clusterSpeedTimesMs[cluster].length;
                    if (u.mCpuClusterSpeedTimesUs[cluster] == null || speedsInCluster != u.mCpuClusterSpeedTimesUs[cluster].length) {
                        u.mCpuClusterSpeedTimesUs[cluster] = new LongSamplingCounter[speedsInCluster];
                    }
                    LongSamplingCounter[] cpuSpeeds = u.mCpuClusterSpeedTimesUs[cluster];
                    for (int speed = 0; speed < speedsInCluster; ++speed) {
                        if (cpuSpeeds[speed] == null) {
                            cpuSpeeds[speed] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                        }
                        cpuSpeeds[speed].addCountLocked(appCpuTimeUs * clusterSpeedTimesMs[cluster][speed] / totalCpuClustersTimeMs, onBattery);
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public void readKernelUidCpuTimesLocked(ArrayList<StopwatchTimer> partialTimers, SparseLongArray updatedUids, boolean onBattery) {
        this.mTempTotalCpuSystemTimeUs = 0L;
        this.mTempTotalCpuUserTimeUs = 0L;
        int numWakelocks = partialTimers == null ? 0 : partialTimers.size();
        long startTimeMs = this.mClocks.uptimeMillis();
        this.mCpuUidUserSysTimeReader.readDelta((uid, timesUs) -> {
            long userTimeUs = timesUs[0];
            long systemTimeUs = timesUs[1];
            if (Process.isIsolated(uid = this.mapUid(uid))) {
                this.mCpuUidUserSysTimeReader.removeUid(uid);
                Slog.d(TAG, "Got readings for an isolated uid with no mapping: " + uid);
                return;
            }
            if (!this.mUserInfoProvider.exists(UserHandle.getUserId(uid))) {
                Slog.d(TAG, "Got readings for an invalid user's uid " + uid);
                this.mCpuUidUserSysTimeReader.removeUid(uid);
                return;
            }
            Uid u = this.getUidStatsLocked(uid);
            this.mTempTotalCpuUserTimeUs += userTimeUs;
            this.mTempTotalCpuSystemTimeUs += systemTimeUs;
            StringBuilder sb = null;
            if (numWakelocks > 0) {
                userTimeUs = userTimeUs * 50L / 100L;
                systemTimeUs = systemTimeUs * 50L / 100L;
            }
            if (sb != null) {
                sb.append("  adding to uid=").append(u.mUid).append(": u=");
                TimeUtils.formatDuration(userTimeUs / 1000L, sb);
                sb.append(" s=");
                TimeUtils.formatDuration(systemTimeUs / 1000L, sb);
                Slog.d(TAG, sb.toString());
            }
            u.mUserCpuTime.addCountLocked(userTimeUs, onBattery);
            u.mSystemCpuTime.addCountLocked(systemTimeUs, onBattery);
            if (updatedUids != null) {
                updatedUids.put(u.getUid(), userTimeUs + systemTimeUs);
            }
        });
        long elapsedTimeMs = this.mClocks.uptimeMillis() - startTimeMs;
        if (elapsedTimeMs >= 100L) {
            Slog.d(TAG, "Reading cpu stats took " + elapsedTimeMs + "ms");
        }
        if (numWakelocks > 0) {
            this.mTempTotalCpuUserTimeUs = this.mTempTotalCpuUserTimeUs * 50L / 100L;
            this.mTempTotalCpuSystemTimeUs = this.mTempTotalCpuSystemTimeUs * 50L / 100L;
            for (int i = 0; i < numWakelocks; ++i) {
                StopwatchTimer timer = partialTimers.get(i);
                int userTimeUs = (int)(this.mTempTotalCpuUserTimeUs / (long)(numWakelocks - i));
                int systemTimeUs = (int)(this.mTempTotalCpuSystemTimeUs / (long)(numWakelocks - i));
                timer.mUid.mUserCpuTime.addCountLocked(userTimeUs, onBattery);
                timer.mUid.mSystemCpuTime.addCountLocked(systemTimeUs, onBattery);
                if (updatedUids != null) {
                    int uid2 = timer.mUid.getUid();
                    updatedUids.put(uid2, updatedUids.get(uid2, 0L) + (long)userTimeUs + (long)systemTimeUs);
                }
                Uid.Proc proc = timer.mUid.getProcessStatsLocked("*wakelock*");
                proc.addCpuTimeLocked(userTimeUs / 1000, systemTimeUs / 1000, onBattery);
                this.mTempTotalCpuUserTimeUs -= (long)userTimeUs;
                this.mTempTotalCpuSystemTimeUs -= (long)systemTimeUs;
            }
        }
    }

    @VisibleForTesting
    public void readKernelUidCpuFreqTimesLocked(ArrayList<StopwatchTimer> partialTimers, boolean onBattery, boolean onBatteryScreenOff) {
        boolean perClusterTimesAvailable = this.mCpuUidFreqTimeReader.perClusterTimesAvailable();
        int numWakelocks = partialTimers == null ? 0 : partialTimers.size();
        int numClusters = this.mPowerProfile.getNumCpuClusters();
        this.mWakeLockAllocationsUs = null;
        long startTimeMs = this.mClocks.uptimeMillis();
        this.mCpuUidFreqTimeReader.readDelta((uid, cpuFreqTimeMs) -> {
            if (Process.isIsolated(uid = this.mapUid(uid))) {
                this.mCpuUidFreqTimeReader.removeUid(uid);
                Slog.d(TAG, "Got freq readings for an isolated uid with no mapping: " + uid);
                return;
            }
            if (!this.mUserInfoProvider.exists(UserHandle.getUserId(uid))) {
                Slog.d(TAG, "Got freq readings for an invalid user's uid " + uid);
                this.mCpuUidFreqTimeReader.removeUid(uid);
                return;
            }
            Uid u = this.getUidStatsLocked(uid);
            if (u.mCpuFreqTimeMs == null || u.mCpuFreqTimeMs.getSize() != ((long[])cpuFreqTimeMs).length) {
                BatteryStatsImpl.detachIfNotNull(u.mCpuFreqTimeMs);
                u.mCpuFreqTimeMs = new LongSamplingCounterArray(this.mOnBatteryTimeBase);
            }
            u.mCpuFreqTimeMs.addCountLocked((long[])cpuFreqTimeMs, onBattery);
            if (u.mScreenOffCpuFreqTimeMs == null || u.mScreenOffCpuFreqTimeMs.getSize() != ((long[])cpuFreqTimeMs).length) {
                BatteryStatsImpl.detachIfNotNull(u.mScreenOffCpuFreqTimeMs);
                u.mScreenOffCpuFreqTimeMs = new LongSamplingCounterArray(this.mOnBatteryScreenOffTimeBase);
            }
            u.mScreenOffCpuFreqTimeMs.addCountLocked((long[])cpuFreqTimeMs, onBatteryScreenOff);
            if (perClusterTimesAvailable) {
                if (u.mCpuClusterSpeedTimesUs == null || u.mCpuClusterSpeedTimesUs.length != numClusters) {
                    BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs);
                    u.mCpuClusterSpeedTimesUs = new LongSamplingCounter[numClusters][];
                }
                if (numWakelocks > 0 && this.mWakeLockAllocationsUs == null) {
                    this.mWakeLockAllocationsUs = new long[numClusters][];
                }
                int freqIndex = 0;
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    int speedsInCluster = this.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster);
                    if (u.mCpuClusterSpeedTimesUs[cluster] == null || u.mCpuClusterSpeedTimesUs[cluster].length != speedsInCluster) {
                        BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs[cluster]);
                        u.mCpuClusterSpeedTimesUs[cluster] = new LongSamplingCounter[speedsInCluster];
                    }
                    if (numWakelocks > 0 && this.mWakeLockAllocationsUs[cluster] == null) {
                        this.mWakeLockAllocationsUs[cluster] = new long[speedsInCluster];
                    }
                    LongSamplingCounter[] cpuTimesUs = u.mCpuClusterSpeedTimesUs[cluster];
                    for (int speed = 0; speed < speedsInCluster; ++speed) {
                        long appAllocationUs;
                        if (cpuTimesUs[speed] == null) {
                            cpuTimesUs[speed] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                        }
                        if (this.mWakeLockAllocationsUs != null) {
                            appAllocationUs = cpuFreqTimeMs[freqIndex] * 1000L * 50L / 100L;
                            long[] lArray = this.mWakeLockAllocationsUs[cluster];
                            int n = speed;
                            lArray[n] = lArray[n] + (cpuFreqTimeMs[freqIndex] * 1000L - appAllocationUs);
                        } else {
                            appAllocationUs = cpuFreqTimeMs[freqIndex] * 1000L;
                        }
                        cpuTimesUs[speed].addCountLocked(appAllocationUs, onBattery);
                        ++freqIndex;
                    }
                }
            }
        });
        long elapsedTimeMs = this.mClocks.uptimeMillis() - startTimeMs;
        if (elapsedTimeMs >= 100L) {
            Slog.d(TAG, "Reading cpu freq times took " + elapsedTimeMs + "ms");
        }
        if (this.mWakeLockAllocationsUs != null) {
            for (int i = 0; i < numWakelocks; ++i) {
                Uid u = partialTimers.get((int)i).mUid;
                if (u.mCpuClusterSpeedTimesUs == null || u.mCpuClusterSpeedTimesUs.length != numClusters) {
                    BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs);
                    u.mCpuClusterSpeedTimesUs = new LongSamplingCounter[numClusters][];
                }
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    int speedsInCluster = this.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster);
                    if (u.mCpuClusterSpeedTimesUs[cluster] == null || u.mCpuClusterSpeedTimesUs[cluster].length != speedsInCluster) {
                        BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs[cluster]);
                        u.mCpuClusterSpeedTimesUs[cluster] = new LongSamplingCounter[speedsInCluster];
                    }
                    LongSamplingCounter[] cpuTimeUs = u.mCpuClusterSpeedTimesUs[cluster];
                    int speed = 0;
                    while (speed < speedsInCluster) {
                        if (cpuTimeUs[speed] == null) {
                            cpuTimeUs[speed] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                        }
                        long allocationUs = this.mWakeLockAllocationsUs[cluster][speed] / (long)(numWakelocks - i);
                        cpuTimeUs[speed].addCountLocked(allocationUs, onBattery);
                        long[] lArray = this.mWakeLockAllocationsUs[cluster];
                        int n = speed++;
                        lArray[n] = lArray[n] - allocationUs;
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public void readKernelUidCpuActiveTimesLocked(boolean onBattery) {
        long startTimeMs = this.mClocks.uptimeMillis();
        this.mCpuUidActiveTimeReader.readDelta((uid, cpuActiveTimesMs) -> {
            if (Process.isIsolated(uid = this.mapUid(uid))) {
                this.mCpuUidActiveTimeReader.removeUid(uid);
                Slog.w(TAG, "Got active times for an isolated uid with no mapping: " + uid);
                return;
            }
            if (!this.mUserInfoProvider.exists(UserHandle.getUserId(uid))) {
                Slog.w(TAG, "Got active times for an invalid user's uid " + uid);
                this.mCpuUidActiveTimeReader.removeUid(uid);
                return;
            }
            Uid u = this.getUidStatsLocked(uid);
            u.mCpuActiveTimeMs.addCountLocked((long)cpuActiveTimesMs, onBattery);
        });
        long elapsedTimeMs = this.mClocks.uptimeMillis() - startTimeMs;
        if (elapsedTimeMs >= 100L) {
            Slog.d(TAG, "Reading cpu active times took " + elapsedTimeMs + "ms");
        }
    }

    @VisibleForTesting
    public void readKernelUidCpuClusterTimesLocked(boolean onBattery) {
        long startTimeMs = this.mClocks.uptimeMillis();
        this.mCpuUidClusterTimeReader.readDelta((uid, cpuClusterTimesMs) -> {
            if (Process.isIsolated(uid = this.mapUid(uid))) {
                this.mCpuUidClusterTimeReader.removeUid(uid);
                Slog.w(TAG, "Got cluster times for an isolated uid with no mapping: " + uid);
                return;
            }
            if (!this.mUserInfoProvider.exists(UserHandle.getUserId(uid))) {
                Slog.w(TAG, "Got cluster times for an invalid user's uid " + uid);
                this.mCpuUidClusterTimeReader.removeUid(uid);
                return;
            }
            Uid u = this.getUidStatsLocked(uid);
            u.mCpuClusterTimesMs.addCountLocked((long[])cpuClusterTimesMs, onBattery);
        });
        long elapsedTimeMs = this.mClocks.uptimeMillis() - startTimeMs;
        if (elapsedTimeMs >= 100L) {
            Slog.d(TAG, "Reading cpu cluster times took " + elapsedTimeMs + "ms");
        }
    }

    boolean setChargingLocked(boolean charging) {
        this.mHandler.removeCallbacks(this.mDeferSetCharging);
        if (this.mCharging != charging) {
            this.mCharging = charging;
            this.mHistoryCur.states2 = charging ? (this.mHistoryCur.states2 |= 0x1000000) : (this.mHistoryCur.states2 &= 0xFEFFFFFF);
            this.mHandler.sendEmptyMessage(3);
            return true;
        }
        return false;
    }

    @GuardedBy(value={"this"})
    protected void setOnBatteryLocked(long mSecRealtime, long mSecUptime, boolean onBattery, int oldStatus, int level, int chargeUAh) {
        boolean doWrite = false;
        Message m = this.mHandler.obtainMessage(2);
        m.arg1 = onBattery ? 1 : 0;
        this.mHandler.sendMessage(m);
        long uptime = mSecUptime * 1000L;
        long realtime = mSecRealtime * 1000L;
        int screenState = this.mScreenState;
        if (onBattery) {
            boolean reset = false;
            if (!this.mNoAutoReset && (oldStatus == 5 || level >= 90 || this.mDischargeCurrentLevel < 20 && level >= 80)) {
                Slog.i(TAG, "Resetting battery stats: level=" + level + " status=" + oldStatus + " dischargeLevel=" + this.mDischargeCurrentLevel + " lowAmount=" + this.getLowDischargeAmountSinceCharge() + " highAmount=" + this.getHighDischargeAmountSinceCharge());
                if (this.getLowDischargeAmountSinceCharge() >= 20) {
                    long startTime = SystemClock.uptimeMillis();
                    final Parcel parcel = Parcel.obtain();
                    this.writeSummaryToParcel(parcel, true);
                    final long initialTime = SystemClock.uptimeMillis() - startTime;
                    BackgroundThread.getHandler().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            AtomicFile atomicFile = BatteryStatsImpl.this.mCheckinFile;
                            synchronized (atomicFile) {
                                long startTime2 = SystemClock.uptimeMillis();
                                FileOutputStream stream = null;
                                try {
                                    stream = BatteryStatsImpl.this.mCheckinFile.startWrite();
                                    stream.write(parcel.marshall());
                                    stream.flush();
                                    BatteryStatsImpl.this.mCheckinFile.finishWrite(stream);
                                    EventLogTags.writeCommitSysConfigFile("batterystats-checkin", initialTime + SystemClock.uptimeMillis() - startTime2);
                                }
                                catch (IOException e) {
                                    Slog.w("BatteryStats", "Error writing checkin battery statistics", e);
                                    BatteryStatsImpl.this.mCheckinFile.failWrite(stream);
                                }
                                finally {
                                    parcel.recycle();
                                }
                            }
                        }
                    });
                }
                doWrite = true;
                this.resetAllStatsLocked();
                if (chargeUAh > 0 && level > 0) {
                    this.mEstimatedBatteryCapacity = (int)((double)(chargeUAh / 1000) / ((double)level / 100.0));
                }
                this.mDischargeStartLevel = level;
                reset = true;
                this.mDischargeStepTracker.init();
            }
            if (this.mCharging) {
                this.setChargingLocked(false);
            }
            this.mLastChargingStateLevel = level;
            this.mOnBatteryInternal = true;
            this.mOnBattery = true;
            this.mLastDischargeStepLevel = level;
            this.mMinDischargeStepLevel = level;
            this.mDischargeStepTracker.clearTime();
            this.mDailyDischargeStepTracker.clearTime();
            this.mInitStepMode = this.mCurStepMode;
            this.mModStepMode = 0;
            this.pullPendingStateUpdatesLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states &= 0xFFF7FFFF;
            if (reset) {
                this.mRecordingHistory = true;
                this.startRecordingHistory(mSecRealtime, mSecUptime, reset);
            }
            this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
            this.mDischargeCurrentLevel = this.mDischargeUnplugLevel = level;
            if (this.isScreenOn(screenState)) {
                this.mDischargeScreenOnUnplugLevel = level;
                this.mDischargeScreenDozeUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else if (this.isScreenDoze(screenState)) {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenDozeUnplugLevel = level;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenDozeUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = level;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenDoze = 0;
            this.mDischargeAmountScreenOff = 0;
            this.updateTimeBasesLocked(true, screenState, uptime, realtime);
        } else {
            this.mLastChargingStateLevel = level;
            this.mOnBatteryInternal = false;
            this.mOnBattery = false;
            this.pullPendingStateUpdatesLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states |= 0x80000;
            this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
            this.mDischargeCurrentLevel = this.mDischargePlugLevel = level;
            if (level < this.mDischargeUnplugLevel) {
                this.mLowDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level - 1;
                this.mHighDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level;
            }
            this.updateDischargeScreenLevelsLocked(screenState, screenState);
            this.updateTimeBasesLocked(false, screenState, uptime, realtime);
            this.mChargeStepTracker.init();
            this.mLastChargeStepLevel = level;
            this.mMaxChargeStepLevel = level;
            this.mInitStepMode = this.mCurStepMode;
            this.mModStepMode = 0;
        }
        if ((doWrite || this.mLastWriteTime + 60000L < mSecRealtime) && this.mStatsFile != null && this.mBatteryStatsHistory.getActiveFile() != null) {
            this.writeAsyncLocked();
        }
    }

    private void startRecordingHistory(long elapsedRealtimeMs, long uptimeMs, boolean reset) {
        this.mRecordingHistory = true;
        this.mHistoryCur.currentTime = System_Delegate.currentTimeMillis();
        this.addHistoryBufferLocked(elapsedRealtimeMs, reset ? (byte)7 : 5, this.mHistoryCur);
        this.mHistoryCur.currentTime = 0L;
        if (reset) {
            this.initActiveHistoryEventsLocked(elapsedRealtimeMs, uptimeMs);
        }
    }

    private void recordCurrentTimeChangeLocked(long currentTime, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mRecordingHistory) {
            this.mHistoryCur.currentTime = currentTime;
            this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)5, this.mHistoryCur);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    private void recordShutdownLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mRecordingHistory) {
            this.mHistoryCur.currentTime = System_Delegate.currentTimeMillis();
            this.addHistoryBufferLocked(elapsedRealtimeMs, (byte)8, this.mHistoryCur);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    private void scheduleSyncExternalStatsLocked(String reason, int updateFlags) {
        if (this.mExternalSync != null) {
            this.mExternalSync.scheduleSync(reason, updateFlags);
        }
    }

    @GuardedBy(value={"this"})
    public void setBatteryStateLocked(int status, int health, int plugType, int level, int temp, int volt, int chargeUAh, int chargeFullUAh, long chargeTimeToFullSeconds) {
        temp = Math.max(0, temp);
        this.reportChangesToStatsLog(this.mHaveBatteryLevel ? this.mHistoryCur : null, status, plugType, level);
        boolean onBattery = BatteryStatsImpl.isOnBattery(plugType, status);
        long uptime = this.mClocks.uptimeMillis();
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        if (!this.mHaveBatteryLevel) {
            this.mHaveBatteryLevel = true;
            if (onBattery == this.mOnBattery) {
                this.mHistoryCur.states = onBattery ? (this.mHistoryCur.states &= 0xFFF7FFFF) : (this.mHistoryCur.states |= 0x80000);
            }
            this.mHistoryCur.states2 |= 0x1000000;
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.batteryChargeUAh = chargeUAh;
            this.mLastChargeStepLevel = this.mLastDischargeStepLevel = level;
            this.mMinDischargeStepLevel = this.mLastDischargeStepLevel;
            this.mMaxChargeStepLevel = this.mLastDischargeStepLevel;
            this.mLastChargingStateLevel = level;
        } else if (this.mCurrentBatteryLevel != level || this.mOnBattery != onBattery) {
            this.recordDailyStatsIfNeededLocked(level >= 100 && onBattery);
        }
        byte oldStatus = this.mHistoryCur.batteryStatus;
        if (onBattery) {
            this.mDischargeCurrentLevel = level;
            if (!this.mRecordingHistory) {
                this.mRecordingHistory = true;
                this.startRecordingHistory(elapsedRealtime, uptime, true);
            }
        } else if (level < 96 && status != 1 && !this.mRecordingHistory) {
            this.mRecordingHistory = true;
            this.startRecordingHistory(elapsedRealtime, uptime, true);
        }
        this.mCurrentBatteryLevel = level;
        if (this.mDischargePlugLevel < 0) {
            this.mDischargePlugLevel = level;
        }
        if (onBattery != this.mOnBattery) {
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryHealth = (byte)health;
            this.mHistoryCur.batteryPlugType = (byte)plugType;
            this.mHistoryCur.batteryTemperature = (short)temp;
            this.mHistoryCur.batteryVoltage = (char)volt;
            if (chargeUAh < this.mHistoryCur.batteryChargeUAh) {
                long chargeDiff = this.mHistoryCur.batteryChargeUAh - chargeUAh;
                this.mDischargeCounter.addCountLocked(chargeDiff);
                this.mDischargeScreenOffCounter.addCountLocked(chargeDiff);
                if (this.isScreenDoze(this.mScreenState)) {
                    this.mDischargeScreenDozeCounter.addCountLocked(chargeDiff);
                }
                if (this.mDeviceIdleMode == 1) {
                    this.mDischargeLightDozeCounter.addCountLocked(chargeDiff);
                } else if (this.mDeviceIdleMode == 2) {
                    this.mDischargeDeepDozeCounter.addCountLocked(chargeDiff);
                }
            }
            this.mHistoryCur.batteryChargeUAh = chargeUAh;
            this.setOnBatteryLocked(elapsedRealtime, uptime, onBattery, oldStatus, level, chargeUAh);
        } else {
            boolean changed = false;
            if (this.mHistoryCur.batteryLevel != level) {
                this.mHistoryCur.batteryLevel = (byte)level;
                changed = true;
                this.mExternalSync.scheduleSyncDueToBatteryLevelChange(this.mConstants.BATTERY_LEVEL_COLLECTION_DELAY_MS);
            }
            if (this.mHistoryCur.batteryStatus != status) {
                this.mHistoryCur.batteryStatus = (byte)status;
                changed = true;
            }
            if (this.mHistoryCur.batteryHealth != health) {
                this.mHistoryCur.batteryHealth = (byte)health;
                changed = true;
            }
            if (this.mHistoryCur.batteryPlugType != plugType) {
                this.mHistoryCur.batteryPlugType = (byte)plugType;
                changed = true;
            }
            if (temp >= this.mHistoryCur.batteryTemperature + 10 || temp <= this.mHistoryCur.batteryTemperature - 10) {
                this.mHistoryCur.batteryTemperature = (short)temp;
                changed = true;
            }
            if (volt > this.mHistoryCur.batteryVoltage + 20 || volt < this.mHistoryCur.batteryVoltage - 20) {
                this.mHistoryCur.batteryVoltage = (char)volt;
                changed = true;
            }
            if (chargeUAh >= this.mHistoryCur.batteryChargeUAh + 10 || chargeUAh <= this.mHistoryCur.batteryChargeUAh - 10) {
                if (chargeUAh < this.mHistoryCur.batteryChargeUAh) {
                    long chargeDiff = this.mHistoryCur.batteryChargeUAh - chargeUAh;
                    this.mDischargeCounter.addCountLocked(chargeDiff);
                    this.mDischargeScreenOffCounter.addCountLocked(chargeDiff);
                    if (this.isScreenDoze(this.mScreenState)) {
                        this.mDischargeScreenDozeCounter.addCountLocked(chargeDiff);
                    }
                    if (this.mDeviceIdleMode == 1) {
                        this.mDischargeLightDozeCounter.addCountLocked(chargeDiff);
                    } else if (this.mDeviceIdleMode == 2) {
                        this.mDischargeDeepDozeCounter.addCountLocked(chargeDiff);
                    }
                }
                this.mHistoryCur.batteryChargeUAh = chargeUAh;
                changed = true;
            }
            long modeBits = (long)this.mInitStepMode << 48 | (long)this.mModStepMode << 56 | (long)(level & 0xFF) << 40;
            if (onBattery) {
                changed |= this.setChargingLocked(false);
                if (this.mLastDischargeStepLevel != level && this.mMinDischargeStepLevel > level) {
                    this.mDischargeStepTracker.addLevelSteps(this.mLastDischargeStepLevel - level, modeBits, elapsedRealtime);
                    this.mDailyDischargeStepTracker.addLevelSteps(this.mLastDischargeStepLevel - level, modeBits, elapsedRealtime);
                    this.mLastDischargeStepLevel = level;
                    this.mMinDischargeStepLevel = level;
                    this.mInitStepMode = this.mCurStepMode;
                    this.mModStepMode = 0;
                }
            } else {
                if (level >= 90) {
                    changed |= this.setChargingLocked(true);
                } else if (!this.mCharging) {
                    if (this.mLastChargeStepLevel < level) {
                        if (!this.mHandler.hasCallbacks(this.mDeferSetCharging)) {
                            this.mHandler.postDelayed(this.mDeferSetCharging, this.mConstants.BATTERY_CHARGED_DELAY_MS);
                        }
                    } else if (this.mLastChargeStepLevel > level) {
                        this.mHandler.removeCallbacks(this.mDeferSetCharging);
                    }
                } else if (this.mLastChargeStepLevel > level) {
                    changed |= this.setChargingLocked(false);
                }
                if (this.mLastChargeStepLevel != level && this.mMaxChargeStepLevel < level) {
                    this.mChargeStepTracker.addLevelSteps(level - this.mLastChargeStepLevel, modeBits, elapsedRealtime);
                    this.mDailyChargeStepTracker.addLevelSteps(level - this.mLastChargeStepLevel, modeBits, elapsedRealtime);
                    this.mMaxChargeStepLevel = level;
                    this.mInitStepMode = this.mCurStepMode;
                    this.mModStepMode = 0;
                }
                this.mLastChargeStepLevel = level;
            }
            if (changed) {
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            }
        }
        if (!(onBattery || status != 5 && status != 1)) {
            this.mRecordingHistory = false;
        }
        this.mMinLearnedBatteryCapacity = this.mMinLearnedBatteryCapacity == -1 ? chargeFullUAh : Math.min(this.mMinLearnedBatteryCapacity, chargeFullUAh);
        this.mMaxLearnedBatteryCapacity = Math.max(this.mMaxLearnedBatteryCapacity, chargeFullUAh);
        this.mBatteryTimeToFullSeconds = chargeTimeToFullSeconds;
    }

    public static boolean isOnBattery(int plugType, int status) {
        return plugType == 0 && status != 1;
    }

    private void reportChangesToStatsLog(BatteryStats.HistoryItem recentPast, int status, int plugType, int level) {
        if (recentPast == null || recentPast.batteryStatus != status) {
            FrameworkStatsLog.write(31, status);
        }
        if (recentPast == null || recentPast.batteryPlugType != plugType) {
            FrameworkStatsLog.write(32, plugType);
        }
        if (recentPast == null || recentPast.batteryLevel != level) {
            FrameworkStatsLog.write(30, level);
        }
    }

    @UnsupportedAppUsage
    public long getAwakeTimeBattery() {
        return this.getBatteryUptimeLocked();
    }

    @UnsupportedAppUsage
    public long getAwakeTimePlugged() {
        return this.mClocks.uptimeMillis() * 1000L - this.getAwakeTimeBattery();
    }

    @Override
    public long computeUptime(long curTime, int which) {
        return this.mUptime + (curTime - this.mUptimeStart);
    }

    @Override
    public long computeRealtime(long curTime, int which) {
        return this.mRealtime + (curTime - this.mRealtimeStart);
    }

    @Override
    @UnsupportedAppUsage
    public long computeBatteryUptime(long curTime, int which) {
        return this.mOnBatteryTimeBase.computeUptime(curTime, which);
    }

    @Override
    @UnsupportedAppUsage
    public long computeBatteryRealtime(long curTime, int which) {
        return this.mOnBatteryTimeBase.computeRealtime(curTime, which);
    }

    @Override
    public long computeBatteryScreenOffUptime(long curTime, int which) {
        return this.mOnBatteryScreenOffTimeBase.computeUptime(curTime, which);
    }

    @Override
    public long computeBatteryScreenOffRealtime(long curTime, int which) {
        return this.mOnBatteryScreenOffTimeBase.computeRealtime(curTime, which);
    }

    private long computeTimePerLevel(long[] steps, int numSteps) {
        if (numSteps <= 0) {
            return -1L;
        }
        long total = 0L;
        for (int i = 0; i < numSteps; ++i) {
            total += steps[i] & 0xFFFFFFFFFFL;
        }
        return total / (long)numSteps;
    }

    @Override
    @UnsupportedAppUsage
    public long computeBatteryTimeRemaining(long curTime) {
        if (!this.mOnBattery) {
            return -1L;
        }
        if (this.mDischargeStepTracker.mNumStepDurations < 1) {
            return -1L;
        }
        long msPerLevel = this.mDischargeStepTracker.computeTimePerLevel();
        if (msPerLevel <= 0L) {
            return -1L;
        }
        return msPerLevel * (long)this.mCurrentBatteryLevel * 1000L;
    }

    @Override
    public BatteryStats.LevelStepTracker getDischargeLevelStepTracker() {
        return this.mDischargeStepTracker;
    }

    @Override
    public BatteryStats.LevelStepTracker getDailyDischargeLevelStepTracker() {
        return this.mDailyDischargeStepTracker;
    }

    @Override
    public long computeChargeTimeRemaining(long curTime) {
        if (this.mOnBattery) {
            return -1L;
        }
        if (this.mBatteryTimeToFullSeconds >= 0L) {
            return this.mBatteryTimeToFullSeconds * 1000000L;
        }
        if (this.mChargeStepTracker.mNumStepDurations < 1) {
            return -1L;
        }
        long msPerLevel = this.mChargeStepTracker.computeTimePerLevel();
        if (msPerLevel <= 0L) {
            return -1L;
        }
        return msPerLevel * (long)(100 - this.mCurrentBatteryLevel) * 1000L;
    }

    public CellularBatteryStats getCellularBatteryStats() {
        boolean which = false;
        long rawRealTime = SystemClock.elapsedRealtime() * 1000L;
        BatteryStats.ControllerActivityCounter counter = this.getModemControllerActivity();
        long sleepTimeMs = counter.getSleepTimeCounter().getCountLocked(0);
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(0);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(0);
        long energyConsumedMaMs = counter.getPowerCounter().getCountLocked(0);
        long monitoredRailChargeConsumedMaMs = counter.getMonitoredRailChargeConsumedMaMs().getCountLocked(0);
        long[] timeInRatMs = new long[BatteryStats.NUM_DATA_CONNECTION_TYPES];
        for (int i = 0; i < timeInRatMs.length; ++i) {
            timeInRatMs[i] = this.getPhoneDataConnectionTime(i, rawRealTime, 0) / 1000L;
        }
        long[] timeInRxSignalStrengthLevelMs = new long[CellSignalStrength.getNumSignalStrengthLevels()];
        for (int i = 0; i < timeInRxSignalStrengthLevelMs.length; ++i) {
            timeInRxSignalStrengthLevelMs[i] = this.getPhoneSignalStrengthTime(i, rawRealTime, 0) / 1000L;
        }
        long[] txTimeMs = new long[Math.min(5, counter.getTxTimeCounters().length)];
        long totalTxTimeMs = 0L;
        for (int i = 0; i < txTimeMs.length; ++i) {
            txTimeMs[i] = counter.getTxTimeCounters()[i].getCountLocked(0);
            totalTxTimeMs += txTimeMs[i];
        }
        return new CellularBatteryStats(this.computeBatteryRealtime(rawRealTime, 0) / 1000L, this.getMobileRadioActiveTime(rawRealTime, 0) / 1000L, this.getNetworkActivityPackets(1, 0), this.getNetworkActivityBytes(1, 0), this.getNetworkActivityPackets(0, 0), this.getNetworkActivityBytes(0, 0), sleepTimeMs, idleTimeMs, rxTimeMs, energyConsumedMaMs, timeInRatMs, timeInRxSignalStrengthLevelMs, txTimeMs, monitoredRailChargeConsumedMaMs);
    }

    public WifiBatteryStats getWifiBatteryStats() {
        boolean which = false;
        long rawRealTime = SystemClock.elapsedRealtime() * 1000L;
        BatteryStats.ControllerActivityCounter counter = this.getWifiControllerActivity();
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(0);
        long scanTimeMs = counter.getScanTimeCounter().getCountLocked(0);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(0);
        long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(0);
        long totalControllerActivityTimeMs = this.computeBatteryRealtime(SystemClock.elapsedRealtime() * 1000L, 0) / 1000L;
        long sleepTimeMs = totalControllerActivityTimeMs - (idleTimeMs + rxTimeMs + txTimeMs);
        long energyConsumedMaMs = counter.getPowerCounter().getCountLocked(0);
        long monitoredRailChargeConsumedMaMs = counter.getMonitoredRailChargeConsumedMaMs().getCountLocked(0);
        long numAppScanRequest = 0L;
        for (int i = 0; i < this.mUidStats.size(); ++i) {
            numAppScanRequest += (long)this.mUidStats.valueAt((int)i).mWifiScanTimer.getCountLocked(0);
        }
        long[] timeInStateMs = new long[8];
        for (int i = 0; i < 8; ++i) {
            timeInStateMs[i] = this.getWifiStateTime(i, rawRealTime, 0) / 1000L;
        }
        long[] timeInSupplStateMs = new long[13];
        for (int i = 0; i < 13; ++i) {
            timeInSupplStateMs[i] = this.getWifiSupplStateTime(i, rawRealTime, 0) / 1000L;
        }
        long[] timeSignalStrengthTimeMs = new long[5];
        for (int i = 0; i < 5; ++i) {
            timeSignalStrengthTimeMs[i] = this.getWifiSignalStrengthTime(i, rawRealTime, 0) / 1000L;
        }
        return new WifiBatteryStats(this.computeBatteryRealtime(rawRealTime, 0) / 1000L, this.getWifiActiveTime(rawRealTime, 0) / 1000L, this.getNetworkActivityPackets(3, 0), this.getNetworkActivityBytes(3, 0), this.getNetworkActivityPackets(2, 0), this.getNetworkActivityBytes(2, 0), sleepTimeMs, scanTimeMs, idleTimeMs, rxTimeMs, txTimeMs, energyConsumedMaMs, numAppScanRequest, timeInStateMs, timeSignalStrengthTimeMs, timeInSupplStateMs, monitoredRailChargeConsumedMaMs);
    }

    public GpsBatteryStats getGpsBatteryStats() {
        GpsBatteryStats s = new GpsBatteryStats();
        boolean which = false;
        long rawRealTime = SystemClock.elapsedRealtime() * 1000L;
        s.setLoggingDurationMs(this.computeBatteryRealtime(rawRealTime, 0) / 1000L);
        s.setEnergyConsumedMaMs(this.getGpsBatteryDrainMaMs());
        long[] time = new long[2];
        for (int i = 0; i < time.length; ++i) {
            time[i] = this.getGpsSignalQualityTime(i, rawRealTime, 0) / 1000L;
        }
        s.setTimeInGpsSignalQualityLevel(time);
        return s;
    }

    @Override
    public BatteryStats.LevelStepTracker getChargeLevelStepTracker() {
        return this.mChargeStepTracker;
    }

    @Override
    public BatteryStats.LevelStepTracker getDailyChargeLevelStepTracker() {
        return this.mDailyChargeStepTracker;
    }

    @Override
    public ArrayList<BatteryStats.PackageChange> getDailyPackageChanges() {
        return this.mDailyPackageChanges;
    }

    protected long getBatteryUptimeLocked() {
        return this.mOnBatteryTimeBase.getUptime(this.mClocks.uptimeMillis() * 1000L);
    }

    @Override
    public long getBatteryUptime(long curTime) {
        return this.mOnBatteryTimeBase.getUptime(curTime);
    }

    @Override
    @UnsupportedAppUsage
    public long getBatteryRealtime(long curTime) {
        return this.mOnBatteryTimeBase.getRealtime(curTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public int getDischargeStartLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeStartLevelLocked();
        }
    }

    public int getDischargeStartLevelLocked() {
        return this.mDischargeUnplugLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public int getDischargeCurrentLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeCurrentLevelLocked();
        }
    }

    public int getDischargeCurrentLevelLocked() {
        return this.mDischargeCurrentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLowDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mLowDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel - 1;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHighDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mHighDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    @Override
    @UnsupportedAppUsage
    public int getDischargeAmount(int which) {
        int dischargeAmount;
        int n = dischargeAmount = which == 0 ? this.getHighDischargeAmountSinceCharge() : this.getDischargeStartLevel() - this.getDischargeCurrentLevel();
        if (dischargeAmount < 0) {
            dischargeAmount = 0;
        }
        return dischargeAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public int getDischargeAmountScreenOn() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOn;
            if (this.mOnBattery && this.isScreenOn(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOnSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOnSinceCharge;
            if (this.mOnBattery && this.isScreenOn(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public int getDischargeAmountScreenOff() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOff;
            if (this.mOnBattery && this.isScreenOff(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val + this.getDischargeAmountScreenDoze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOffSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOffSinceCharge;
            if (this.mOnBattery && this.isScreenOff(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val + this.getDischargeAmountScreenDozeSinceCharge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenDoze() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenDoze;
            if (this.mOnBattery && this.isScreenDoze(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenDozeUnplugLevel) {
                val += this.mDischargeScreenDozeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenDozeSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenDozeSinceCharge;
            if (this.mOnBattery && this.isScreenDoze(this.mScreenState) && this.mDischargeCurrentLevel < this.mDischargeScreenDozeUnplugLevel) {
                val += this.mDischargeScreenDozeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    @UnsupportedAppUsage
    public Uid getUidStatsLocked(int uid) {
        Uid u = this.mUidStats.get(uid);
        if (u == null) {
            u = new Uid(this, uid);
            this.mUidStats.put(uid, u);
        }
        return u;
    }

    public Uid getAvailableUidStatsLocked(int uid) {
        Uid u = this.mUidStats.get(uid);
        return u;
    }

    public void onCleanupUserLocked(int userId) {
        int firstUidForUser = UserHandle.getUid(userId, 0);
        int lastUidForUser = UserHandle.getUid(userId, 99999);
        this.mPendingRemovedUids.add(new UidToRemove(firstUidForUser, lastUidForUser, this.mClocks.elapsedRealtime()));
    }

    public void onUserRemovedLocked(int userId) {
        int firstUidForUser = UserHandle.getUid(userId, 0);
        int lastUidForUser = UserHandle.getUid(userId, 99999);
        this.mUidStats.put(firstUidForUser, null);
        this.mUidStats.put(lastUidForUser, null);
        int firstIndex = this.mUidStats.indexOfKey(firstUidForUser);
        int lastIndex = this.mUidStats.indexOfKey(lastUidForUser);
        for (int i = firstIndex; i <= lastIndex; ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            if (uid == null) continue;
            uid.detachFromTimeBase();
        }
        this.mUidStats.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    @UnsupportedAppUsage
    public void removeUidStatsLocked(int uid) {
        Uid u = this.mUidStats.get(uid);
        if (u != null) {
            u.detachFromTimeBase();
        }
        this.mUidStats.remove(uid);
        this.mPendingRemovedUids.add(new UidToRemove(uid, this.mClocks.elapsedRealtime()));
    }

    @UnsupportedAppUsage
    public Uid.Proc getProcessStatsLocked(int uid, String name) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid);
        return u.getProcessStatsLocked(name);
    }

    @UnsupportedAppUsage
    public Uid.Pkg getPackageStatsLocked(int uid, String pkg) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid);
        return u.getPackageStatsLocked(pkg);
    }

    @UnsupportedAppUsage
    public Uid.Pkg.Serv getServiceStatsLocked(int uid, String pkg, String name) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid);
        return u.getServiceStatsLocked(pkg, name);
    }

    public void shutdownLocked() {
        this.recordShutdownLocked(this.mClocks.elapsedRealtime(), this.mClocks.uptimeMillis());
        this.writeSyncLocked();
        this.mShuttingDown = true;
    }

    public boolean trackPerProcStateCpuTimes() {
        return this.mConstants.TRACK_CPU_TIMES_BY_PROC_STATE && this.mPerProcStateCpuTimesAvailable;
    }

    public void systemServicesReady(Context context) {
        this.mConstants.startObserving(context.getContentResolver());
        this.registerUsbStateReceiver(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExternalStatsCollectionRateLimitMs() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.mConstants.EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS;
        }
    }

    @GuardedBy(value={"this"})
    public void dumpConstantsLocked(PrintWriter pw) {
        this.mConstants.dumpLocked(pw);
    }

    @GuardedBy(value={"this"})
    public void dumpCpuStatsLocked(PrintWriter pw) {
        long[] times;
        Uid uid;
        int u;
        int i;
        int size = this.mUidStats.size();
        pw.println("Per UID CPU user & system time in ms:");
        for (i = 0; i < size; ++i) {
            u = this.mUidStats.keyAt(i);
            uid = this.mUidStats.get(u);
            pw.print("  ");
            pw.print(u);
            pw.print(": ");
            pw.print(uid.getUserCpuTimeUs(0) / 1000L);
            pw.print(" ");
            pw.println(uid.getSystemCpuTimeUs(0) / 1000L);
        }
        pw.println("Per UID CPU active time in ms:");
        for (i = 0; i < size; ++i) {
            u = this.mUidStats.keyAt(i);
            uid = this.mUidStats.get(u);
            if (uid.getCpuActiveTime() <= 0L) continue;
            pw.print("  ");
            pw.print(u);
            pw.print(": ");
            pw.println(uid.getCpuActiveTime());
        }
        pw.println("Per UID CPU cluster time in ms:");
        for (i = 0; i < size; ++i) {
            u = this.mUidStats.keyAt(i);
            times = this.mUidStats.get(u).getCpuClusterTimes();
            if (times == null) continue;
            pw.print("  ");
            pw.print(u);
            pw.print(": ");
            pw.println(Arrays.toString(times));
        }
        pw.println("Per UID CPU frequency time in ms:");
        for (i = 0; i < size; ++i) {
            u = this.mUidStats.keyAt(i);
            times = this.mUidStats.get(u).getCpuFreqTimes(0);
            if (times == null) continue;
            pw.print("  ");
            pw.print(u);
            pw.print(": ");
            pw.println(Arrays.toString(times));
        }
    }

    public void writeAsyncLocked() {
        this.writeStatsLocked(false);
        this.writeHistoryLocked(false);
    }

    public void writeSyncLocked() {
        this.writeStatsLocked(true);
        this.writeHistoryLocked(true);
    }

    void writeStatsLocked(boolean sync) {
        if (this.mStatsFile == null) {
            Slog.w(TAG, "writeStatsLocked: no file associated with this instance");
            return;
        }
        if (this.mShuttingDown) {
            return;
        }
        Parcel p = Parcel.obtain();
        long start = SystemClock.uptimeMillis();
        this.writeSummaryToParcel(p, false);
        this.mLastWriteTime = this.mClocks.elapsedRealtime();
        this.writeParcelToFileLocked(p, this.mStatsFile, sync);
    }

    void writeHistoryLocked(boolean sync) {
        if (this.mBatteryStatsHistory.getActiveFile() == null) {
            Slog.w(TAG, "writeHistoryLocked: no history file associated with this instance");
            return;
        }
        if (this.mShuttingDown) {
            return;
        }
        Parcel p = Parcel.obtain();
        long start = SystemClock.uptimeMillis();
        this.writeHistoryBuffer(p, true, true);
        this.writeParcelToFileLocked(p, this.mBatteryStatsHistory.getActiveFile(), sync);
    }

    void writeParcelToFileLocked(final Parcel p, final AtomicFile file, boolean sync) {
        if (sync) {
            this.commitPendingDataToDisk(p, file);
        } else {
            BackgroundThread.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    BatteryStatsImpl.this.commitPendingDataToDisk(p, file);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPendingDataToDisk(Parcel p, AtomicFile file) {
        this.mWriteLock.lock();
        FileOutputStream fos = null;
        try {
            long startTime = SystemClock.uptimeMillis();
            fos = file.startWrite();
            fos.write(p.marshall());
            fos.flush();
            file.finishWrite(fos);
            EventLogTags.writeCommitSysConfigFile("batterystats", SystemClock.uptimeMillis() - startTime);
        }
        catch (IOException e) {
            Slog.w(TAG, "Error writing battery statistics", e);
            file.failWrite(fos);
        }
        finally {
            p.recycle();
            this.mWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void readLocked() {
        if (this.mDailyFile != null) {
            this.readDailyStatsLocked();
        }
        if (this.mStatsFile == null) {
            Slog.w(TAG, "readLocked: no file associated with this instance");
            return;
        }
        AtomicFile activeHistoryFile = this.mBatteryStatsHistory.getActiveFile();
        if (activeHistoryFile == null) {
            Slog.w(TAG, "readLocked: no history file associated with this instance");
            return;
        }
        this.mUidStats.clear();
        Parcel stats = Parcel.obtain();
        try {
            long start = SystemClock.uptimeMillis();
            if (this.mStatsFile.exists()) {
                byte[] raw2 = this.mStatsFile.readFully();
                stats.unmarshall(raw2, 0, raw2.length);
                stats.setDataPosition(0);
                this.readSummaryFromParcel(stats);
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Error reading battery statistics", e);
            this.resetAllStatsLocked();
        }
        finally {
            stats.recycle();
        }
        Parcel history = Parcel.obtain();
        try {
            byte[] raw3;
            long start = SystemClock.uptimeMillis();
            if (activeHistoryFile.exists() && (raw3 = activeHistoryFile.readFully()).length > 0) {
                history.unmarshall(raw3, 0, raw3.length);
                history.setDataPosition(0);
                this.readHistoryBuffer(history, true);
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Error reading battery history", e);
            this.clearHistoryLocked();
            this.mBatteryStatsHistory.resetAllFiles();
        }
        finally {
            history.recycle();
        }
        this.mEndPlatformVersion = _Original_Build.ID;
        if (this.mHistoryBuffer.dataPosition() > 0 || this.mBatteryStatsHistory.getFilesNumbers().size() > 1) {
            this.mRecordingHistory = true;
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.addHistoryBufferLocked(elapsedRealtime, (byte)4, this.mHistoryCur);
            this.startRecordingHistory(elapsedRealtime, uptime, false);
        }
        this.recordDailyStatsIfNeededLocked(false);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    void readHistoryBuffer(Parcel in, boolean andOldHistory) throws ParcelFormatException {
        int version = in.readInt();
        if (version != 186) {
            Slog.w("BatteryStats", "readHistoryBuffer: version got " + version + ", expected " + 186 + "; erasing old stats");
            return;
        }
        long historyBaseTime = in.readLong();
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        int bufSize = in.readInt();
        int curPos = in.dataPosition();
        if (bufSize >= this.mConstants.MAX_HISTORY_BUFFER * 100) {
            throw new ParcelFormatException("File corrupt: history data buffer too large " + bufSize);
        }
        if ((bufSize & 0xFFFFFFFC) != bufSize) {
            throw new ParcelFormatException("File corrupt: history data buffer not aligned " + bufSize);
        }
        this.mHistoryBuffer.appendFrom(in, curPos, bufSize);
        in.setDataPosition(curPos + bufSize);
        if (andOldHistory) {
            this.readOldHistory(in);
        }
        this.mHistoryBaseTime = historyBaseTime;
        if (this.mHistoryBaseTime > 0L) {
            long oldnow = this.mClocks.elapsedRealtime();
            this.mHistoryBaseTime = this.mHistoryBaseTime - oldnow + 1L;
        }
    }

    void readOldHistory(Parcel in) {
    }

    void writeHistoryBuffer(Parcel out, boolean inclData, boolean andOldHistory) {
        out.writeInt(186);
        out.writeLong(this.mHistoryBaseTime + this.mLastHistoryElapsedRealtime);
        if (!inclData) {
            out.writeInt(0);
            out.writeInt(0);
            return;
        }
        out.writeInt(this.mHistoryBuffer.dataSize());
        out.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
        if (andOldHistory) {
            this.writeOldHistory(out);
        }
    }

    void writeOldHistory(Parcel out) {
    }

    public void readSummaryFromParcel(Parcel in) throws ParcelFormatException {
        int i;
        int NPKG;
        int version = in.readInt();
        if (version != 186) {
            Slog.w("BatteryStats", "readFromParcel: version got " + version + ", expected " + 186 + "; erasing old stats");
            return;
        }
        boolean inclHistory = in.readBoolean();
        if (inclHistory) {
            this.readHistoryBuffer(in, true);
            this.mBatteryStatsHistory.readFromParcel(in);
        }
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        int numTags = in.readInt();
        for (int i2 = 0; i2 < numTags; ++i2) {
            int idx = in.readInt();
            String str = in.readString();
            if (str == null) {
                throw new ParcelFormatException("null history tag string");
            }
            int uid = in.readInt();
            BatteryStats.HistoryTag tag = new BatteryStats.HistoryTag();
            tag.string = str;
            tag.uid = uid;
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(tag, idx);
            if (idx >= this.mNextHistoryTagIdx) {
                this.mNextHistoryTagIdx = idx + 1;
            }
            this.mNumHistoryTagChars += tag.string.length() + 1;
        }
        this.mStartCount = in.readInt();
        this.mUptime = in.readLong();
        this.mRealtime = in.readLong();
        this.mStartClockTime = in.readLong();
        this.mStartPlatformVersion = in.readString();
        this.mEndPlatformVersion = in.readString();
        this.mOnBatteryTimeBase.readSummaryFromParcel(in);
        this.mOnBatteryScreenOffTimeBase.readSummaryFromParcel(in);
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargePlugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mCurrentBatteryLevel = in.readInt();
        this.mEstimatedBatteryCapacity = in.readInt();
        this.mMinLearnedBatteryCapacity = in.readInt();
        this.mMaxLearnedBatteryCapacity = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        this.mDischargeAmountScreenDozeSinceCharge = in.readInt();
        this.mDischargeStepTracker.readFromParcel(in);
        this.mChargeStepTracker.readFromParcel(in);
        this.mDailyDischargeStepTracker.readFromParcel(in);
        this.mDailyChargeStepTracker.readFromParcel(in);
        this.mDischargeCounter.readSummaryFromParcelLocked(in);
        this.mDischargeScreenOffCounter.readSummaryFromParcelLocked(in);
        this.mDischargeScreenDozeCounter.readSummaryFromParcelLocked(in);
        this.mDischargeLightDozeCounter.readSummaryFromParcelLocked(in);
        this.mDischargeDeepDozeCounter.readSummaryFromParcelLocked(in);
        if (NPKG > 0) {
            this.mDailyPackageChanges = new ArrayList(NPKG);
            for (NPKG = in.readInt(); NPKG > 0; --NPKG) {
                BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
                pc.mPackageName = in.readString();
                pc.mUpdate = in.readInt() != 0;
                pc.mVersionCode = in.readLong();
                this.mDailyPackageChanges.add(pc);
            }
        } else {
            this.mDailyPackageChanges = null;
        }
        this.mDailyStartTime = in.readLong();
        this.mNextMinDailyDeadline = in.readLong();
        this.mNextMaxDailyDeadline = in.readLong();
        ++this.mStartCount;
        this.mScreenState = 0;
        this.mScreenOnTimer.readSummaryFromParcelLocked(in);
        this.mScreenDozeTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mInteractive = false;
        this.mInteractiveTimer.readSummaryFromParcelLocked(in);
        this.mPhoneOn = false;
        this.mPowerSaveModeEnabledTimer.readSummaryFromParcelLocked(in);
        this.mLongestLightIdleTime = in.readLong();
        this.mLongestFullIdleTime = in.readLong();
        this.mDeviceIdleModeLightTimer.readSummaryFromParcelLocked(in);
        this.mDeviceIdleModeFullTimer.readSummaryFromParcelLocked(in);
        this.mDeviceLightIdlingTimer.readSummaryFromParcelLocked(in);
        this.mDeviceIdlingTimer.readSummaryFromParcelLocked(in);
        this.mPhoneOnTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mPhoneSignalScanningTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i].readSummaryFromParcelLocked(in);
            this.mNetworkPacketActivityCounters[i].readSummaryFromParcelLocked(in);
        }
        this.mMobileRadioPowerState = 1;
        this.mMobileRadioActiveTimer.readSummaryFromParcelLocked(in);
        this.mMobileRadioActivePerAppTimer.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveAdjustedTime.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveUnknownTime.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveUnknownCount.readSummaryFromParcelLocked(in);
        this.mWifiMulticastWakelockTimer.readSummaryFromParcelLocked(in);
        this.mWifiRadioPowerState = 1;
        this.mWifiOn = false;
        this.mWifiOnTimer.readSummaryFromParcelLocked(in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mWifiActiveTimer.readSummaryFromParcelLocked(in);
        this.mWifiActivity.readSummaryFromParcel(in);
        for (i = 0; i < 2; ++i) {
            this.mGpsSignalQualityTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mBluetoothActivity.readSummaryFromParcel(in);
        this.mModemActivity.readSummaryFromParcel(in);
        this.mHasWifiReporting = in.readInt() != 0;
        this.mHasBluetoothReporting = in.readInt() != 0;
        this.mHasModemReporting = in.readInt() != 0;
        this.mNumConnectivityChange = in.readInt();
        this.mFlashlightOnNesting = 0;
        this.mFlashlightOnTimer.readSummaryFromParcelLocked(in);
        this.mCameraOnNesting = 0;
        this.mCameraOnTimer.readSummaryFromParcelLocked(in);
        this.mBluetoothScanNesting = 0;
        this.mBluetoothScanTimer.readSummaryFromParcelLocked(in);
        int NRPMS = in.readInt();
        if (NRPMS > 10000) {
            throw new ParcelFormatException("File corrupt: too many rpm stats " + NRPMS);
        }
        for (int irpm = 0; irpm < NRPMS; ++irpm) {
            if (in.readInt() == 0) continue;
            String rpmName = in.readString();
            this.getRpmTimerLocked(rpmName).readSummaryFromParcelLocked(in);
        }
        int NSORPMS = in.readInt();
        if (NSORPMS > 10000) {
            throw new ParcelFormatException("File corrupt: too many screen-off rpm stats " + NSORPMS);
        }
        for (int irpm = 0; irpm < NSORPMS; ++irpm) {
            if (in.readInt() == 0) continue;
            String rpmName = in.readString();
            this.getScreenOffRpmTimerLocked(rpmName).readSummaryFromParcelLocked(in);
        }
        int NKW = in.readInt();
        if (NKW > 10000) {
            throw new ParcelFormatException("File corrupt: too many kernel wake locks " + NKW);
        }
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String kwltName = in.readString();
            this.getKernelWakelockTimerLocked(kwltName).readSummaryFromParcelLocked(in);
        }
        int NWR = in.readInt();
        if (NWR > 10000) {
            throw new ParcelFormatException("File corrupt: too many wakeup reasons " + NWR);
        }
        for (int iwr = 0; iwr < NWR; ++iwr) {
            if (in.readInt() == 0) continue;
            String reasonName = in.readString();
            this.getWakeupReasonTimerLocked(reasonName).readSummaryFromParcelLocked(in);
        }
        int NMS = in.readInt();
        for (int ims = 0; ims < NMS; ++ims) {
            if (in.readInt() == 0) continue;
            long kmstName = in.readLong();
            this.getKernelMemoryTimerLocked(kmstName).readSummaryFromParcelLocked(in);
        }
        int NU = in.readInt();
        if (NU > 10000) {
            throw new ParcelFormatException("File corrupt: too many uids " + NU);
        }
        for (int iu = 0; iu < NU; ++iu) {
            TimeBaseObs p;
            int ip;
            int procState;
            int i3;
            int uid = in.readInt();
            Uid u = new Uid(this, uid);
            this.mUidStats.put(uid, u);
            u.mOnBatteryBackgroundTimeBase.readSummaryFromParcel(in);
            u.mOnBatteryScreenOffBackgroundTimeBase.readSummaryFromParcel(in);
            u.mWifiRunning = false;
            if (in.readInt() != 0) {
                u.mWifiRunningTimer.readSummaryFromParcelLocked(in);
            }
            u.mFullWifiLockOut = false;
            if (in.readInt() != 0) {
                u.mFullWifiLockTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiScanStarted = false;
            if (in.readInt() != 0) {
                u.mWifiScanTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiBatchedScanBinStarted = -1;
            for (i3 = 0; i3 < 5; ++i3) {
                if (in.readInt() == 0) continue;
                u.makeWifiBatchedScanBin(i3, null);
                u.mWifiBatchedScanTimer[i3].readSummaryFromParcelLocked(in);
            }
            u.mWifiMulticastWakelockCount = 0;
            if (in.readInt() != 0) {
                u.mWifiMulticastTimer.readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createAudioTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createVideoTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createFlashlightTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createCameraTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createForegroundActivityTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createForegroundServiceTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createAggregatedPartialWakelockTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createBluetoothScanTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createBluetoothUnoptimizedScanTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createBluetoothScanResultCounterLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createBluetoothScanResultBgCounterLocked().readSummaryFromParcelLocked(in);
            }
            u.mProcessState = 20;
            for (i3 = 0; i3 < 7; ++i3) {
                if (in.readInt() == 0) continue;
                u.makeProcessState(i3, null);
                u.mProcessStateTimer[i3].readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createVibratorOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                if (u.mUserActivityCounters == null) {
                    u.initUserActivityLocked();
                }
                for (i3 = 0; i3 < Uid.NUM_USER_ACTIVITY_TYPES; ++i3) {
                    u.mUserActivityCounters[i3].readSummaryFromParcelLocked(in);
                }
            }
            if (in.readInt() != 0) {
                if (u.mNetworkByteActivityCounters == null) {
                    u.initNetworkActivityLocked();
                }
                for (i3 = 0; i3 < 10; ++i3) {
                    u.mNetworkByteActivityCounters[i3].readSummaryFromParcelLocked(in);
                    u.mNetworkPacketActivityCounters[i3].readSummaryFromParcelLocked(in);
                }
                u.mMobileRadioActiveTime.readSummaryFromParcelLocked(in);
                u.mMobileRadioActiveCount.readSummaryFromParcelLocked(in);
            }
            u.mUserCpuTime.readSummaryFromParcelLocked(in);
            u.mSystemCpuTime.readSummaryFromParcelLocked(in);
            if (in.readInt() != 0) {
                int numClusters = in.readInt();
                if (this.mPowerProfile != null && this.mPowerProfile.getNumCpuClusters() != numClusters) {
                    throw new ParcelFormatException("Incompatible cpu cluster arrangement");
                }
                BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs);
                u.mCpuClusterSpeedTimesUs = new LongSamplingCounter[numClusters][];
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    if (in.readInt() != 0) {
                        int NSB = in.readInt();
                        if (this.mPowerProfile != null && this.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster) != NSB) {
                            throw new ParcelFormatException("File corrupt: too many speed bins " + NSB);
                        }
                        u.mCpuClusterSpeedTimesUs[cluster] = new LongSamplingCounter[NSB];
                        for (int speed = 0; speed < NSB; ++speed) {
                            if (in.readInt() == 0) continue;
                            u.mCpuClusterSpeedTimesUs[cluster][speed] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                            u.mCpuClusterSpeedTimesUs[cluster][speed].readSummaryFromParcelLocked(in);
                        }
                        continue;
                    }
                    u.mCpuClusterSpeedTimesUs[cluster] = null;
                }
            } else {
                BatteryStatsImpl.detachIfNotNull(u.mCpuClusterSpeedTimesUs);
                u.mCpuClusterSpeedTimesUs = null;
            }
            BatteryStatsImpl.detachIfNotNull(u.mCpuFreqTimeMs);
            u.mCpuFreqTimeMs = LongSamplingCounterArray.readSummaryFromParcelLocked(in, this.mOnBatteryTimeBase);
            BatteryStatsImpl.detachIfNotNull(u.mScreenOffCpuFreqTimeMs);
            u.mScreenOffCpuFreqTimeMs = LongSamplingCounterArray.readSummaryFromParcelLocked(in, this.mOnBatteryScreenOffTimeBase);
            u.mCpuActiveTimeMs.readSummaryFromParcelLocked(in);
            u.mCpuClusterTimesMs.readSummaryFromParcelLocked(in);
            int length = in.readInt();
            if (length == 7) {
                BatteryStatsImpl.detachIfNotNull(u.mProcStateTimeMs);
                u.mProcStateTimeMs = new LongSamplingCounterArray[length];
                for (procState = 0; procState < length; ++procState) {
                    u.mProcStateTimeMs[procState] = LongSamplingCounterArray.readSummaryFromParcelLocked(in, this.mOnBatteryTimeBase);
                }
            } else {
                BatteryStatsImpl.detachIfNotNull(u.mProcStateTimeMs);
                u.mProcStateTimeMs = null;
            }
            length = in.readInt();
            if (length == 7) {
                BatteryStatsImpl.detachIfNotNull(u.mProcStateScreenOffTimeMs);
                u.mProcStateScreenOffTimeMs = new LongSamplingCounterArray[length];
                for (procState = 0; procState < length; ++procState) {
                    u.mProcStateScreenOffTimeMs[procState] = LongSamplingCounterArray.readSummaryFromParcelLocked(in, this.mOnBatteryScreenOffTimeBase);
                }
            } else {
                BatteryStatsImpl.detachIfNotNull(u.mProcStateScreenOffTimeMs);
                u.mProcStateScreenOffTimeMs = null;
            }
            if (in.readInt() != 0) {
                BatteryStatsImpl.detachIfNotNull(u.mMobileRadioApWakeupCount);
                u.mMobileRadioApWakeupCount = new LongSamplingCounter(this.mOnBatteryTimeBase);
                u.mMobileRadioApWakeupCount.readSummaryFromParcelLocked(in);
            } else {
                BatteryStatsImpl.detachIfNotNull(u.mMobileRadioApWakeupCount);
                u.mMobileRadioApWakeupCount = null;
            }
            if (in.readInt() != 0) {
                BatteryStatsImpl.detachIfNotNull(u.mWifiRadioApWakeupCount);
                u.mWifiRadioApWakeupCount = new LongSamplingCounter(this.mOnBatteryTimeBase);
                u.mWifiRadioApWakeupCount.readSummaryFromParcelLocked(in);
            } else {
                BatteryStatsImpl.detachIfNotNull(u.mWifiRadioApWakeupCount);
                u.mWifiRadioApWakeupCount = null;
            }
            int NW = in.readInt();
            if (NW > MAX_WAKELOCKS_PER_UID + 1) {
                throw new ParcelFormatException("File corrupt: too many wake locks " + NW);
            }
            for (int iw = 0; iw < NW; ++iw) {
                String wlName = in.readString();
                u.readWakeSummaryFromParcelLocked(wlName, in);
            }
            int NS = in.readInt();
            if (NS > MAX_WAKELOCKS_PER_UID + 1) {
                throw new ParcelFormatException("File corrupt: too many syncs " + NS);
            }
            for (int is = 0; is < NS; ++is) {
                String name = in.readString();
                u.readSyncSummaryFromParcelLocked(name, in);
            }
            int NJ = in.readInt();
            if (NJ > MAX_WAKELOCKS_PER_UID + 1) {
                throw new ParcelFormatException("File corrupt: too many job timers " + NJ);
            }
            for (int ij = 0; ij < NJ; ++ij) {
                String name = in.readString();
                u.readJobSummaryFromParcelLocked(name, in);
            }
            u.readJobCompletionsFromParcelLocked(in);
            u.mJobsDeferredEventCount.readSummaryFromParcelLocked(in);
            u.mJobsDeferredCount.readSummaryFromParcelLocked(in);
            u.mJobsFreshnessTimeMs.readSummaryFromParcelLocked(in);
            BatteryStatsImpl.detachIfNotNull(u.mJobsFreshnessBuckets);
            for (int i4 = 0; i4 < JOB_FRESHNESS_BUCKETS.length; ++i4) {
                if (in.readInt() == 0) continue;
                u.mJobsFreshnessBuckets[i4] = new Counter(u.mBsi.mOnBatteryTimeBase);
                u.mJobsFreshnessBuckets[i4].readSummaryFromParcelLocked(in);
            }
            int NP = in.readInt();
            if (NP > 1000) {
                throw new ParcelFormatException("File corrupt: too many sensors " + NP);
            }
            for (int is = 0; is < NP; ++is) {
                int seNumber = in.readInt();
                if (in.readInt() == 0) continue;
                u.getSensorTimerLocked(seNumber, true).readSummaryFromParcelLocked(in);
            }
            NP = in.readInt();
            if (NP > 1000) {
                throw new ParcelFormatException("File corrupt: too many processes " + NP);
            }
            for (ip = 0; ip < NP; ++ip) {
                String procName = in.readString();
                p = u.getProcessStatsLocked(procName);
                ((Uid.Proc)p).mUserTime = in.readLong();
                ((Uid.Proc)p).mSystemTime = in.readLong();
                ((Uid.Proc)p).mForegroundTime = in.readLong();
                ((Uid.Proc)p).mStarts = in.readInt();
                ((Uid.Proc)p).mNumCrashes = in.readInt();
                ((Uid.Proc)p).mNumAnrs = in.readInt();
                ((Uid.Proc)p).readExcessivePowerFromParcelLocked(in);
            }
            NP = in.readInt();
            if (NP > 10000) {
                throw new ParcelFormatException("File corrupt: too many packages " + NP);
            }
            for (ip = 0; ip < NP; ++ip) {
                String pkgName = in.readString();
                BatteryStatsImpl.detachIfNotNull(u.mPackageStats.get(pkgName));
                p = u.getPackageStatsLocked(pkgName);
                int NWA = in.readInt();
                if (NWA > 10000) {
                    throw new ParcelFormatException("File corrupt: too many wakeup alarms " + NWA);
                }
                ((Uid.Pkg)p).mWakeupAlarms.clear();
                for (int iwa = 0; iwa < NWA; ++iwa) {
                    String tag = in.readString();
                    Counter c = new Counter(this.mOnBatteryScreenOffTimeBase);
                    c.readSummaryFromParcelLocked(in);
                    ((Uid.Pkg)p).mWakeupAlarms.put(tag, c);
                }
                NS = in.readInt();
                if (NS > 10000) {
                    throw new ParcelFormatException("File corrupt: too many services " + NS);
                }
                for (int is = 0; is < NS; ++is) {
                    String servName = in.readString();
                    Uid.Pkg.Serv s = u.getServiceStatsLocked(pkgName, servName);
                    s.mStartTime = in.readLong();
                    s.mStarts = in.readInt();
                    s.mLaunches = in.readInt();
                }
            }
        }
    }

    public void writeSummaryToParcel(Parcel out, boolean inclHistory) {
        Timer rpmt;
        int i;
        this.pullPendingStateUpdatesLocked();
        this.getStartClockTime();
        long NOW_SYS = this.mClocks.uptimeMillis() * 1000L;
        long NOWREAL_SYS = this.mClocks.elapsedRealtime() * 1000L;
        out.writeInt(186);
        out.writeBoolean(inclHistory);
        if (inclHistory) {
            this.writeHistoryBuffer(out, true, true);
            this.mBatteryStatsHistory.writeToParcel(out);
        }
        out.writeInt(this.mHistoryTagPool.size());
        for (Map.Entry<BatteryStats.HistoryTag, Integer> ent : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag tag = ent.getKey();
            out.writeInt(ent.getValue());
            out.writeString(tag.string);
            out.writeInt(tag.uid);
        }
        out.writeInt(this.mStartCount);
        out.writeLong(this.computeUptime(NOW_SYS, 0));
        out.writeLong(this.computeRealtime(NOWREAL_SYS, 0));
        out.writeLong(this.mStartClockTime);
        out.writeString(this.mStartPlatformVersion);
        out.writeString(this.mEndPlatformVersion);
        this.mOnBatteryTimeBase.writeSummaryToParcel(out, NOW_SYS, NOWREAL_SYS);
        this.mOnBatteryScreenOffTimeBase.writeSummaryToParcel(out, NOW_SYS, NOWREAL_SYS);
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargePlugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.mCurrentBatteryLevel);
        out.writeInt(this.mEstimatedBatteryCapacity);
        out.writeInt(this.mMinLearnedBatteryCapacity);
        out.writeInt(this.mMaxLearnedBatteryCapacity);
        out.writeInt(this.getLowDischargeAmountSinceCharge());
        out.writeInt(this.getHighDischargeAmountSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOnSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOffSinceCharge());
        out.writeInt(this.getDischargeAmountScreenDozeSinceCharge());
        this.mDischargeStepTracker.writeToParcel(out);
        this.mChargeStepTracker.writeToParcel(out);
        this.mDailyDischargeStepTracker.writeToParcel(out);
        this.mDailyChargeStepTracker.writeToParcel(out);
        this.mDischargeCounter.writeSummaryFromParcelLocked(out);
        this.mDischargeScreenOffCounter.writeSummaryFromParcelLocked(out);
        this.mDischargeScreenDozeCounter.writeSummaryFromParcelLocked(out);
        this.mDischargeLightDozeCounter.writeSummaryFromParcelLocked(out);
        this.mDischargeDeepDozeCounter.writeSummaryFromParcelLocked(out);
        if (this.mDailyPackageChanges != null) {
            int NPKG = this.mDailyPackageChanges.size();
            out.writeInt(NPKG);
            for (int i2 = 0; i2 < NPKG; ++i2) {
                BatteryStats.PackageChange pc = this.mDailyPackageChanges.get(i2);
                out.writeString(pc.mPackageName);
                out.writeInt(pc.mUpdate ? 1 : 0);
                out.writeLong(pc.mVersionCode);
            }
        } else {
            out.writeInt(0);
        }
        out.writeLong(this.mDailyStartTime);
        out.writeLong(this.mNextMinDailyDeadline);
        out.writeLong(this.mNextMaxDailyDeadline);
        this.mScreenOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mScreenDozeTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        this.mInteractiveTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mPowerSaveModeEnabledTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        out.writeLong(this.mLongestLightIdleTime);
        out.writeLong(this.mLongestFullIdleTime);
        this.mDeviceIdleModeLightTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mDeviceIdleModeFullTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mDeviceLightIdlingTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mDeviceIdlingTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mPhoneOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        this.mPhoneSignalScanningTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i].writeSummaryFromParcelLocked(out);
            this.mNetworkPacketActivityCounters[i].writeSummaryFromParcelLocked(out);
        }
        this.mMobileRadioActiveTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mMobileRadioActivePerAppTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mMobileRadioActiveAdjustedTime.writeSummaryFromParcelLocked(out);
        this.mMobileRadioActiveUnknownTime.writeSummaryFromParcelLocked(out);
        this.mMobileRadioActiveUnknownCount.writeSummaryFromParcelLocked(out);
        this.mWifiMulticastWakelockTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mWifiOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mGlobalWifiRunningTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        this.mWifiActiveTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mWifiActivity.writeSummaryToParcel(out);
        for (i = 0; i < 2; ++i) {
            this.mGpsSignalQualityTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        this.mBluetoothActivity.writeSummaryToParcel(out);
        this.mModemActivity.writeSummaryToParcel(out);
        out.writeInt(this.mHasWifiReporting ? 1 : 0);
        out.writeInt(this.mHasBluetoothReporting ? 1 : 0);
        out.writeInt(this.mHasModemReporting ? 1 : 0);
        out.writeInt(this.mNumConnectivityChange);
        this.mFlashlightOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mCameraOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mBluetoothScanTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        out.writeInt(this.mRpmStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mRpmStats.entrySet()) {
            rpmt = ent.getValue();
            if (rpmt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                rpmt.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mScreenOffRpmStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mScreenOffRpmStats.entrySet()) {
            rpmt = ent.getValue();
            if (rpmt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                rpmt.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mKernelWakelockStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
            Timer kwlt = ent.getValue();
            if (kwlt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                kwlt.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mWakeupReasonStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mWakeupReasonStats.entrySet()) {
            SamplingTimer timer = ent.getValue();
            if (timer != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                timer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mKernelMemoryStats.size());
        for (int i3 = 0; i3 < this.mKernelMemoryStats.size(); ++i3) {
            Timer kmt = this.mKernelMemoryStats.valueAt(i3);
            if (kmt != null) {
                out.writeInt(1);
                out.writeLong(this.mKernelMemoryStats.keyAt(i3));
                kmt.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                continue;
            }
            out.writeInt(0);
        }
        int NU = this.mUidStats.size();
        out.writeInt(NU);
        for (int iu = 0; iu < NU; ++iu) {
            int i4;
            out.writeInt(this.mUidStats.keyAt(iu));
            Uid u = this.mUidStats.valueAt(iu);
            u.mOnBatteryBackgroundTimeBase.writeSummaryToParcel(out, NOW_SYS, NOWREAL_SYS);
            u.mOnBatteryScreenOffBackgroundTimeBase.writeSummaryToParcel(out, NOW_SYS, NOWREAL_SYS);
            if (u.mWifiRunningTimer != null) {
                out.writeInt(1);
                u.mWifiRunningTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mFullWifiLockTimer != null) {
                out.writeInt(1);
                u.mFullWifiLockTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mWifiScanTimer != null) {
                out.writeInt(1);
                u.mWifiScanTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            for (i4 = 0; i4 < 5; ++i4) {
                if (u.mWifiBatchedScanTimer[i4] != null) {
                    out.writeInt(1);
                    u.mWifiBatchedScanTimer[i4].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            if (u.mWifiMulticastTimer != null) {
                out.writeInt(1);
                u.mWifiMulticastTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                u.mAudioTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                u.mVideoTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mFlashlightTurnedOnTimer != null) {
                out.writeInt(1);
                u.mFlashlightTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mCameraTurnedOnTimer != null) {
                out.writeInt(1);
                u.mCameraTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mForegroundActivityTimer != null) {
                out.writeInt(1);
                u.mForegroundActivityTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mForegroundServiceTimer != null) {
                out.writeInt(1);
                u.mForegroundServiceTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mAggregatedPartialWakelockTimer != null) {
                out.writeInt(1);
                u.mAggregatedPartialWakelockTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mBluetoothScanTimer != null) {
                out.writeInt(1);
                u.mBluetoothScanTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mBluetoothUnoptimizedScanTimer != null) {
                out.writeInt(1);
                u.mBluetoothUnoptimizedScanTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mBluetoothScanResultCounter != null) {
                out.writeInt(1);
                u.mBluetoothScanResultCounter.writeSummaryFromParcelLocked(out);
            } else {
                out.writeInt(0);
            }
            if (u.mBluetoothScanResultBgCounter != null) {
                out.writeInt(1);
                u.mBluetoothScanResultBgCounter.writeSummaryFromParcelLocked(out);
            } else {
                out.writeInt(0);
            }
            for (i4 = 0; i4 < 7; ++i4) {
                if (u.mProcessStateTimer[i4] != null) {
                    out.writeInt(1);
                    u.mProcessStateTimer[i4].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            if (u.mVibratorOnTimer != null) {
                out.writeInt(1);
                u.mVibratorOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mUserActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i4 = 0; i4 < Uid.NUM_USER_ACTIVITY_TYPES; ++i4) {
                    u.mUserActivityCounters[i4].writeSummaryFromParcelLocked(out);
                }
            }
            if (u.mNetworkByteActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i4 = 0; i4 < 10; ++i4) {
                    u.mNetworkByteActivityCounters[i4].writeSummaryFromParcelLocked(out);
                    u.mNetworkPacketActivityCounters[i4].writeSummaryFromParcelLocked(out);
                }
                u.mMobileRadioActiveTime.writeSummaryFromParcelLocked(out);
                u.mMobileRadioActiveCount.writeSummaryFromParcelLocked(out);
            }
            u.mUserCpuTime.writeSummaryFromParcelLocked(out);
            u.mSystemCpuTime.writeSummaryFromParcelLocked(out);
            if (u.mCpuClusterSpeedTimesUs != null) {
                out.writeInt(1);
                out.writeInt(u.mCpuClusterSpeedTimesUs.length);
                for (LongSamplingCounter[] cpuSpeeds : u.mCpuClusterSpeedTimesUs) {
                    if (cpuSpeeds != null) {
                        out.writeInt(1);
                        out.writeInt(cpuSpeeds.length);
                        for (LongSamplingCounter c : cpuSpeeds) {
                            if (c != null) {
                                out.writeInt(1);
                                c.writeSummaryFromParcelLocked(out);
                                continue;
                            }
                            out.writeInt(0);
                        }
                        continue;
                    }
                    out.writeInt(0);
                }
            } else {
                out.writeInt(0);
            }
            LongSamplingCounterArray.writeSummaryToParcelLocked(out, u.mCpuFreqTimeMs);
            LongSamplingCounterArray.writeSummaryToParcelLocked(out, u.mScreenOffCpuFreqTimeMs);
            u.mCpuActiveTimeMs.writeSummaryFromParcelLocked(out);
            u.mCpuClusterTimesMs.writeSummaryToParcelLocked(out);
            if (u.mProcStateTimeMs != null) {
                out.writeInt(u.mProcStateTimeMs.length);
                for (LongSamplingCounterArray counters : u.mProcStateTimeMs) {
                    LongSamplingCounterArray.writeSummaryToParcelLocked(out, counters);
                }
            } else {
                out.writeInt(0);
            }
            if (u.mProcStateScreenOffTimeMs != null) {
                out.writeInt(u.mProcStateScreenOffTimeMs.length);
                for (LongSamplingCounterArray counters : u.mProcStateScreenOffTimeMs) {
                    LongSamplingCounterArray.writeSummaryToParcelLocked(out, counters);
                }
            } else {
                out.writeInt(0);
            }
            if (u.mMobileRadioApWakeupCount != null) {
                out.writeInt(1);
                u.mMobileRadioApWakeupCount.writeSummaryFromParcelLocked(out);
            } else {
                out.writeInt(0);
            }
            if (u.mWifiRadioApWakeupCount != null) {
                out.writeInt(1);
                u.mWifiRadioApWakeupCount.writeSummaryFromParcelLocked(out);
            } else {
                out.writeInt(0);
            }
            ArrayMap<String, Uid.Wakelock> wakeStats = u.mWakelockStats.getMap();
            int NW = wakeStats.size();
            out.writeInt(NW);
            for (int iw = 0; iw < NW; ++iw) {
                out.writeString(wakeStats.keyAt(iw));
                Uid.Wakelock wl = wakeStats.valueAt(iw);
                if (wl.mTimerFull != null) {
                    out.writeInt(1);
                    wl.mTimerFull.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerPartial != null) {
                    out.writeInt(1);
                    wl.mTimerPartial.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerWindow != null) {
                    out.writeInt(1);
                    wl.mTimerWindow.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerDraw != null) {
                    out.writeInt(1);
                    wl.mTimerDraw.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            ArrayMap<String, DualTimer> syncStats = u.mSyncStats.getMap();
            int NS = syncStats.size();
            out.writeInt(NS);
            for (int is = 0; is < NS; ++is) {
                out.writeString(syncStats.keyAt(is));
                syncStats.valueAt(is).writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            }
            ArrayMap<String, DualTimer> jobStats = u.mJobStats.getMap();
            int NJ = jobStats.size();
            out.writeInt(NJ);
            for (int ij = 0; ij < NJ; ++ij) {
                out.writeString(jobStats.keyAt(ij));
                jobStats.valueAt(ij).writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            }
            u.writeJobCompletionsToParcelLocked(out);
            u.mJobsDeferredEventCount.writeSummaryFromParcelLocked(out);
            u.mJobsDeferredCount.writeSummaryFromParcelLocked(out);
            u.mJobsFreshnessTimeMs.writeSummaryFromParcelLocked(out);
            for (int i5 = 0; i5 < JOB_FRESHNESS_BUCKETS.length; ++i5) {
                if (u.mJobsFreshnessBuckets[i5] != null) {
                    out.writeInt(1);
                    u.mJobsFreshnessBuckets[i5].writeSummaryFromParcelLocked(out);
                    continue;
                }
                out.writeInt(0);
            }
            int NSE = u.mSensorStats.size();
            out.writeInt(NSE);
            for (int ise = 0; ise < NSE; ++ise) {
                out.writeInt(u.mSensorStats.keyAt(ise));
                Uid.Sensor se = u.mSensorStats.valueAt(ise);
                if (se.mTimer != null) {
                    out.writeInt(1);
                    se.mTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            int NP = u.mProcessStats.size();
            out.writeInt(NP);
            for (int ip = 0; ip < NP; ++ip) {
                out.writeString(u.mProcessStats.keyAt(ip));
                Uid.Proc ps = u.mProcessStats.valueAt(ip);
                out.writeLong(ps.mUserTime);
                out.writeLong(ps.mSystemTime);
                out.writeLong(ps.mForegroundTime);
                out.writeInt(ps.mStarts);
                out.writeInt(ps.mNumCrashes);
                out.writeInt(ps.mNumAnrs);
                ps.writeExcessivePowerToParcelLocked(out);
            }
            NP = u.mPackageStats.size();
            out.writeInt(NP);
            if (NP <= 0) continue;
            for (Map.Entry<String, Uid.Pkg> ent : u.mPackageStats.entrySet()) {
                out.writeString(ent.getKey());
                Uid.Pkg ps = ent.getValue();
                int NWA = ps.mWakeupAlarms.size();
                out.writeInt(NWA);
                for (int iwa = 0; iwa < NWA; ++iwa) {
                    out.writeString(ps.mWakeupAlarms.keyAt(iwa));
                    ps.mWakeupAlarms.valueAt(iwa).writeSummaryFromParcelLocked(out);
                }
                NS = ps.mServiceStats.size();
                out.writeInt(NS);
                for (int is = 0; is < NS; ++is) {
                    out.writeString(ps.mServiceStats.keyAt(is));
                    Uid.Pkg.Serv ss = ps.mServiceStats.valueAt(is);
                    long time = ss.getStartTimeToNowLocked(this.mOnBatteryTimeBase.getUptime(NOW_SYS));
                    out.writeLong(time);
                    out.writeInt(ss.mStarts);
                    out.writeInt(ss.mLaunches);
                }
            }
        }
    }

    public void readFromParcel(Parcel in) {
        this.readFromParcelLocked(in);
    }

    void readFromParcelLocked(Parcel in) {
        int i;
        int magic = in.readInt();
        if (magic != -1166707595) {
            throw new ParcelFormatException("Bad magic number: #" + Integer.toHexString(magic));
        }
        this.readHistoryBuffer(in, false);
        this.mBatteryStatsHistory.readFromParcel(in);
        this.mStartCount = in.readInt();
        this.mStartClockTime = in.readLong();
        this.mStartPlatformVersion = in.readString();
        this.mEndPlatformVersion = in.readString();
        this.mUptime = in.readLong();
        this.mUptimeStart = in.readLong();
        this.mRealtime = in.readLong();
        this.mRealtimeStart = in.readLong();
        this.mOnBattery = in.readInt() != 0;
        this.mEstimatedBatteryCapacity = in.readInt();
        this.mMinLearnedBatteryCapacity = in.readInt();
        this.mMaxLearnedBatteryCapacity = in.readInt();
        this.mOnBatteryInternal = false;
        this.mOnBatteryTimeBase.readFromParcel(in);
        this.mOnBatteryScreenOffTimeBase.readFromParcel(in);
        this.mScreenState = 0;
        this.mScreenOnTimer = new StopwatchTimer(this.mClocks, null, -1, null, this.mOnBatteryTimeBase, in);
        this.mScreenDozeTimer = new StopwatchTimer(this.mClocks, null, -1, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(this.mClocks, null, -100 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mInteractive = false;
        this.mInteractiveTimer = new StopwatchTimer(this.mClocks, null, -10, null, this.mOnBatteryTimeBase, in);
        this.mPhoneOn = false;
        this.mPowerSaveModeEnabledTimer = new StopwatchTimer(this.mClocks, null, -2, null, this.mOnBatteryTimeBase, in);
        this.mLongestLightIdleTime = in.readLong();
        this.mLongestFullIdleTime = in.readLong();
        this.mDeviceIdleModeLightTimer = new StopwatchTimer(this.mClocks, null, -14, null, this.mOnBatteryTimeBase, in);
        this.mDeviceIdleModeFullTimer = new StopwatchTimer(this.mClocks, null, -11, null, this.mOnBatteryTimeBase, in);
        this.mDeviceLightIdlingTimer = new StopwatchTimer(this.mClocks, null, -15, null, this.mOnBatteryTimeBase, in);
        this.mDeviceIdlingTimer = new StopwatchTimer(this.mClocks, null, -12, null, this.mOnBatteryTimeBase, in);
        this.mPhoneOnTimer = new StopwatchTimer(this.mClocks, null, -3, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(this.mClocks, null, -200 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(this.mClocks, null, -199, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(this.mClocks, null, -300 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        }
        this.mMobileRadioPowerState = 1;
        this.mMobileRadioActiveTimer = new StopwatchTimer(this.mClocks, null, -400, null, this.mOnBatteryTimeBase, in);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(this.mClocks, null, -401, null, this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mWifiMulticastWakelockTimer = new StopwatchTimer(this.mClocks, null, -4, null, this.mOnBatteryTimeBase, in);
        this.mWifiRadioPowerState = 1;
        this.mWifiOn = false;
        this.mWifiOnTimer = new StopwatchTimer(this.mClocks, null, -4, null, this.mOnBatteryTimeBase, in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer = new StopwatchTimer(this.mClocks, null, -5, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(this.mClocks, null, -600 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(this.mClocks, null, -700 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(this.mClocks, null, -800 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mWifiActiveTimer = new StopwatchTimer(this.mClocks, null, -900, null, this.mOnBatteryTimeBase, in);
        this.mWifiActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 1, in);
        for (i = 0; i < 2; ++i) {
            this.mGpsSignalQualityTimer[i] = new StopwatchTimer(this.mClocks, null, -1000 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mBluetoothActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 1, in);
        this.mModemActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 5, in);
        this.mHasWifiReporting = in.readInt() != 0;
        this.mHasBluetoothReporting = in.readInt() != 0;
        this.mHasModemReporting = in.readInt() != 0;
        this.mNumConnectivityChange = in.readInt();
        this.mAudioOnNesting = 0;
        this.mAudioOnTimer = new StopwatchTimer(this.mClocks, null, -7, null, this.mOnBatteryTimeBase);
        this.mVideoOnNesting = 0;
        this.mVideoOnTimer = new StopwatchTimer(this.mClocks, null, -8, null, this.mOnBatteryTimeBase);
        this.mFlashlightOnNesting = 0;
        this.mFlashlightOnTimer = new StopwatchTimer(this.mClocks, null, -9, null, this.mOnBatteryTimeBase, in);
        this.mCameraOnNesting = 0;
        this.mCameraOnTimer = new StopwatchTimer(this.mClocks, null, -13, null, this.mOnBatteryTimeBase, in);
        this.mBluetoothScanNesting = 0;
        this.mBluetoothScanTimer = new StopwatchTimer(this.mClocks, null, -14, null, this.mOnBatteryTimeBase, in);
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargePlugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mCurrentBatteryLevel = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOn = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOff = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        this.mDischargeAmountScreenDoze = in.readInt();
        this.mDischargeAmountScreenDozeSinceCharge = in.readInt();
        this.mDischargeStepTracker.readFromParcel(in);
        this.mChargeStepTracker.readFromParcel(in);
        this.mDischargeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mDischargeScreenOffCounter = new LongSamplingCounter(this.mOnBatteryScreenOffTimeBase, in);
        this.mDischargeScreenDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mDischargeLightDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mDischargeDeepDozeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mLastWriteTime = in.readLong();
        this.mRpmStats.clear();
        int NRPMS = in.readInt();
        for (int irpm = 0; irpm < NRPMS; ++irpm) {
            if (in.readInt() == 0) continue;
            String rpmName = in.readString();
            SamplingTimer rpmt = new SamplingTimer(this.mClocks, this.mOnBatteryTimeBase, in);
            this.mRpmStats.put(rpmName, rpmt);
        }
        this.mScreenOffRpmStats.clear();
        int NSORPMS = in.readInt();
        for (int irpm = 0; irpm < NSORPMS; ++irpm) {
            if (in.readInt() == 0) continue;
            String rpmName = in.readString();
            SamplingTimer rpmt = new SamplingTimer(this.mClocks, this.mOnBatteryScreenOffTimeBase, in);
            this.mScreenOffRpmStats.put(rpmName, rpmt);
        }
        this.mKernelWakelockStats.clear();
        int NKW = in.readInt();
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String wakelockName = in.readString();
            SamplingTimer kwlt = new SamplingTimer(this.mClocks, this.mOnBatteryScreenOffTimeBase, in);
            this.mKernelWakelockStats.put(wakelockName, kwlt);
        }
        this.mWakeupReasonStats.clear();
        int NWR = in.readInt();
        for (int iwr = 0; iwr < NWR; ++iwr) {
            if (in.readInt() == 0) continue;
            String reasonName = in.readString();
            SamplingTimer timer = new SamplingTimer(this.mClocks, this.mOnBatteryTimeBase, in);
            this.mWakeupReasonStats.put(reasonName, timer);
        }
        this.mKernelMemoryStats.clear();
        int nmt = in.readInt();
        for (int imt = 0; imt < nmt; ++imt) {
            if (in.readInt() == 0) continue;
            Long bucket = in.readLong();
            SamplingTimer kmt = new SamplingTimer(this.mClocks, this.mOnBatteryTimeBase, in);
            this.mKernelMemoryStats.put(bucket, kmt);
        }
        this.mPartialTimers.clear();
        this.mFullTimers.clear();
        this.mWindowTimers.clear();
        this.mWifiRunningTimers.clear();
        this.mFullWifiLockTimers.clear();
        this.mWifiScanTimers.clear();
        this.mWifiBatchedScanTimers.clear();
        this.mWifiMulticastTimers.clear();
        this.mAudioTurnedOnTimers.clear();
        this.mVideoTurnedOnTimers.clear();
        this.mFlashlightTurnedOnTimers.clear();
        this.mCameraTurnedOnTimers.clear();
        int numUids = in.readInt();
        this.mUidStats.clear();
        for (int i2 = 0; i2 < numUids; ++i2) {
            int uid = in.readInt();
            Uid u = new Uid(this, uid);
            u.readFromParcelLocked(this.mOnBatteryTimeBase, this.mOnBatteryScreenOffTimeBase, in);
            this.mUidStats.append(uid, u);
        }
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.writeToParcelLocked(out, true, flags);
    }

    @Override
    public void writeToParcelWithoutUids(Parcel out, int flags) {
        this.writeToParcelLocked(out, false, flags);
    }

    void writeToParcelLocked(Parcel out, boolean inclUids, int flags) {
        SamplingTimer rpmt;
        int i;
        this.pullPendingStateUpdatesLocked();
        this.getStartClockTime();
        long uSecUptime = this.mClocks.uptimeMillis() * 1000L;
        long uSecRealtime = this.mClocks.elapsedRealtime() * 1000L;
        long batteryRealtime = this.mOnBatteryTimeBase.getRealtime(uSecRealtime);
        long batteryScreenOffRealtime = this.mOnBatteryScreenOffTimeBase.getRealtime(uSecRealtime);
        out.writeInt(-1166707595);
        this.writeHistoryBuffer(out, true, false);
        this.mBatteryStatsHistory.writeToParcel(out);
        out.writeInt(this.mStartCount);
        out.writeLong(this.mStartClockTime);
        out.writeString(this.mStartPlatformVersion);
        out.writeString(this.mEndPlatformVersion);
        out.writeLong(this.mUptime);
        out.writeLong(this.mUptimeStart);
        out.writeLong(this.mRealtime);
        out.writeLong(this.mRealtimeStart);
        out.writeInt(this.mOnBattery ? 1 : 0);
        out.writeInt(this.mEstimatedBatteryCapacity);
        out.writeInt(this.mMinLearnedBatteryCapacity);
        out.writeInt(this.mMaxLearnedBatteryCapacity);
        this.mOnBatteryTimeBase.writeToParcel(out, uSecUptime, uSecRealtime);
        this.mOnBatteryScreenOffTimeBase.writeToParcel(out, uSecUptime, uSecRealtime);
        this.mScreenOnTimer.writeToParcel(out, uSecRealtime);
        this.mScreenDozeTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mInteractiveTimer.writeToParcel(out, uSecRealtime);
        this.mPowerSaveModeEnabledTimer.writeToParcel(out, uSecRealtime);
        out.writeLong(this.mLongestLightIdleTime);
        out.writeLong(this.mLongestFullIdleTime);
        this.mDeviceIdleModeLightTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceIdleModeFullTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceLightIdlingTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceIdlingTimer.writeToParcel(out, uSecRealtime);
        this.mPhoneOnTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mPhoneSignalScanningTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 10; ++i) {
            this.mNetworkByteActivityCounters[i].writeToParcel(out);
            this.mNetworkPacketActivityCounters[i].writeToParcel(out);
        }
        this.mMobileRadioActiveTimer.writeToParcel(out, uSecRealtime);
        this.mMobileRadioActivePerAppTimer.writeToParcel(out, uSecRealtime);
        this.mMobileRadioActiveAdjustedTime.writeToParcel(out);
        this.mMobileRadioActiveUnknownTime.writeToParcel(out);
        this.mMobileRadioActiveUnknownCount.writeToParcel(out);
        this.mWifiMulticastWakelockTimer.writeToParcel(out, uSecRealtime);
        this.mWifiOnTimer.writeToParcel(out, uSecRealtime);
        this.mGlobalWifiRunningTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mWifiActiveTimer.writeToParcel(out, uSecRealtime);
        this.mWifiActivity.writeToParcel(out, 0);
        for (i = 0; i < 2; ++i) {
            this.mGpsSignalQualityTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mBluetoothActivity.writeToParcel(out, 0);
        this.mModemActivity.writeToParcel(out, 0);
        out.writeInt(this.mHasWifiReporting ? 1 : 0);
        out.writeInt(this.mHasBluetoothReporting ? 1 : 0);
        out.writeInt(this.mHasModemReporting ? 1 : 0);
        out.writeInt(this.mNumConnectivityChange);
        this.mFlashlightOnTimer.writeToParcel(out, uSecRealtime);
        this.mCameraOnTimer.writeToParcel(out, uSecRealtime);
        this.mBluetoothScanTimer.writeToParcel(out, uSecRealtime);
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargePlugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.mCurrentBatteryLevel);
        out.writeInt(this.mLowDischargeAmountSinceCharge);
        out.writeInt(this.mHighDischargeAmountSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOn);
        out.writeInt(this.mDischargeAmountScreenOnSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOff);
        out.writeInt(this.mDischargeAmountScreenOffSinceCharge);
        out.writeInt(this.mDischargeAmountScreenDoze);
        out.writeInt(this.mDischargeAmountScreenDozeSinceCharge);
        this.mDischargeStepTracker.writeToParcel(out);
        this.mChargeStepTracker.writeToParcel(out);
        this.mDischargeCounter.writeToParcel(out);
        this.mDischargeScreenOffCounter.writeToParcel(out);
        this.mDischargeScreenDozeCounter.writeToParcel(out);
        this.mDischargeLightDozeCounter.writeToParcel(out);
        this.mDischargeDeepDozeCounter.writeToParcel(out);
        out.writeLong(this.mLastWriteTime);
        out.writeInt(this.mRpmStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mRpmStats.entrySet()) {
            rpmt = ent.getValue();
            if (rpmt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                rpmt.writeToParcel(out, uSecRealtime);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mScreenOffRpmStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mScreenOffRpmStats.entrySet()) {
            rpmt = ent.getValue();
            if (rpmt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                rpmt.writeToParcel(out, uSecRealtime);
                continue;
            }
            out.writeInt(0);
        }
        if (inclUids) {
            out.writeInt(this.mKernelWakelockStats.size());
            for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer kwlt = ent.getValue();
                if (kwlt != null) {
                    out.writeInt(1);
                    out.writeString(ent.getKey());
                    kwlt.writeToParcel(out, uSecRealtime);
                    continue;
                }
                out.writeInt(0);
            }
            out.writeInt(this.mWakeupReasonStats.size());
            for (Map.Entry<String, SamplingTimer> ent : this.mWakeupReasonStats.entrySet()) {
                SamplingTimer timer = ent.getValue();
                if (timer != null) {
                    out.writeInt(1);
                    out.writeString(ent.getKey());
                    timer.writeToParcel(out, uSecRealtime);
                    continue;
                }
                out.writeInt(0);
            }
        } else {
            out.writeInt(0);
            out.writeInt(0);
        }
        out.writeInt(this.mKernelMemoryStats.size());
        for (int i2 = 0; i2 < this.mKernelMemoryStats.size(); ++i2) {
            SamplingTimer kmt = this.mKernelMemoryStats.valueAt(i2);
            if (kmt != null) {
                out.writeInt(1);
                out.writeLong(this.mKernelMemoryStats.keyAt(i2));
                kmt.writeToParcel(out, uSecRealtime);
                continue;
            }
            out.writeInt(0);
        }
        if (inclUids) {
            int size = this.mUidStats.size();
            out.writeInt(size);
            for (int i3 = 0; i3 < size; ++i3) {
                out.writeInt(this.mUidStats.keyAt(i3));
                Uid uid = this.mUidStats.valueAt(i3);
                uid.writeToParcelLocked(out, uSecUptime, uSecRealtime);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void prepareForDumpLocked() {
        this.pullPendingStateUpdatesLocked();
        this.getStartClockTime();
    }

    @Override
    public void dumpLocked(Context context, PrintWriter pw, int flags, int reqUid, long histStart) {
        super.dumpLocked(context, pw, flags, reqUid, histStart);
        pw.print("Total cpu time reads: ");
        pw.println(this.mNumSingleUidCpuTimeReads);
        pw.print("Batched cpu time reads: ");
        pw.println(this.mNumBatchedSingleUidCpuTimeReads);
        pw.print("Batching Duration (min): ");
        pw.println((this.mClocks.uptimeMillis() - this.mCpuTimeReadsTrackingStartTime) / 60000L);
        pw.print("All UID cpu time reads since the later of device start or stats reset: ");
        pw.println(this.mNumAllUidCpuTimeReads);
        pw.print("UIDs removed since the later of device start or stats reset: ");
        pw.println(this.mNumUidsRemoved);
    }

    @VisibleForTesting
    public class Constants
    extends ContentObserver {
        public static final String KEY_TRACK_CPU_TIMES_BY_PROC_STATE = "track_cpu_times_by_proc_state";
        public static final String KEY_TRACK_CPU_ACTIVE_CLUSTER_TIME = "track_cpu_active_cluster_time";
        public static final String KEY_PROC_STATE_CPU_TIMES_READ_DELAY_MS = "proc_state_cpu_times_read_delay_ms";
        public static final String KEY_KERNEL_UID_READERS_THROTTLE_TIME = "kernel_uid_readers_throttle_time";
        public static final String KEY_UID_REMOVE_DELAY_MS = "uid_remove_delay_ms";
        public static final String KEY_EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS = "external_stats_collection_rate_limit_ms";
        public static final String KEY_BATTERY_LEVEL_COLLECTION_DELAY_MS = "battery_level_collection_delay_ms";
        public static final String KEY_MAX_HISTORY_FILES = "max_history_files";
        public static final String KEY_MAX_HISTORY_BUFFER_KB = "max_history_buffer_kb";
        public static final String KEY_BATTERY_CHARGED_DELAY_MS = "battery_charged_delay_ms";
        private static final boolean DEFAULT_TRACK_CPU_TIMES_BY_PROC_STATE = false;
        private static final boolean DEFAULT_TRACK_CPU_ACTIVE_CLUSTER_TIME = true;
        private static final long DEFAULT_PROC_STATE_CPU_TIMES_READ_DELAY_MS = 5000L;
        private static final long DEFAULT_KERNEL_UID_READERS_THROTTLE_TIME = 1000L;
        private static final long DEFAULT_UID_REMOVE_DELAY_MS = 300000L;
        private static final long DEFAULT_EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS = 600000L;
        private static final long DEFAULT_BATTERY_LEVEL_COLLECTION_DELAY_MS = 300000L;
        private static final int DEFAULT_MAX_HISTORY_FILES = 32;
        private static final int DEFAULT_MAX_HISTORY_BUFFER_KB = 128;
        private static final int DEFAULT_MAX_HISTORY_FILES_LOW_RAM_DEVICE = 64;
        private static final int DEFAULT_MAX_HISTORY_BUFFER_LOW_RAM_DEVICE_KB = 64;
        private static final int DEFAULT_BATTERY_CHARGED_DELAY_MS = 900000;
        public boolean TRACK_CPU_TIMES_BY_PROC_STATE;
        public boolean TRACK_CPU_ACTIVE_CLUSTER_TIME;
        public long PROC_STATE_CPU_TIMES_READ_DELAY_MS;
        public long KERNEL_UID_READERS_THROTTLE_TIME;
        public long UID_REMOVE_DELAY_MS;
        public long EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS;
        public long BATTERY_LEVEL_COLLECTION_DELAY_MS;
        public int MAX_HISTORY_FILES;
        public int MAX_HISTORY_BUFFER;
        public int BATTERY_CHARGED_DELAY_MS;
        private ContentResolver mResolver;
        private final KeyValueListParser mParser;

        public Constants(Handler handler) {
            super(handler);
            this.TRACK_CPU_TIMES_BY_PROC_STATE = false;
            this.TRACK_CPU_ACTIVE_CLUSTER_TIME = true;
            this.PROC_STATE_CPU_TIMES_READ_DELAY_MS = 5000L;
            this.UID_REMOVE_DELAY_MS = 300000L;
            this.EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS = 600000L;
            this.BATTERY_LEVEL_COLLECTION_DELAY_MS = 300000L;
            this.BATTERY_CHARGED_DELAY_MS = 900000;
            this.mParser = new KeyValueListParser(',');
            if (ActivityManager.isLowRamDeviceStatic()) {
                this.MAX_HISTORY_FILES = 64;
                this.MAX_HISTORY_BUFFER = 65536;
            } else {
                this.MAX_HISTORY_FILES = 32;
                this.MAX_HISTORY_BUFFER = 131072;
            }
        }

        public void startObserving(ContentResolver resolver) {
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("battery_stats_constants"), false, this);
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("battery_charging_state_update_delay"), false, this);
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (uri.equals(Settings.Global.getUriFor("battery_charging_state_update_delay"))) {
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                synchronized (batteryStatsImpl) {
                    this.updateBatteryChargedDelayMsLocked();
                }
                return;
            }
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConstants() {
            BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
            synchronized (batteryStatsImpl) {
                try {
                    this.mParser.setString(Settings.Global.getString(this.mResolver, "battery_stats_constants"));
                }
                catch (IllegalArgumentException e) {
                    Slog.e(BatteryStatsImpl.TAG, "Bad batterystats settings", e);
                }
                this.updateTrackCpuTimesByProcStateLocked(this.TRACK_CPU_TIMES_BY_PROC_STATE, this.mParser.getBoolean(KEY_TRACK_CPU_TIMES_BY_PROC_STATE, false));
                this.TRACK_CPU_ACTIVE_CLUSTER_TIME = this.mParser.getBoolean(KEY_TRACK_CPU_ACTIVE_CLUSTER_TIME, true);
                this.updateProcStateCpuTimesReadDelayMs(this.PROC_STATE_CPU_TIMES_READ_DELAY_MS, this.mParser.getLong(KEY_PROC_STATE_CPU_TIMES_READ_DELAY_MS, 5000L));
                this.updateKernelUidReadersThrottleTime(this.KERNEL_UID_READERS_THROTTLE_TIME, this.mParser.getLong(KEY_KERNEL_UID_READERS_THROTTLE_TIME, 1000L));
                this.updateUidRemoveDelay(this.mParser.getLong(KEY_UID_REMOVE_DELAY_MS, 300000L));
                this.EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS = this.mParser.getLong(KEY_EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS, 600000L);
                this.BATTERY_LEVEL_COLLECTION_DELAY_MS = this.mParser.getLong(KEY_BATTERY_LEVEL_COLLECTION_DELAY_MS, 300000L);
                this.MAX_HISTORY_FILES = this.mParser.getInt(KEY_MAX_HISTORY_FILES, ActivityManager.isLowRamDeviceStatic() ? 64 : 32);
                this.MAX_HISTORY_BUFFER = this.mParser.getInt(KEY_MAX_HISTORY_BUFFER_KB, ActivityManager.isLowRamDeviceStatic() ? 64 : 128) * 1024;
                this.updateBatteryChargedDelayMsLocked();
            }
        }

        private void updateBatteryChargedDelayMsLocked() {
            int delay = Settings.Global.getInt(this.mResolver, "battery_charging_state_update_delay", -1);
            this.BATTERY_CHARGED_DELAY_MS = delay >= 0 ? delay : this.mParser.getInt(KEY_BATTERY_CHARGED_DELAY_MS, 900000);
        }

        private void updateTrackCpuTimesByProcStateLocked(boolean wasEnabled, boolean isEnabled) {
            this.TRACK_CPU_TIMES_BY_PROC_STATE = isEnabled;
            if (isEnabled && !wasEnabled) {
                BatteryStatsImpl.this.mIsPerProcessStateCpuDataStale = true;
                BatteryStatsImpl.this.mExternalSync.scheduleCpuSyncDueToSettingChange();
                BatteryStatsImpl.this.mNumSingleUidCpuTimeReads = 0L;
                BatteryStatsImpl.this.mNumBatchedSingleUidCpuTimeReads = 0L;
                BatteryStatsImpl.this.mCpuTimeReadsTrackingStartTime = BatteryStatsImpl.this.mClocks.uptimeMillis();
            }
        }

        private void updateProcStateCpuTimesReadDelayMs(long oldDelayMillis, long newDelayMillis) {
            this.PROC_STATE_CPU_TIMES_READ_DELAY_MS = newDelayMillis;
            if (oldDelayMillis != newDelayMillis) {
                BatteryStatsImpl.this.mNumSingleUidCpuTimeReads = 0L;
                BatteryStatsImpl.this.mNumBatchedSingleUidCpuTimeReads = 0L;
                BatteryStatsImpl.this.mCpuTimeReadsTrackingStartTime = BatteryStatsImpl.this.mClocks.uptimeMillis();
            }
        }

        private void updateKernelUidReadersThrottleTime(long oldTimeMs, long newTimeMs) {
            this.KERNEL_UID_READERS_THROTTLE_TIME = newTimeMs;
            if (oldTimeMs != newTimeMs) {
                BatteryStatsImpl.this.mCpuUidUserSysTimeReader.setThrottle(this.KERNEL_UID_READERS_THROTTLE_TIME);
                BatteryStatsImpl.this.mCpuUidFreqTimeReader.setThrottle(this.KERNEL_UID_READERS_THROTTLE_TIME);
                BatteryStatsImpl.this.mCpuUidActiveTimeReader.setThrottle(this.KERNEL_UID_READERS_THROTTLE_TIME);
                BatteryStatsImpl.this.mCpuUidClusterTimeReader.setThrottle(this.KERNEL_UID_READERS_THROTTLE_TIME);
            }
        }

        private void updateUidRemoveDelay(long newTimeMs) {
            this.UID_REMOVE_DELAY_MS = newTimeMs;
            BatteryStatsImpl.this.clearPendingRemovedUids();
        }

        public void dumpLocked(PrintWriter pw) {
            pw.print(KEY_TRACK_CPU_TIMES_BY_PROC_STATE);
            pw.print("=");
            pw.println(this.TRACK_CPU_TIMES_BY_PROC_STATE);
            pw.print(KEY_TRACK_CPU_ACTIVE_CLUSTER_TIME);
            pw.print("=");
            pw.println(this.TRACK_CPU_ACTIVE_CLUSTER_TIME);
            pw.print(KEY_PROC_STATE_CPU_TIMES_READ_DELAY_MS);
            pw.print("=");
            pw.println(this.PROC_STATE_CPU_TIMES_READ_DELAY_MS);
            pw.print(KEY_KERNEL_UID_READERS_THROTTLE_TIME);
            pw.print("=");
            pw.println(this.KERNEL_UID_READERS_THROTTLE_TIME);
            pw.print(KEY_EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS);
            pw.print("=");
            pw.println(this.EXTERNAL_STATS_COLLECTION_RATE_LIMIT_MS);
            pw.print(KEY_BATTERY_LEVEL_COLLECTION_DELAY_MS);
            pw.print("=");
            pw.println(this.BATTERY_LEVEL_COLLECTION_DELAY_MS);
            pw.print(KEY_MAX_HISTORY_FILES);
            pw.print("=");
            pw.println(this.MAX_HISTORY_FILES);
            pw.print(KEY_MAX_HISTORY_BUFFER_KB);
            pw.print("=");
            pw.println(this.MAX_HISTORY_BUFFER / 1024);
            pw.print(KEY_BATTERY_CHARGED_DELAY_MS);
            pw.print("=");
            pw.println(this.BATTERY_CHARGED_DELAY_MS);
        }
    }

    private class BluetoothActivityInfoCache {
        long idleTimeMs;
        long rxTimeMs;
        long txTimeMs;
        long energy;
        SparseLongArray uidRxBytes = new SparseLongArray();
        SparseLongArray uidTxBytes = new SparseLongArray();

        private BluetoothActivityInfoCache() {
        }

        void set(BluetoothActivityEnergyInfo info) {
            this.idleTimeMs = info.getControllerIdleTimeMillis();
            this.rxTimeMs = info.getControllerRxTimeMillis();
            this.txTimeMs = info.getControllerTxTimeMillis();
            this.energy = info.getControllerEnergyUsed();
            if (info.getUidTraffic() != null) {
                for (UidTraffic traffic : info.getUidTraffic()) {
                    this.uidRxBytes.put(traffic.getUid(), traffic.getRxBytes());
                    this.uidTxBytes.put(traffic.getUid(), traffic.getTxBytes());
                }
            }
        }
    }

    public static class Uid
    extends BatteryStats.Uid {
        protected BatteryStatsImpl mBsi;
        final int mUid;
        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public final TimeBase mOnBatteryBackgroundTimeBase;
        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public final TimeBase mOnBatteryScreenOffBackgroundTimeBase;
        boolean mWifiRunning;
        StopwatchTimer mWifiRunningTimer;
        boolean mFullWifiLockOut;
        StopwatchTimer mFullWifiLockTimer;
        boolean mWifiScanStarted;
        DualTimer mWifiScanTimer;
        static final int NO_BATCHED_SCAN_STARTED = -1;
        int mWifiBatchedScanBinStarted = -1;
        StopwatchTimer[] mWifiBatchedScanTimer;
        int mWifiMulticastWakelockCount;
        StopwatchTimer mWifiMulticastTimer;
        StopwatchTimer mAudioTurnedOnTimer;
        StopwatchTimer mVideoTurnedOnTimer;
        StopwatchTimer mFlashlightTurnedOnTimer;
        StopwatchTimer mCameraTurnedOnTimer;
        StopwatchTimer mForegroundActivityTimer;
        StopwatchTimer mForegroundServiceTimer;
        DualTimer mAggregatedPartialWakelockTimer;
        DualTimer mBluetoothScanTimer;
        DualTimer mBluetoothUnoptimizedScanTimer;
        Counter mBluetoothScanResultCounter;
        Counter mBluetoothScanResultBgCounter;
        int mProcessState = 20;
        StopwatchTimer[] mProcessStateTimer;
        boolean mInForegroundService = false;
        BatchTimer mVibratorOnTimer;
        Counter[] mUserActivityCounters;
        LongSamplingCounter[] mNetworkByteActivityCounters;
        LongSamplingCounter[] mNetworkPacketActivityCounters;
        LongSamplingCounter mMobileRadioActiveTime;
        LongSamplingCounter mMobileRadioActiveCount;
        private LongSamplingCounter mMobileRadioApWakeupCount;
        private LongSamplingCounter mWifiRadioApWakeupCount;
        private ControllerActivityCounterImpl mWifiControllerActivity;
        private ControllerActivityCounterImpl mBluetoothControllerActivity;
        private ControllerActivityCounterImpl mModemControllerActivity;
        long mLastStepUserTime;
        long mLastStepSystemTime;
        long mCurStepUserTime;
        long mCurStepSystemTime;
        LongSamplingCounter mUserCpuTime;
        LongSamplingCounter mSystemCpuTime;
        LongSamplingCounter[][] mCpuClusterSpeedTimesUs;
        LongSamplingCounter mCpuActiveTimeMs;
        LongSamplingCounterArray mCpuFreqTimeMs;
        LongSamplingCounterArray mScreenOffCpuFreqTimeMs;
        LongSamplingCounterArray mCpuClusterTimesMs;
        LongSamplingCounterArray[] mProcStateTimeMs;
        LongSamplingCounterArray[] mProcStateScreenOffTimeMs;
        IntArray mChildUids;
        final OverflowArrayMap<Wakelock> mWakelockStats;
        final OverflowArrayMap<DualTimer> mSyncStats;
        final OverflowArrayMap<DualTimer> mJobStats;
        final ArrayMap<String, SparseIntArray> mJobCompletions = new ArrayMap();
        Counter mJobsDeferredEventCount;
        Counter mJobsDeferredCount;
        LongSamplingCounter mJobsFreshnessTimeMs;
        final Counter[] mJobsFreshnessBuckets;
        final SparseArray<Sensor> mSensorStats = new SparseArray();
        final ArrayMap<String, Proc> mProcessStats = new ArrayMap();
        final ArrayMap<String, Pkg> mPackageStats = new ArrayMap();
        final SparseArray<BatteryStats.Uid.Pid> mPids = new SparseArray();

        public Uid(BatteryStatsImpl bsi, int uid) {
            this.mBsi = bsi;
            this.mUid = uid;
            this.mOnBatteryBackgroundTimeBase = new TimeBase(false);
            this.mOnBatteryBackgroundTimeBase.init(this.mBsi.mClocks.uptimeMillis() * 1000L, this.mBsi.mClocks.elapsedRealtime() * 1000L);
            this.mOnBatteryScreenOffBackgroundTimeBase = new TimeBase(false);
            this.mOnBatteryScreenOffBackgroundTimeBase.init(this.mBsi.mClocks.uptimeMillis() * 1000L, this.mBsi.mClocks.elapsedRealtime() * 1000L);
            this.mUserCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mSystemCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mCpuActiveTimeMs = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mCpuClusterTimesMs = new LongSamplingCounterArray(this.mBsi.mOnBatteryTimeBase);
            BatteryStatsImpl batteryStatsImpl = this.mBsi;
            Objects.requireNonNull(batteryStatsImpl);
            this.mWakelockStats = new OverflowArrayMap<Wakelock>(batteryStatsImpl, uid){
                {
                    BatteryStatsImpl batteryStatsImpl = x0;
                    Objects.requireNonNull(batteryStatsImpl);
                    super(uid);
                }

                @Override
                public Wakelock instantiateObject() {
                    return new Wakelock(mBsi, this);
                }
            };
            BatteryStatsImpl batteryStatsImpl2 = this.mBsi;
            Objects.requireNonNull(batteryStatsImpl2);
            this.mSyncStats = new OverflowArrayMap<DualTimer>(batteryStatsImpl2, uid){
                {
                    BatteryStatsImpl batteryStatsImpl = x0;
                    Objects.requireNonNull(batteryStatsImpl);
                    super(uid);
                }

                @Override
                public DualTimer instantiateObject() {
                    return new DualTimer(mBsi.mClocks, this, 13, null, mBsi.mOnBatteryTimeBase, mOnBatteryBackgroundTimeBase);
                }
            };
            BatteryStatsImpl batteryStatsImpl3 = this.mBsi;
            Objects.requireNonNull(batteryStatsImpl3);
            this.mJobStats = new OverflowArrayMap<DualTimer>(batteryStatsImpl3, uid){
                {
                    BatteryStatsImpl batteryStatsImpl = x0;
                    Objects.requireNonNull(batteryStatsImpl);
                    super(uid);
                }

                @Override
                public DualTimer instantiateObject() {
                    return new DualTimer(mBsi.mClocks, this, 14, null, mBsi.mOnBatteryTimeBase, mOnBatteryBackgroundTimeBase);
                }
            };
            this.mWifiRunningTimer = new StopwatchTimer(this.mBsi.mClocks, this, 4, this.mBsi.mWifiRunningTimers, this.mBsi.mOnBatteryTimeBase);
            this.mFullWifiLockTimer = new StopwatchTimer(this.mBsi.mClocks, this, 5, this.mBsi.mFullWifiLockTimers, this.mBsi.mOnBatteryTimeBase);
            this.mWifiScanTimer = new DualTimer(this.mBsi.mClocks, this, 6, this.mBsi.mWifiScanTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
            this.mWifiBatchedScanTimer = new StopwatchTimer[5];
            this.mWifiMulticastTimer = new StopwatchTimer(this.mBsi.mClocks, this, 7, this.mBsi.mWifiMulticastTimers, this.mBsi.mOnBatteryTimeBase);
            this.mProcessStateTimer = new StopwatchTimer[7];
            this.mJobsDeferredEventCount = new Counter(this.mBsi.mOnBatteryTimeBase);
            this.mJobsDeferredCount = new Counter(this.mBsi.mOnBatteryTimeBase);
            this.mJobsFreshnessTimeMs = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mJobsFreshnessBuckets = new Counter[BatteryStats.JOB_FRESHNESS_BUCKETS.length];
        }

        @VisibleForTesting
        public void setProcessStateForTest(int procState) {
            this.mProcessState = procState;
        }

        @Override
        public long[] getCpuFreqTimes(int which) {
            return this.nullIfAllZeros(this.mCpuFreqTimeMs, which);
        }

        @Override
        public long[] getScreenOffCpuFreqTimes(int which) {
            return this.nullIfAllZeros(this.mScreenOffCpuFreqTimeMs, which);
        }

        @Override
        public long getCpuActiveTime() {
            return this.mCpuActiveTimeMs.getCountLocked(0);
        }

        @Override
        public long[] getCpuClusterTimes() {
            return this.nullIfAllZeros(this.mCpuClusterTimesMs, 0);
        }

        @Override
        public long[] getCpuFreqTimes(int which, int procState) {
            if (which < 0 || which >= 7) {
                return null;
            }
            if (this.mProcStateTimeMs == null) {
                return null;
            }
            if (!this.mBsi.mPerProcStateCpuTimesAvailable) {
                this.mProcStateTimeMs = null;
                return null;
            }
            return this.nullIfAllZeros(this.mProcStateTimeMs[procState], which);
        }

        @Override
        public long[] getScreenOffCpuFreqTimes(int which, int procState) {
            if (which < 0 || which >= 7) {
                return null;
            }
            if (this.mProcStateScreenOffTimeMs == null) {
                return null;
            }
            if (!this.mBsi.mPerProcStateCpuTimesAvailable) {
                this.mProcStateScreenOffTimeMs = null;
                return null;
            }
            return this.nullIfAllZeros(this.mProcStateScreenOffTimeMs[procState], which);
        }

        public void addIsolatedUid(int isolatedUid) {
            if (this.mChildUids == null) {
                this.mChildUids = new IntArray();
            } else if (this.mChildUids.indexOf(isolatedUid) >= 0) {
                return;
            }
            this.mChildUids.add(isolatedUid);
        }

        public void removeIsolatedUid(int isolatedUid) {
            int idx;
            int n = idx = this.mChildUids == null ? -1 : this.mChildUids.indexOf(isolatedUid);
            if (idx < 0) {
                return;
            }
            this.mChildUids.remove(idx);
        }

        private long[] nullIfAllZeros(LongSamplingCounterArray cpuTimesMs, int which) {
            if (cpuTimesMs == null) {
                return null;
            }
            long[] counts = cpuTimesMs.getCountsLocked(which);
            if (counts == null) {
                return null;
            }
            for (int i = counts.length - 1; i >= 0; --i) {
                if (counts[i] == 0L) continue;
                return counts;
            }
            return null;
        }

        private void addProcStateTimesMs(int procState, long[] cpuTimesMs, boolean onBattery) {
            if (this.mProcStateTimeMs == null) {
                this.mProcStateTimeMs = new LongSamplingCounterArray[7];
            }
            if (this.mProcStateTimeMs[procState] == null || this.mProcStateTimeMs[procState].getSize() != cpuTimesMs.length) {
                BatteryStatsImpl.detachIfNotNull(this.mProcStateTimeMs[procState]);
                this.mProcStateTimeMs[procState] = new LongSamplingCounterArray(this.mBsi.mOnBatteryTimeBase);
            }
            this.mProcStateTimeMs[procState].addCountLocked(cpuTimesMs, onBattery);
        }

        private void addProcStateScreenOffTimesMs(int procState, long[] cpuTimesMs, boolean onBatteryScreenOff) {
            if (this.mProcStateScreenOffTimeMs == null) {
                this.mProcStateScreenOffTimeMs = new LongSamplingCounterArray[7];
            }
            if (this.mProcStateScreenOffTimeMs[procState] == null || this.mProcStateScreenOffTimeMs[procState].getSize() != cpuTimesMs.length) {
                BatteryStatsImpl.detachIfNotNull(this.mProcStateScreenOffTimeMs[procState]);
                this.mProcStateScreenOffTimeMs[procState] = new LongSamplingCounterArray(this.mBsi.mOnBatteryScreenOffTimeBase);
            }
            this.mProcStateScreenOffTimeMs[procState].addCountLocked(cpuTimesMs, onBatteryScreenOff);
        }

        @Override
        public Timer getAggregatedPartialWakelockTimer() {
            return this.mAggregatedPartialWakelockTimer;
        }

        @Override
        @UnsupportedAppUsage
        public ArrayMap<String, ? extends BatteryStats.Uid.Wakelock> getWakelockStats() {
            return this.mWakelockStats.getMap();
        }

        @Override
        public Timer getMulticastWakelockStats() {
            return this.mWifiMulticastTimer;
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Timer> getSyncStats() {
            return this.mSyncStats.getMap();
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Timer> getJobStats() {
            return this.mJobStats.getMap();
        }

        @Override
        public ArrayMap<String, SparseIntArray> getJobCompletionStats() {
            return this.mJobCompletions;
        }

        @Override
        @UnsupportedAppUsage
        public SparseArray<? extends BatteryStats.Uid.Sensor> getSensorStats() {
            return this.mSensorStats;
        }

        @Override
        @UnsupportedAppUsage
        public ArrayMap<String, ? extends BatteryStats.Uid.Proc> getProcessStats() {
            return this.mProcessStats;
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Uid.Pkg> getPackageStats() {
            return this.mPackageStats;
        }

        @Override
        @UnsupportedAppUsage
        public int getUid() {
            return this.mUid;
        }

        @Override
        public void noteWifiRunningLocked(long elapsedRealtimeMs) {
            if (!this.mWifiRunning) {
                this.mWifiRunning = true;
                if (this.mWifiRunningTimer == null) {
                    this.mWifiRunningTimer = new StopwatchTimer(this.mBsi.mClocks, this, 4, this.mBsi.mWifiRunningTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mWifiRunningTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiRunning) {
                this.mWifiRunning = false;
                this.mWifiRunningTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteFullWifiLockAcquiredLocked(long elapsedRealtimeMs) {
            if (!this.mFullWifiLockOut) {
                this.mFullWifiLockOut = true;
                if (this.mFullWifiLockTimer == null) {
                    this.mFullWifiLockTimer = new StopwatchTimer(this.mBsi.mClocks, this, 5, this.mBsi.mFullWifiLockTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mFullWifiLockTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteFullWifiLockReleasedLocked(long elapsedRealtimeMs) {
            if (this.mFullWifiLockOut) {
                this.mFullWifiLockOut = false;
                this.mFullWifiLockTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiScanStartedLocked(long elapsedRealtimeMs) {
            if (!this.mWifiScanStarted) {
                this.mWifiScanStarted = true;
                if (this.mWifiScanTimer == null) {
                    this.mWifiScanTimer = new DualTimer(this.mBsi.mClocks, this, 6, this.mBsi.mWifiScanTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
                }
                this.mWifiScanTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiScanStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiScanStarted) {
                this.mWifiScanStarted = false;
                this.mWifiScanTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiBatchedScanStartedLocked(int csph, long elapsedRealtimeMs) {
            int bin;
            for (bin = 0; csph > 8 && bin < 4; csph >>= 3, ++bin) {
            }
            if (this.mWifiBatchedScanBinStarted == bin) {
                return;
            }
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(elapsedRealtimeMs);
            }
            this.mWifiBatchedScanBinStarted = bin;
            if (this.mWifiBatchedScanTimer[bin] == null) {
                this.makeWifiBatchedScanBin(bin, null);
            }
            this.mWifiBatchedScanTimer[bin].startRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void noteWifiBatchedScanStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(elapsedRealtimeMs);
                this.mWifiBatchedScanBinStarted = -1;
            }
        }

        @Override
        public void noteWifiMulticastEnabledLocked(long elapsedRealtimeMs) {
            if (this.mWifiMulticastWakelockCount == 0) {
                if (this.mWifiMulticastTimer == null) {
                    this.mWifiMulticastTimer = new StopwatchTimer(this.mBsi.mClocks, this, 7, this.mBsi.mWifiMulticastTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mWifiMulticastTimer.startRunningLocked(elapsedRealtimeMs);
            }
            ++this.mWifiMulticastWakelockCount;
        }

        @Override
        public void noteWifiMulticastDisabledLocked(long elapsedRealtimeMs) {
            if (this.mWifiMulticastWakelockCount == 0) {
                return;
            }
            --this.mWifiMulticastWakelockCount;
            if (this.mWifiMulticastWakelockCount == 0) {
                this.mWifiMulticastTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public BatteryStats.ControllerActivityCounter getWifiControllerActivity() {
            return this.mWifiControllerActivity;
        }

        @Override
        public BatteryStats.ControllerActivityCounter getBluetoothControllerActivity() {
            return this.mBluetoothControllerActivity;
        }

        @Override
        public BatteryStats.ControllerActivityCounter getModemControllerActivity() {
            return this.mModemControllerActivity;
        }

        public ControllerActivityCounterImpl getOrCreateWifiControllerActivityLocked() {
            if (this.mWifiControllerActivity == null) {
                this.mWifiControllerActivity = new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 1);
            }
            return this.mWifiControllerActivity;
        }

        public ControllerActivityCounterImpl getOrCreateBluetoothControllerActivityLocked() {
            if (this.mBluetoothControllerActivity == null) {
                this.mBluetoothControllerActivity = new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 1);
            }
            return this.mBluetoothControllerActivity;
        }

        public ControllerActivityCounterImpl getOrCreateModemControllerActivityLocked() {
            if (this.mModemControllerActivity == null) {
                this.mModemControllerActivity = new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 5);
            }
            return this.mModemControllerActivity;
        }

        public StopwatchTimer createAudioTurnedOnTimerLocked() {
            if (this.mAudioTurnedOnTimer == null) {
                this.mAudioTurnedOnTimer = new StopwatchTimer(this.mBsi.mClocks, this, 15, this.mBsi.mAudioTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mAudioTurnedOnTimer;
        }

        public void noteAudioTurnedOnLocked(long elapsedRealtimeMs) {
            this.createAudioTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteAudioTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetAudioLocked(long elapsedRealtimeMs) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createVideoTurnedOnTimerLocked() {
            if (this.mVideoTurnedOnTimer == null) {
                this.mVideoTurnedOnTimer = new StopwatchTimer(this.mBsi.mClocks, this, 8, this.mBsi.mVideoTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mVideoTurnedOnTimer;
        }

        public void noteVideoTurnedOnLocked(long elapsedRealtimeMs) {
            this.createVideoTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteVideoTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetVideoLocked(long elapsedRealtimeMs) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createFlashlightTurnedOnTimerLocked() {
            if (this.mFlashlightTurnedOnTimer == null) {
                this.mFlashlightTurnedOnTimer = new StopwatchTimer(this.mBsi.mClocks, this, 16, this.mBsi.mFlashlightTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mFlashlightTurnedOnTimer;
        }

        public void noteFlashlightTurnedOnLocked(long elapsedRealtimeMs) {
            this.createFlashlightTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteFlashlightTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mFlashlightTurnedOnTimer != null) {
                this.mFlashlightTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetFlashlightLocked(long elapsedRealtimeMs) {
            if (this.mFlashlightTurnedOnTimer != null) {
                this.mFlashlightTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createCameraTurnedOnTimerLocked() {
            if (this.mCameraTurnedOnTimer == null) {
                this.mCameraTurnedOnTimer = new StopwatchTimer(this.mBsi.mClocks, this, 17, this.mBsi.mCameraTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mCameraTurnedOnTimer;
        }

        public void noteCameraTurnedOnLocked(long elapsedRealtimeMs) {
            this.createCameraTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteCameraTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mCameraTurnedOnTimer != null) {
                this.mCameraTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetCameraLocked(long elapsedRealtimeMs) {
            if (this.mCameraTurnedOnTimer != null) {
                this.mCameraTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createForegroundActivityTimerLocked() {
            if (this.mForegroundActivityTimer == null) {
                this.mForegroundActivityTimer = new StopwatchTimer(this.mBsi.mClocks, this, 10, null, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mForegroundActivityTimer;
        }

        public StopwatchTimer createForegroundServiceTimerLocked() {
            if (this.mForegroundServiceTimer == null) {
                this.mForegroundServiceTimer = new StopwatchTimer(this.mBsi.mClocks, this, 22, null, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mForegroundServiceTimer;
        }

        public DualTimer createAggregatedPartialWakelockTimerLocked() {
            if (this.mAggregatedPartialWakelockTimer == null) {
                this.mAggregatedPartialWakelockTimer = new DualTimer(this.mBsi.mClocks, this, 20, null, this.mBsi.mOnBatteryScreenOffTimeBase, this.mOnBatteryScreenOffBackgroundTimeBase);
            }
            return this.mAggregatedPartialWakelockTimer;
        }

        public DualTimer createBluetoothScanTimerLocked() {
            if (this.mBluetoothScanTimer == null) {
                this.mBluetoothScanTimer = new DualTimer(this.mBsi.mClocks, this, 19, this.mBsi.mBluetoothScanOnTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
            }
            return this.mBluetoothScanTimer;
        }

        public DualTimer createBluetoothUnoptimizedScanTimerLocked() {
            if (this.mBluetoothUnoptimizedScanTimer == null) {
                this.mBluetoothUnoptimizedScanTimer = new DualTimer(this.mBsi.mClocks, this, 21, null, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
            }
            return this.mBluetoothUnoptimizedScanTimer;
        }

        public void noteBluetoothScanStartedLocked(long elapsedRealtimeMs, boolean isUnoptimized) {
            this.createBluetoothScanTimerLocked().startRunningLocked(elapsedRealtimeMs);
            if (isUnoptimized) {
                this.createBluetoothUnoptimizedScanTimerLocked().startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteBluetoothScanStoppedLocked(long elapsedRealtimeMs, boolean isUnoptimized) {
            if (this.mBluetoothScanTimer != null) {
                this.mBluetoothScanTimer.stopRunningLocked(elapsedRealtimeMs);
            }
            if (isUnoptimized && this.mBluetoothUnoptimizedScanTimer != null) {
                this.mBluetoothUnoptimizedScanTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetBluetoothScanLocked(long elapsedRealtimeMs) {
            if (this.mBluetoothScanTimer != null) {
                this.mBluetoothScanTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
            if (this.mBluetoothUnoptimizedScanTimer != null) {
                this.mBluetoothUnoptimizedScanTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public Counter createBluetoothScanResultCounterLocked() {
            if (this.mBluetoothScanResultCounter == null) {
                this.mBluetoothScanResultCounter = new Counter(this.mBsi.mOnBatteryTimeBase);
            }
            return this.mBluetoothScanResultCounter;
        }

        public Counter createBluetoothScanResultBgCounterLocked() {
            if (this.mBluetoothScanResultBgCounter == null) {
                this.mBluetoothScanResultBgCounter = new Counter(this.mOnBatteryBackgroundTimeBase);
            }
            return this.mBluetoothScanResultBgCounter;
        }

        public void noteBluetoothScanResultsLocked(int numNewResults) {
            this.createBluetoothScanResultCounterLocked().addAtomic(numNewResults);
            this.createBluetoothScanResultBgCounterLocked().addAtomic(numNewResults);
        }

        @Override
        public void noteActivityResumedLocked(long elapsedRealtimeMs) {
            this.createForegroundActivityTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void noteActivityPausedLocked(long elapsedRealtimeMs) {
            if (this.mForegroundActivityTimer != null) {
                this.mForegroundActivityTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteForegroundServiceResumedLocked(long elapsedRealtimeMs) {
            this.createForegroundServiceTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteForegroundServicePausedLocked(long elapsedRealtimeMs) {
            if (this.mForegroundServiceTimer != null) {
                this.mForegroundServiceTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public BatchTimer createVibratorOnTimerLocked() {
            if (this.mVibratorOnTimer == null) {
                this.mVibratorOnTimer = new BatchTimer(this.mBsi.mClocks, this, 9, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mVibratorOnTimer;
        }

        public void noteVibratorOnLocked(long durationMillis) {
            this.createVibratorOnTimerLocked().addDuration(this.mBsi, durationMillis);
        }

        public void noteVibratorOffLocked() {
            if (this.mVibratorOnTimer != null) {
                this.mVibratorOnTimer.abortLastDuration(this.mBsi);
            }
        }

        @Override
        @UnsupportedAppUsage
        public long getWifiRunningTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiRunningTimer == null) {
                return 0L;
            }
            return this.mWifiRunningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public long getFullWifiLockTime(long elapsedRealtimeUs, int which) {
            if (this.mFullWifiLockTimer == null) {
                return 0L;
            }
            return this.mFullWifiLockTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        @UnsupportedAppUsage
        public long getWifiScanTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiScanTimer == null) {
                return 0L;
            }
            return this.mWifiScanTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public int getWifiScanCount(int which) {
            if (this.mWifiScanTimer == null) {
                return 0;
            }
            return this.mWifiScanTimer.getCountLocked(which);
        }

        @Override
        public Timer getWifiScanTimer() {
            return this.mWifiScanTimer;
        }

        @Override
        public int getWifiScanBackgroundCount(int which) {
            if (this.mWifiScanTimer == null || this.mWifiScanTimer.getSubTimer() == null) {
                return 0;
            }
            return this.mWifiScanTimer.getSubTimer().getCountLocked(which);
        }

        @Override
        public long getWifiScanActualTime(long elapsedRealtimeUs) {
            if (this.mWifiScanTimer == null) {
                return 0L;
            }
            long elapsedRealtimeMs = (elapsedRealtimeUs + 500L) / 1000L;
            return this.mWifiScanTimer.getTotalDurationMsLocked(elapsedRealtimeMs) * 1000L;
        }

        @Override
        public long getWifiScanBackgroundTime(long elapsedRealtimeUs) {
            if (this.mWifiScanTimer == null || this.mWifiScanTimer.getSubTimer() == null) {
                return 0L;
            }
            long elapsedRealtimeMs = (elapsedRealtimeUs + 500L) / 1000L;
            return this.mWifiScanTimer.getSubTimer().getTotalDurationMsLocked(elapsedRealtimeMs) * 1000L;
        }

        @Override
        public Timer getWifiScanBackgroundTimer() {
            if (this.mWifiScanTimer == null) {
                return null;
            }
            return this.mWifiScanTimer.getSubTimer();
        }

        @Override
        public long getWifiBatchedScanTime(int csphBin, long elapsedRealtimeUs, int which) {
            if (csphBin < 0 || csphBin >= 5) {
                return 0L;
            }
            if (this.mWifiBatchedScanTimer[csphBin] == null) {
                return 0L;
            }
            return this.mWifiBatchedScanTimer[csphBin].getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public int getWifiBatchedScanCount(int csphBin, int which) {
            if (csphBin < 0 || csphBin >= 5) {
                return 0;
            }
            if (this.mWifiBatchedScanTimer[csphBin] == null) {
                return 0;
            }
            return this.mWifiBatchedScanTimer[csphBin].getCountLocked(which);
        }

        @Override
        public long getWifiMulticastTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiMulticastTimer == null) {
                return 0L;
            }
            return this.mWifiMulticastTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public Timer getAudioTurnedOnTimer() {
            return this.mAudioTurnedOnTimer;
        }

        @Override
        public Timer getVideoTurnedOnTimer() {
            return this.mVideoTurnedOnTimer;
        }

        @Override
        public Timer getFlashlightTurnedOnTimer() {
            return this.mFlashlightTurnedOnTimer;
        }

        @Override
        public Timer getCameraTurnedOnTimer() {
            return this.mCameraTurnedOnTimer;
        }

        @Override
        public Timer getForegroundActivityTimer() {
            return this.mForegroundActivityTimer;
        }

        @Override
        public Timer getForegroundServiceTimer() {
            return this.mForegroundServiceTimer;
        }

        @Override
        public Timer getBluetoothScanTimer() {
            return this.mBluetoothScanTimer;
        }

        @Override
        public Timer getBluetoothScanBackgroundTimer() {
            if (this.mBluetoothScanTimer == null) {
                return null;
            }
            return this.mBluetoothScanTimer.getSubTimer();
        }

        @Override
        public Timer getBluetoothUnoptimizedScanTimer() {
            return this.mBluetoothUnoptimizedScanTimer;
        }

        @Override
        public Timer getBluetoothUnoptimizedScanBackgroundTimer() {
            if (this.mBluetoothUnoptimizedScanTimer == null) {
                return null;
            }
            return this.mBluetoothUnoptimizedScanTimer.getSubTimer();
        }

        @Override
        public Counter getBluetoothScanResultCounter() {
            return this.mBluetoothScanResultCounter;
        }

        @Override
        public Counter getBluetoothScanResultBgCounter() {
            return this.mBluetoothScanResultBgCounter;
        }

        void makeProcessState(int i, Parcel in) {
            if (i < 0 || i >= 7) {
                return;
            }
            BatteryStatsImpl.detachIfNotNull(this.mProcessStateTimer[i]);
            this.mProcessStateTimer[i] = in == null ? new StopwatchTimer(this.mBsi.mClocks, this, 12, null, this.mBsi.mOnBatteryTimeBase) : new StopwatchTimer(this.mBsi.mClocks, this, 12, null, this.mBsi.mOnBatteryTimeBase, in);
        }

        @Override
        public long getProcessStateTime(int state, long elapsedRealtimeUs, int which) {
            if (state < 0 || state >= 7) {
                return 0L;
            }
            if (this.mProcessStateTimer[state] == null) {
                return 0L;
            }
            return this.mProcessStateTimer[state].getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public Timer getProcessStateTimer(int state) {
            if (state < 0 || state >= 7) {
                return null;
            }
            return this.mProcessStateTimer[state];
        }

        @Override
        public Timer getVibratorOnTimer() {
            return this.mVibratorOnTimer;
        }

        @Override
        public void noteUserActivityLocked(int type) {
            if (this.mUserActivityCounters == null) {
                this.initUserActivityLocked();
            }
            if (type >= 0 && type < NUM_USER_ACTIVITY_TYPES) {
                this.mUserActivityCounters[type].stepAtomic();
            } else {
                Slog.w(BatteryStatsImpl.TAG, "Unknown user activity type " + type + " was specified.", new Throwable());
            }
        }

        @Override
        public boolean hasUserActivity() {
            return this.mUserActivityCounters != null;
        }

        @Override
        public int getUserActivityCount(int type, int which) {
            if (this.mUserActivityCounters == null) {
                return 0;
            }
            return this.mUserActivityCounters[type].getCountLocked(which);
        }

        void makeWifiBatchedScanBin(int i, Parcel in) {
            if (i < 0 || i >= 5) {
                return;
            }
            ArrayList<StopwatchTimer> collected = this.mBsi.mWifiBatchedScanTimers.get(i);
            if (collected == null) {
                collected = new ArrayList();
                this.mBsi.mWifiBatchedScanTimers.put(i, collected);
            }
            BatteryStatsImpl.detachIfNotNull(this.mWifiBatchedScanTimer[i]);
            this.mWifiBatchedScanTimer[i] = in == null ? new StopwatchTimer(this.mBsi.mClocks, this, 11, collected, this.mBsi.mOnBatteryTimeBase) : new StopwatchTimer(this.mBsi.mClocks, this, 11, collected, this.mBsi.mOnBatteryTimeBase, in);
        }

        void initUserActivityLocked() {
            BatteryStatsImpl.detachIfNotNull(this.mUserActivityCounters);
            this.mUserActivityCounters = new Counter[NUM_USER_ACTIVITY_TYPES];
            for (int i = 0; i < NUM_USER_ACTIVITY_TYPES; ++i) {
                this.mUserActivityCounters[i] = new Counter(this.mBsi.mOnBatteryTimeBase);
            }
        }

        void noteNetworkActivityLocked(int type, long deltaBytes, long deltaPackets) {
            if (this.mNetworkByteActivityCounters == null) {
                this.initNetworkActivityLocked();
            }
            if (type >= 0 && type < 10) {
                this.mNetworkByteActivityCounters[type].addCountLocked(deltaBytes);
                this.mNetworkPacketActivityCounters[type].addCountLocked(deltaPackets);
            } else {
                Slog.w(BatteryStatsImpl.TAG, "Unknown network activity type " + type + " was specified.", new Throwable());
            }
        }

        void noteMobileRadioActiveTimeLocked(long batteryUptime) {
            if (this.mNetworkByteActivityCounters == null) {
                this.initNetworkActivityLocked();
            }
            this.mMobileRadioActiveTime.addCountLocked(batteryUptime);
            this.mMobileRadioActiveCount.addCountLocked(1L);
        }

        @Override
        public boolean hasNetworkActivity() {
            return this.mNetworkByteActivityCounters != null;
        }

        @Override
        public long getNetworkActivityBytes(int type, int which) {
            if (this.mNetworkByteActivityCounters != null && type >= 0 && type < this.mNetworkByteActivityCounters.length) {
                return this.mNetworkByteActivityCounters[type].getCountLocked(which);
            }
            return 0L;
        }

        @Override
        public long getNetworkActivityPackets(int type, int which) {
            if (this.mNetworkPacketActivityCounters != null && type >= 0 && type < this.mNetworkPacketActivityCounters.length) {
                return this.mNetworkPacketActivityCounters[type].getCountLocked(which);
            }
            return 0L;
        }

        @Override
        public long getMobileRadioActiveTime(int which) {
            return this.mMobileRadioActiveTime != null ? this.mMobileRadioActiveTime.getCountLocked(which) : 0L;
        }

        @Override
        public int getMobileRadioActiveCount(int which) {
            return this.mMobileRadioActiveCount != null ? (int)this.mMobileRadioActiveCount.getCountLocked(which) : 0;
        }

        @Override
        public long getUserCpuTimeUs(int which) {
            return this.mUserCpuTime.getCountLocked(which);
        }

        @Override
        public long getSystemCpuTimeUs(int which) {
            return this.mSystemCpuTime.getCountLocked(which);
        }

        @Override
        public long getTimeAtCpuSpeed(int cluster, int step, int which) {
            LongSamplingCounter c;
            LongSamplingCounter[] cpuSpeedTimesUs;
            if (this.mCpuClusterSpeedTimesUs != null && cluster >= 0 && cluster < this.mCpuClusterSpeedTimesUs.length && (cpuSpeedTimesUs = this.mCpuClusterSpeedTimesUs[cluster]) != null && step >= 0 && step < cpuSpeedTimesUs.length && (c = cpuSpeedTimesUs[step]) != null) {
                return c.getCountLocked(which);
            }
            return 0L;
        }

        public void noteMobileRadioApWakeupLocked() {
            if (this.mMobileRadioApWakeupCount == null) {
                this.mMobileRadioApWakeupCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            }
            this.mMobileRadioApWakeupCount.addCountLocked(1L);
        }

        @Override
        public long getMobileRadioApWakeupCount(int which) {
            if (this.mMobileRadioApWakeupCount != null) {
                return this.mMobileRadioApWakeupCount.getCountLocked(which);
            }
            return 0L;
        }

        public void noteWifiRadioApWakeupLocked() {
            if (this.mWifiRadioApWakeupCount == null) {
                this.mWifiRadioApWakeupCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            }
            this.mWifiRadioApWakeupCount.addCountLocked(1L);
        }

        @Override
        public long getWifiRadioApWakeupCount(int which) {
            if (this.mWifiRadioApWakeupCount != null) {
                return this.mWifiRadioApWakeupCount.getCountLocked(which);
            }
            return 0L;
        }

        @Override
        public void getDeferredJobsCheckinLineLocked(StringBuilder sb, int which) {
            sb.setLength(0);
            int deferredEventCount = this.mJobsDeferredEventCount.getCountLocked(which);
            if (deferredEventCount == 0) {
                return;
            }
            int deferredCount = this.mJobsDeferredCount.getCountLocked(which);
            long totalLatency = this.mJobsFreshnessTimeMs.getCountLocked(which);
            sb.append(deferredEventCount);
            sb.append(',');
            sb.append(deferredCount);
            sb.append(',');
            sb.append(totalLatency);
            for (int i = 0; i < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i) {
                if (this.mJobsFreshnessBuckets[i] == null) {
                    sb.append(",0");
                    continue;
                }
                sb.append(",");
                sb.append(this.mJobsFreshnessBuckets[i].getCountLocked(which));
            }
        }

        @Override
        public void getDeferredJobsLineLocked(StringBuilder sb, int which) {
            sb.setLength(0);
            int deferredEventCount = this.mJobsDeferredEventCount.getCountLocked(which);
            if (deferredEventCount == 0) {
                return;
            }
            int deferredCount = this.mJobsDeferredCount.getCountLocked(which);
            long totalLatency = this.mJobsFreshnessTimeMs.getCountLocked(which);
            sb.append("times=");
            sb.append(deferredEventCount);
            sb.append(", ");
            sb.append("count=");
            sb.append(deferredCount);
            sb.append(", ");
            sb.append("totalLatencyMs=");
            sb.append(totalLatency);
            sb.append(", ");
            for (int i = 0; i < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i) {
                sb.append("<");
                sb.append(BatteryStats.JOB_FRESHNESS_BUCKETS[i]);
                sb.append("ms=");
                if (this.mJobsFreshnessBuckets[i] == null) {
                    sb.append("0");
                } else {
                    sb.append(this.mJobsFreshnessBuckets[i].getCountLocked(which));
                }
                sb.append(" ");
            }
        }

        void initNetworkActivityLocked() {
            BatteryStatsImpl.detachIfNotNull(this.mNetworkByteActivityCounters);
            this.mNetworkByteActivityCounters = new LongSamplingCounter[10];
            BatteryStatsImpl.detachIfNotNull(this.mNetworkPacketActivityCounters);
            this.mNetworkPacketActivityCounters = new LongSamplingCounter[10];
            for (int i = 0; i < 10; ++i) {
                this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
                this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            }
            BatteryStatsImpl.detachIfNotNull(this.mMobileRadioActiveTime);
            this.mMobileRadioActiveTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            BatteryStatsImpl.detachIfNotNull(this.mMobileRadioActiveCount);
            this.mMobileRadioActiveCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public boolean reset(long uptime, long realtime) {
            int i;
            int i2;
            boolean active = false;
            this.mOnBatteryBackgroundTimeBase.init(uptime, realtime);
            this.mOnBatteryScreenOffBackgroundTimeBase.init(uptime, realtime);
            if (this.mWifiRunningTimer != null) {
                active |= !this.mWifiRunningTimer.reset(false);
                active |= this.mWifiRunning;
            }
            if (this.mFullWifiLockTimer != null) {
                active |= !this.mFullWifiLockTimer.reset(false);
                active |= this.mFullWifiLockOut;
            }
            if (this.mWifiScanTimer != null) {
                active |= !this.mWifiScanTimer.reset(false);
                active |= this.mWifiScanStarted;
            }
            if (this.mWifiBatchedScanTimer != null) {
                for (i2 = 0; i2 < 5; ++i2) {
                    if (this.mWifiBatchedScanTimer[i2] == null) continue;
                    active |= !this.mWifiBatchedScanTimer[i2].reset(false);
                }
                active |= this.mWifiBatchedScanBinStarted != -1;
            }
            if (this.mWifiMulticastTimer != null) {
                active |= !this.mWifiMulticastTimer.reset(false);
                active |= this.mWifiMulticastWakelockCount > 0;
            }
            active |= !BatteryStatsImpl.resetIfNotNull(this.mAudioTurnedOnTimer, false);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mVideoTurnedOnTimer, false);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mFlashlightTurnedOnTimer, false);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mCameraTurnedOnTimer, false);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mForegroundActivityTimer, false);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mForegroundServiceTimer, false);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mAggregatedPartialWakelockTimer, false);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mBluetoothScanTimer, false);
            active |= !BatteryStatsImpl.resetIfNotNull(this.mBluetoothUnoptimizedScanTimer, false);
            BatteryStatsImpl.resetIfNotNull(this.mBluetoothScanResultCounter, false);
            BatteryStatsImpl.resetIfNotNull(this.mBluetoothScanResultBgCounter, false);
            if (this.mProcessStateTimer != null) {
                for (i2 = 0; i2 < 7; ++i2) {
                    active |= !BatteryStatsImpl.resetIfNotNull(this.mProcessStateTimer[i2], false);
                }
                active |= this.mProcessState != 20;
            }
            if (this.mVibratorOnTimer != null) {
                if (this.mVibratorOnTimer.reset(false)) {
                    this.mVibratorOnTimer.detach();
                    this.mVibratorOnTimer = null;
                } else {
                    active = true;
                }
            }
            BatteryStatsImpl.resetIfNotNull(this.mUserActivityCounters, false);
            BatteryStatsImpl.resetIfNotNull(this.mNetworkByteActivityCounters, false);
            BatteryStatsImpl.resetIfNotNull(this.mNetworkPacketActivityCounters, false);
            BatteryStatsImpl.resetIfNotNull(this.mMobileRadioActiveTime, false);
            BatteryStatsImpl.resetIfNotNull(this.mMobileRadioActiveCount, false);
            BatteryStatsImpl.resetIfNotNull(this.mWifiControllerActivity, false);
            BatteryStatsImpl.resetIfNotNull(this.mBluetoothControllerActivity, false);
            BatteryStatsImpl.resetIfNotNull(this.mModemControllerActivity, false);
            BatteryStatsImpl.resetIfNotNull(this.mUserCpuTime, false);
            BatteryStatsImpl.resetIfNotNull(this.mSystemCpuTime, false);
            BatteryStatsImpl.resetIfNotNull(this.mCpuClusterSpeedTimesUs, false);
            BatteryStatsImpl.resetIfNotNull(this.mCpuFreqTimeMs, false);
            BatteryStatsImpl.resetIfNotNull(this.mScreenOffCpuFreqTimeMs, false);
            BatteryStatsImpl.resetIfNotNull(this.mCpuActiveTimeMs, false);
            BatteryStatsImpl.resetIfNotNull(this.mCpuClusterTimesMs, false);
            BatteryStatsImpl.resetIfNotNull(this.mProcStateTimeMs, false);
            BatteryStatsImpl.resetIfNotNull(this.mProcStateScreenOffTimeMs, false);
            BatteryStatsImpl.resetIfNotNull(this.mMobileRadioApWakeupCount, false);
            BatteryStatsImpl.resetIfNotNull(this.mWifiRadioApWakeupCount, false);
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            for (int iw = wakeStats.size() - 1; iw >= 0; --iw) {
                Wakelock wl = wakeStats.valueAt(iw);
                if (wl.reset()) {
                    wakeStats.removeAt(iw);
                    continue;
                }
                active = true;
            }
            this.mWakelockStats.cleanup();
            ArrayMap<String, DualTimer> syncStats = this.mSyncStats.getMap();
            for (int is = syncStats.size() - 1; is >= 0; --is) {
                DualTimer timer = syncStats.valueAt(is);
                if (timer.reset(false)) {
                    syncStats.removeAt(is);
                    timer.detach();
                    continue;
                }
                active = true;
            }
            this.mSyncStats.cleanup();
            ArrayMap<String, DualTimer> jobStats = this.mJobStats.getMap();
            for (int ij = jobStats.size() - 1; ij >= 0; --ij) {
                DualTimer timer = jobStats.valueAt(ij);
                if (timer.reset(false)) {
                    jobStats.removeAt(ij);
                    timer.detach();
                    continue;
                }
                active = true;
            }
            this.mJobStats.cleanup();
            this.mJobCompletions.clear();
            BatteryStatsImpl.resetIfNotNull(this.mJobsDeferredEventCount, false);
            BatteryStatsImpl.resetIfNotNull(this.mJobsDeferredCount, false);
            BatteryStatsImpl.resetIfNotNull(this.mJobsFreshnessTimeMs, false);
            BatteryStatsImpl.resetIfNotNull(this.mJobsFreshnessBuckets, false);
            for (int ise = this.mSensorStats.size() - 1; ise >= 0; --ise) {
                Sensor s = this.mSensorStats.valueAt(ise);
                if (s.reset()) {
                    this.mSensorStats.removeAt(ise);
                    continue;
                }
                active = true;
            }
            for (int ip = this.mProcessStats.size() - 1; ip >= 0; --ip) {
                Proc proc = this.mProcessStats.valueAt(ip);
                proc.detach();
            }
            this.mProcessStats.clear();
            for (i = this.mPids.size() - 1; i >= 0; --i) {
                BatteryStats.Uid.Pid pid = this.mPids.valueAt(i);
                if (pid.mWakeNesting > 0) {
                    active = true;
                    continue;
                }
                this.mPids.removeAt(i);
            }
            for (i = this.mPackageStats.size() - 1; i >= 0; --i) {
                Pkg p = this.mPackageStats.valueAt(i);
                p.detach();
            }
            this.mPackageStats.clear();
            this.mLastStepSystemTime = 0L;
            this.mLastStepUserTime = 0L;
            this.mCurStepSystemTime = 0L;
            this.mCurStepUserTime = 0L;
            return !active;
        }

        void detachFromTimeBase() {
            BatteryStatsImpl.detachIfNotNull(this.mWifiRunningTimer);
            BatteryStatsImpl.detachIfNotNull(this.mFullWifiLockTimer);
            BatteryStatsImpl.detachIfNotNull(this.mWifiScanTimer);
            BatteryStatsImpl.detachIfNotNull(this.mWifiBatchedScanTimer);
            BatteryStatsImpl.detachIfNotNull(this.mWifiMulticastTimer);
            BatteryStatsImpl.detachIfNotNull(this.mAudioTurnedOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mVideoTurnedOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mFlashlightTurnedOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mCameraTurnedOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mForegroundActivityTimer);
            BatteryStatsImpl.detachIfNotNull(this.mForegroundServiceTimer);
            BatteryStatsImpl.detachIfNotNull(this.mAggregatedPartialWakelockTimer);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothScanTimer);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothUnoptimizedScanTimer);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothScanResultCounter);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothScanResultBgCounter);
            BatteryStatsImpl.detachIfNotNull(this.mProcessStateTimer);
            BatteryStatsImpl.detachIfNotNull(this.mVibratorOnTimer);
            BatteryStatsImpl.detachIfNotNull(this.mUserActivityCounters);
            BatteryStatsImpl.detachIfNotNull(this.mNetworkByteActivityCounters);
            BatteryStatsImpl.detachIfNotNull(this.mNetworkPacketActivityCounters);
            BatteryStatsImpl.detachIfNotNull(this.mMobileRadioActiveTime);
            BatteryStatsImpl.detachIfNotNull(this.mMobileRadioActiveCount);
            BatteryStatsImpl.detachIfNotNull(this.mMobileRadioApWakeupCount);
            BatteryStatsImpl.detachIfNotNull(this.mWifiRadioApWakeupCount);
            BatteryStatsImpl.detachIfNotNull(this.mWifiControllerActivity);
            BatteryStatsImpl.detachIfNotNull(this.mBluetoothControllerActivity);
            BatteryStatsImpl.detachIfNotNull(this.mModemControllerActivity);
            this.mPids.clear();
            BatteryStatsImpl.detachIfNotNull(this.mUserCpuTime);
            BatteryStatsImpl.detachIfNotNull(this.mSystemCpuTime);
            BatteryStatsImpl.detachIfNotNull(this.mCpuClusterSpeedTimesUs);
            BatteryStatsImpl.detachIfNotNull(this.mCpuActiveTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mCpuFreqTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mScreenOffCpuFreqTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mCpuClusterTimesMs);
            BatteryStatsImpl.detachIfNotNull(this.mProcStateTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mProcStateScreenOffTimeMs);
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            for (int iw = wakeStats.size() - 1; iw >= 0; --iw) {
                Wakelock wl = wakeStats.valueAt(iw);
                wl.detachFromTimeBase();
            }
            ArrayMap<String, DualTimer> syncStats = this.mSyncStats.getMap();
            for (int is = syncStats.size() - 1; is >= 0; --is) {
                DualTimer timer = syncStats.valueAt(is);
                BatteryStatsImpl.detachIfNotNull(timer);
            }
            ArrayMap<String, DualTimer> jobStats = this.mJobStats.getMap();
            for (int ij = jobStats.size() - 1; ij >= 0; --ij) {
                DualTimer timer = jobStats.valueAt(ij);
                BatteryStatsImpl.detachIfNotNull(timer);
            }
            BatteryStatsImpl.detachIfNotNull(this.mJobsDeferredEventCount);
            BatteryStatsImpl.detachIfNotNull(this.mJobsDeferredCount);
            BatteryStatsImpl.detachIfNotNull(this.mJobsFreshnessTimeMs);
            BatteryStatsImpl.detachIfNotNull(this.mJobsFreshnessBuckets);
            for (int ise = this.mSensorStats.size() - 1; ise >= 0; --ise) {
                Sensor s = this.mSensorStats.valueAt(ise);
                s.detachFromTimeBase();
            }
            for (int ip = this.mProcessStats.size() - 1; ip >= 0; --ip) {
                Proc proc = this.mProcessStats.valueAt(ip);
                proc.detach();
            }
            this.mProcessStats.clear();
            for (int i = this.mPackageStats.size() - 1; i >= 0; --i) {
                Pkg p = this.mPackageStats.valueAt(i);
                p.detach();
            }
            this.mPackageStats.clear();
        }

        void writeJobCompletionsToParcelLocked(Parcel out) {
            int NJC = this.mJobCompletions.size();
            out.writeInt(NJC);
            for (int ijc = 0; ijc < NJC; ++ijc) {
                out.writeString(this.mJobCompletions.keyAt(ijc));
                SparseIntArray types = this.mJobCompletions.valueAt(ijc);
                int NT = types.size();
                out.writeInt(NT);
                for (int it = 0; it < NT; ++it) {
                    out.writeInt(types.keyAt(it));
                    out.writeInt(types.valueAt(it));
                }
            }
        }

        void writeToParcelLocked(Parcel out, long uptimeUs, long elapsedRealtimeUs) {
            int i;
            this.mOnBatteryBackgroundTimeBase.writeToParcel(out, uptimeUs, elapsedRealtimeUs);
            this.mOnBatteryScreenOffBackgroundTimeBase.writeToParcel(out, uptimeUs, elapsedRealtimeUs);
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            int NW = wakeStats.size();
            out.writeInt(NW);
            for (int iw = 0; iw < NW; ++iw) {
                out.writeString(wakeStats.keyAt(iw));
                Wakelock wakelock = wakeStats.valueAt(iw);
                wakelock.writeToParcelLocked(out, elapsedRealtimeUs);
            }
            ArrayMap<String, DualTimer> syncStats = this.mSyncStats.getMap();
            int NS = syncStats.size();
            out.writeInt(NS);
            for (int is = 0; is < NS; ++is) {
                out.writeString(syncStats.keyAt(is));
                DualTimer timer = syncStats.valueAt(is);
                Timer.writeTimerToParcel(out, timer, elapsedRealtimeUs);
            }
            ArrayMap<String, DualTimer> jobStats = this.mJobStats.getMap();
            int NJ = jobStats.size();
            out.writeInt(NJ);
            for (int ij = 0; ij < NJ; ++ij) {
                out.writeString(jobStats.keyAt(ij));
                DualTimer timer = jobStats.valueAt(ij);
                Timer.writeTimerToParcel(out, timer, elapsedRealtimeUs);
            }
            this.writeJobCompletionsToParcelLocked(out);
            this.mJobsDeferredEventCount.writeToParcel(out);
            this.mJobsDeferredCount.writeToParcel(out);
            this.mJobsFreshnessTimeMs.writeToParcel(out);
            for (int i2 = 0; i2 < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i2) {
                Counter.writeCounterToParcel(out, this.mJobsFreshnessBuckets[i2]);
            }
            int NSE = this.mSensorStats.size();
            out.writeInt(NSE);
            for (int ise = 0; ise < NSE; ++ise) {
                out.writeInt(this.mSensorStats.keyAt(ise));
                Sensor sensor = this.mSensorStats.valueAt(ise);
                sensor.writeToParcelLocked(out, elapsedRealtimeUs);
            }
            int NP = this.mProcessStats.size();
            out.writeInt(NP);
            for (int ip = 0; ip < NP; ++ip) {
                out.writeString(this.mProcessStats.keyAt(ip));
                Proc proc = this.mProcessStats.valueAt(ip);
                proc.writeToParcelLocked(out);
            }
            out.writeInt(this.mPackageStats.size());
            for (Map.Entry<String, Pkg> pkgEntry : this.mPackageStats.entrySet()) {
                out.writeString(pkgEntry.getKey());
                Pkg pkg = pkgEntry.getValue();
                pkg.writeToParcelLocked(out);
            }
            if (this.mWifiRunningTimer != null) {
                out.writeInt(1);
                this.mWifiRunningTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mFullWifiLockTimer != null) {
                out.writeInt(1);
                this.mFullWifiLockTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiScanTimer != null) {
                out.writeInt(1);
                this.mWifiScanTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 5; ++i) {
                if (this.mWifiBatchedScanTimer[i] != null) {
                    out.writeInt(1);
                    this.mWifiBatchedScanTimer[i].writeToParcel(out, elapsedRealtimeUs);
                    continue;
                }
                out.writeInt(0);
            }
            if (this.mWifiMulticastTimer != null) {
                out.writeInt(1);
                this.mWifiMulticastTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                this.mAudioTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                this.mVideoTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mFlashlightTurnedOnTimer != null) {
                out.writeInt(1);
                this.mFlashlightTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mCameraTurnedOnTimer != null) {
                out.writeInt(1);
                this.mCameraTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mForegroundActivityTimer != null) {
                out.writeInt(1);
                this.mForegroundActivityTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mForegroundServiceTimer != null) {
                out.writeInt(1);
                this.mForegroundServiceTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mAggregatedPartialWakelockTimer != null) {
                out.writeInt(1);
                this.mAggregatedPartialWakelockTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothScanTimer != null) {
                out.writeInt(1);
                this.mBluetoothScanTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothUnoptimizedScanTimer != null) {
                out.writeInt(1);
                this.mBluetoothUnoptimizedScanTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothScanResultCounter != null) {
                out.writeInt(1);
                this.mBluetoothScanResultCounter.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothScanResultBgCounter != null) {
                out.writeInt(1);
                this.mBluetoothScanResultBgCounter.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 7; ++i) {
                if (this.mProcessStateTimer[i] != null) {
                    out.writeInt(1);
                    this.mProcessStateTimer[i].writeToParcel(out, elapsedRealtimeUs);
                    continue;
                }
                out.writeInt(0);
            }
            if (this.mVibratorOnTimer != null) {
                out.writeInt(1);
                this.mVibratorOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mUserActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < NUM_USER_ACTIVITY_TYPES; ++i) {
                    this.mUserActivityCounters[i].writeToParcel(out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.mNetworkByteActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < 10; ++i) {
                    this.mNetworkByteActivityCounters[i].writeToParcel(out);
                    this.mNetworkPacketActivityCounters[i].writeToParcel(out);
                }
                this.mMobileRadioActiveTime.writeToParcel(out);
                this.mMobileRadioActiveCount.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiControllerActivity != null) {
                out.writeInt(1);
                this.mWifiControllerActivity.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothControllerActivity != null) {
                out.writeInt(1);
                this.mBluetoothControllerActivity.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            if (this.mModemControllerActivity != null) {
                out.writeInt(1);
                this.mModemControllerActivity.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            this.mUserCpuTime.writeToParcel(out);
            this.mSystemCpuTime.writeToParcel(out);
            if (this.mCpuClusterSpeedTimesUs != null) {
                out.writeInt(1);
                out.writeInt(this.mCpuClusterSpeedTimesUs.length);
                for (LongSamplingCounter[] cpuSpeeds : this.mCpuClusterSpeedTimesUs) {
                    if (cpuSpeeds != null) {
                        out.writeInt(1);
                        out.writeInt(cpuSpeeds.length);
                        for (LongSamplingCounter c : cpuSpeeds) {
                            if (c != null) {
                                out.writeInt(1);
                                c.writeToParcel(out);
                                continue;
                            }
                            out.writeInt(0);
                        }
                        continue;
                    }
                    out.writeInt(0);
                }
            } else {
                out.writeInt(0);
            }
            LongSamplingCounterArray.writeToParcel(out, this.mCpuFreqTimeMs);
            LongSamplingCounterArray.writeToParcel(out, this.mScreenOffCpuFreqTimeMs);
            this.mCpuActiveTimeMs.writeToParcel(out);
            this.mCpuClusterTimesMs.writeToParcel(out);
            if (this.mProcStateTimeMs != null) {
                out.writeInt(this.mProcStateTimeMs.length);
                for (LongSamplingCounterArray counters : this.mProcStateTimeMs) {
                    LongSamplingCounterArray.writeToParcel(out, counters);
                }
            } else {
                out.writeInt(0);
            }
            if (this.mProcStateScreenOffTimeMs != null) {
                out.writeInt(this.mProcStateScreenOffTimeMs.length);
                for (LongSamplingCounterArray counters : this.mProcStateScreenOffTimeMs) {
                    LongSamplingCounterArray.writeToParcel(out, counters);
                }
            } else {
                out.writeInt(0);
            }
            if (this.mMobileRadioApWakeupCount != null) {
                out.writeInt(1);
                this.mMobileRadioApWakeupCount.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiRadioApWakeupCount != null) {
                out.writeInt(1);
                this.mWifiRadioApWakeupCount.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
        }

        void readJobCompletionsFromParcelLocked(Parcel in) {
            int numJobCompletions = in.readInt();
            this.mJobCompletions.clear();
            for (int j = 0; j < numJobCompletions; ++j) {
                String jobName = in.readString();
                int numTypes = in.readInt();
                if (numTypes <= 0) continue;
                SparseIntArray types = new SparseIntArray();
                for (int k = 0; k < numTypes; ++k) {
                    int type = in.readInt();
                    int count = in.readInt();
                    types.put(type, count);
                }
                this.mJobCompletions.put(jobName, types);
            }
        }

        void readFromParcelLocked(TimeBase timeBase, TimeBase screenOffTimeBase, Parcel in) {
            int i;
            this.mOnBatteryBackgroundTimeBase.readFromParcel(in);
            this.mOnBatteryScreenOffBackgroundTimeBase.readFromParcel(in);
            int numWakelocks = in.readInt();
            this.mWakelockStats.clear();
            for (int j = 0; j < numWakelocks; ++j) {
                String wakelockName = in.readString();
                Wakelock wakelock = new Wakelock(this.mBsi, this);
                wakelock.readFromParcelLocked(timeBase, screenOffTimeBase, this.mOnBatteryScreenOffBackgroundTimeBase, in);
                this.mWakelockStats.add(wakelockName, wakelock);
            }
            int numSyncs = in.readInt();
            this.mSyncStats.clear();
            for (int j = 0; j < numSyncs; ++j) {
                String syncName = in.readString();
                if (in.readInt() == 0) continue;
                this.mSyncStats.add(syncName, new DualTimer(this.mBsi.mClocks, this, 13, null, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in));
            }
            int numJobs = in.readInt();
            this.mJobStats.clear();
            for (int j = 0; j < numJobs; ++j) {
                String jobName = in.readString();
                if (in.readInt() == 0) continue;
                this.mJobStats.add(jobName, new DualTimer(this.mBsi.mClocks, this, 14, null, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in));
            }
            this.readJobCompletionsFromParcelLocked(in);
            this.mJobsDeferredEventCount = new Counter(this.mBsi.mOnBatteryTimeBase, in);
            this.mJobsDeferredCount = new Counter(this.mBsi.mOnBatteryTimeBase, in);
            this.mJobsFreshnessTimeMs = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            for (int i2 = 0; i2 < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i2) {
                this.mJobsFreshnessBuckets[i2] = Counter.readCounterFromParcel(this.mBsi.mOnBatteryTimeBase, in);
            }
            int numSensors = in.readInt();
            this.mSensorStats.clear();
            for (int k = 0; k < numSensors; ++k) {
                int sensorNumber = in.readInt();
                Sensor sensor = new Sensor(this.mBsi, this, sensorNumber);
                sensor.readFromParcelLocked(this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in);
                this.mSensorStats.put(sensorNumber, sensor);
            }
            int numProcs = in.readInt();
            this.mProcessStats.clear();
            for (int k = 0; k < numProcs; ++k) {
                String processName = in.readString();
                Proc proc = new Proc(this.mBsi, processName);
                proc.readFromParcelLocked(in);
                this.mProcessStats.put(processName, proc);
            }
            int numPkgs = in.readInt();
            this.mPackageStats.clear();
            for (int l = 0; l < numPkgs; ++l) {
                String packageName = in.readString();
                Pkg pkg = new Pkg(this.mBsi);
                pkg.readFromParcelLocked(in);
                this.mPackageStats.put(packageName, pkg);
            }
            this.mWifiRunning = false;
            this.mWifiRunningTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 4, this.mBsi.mWifiRunningTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mFullWifiLockOut = false;
            this.mFullWifiLockTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 5, this.mBsi.mFullWifiLockTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mWifiScanStarted = false;
            this.mWifiScanTimer = in.readInt() != 0 ? new DualTimer(this.mBsi.mClocks, this, 6, this.mBsi.mWifiScanTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in) : null;
            this.mWifiBatchedScanBinStarted = -1;
            for (i = 0; i < 5; ++i) {
                if (in.readInt() != 0) {
                    this.makeWifiBatchedScanBin(i, in);
                    continue;
                }
                this.mWifiBatchedScanTimer[i] = null;
            }
            this.mWifiMulticastWakelockCount = 0;
            this.mWifiMulticastTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 7, this.mBsi.mWifiMulticastTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mAudioTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 15, this.mBsi.mAudioTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mVideoTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 8, this.mBsi.mVideoTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mFlashlightTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 16, this.mBsi.mFlashlightTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mCameraTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 17, this.mBsi.mCameraTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mForegroundActivityTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 10, null, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mForegroundServiceTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 22, null, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mAggregatedPartialWakelockTimer = in.readInt() != 0 ? new DualTimer(this.mBsi.mClocks, this, 20, null, this.mBsi.mOnBatteryScreenOffTimeBase, this.mOnBatteryScreenOffBackgroundTimeBase, in) : null;
            this.mBluetoothScanTimer = in.readInt() != 0 ? new DualTimer(this.mBsi.mClocks, this, 19, this.mBsi.mBluetoothScanOnTimers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in) : null;
            this.mBluetoothUnoptimizedScanTimer = in.readInt() != 0 ? new DualTimer(this.mBsi.mClocks, this, 21, null, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase, in) : null;
            this.mBluetoothScanResultCounter = in.readInt() != 0 ? new Counter(this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mBluetoothScanResultBgCounter = in.readInt() != 0 ? new Counter(this.mOnBatteryBackgroundTimeBase, in) : null;
            this.mProcessState = 20;
            for (i = 0; i < 7; ++i) {
                if (in.readInt() != 0) {
                    this.makeProcessState(i, in);
                    continue;
                }
                this.mProcessStateTimer[i] = null;
            }
            this.mVibratorOnTimer = in.readInt() != 0 ? new BatchTimer(this.mBsi.mClocks, this, 9, this.mBsi.mOnBatteryTimeBase, in) : null;
            if (in.readInt() != 0) {
                this.mUserActivityCounters = new Counter[NUM_USER_ACTIVITY_TYPES];
                for (i = 0; i < NUM_USER_ACTIVITY_TYPES; ++i) {
                    this.mUserActivityCounters[i] = new Counter(this.mBsi.mOnBatteryTimeBase, in);
                }
            } else {
                this.mUserActivityCounters = null;
            }
            if (in.readInt() != 0) {
                this.mNetworkByteActivityCounters = new LongSamplingCounter[10];
                this.mNetworkPacketActivityCounters = new LongSamplingCounter[10];
                for (i = 0; i < 10; ++i) {
                    this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                    this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                }
                this.mMobileRadioActiveTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                this.mMobileRadioActiveCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            } else {
                this.mNetworkByteActivityCounters = null;
                this.mNetworkPacketActivityCounters = null;
            }
            this.mWifiControllerActivity = in.readInt() != 0 ? new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 1, in) : null;
            this.mBluetoothControllerActivity = in.readInt() != 0 ? new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 1, in) : null;
            this.mModemControllerActivity = in.readInt() != 0 ? new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 5, in) : null;
            this.mUserCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            this.mSystemCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            if (in.readInt() != 0) {
                int numCpuClusters = in.readInt();
                if (this.mBsi.mPowerProfile != null && this.mBsi.mPowerProfile.getNumCpuClusters() != numCpuClusters) {
                    throw new ParcelFormatException("Incompatible number of cpu clusters");
                }
                this.mCpuClusterSpeedTimesUs = new LongSamplingCounter[numCpuClusters][];
                for (int cluster = 0; cluster < numCpuClusters; ++cluster) {
                    if (in.readInt() != 0) {
                        int numSpeeds = in.readInt();
                        if (this.mBsi.mPowerProfile != null && this.mBsi.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster) != numSpeeds) {
                            throw new ParcelFormatException("Incompatible number of cpu speeds");
                        }
                        LongSamplingCounter[] cpuSpeeds = new LongSamplingCounter[numSpeeds];
                        this.mCpuClusterSpeedTimesUs[cluster] = cpuSpeeds;
                        for (int speed = 0; speed < numSpeeds; ++speed) {
                            if (in.readInt() == 0) continue;
                            cpuSpeeds[speed] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                        }
                        continue;
                    }
                    this.mCpuClusterSpeedTimesUs[cluster] = null;
                }
            } else {
                this.mCpuClusterSpeedTimesUs = null;
            }
            this.mCpuFreqTimeMs = LongSamplingCounterArray.readFromParcel(in, this.mBsi.mOnBatteryTimeBase);
            this.mScreenOffCpuFreqTimeMs = LongSamplingCounterArray.readFromParcel(in, this.mBsi.mOnBatteryScreenOffTimeBase);
            this.mCpuActiveTimeMs = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            this.mCpuClusterTimesMs = new LongSamplingCounterArray(this.mBsi.mOnBatteryTimeBase, in);
            int length = in.readInt();
            if (length == 7) {
                this.mProcStateTimeMs = new LongSamplingCounterArray[length];
                for (int procState = 0; procState < length; ++procState) {
                    this.mProcStateTimeMs[procState] = LongSamplingCounterArray.readFromParcel(in, this.mBsi.mOnBatteryTimeBase);
                }
            } else {
                this.mProcStateTimeMs = null;
            }
            if ((length = in.readInt()) == 7) {
                this.mProcStateScreenOffTimeMs = new LongSamplingCounterArray[length];
                for (int procState = 0; procState < length; ++procState) {
                    this.mProcStateScreenOffTimeMs[procState] = LongSamplingCounterArray.readFromParcel(in, this.mBsi.mOnBatteryScreenOffTimeBase);
                }
            } else {
                this.mProcStateScreenOffTimeMs = null;
            }
            this.mMobileRadioApWakeupCount = in.readInt() != 0 ? new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mWifiRadioApWakeupCount = in.readInt() != 0 ? new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in) : null;
        }

        public void noteJobsDeferredLocked(int numDeferred, long sinceLast) {
            this.mJobsDeferredEventCount.addAtomic(1);
            this.mJobsDeferredCount.addAtomic(numDeferred);
            if (sinceLast != 0L) {
                this.mJobsFreshnessTimeMs.addCountLocked(sinceLast);
                for (int i = 0; i < BatteryStats.JOB_FRESHNESS_BUCKETS.length; ++i) {
                    if (sinceLast >= BatteryStats.JOB_FRESHNESS_BUCKETS[i]) continue;
                    if (this.mJobsFreshnessBuckets[i] == null) {
                        this.mJobsFreshnessBuckets[i] = new Counter(this.mBsi.mOnBatteryTimeBase);
                    }
                    this.mJobsFreshnessBuckets[i].addAtomic(1);
                    break;
                }
            }
        }

        public Proc getProcessStatsLocked(String name) {
            Proc ps = this.mProcessStats.get(name);
            if (ps == null) {
                ps = new Proc(this.mBsi, name);
                this.mProcessStats.put(name, ps);
            }
            return ps;
        }

        @GuardedBy(value={"mBsi"})
        public void updateUidProcessStateLocked(int procState) {
            boolean userAwareService = ActivityManager.isForegroundService(procState);
            int uidRunningState = BatteryStats.mapToInternalProcessState(procState);
            if (this.mProcessState == uidRunningState && userAwareService == this.mInForegroundService) {
                return;
            }
            long elapsedRealtimeMs = this.mBsi.mClocks.elapsedRealtime();
            if (this.mProcessState != uidRunningState) {
                long uptimeMs = this.mBsi.mClocks.uptimeMillis();
                if (this.mProcessState != 20) {
                    this.mProcessStateTimer[this.mProcessState].stopRunningLocked(elapsedRealtimeMs);
                    if (this.mBsi.trackPerProcStateCpuTimes()) {
                        if (this.mBsi.mPendingUids.size() == 0) {
                            this.mBsi.mExternalSync.scheduleReadProcStateCpuTimes(this.mBsi.mOnBatteryTimeBase.isRunning(), this.mBsi.mOnBatteryScreenOffTimeBase.isRunning(), this.mBsi.mConstants.PROC_STATE_CPU_TIMES_READ_DELAY_MS);
                            this.mBsi.mNumSingleUidCpuTimeReads++;
                        } else {
                            this.mBsi.mNumBatchedSingleUidCpuTimeReads++;
                        }
                        if (this.mBsi.mPendingUids.indexOfKey(this.mUid) < 0 || ArrayUtils.contains(CRITICAL_PROC_STATES, this.mProcessState)) {
                            this.mBsi.mPendingUids.put(this.mUid, this.mProcessState);
                        }
                    } else {
                        this.mBsi.mPendingUids.clear();
                    }
                }
                this.mProcessState = uidRunningState;
                if (uidRunningState != 20) {
                    if (this.mProcessStateTimer[uidRunningState] == null) {
                        this.makeProcessState(uidRunningState, null);
                    }
                    this.mProcessStateTimer[uidRunningState].startRunningLocked(elapsedRealtimeMs);
                }
                this.updateOnBatteryBgTimeBase(uptimeMs * 1000L, elapsedRealtimeMs * 1000L);
                this.updateOnBatteryScreenOffBgTimeBase(uptimeMs * 1000L, elapsedRealtimeMs * 1000L);
            }
            if (userAwareService != this.mInForegroundService) {
                if (userAwareService) {
                    this.noteForegroundServiceResumedLocked(elapsedRealtimeMs);
                } else {
                    this.noteForegroundServicePausedLocked(elapsedRealtimeMs);
                }
                this.mInForegroundService = userAwareService;
            }
        }

        public boolean isInBackground() {
            return this.mProcessState >= 3;
        }

        public boolean updateOnBatteryBgTimeBase(long uptimeUs, long realtimeUs) {
            boolean on = this.mBsi.mOnBatteryTimeBase.isRunning() && this.isInBackground();
            return this.mOnBatteryBackgroundTimeBase.setRunning(on, uptimeUs, realtimeUs);
        }

        public boolean updateOnBatteryScreenOffBgTimeBase(long uptimeUs, long realtimeUs) {
            boolean on = this.mBsi.mOnBatteryScreenOffTimeBase.isRunning() && this.isInBackground();
            return this.mOnBatteryScreenOffBackgroundTimeBase.setRunning(on, uptimeUs, realtimeUs);
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Pid> getPidStats() {
            return this.mPids;
        }

        public BatteryStats.Uid.Pid getPidStatsLocked(int pid) {
            BatteryStats.Uid.Pid p = this.mPids.get(pid);
            if (p == null) {
                p = new BatteryStats.Uid.Pid();
                this.mPids.put(pid, p);
            }
            return p;
        }

        public Pkg getPackageStatsLocked(String name) {
            Pkg ps = this.mPackageStats.get(name);
            if (ps == null) {
                ps = new Pkg(this.mBsi);
                this.mPackageStats.put(name, ps);
            }
            return ps;
        }

        public Pkg.Serv getServiceStatsLocked(String pkg, String serv) {
            Pkg ps = this.getPackageStatsLocked(pkg);
            Pkg.Serv ss = ps.mServiceStats.get(serv);
            if (ss == null) {
                ss = ps.newServiceStatsLocked();
                ps.mServiceStats.put(serv, ss);
            }
            return ss;
        }

        public void readSyncSummaryFromParcelLocked(String name, Parcel in) {
            DualTimer timer = this.mSyncStats.instantiateObject();
            timer.readSummaryFromParcelLocked(in);
            this.mSyncStats.add(name, timer);
        }

        public void readJobSummaryFromParcelLocked(String name, Parcel in) {
            DualTimer timer = this.mJobStats.instantiateObject();
            timer.readSummaryFromParcelLocked(in);
            this.mJobStats.add(name, timer);
        }

        public void readWakeSummaryFromParcelLocked(String wlName, Parcel in) {
            Wakelock wl = new Wakelock(this.mBsi, this);
            this.mWakelockStats.add(wlName, wl);
            if (in.readInt() != 0) {
                this.getWakelockTimerLocked(wl, 1).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                this.getWakelockTimerLocked(wl, 0).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                this.getWakelockTimerLocked(wl, 2).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                this.getWakelockTimerLocked(wl, 18).readSummaryFromParcelLocked(in);
            }
        }

        public DualTimer getSensorTimerLocked(int sensor, boolean create) {
            DualTimer t;
            Sensor se = this.mSensorStats.get(sensor);
            if (se == null) {
                if (!create) {
                    return null;
                }
                se = new Sensor(this.mBsi, this, sensor);
                this.mSensorStats.put(sensor, se);
            }
            if ((t = se.mTimer) != null) {
                return t;
            }
            ArrayList<StopwatchTimer> timers = this.mBsi.mSensorTimers.get(sensor);
            if (timers == null) {
                timers = new ArrayList();
                this.mBsi.mSensorTimers.put(sensor, timers);
            }
            se.mTimer = t = new DualTimer(this.mBsi.mClocks, this, 3, timers, this.mBsi.mOnBatteryTimeBase, this.mOnBatteryBackgroundTimeBase);
            return t;
        }

        public void noteStartSyncLocked(String name, long elapsedRealtimeMs) {
            DualTimer t = this.mSyncStats.startObject(name);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStopSyncLocked(String name, long elapsedRealtimeMs) {
            DualTimer t = this.mSyncStats.stopObject(name);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStartJobLocked(String name, long elapsedRealtimeMs) {
            DualTimer t = this.mJobStats.startObject(name);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStopJobLocked(String name, long elapsedRealtimeMs, int stopReason) {
            DualTimer t = this.mJobStats.stopObject(name);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
            if (this.mBsi.mOnBatteryTimeBase.isRunning()) {
                SparseIntArray types = this.mJobCompletions.get(name);
                if (types == null) {
                    types = new SparseIntArray();
                    this.mJobCompletions.put(name, types);
                }
                int last = types.get(stopReason, 0);
                types.put(stopReason, last + 1);
            }
        }

        public StopwatchTimer getWakelockTimerLocked(Wakelock wl, int type) {
            if (wl == null) {
                return null;
            }
            switch (type) {
                case 0: {
                    DualTimer t = wl.mTimerPartial;
                    if (t == null) {
                        wl.mTimerPartial = t = new DualTimer(this.mBsi.mClocks, this, 0, this.mBsi.mPartialTimers, this.mBsi.mOnBatteryScreenOffTimeBase, this.mOnBatteryScreenOffBackgroundTimeBase);
                    }
                    return t;
                }
                case 1: {
                    StopwatchTimer t = wl.mTimerFull;
                    if (t == null) {
                        wl.mTimerFull = t = new StopwatchTimer(this.mBsi.mClocks, this, 1, this.mBsi.mFullTimers, this.mBsi.mOnBatteryTimeBase);
                    }
                    return t;
                }
                case 2: {
                    StopwatchTimer t = wl.mTimerWindow;
                    if (t == null) {
                        wl.mTimerWindow = t = new StopwatchTimer(this.mBsi.mClocks, this, 2, this.mBsi.mWindowTimers, this.mBsi.mOnBatteryTimeBase);
                    }
                    return t;
                }
                case 18: {
                    StopwatchTimer t = wl.mTimerDraw;
                    if (t == null) {
                        wl.mTimerDraw = t = new StopwatchTimer(this.mBsi.mClocks, this, 18, this.mBsi.mDrawTimers, this.mBsi.mOnBatteryTimeBase);
                    }
                    return t;
                }
            }
            throw new IllegalArgumentException("type=" + type);
        }

        public void noteStartWakeLocked(int pid, String name, int type, long elapsedRealtimeMs) {
            Wakelock wl = this.mWakelockStats.startObject(name);
            if (wl != null) {
                this.getWakelockTimerLocked(wl, type).startRunningLocked(elapsedRealtimeMs);
            }
            if (type == 0) {
                this.createAggregatedPartialWakelockTimerLocked().startRunningLocked(elapsedRealtimeMs);
                if (pid >= 0) {
                    BatteryStats.Uid.Pid p = this.getPidStatsLocked(pid);
                    if (p.mWakeNesting++ == 0) {
                        p.mWakeStartMs = elapsedRealtimeMs;
                    }
                }
            }
        }

        public void noteStopWakeLocked(int pid, String name, int type, long elapsedRealtimeMs) {
            Wakelock wl = this.mWakelockStats.stopObject(name);
            if (wl != null) {
                StopwatchTimer wlt = this.getWakelockTimerLocked(wl, type);
                wlt.stopRunningLocked(elapsedRealtimeMs);
            }
            if (type == 0) {
                BatteryStats.Uid.Pid p;
                if (this.mAggregatedPartialWakelockTimer != null) {
                    this.mAggregatedPartialWakelockTimer.stopRunningLocked(elapsedRealtimeMs);
                }
                if (pid >= 0 && (p = this.mPids.get(pid)) != null && p.mWakeNesting > 0 && p.mWakeNesting-- == 1) {
                    p.mWakeSumMs += elapsedRealtimeMs - p.mWakeStartMs;
                    p.mWakeStartMs = 0L;
                }
            }
        }

        public void reportExcessiveCpuLocked(String proc, long overTime, long usedTime) {
            Proc p = this.getProcessStatsLocked(proc);
            if (p != null) {
                p.addExcessiveCpu(overTime, usedTime);
            }
        }

        public void noteStartSensor(int sensor, long elapsedRealtimeMs) {
            DualTimer t = this.getSensorTimerLocked(sensor, true);
            t.startRunningLocked(elapsedRealtimeMs);
        }

        public void noteStopSensor(int sensor, long elapsedRealtimeMs) {
            DualTimer t = this.getSensorTimerLocked(sensor, false);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStartGps(long elapsedRealtimeMs) {
            this.noteStartSensor(-10000, elapsedRealtimeMs);
        }

        public void noteStopGps(long elapsedRealtimeMs) {
            this.noteStopSensor(-10000, elapsedRealtimeMs);
        }

        public BatteryStatsImpl getBatteryStats() {
            return this.mBsi;
        }

        public static class Pkg
        extends BatteryStats.Uid.Pkg
        implements TimeBaseObs {
            protected BatteryStatsImpl mBsi;
            ArrayMap<String, Counter> mWakeupAlarms = new ArrayMap();
            final ArrayMap<String, Serv> mServiceStats = new ArrayMap();

            public Pkg(BatteryStatsImpl bsi) {
                this.mBsi = bsi;
                this.mBsi.mOnBatteryScreenOffTimeBase.add(this);
            }

            @Override
            public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            @Override
            public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            @Override
            public boolean reset(boolean detachIfReset) {
                if (detachIfReset) {
                    this.detach();
                }
                return true;
            }

            @Override
            public void detach() {
                int j;
                this.mBsi.mOnBatteryScreenOffTimeBase.remove(this);
                for (j = this.mWakeupAlarms.size() - 1; j >= 0; --j) {
                    BatteryStatsImpl.detachIfNotNull(this.mWakeupAlarms.valueAt(j));
                }
                for (j = this.mServiceStats.size() - 1; j >= 0; --j) {
                    BatteryStatsImpl.detachIfNotNull(this.mServiceStats.valueAt(j));
                }
            }

            void readFromParcelLocked(Parcel in) {
                int numWA = in.readInt();
                this.mWakeupAlarms.clear();
                for (int i = 0; i < numWA; ++i) {
                    String tag = in.readString();
                    this.mWakeupAlarms.put(tag, new Counter(this.mBsi.mOnBatteryScreenOffTimeBase, in));
                }
                int numServs = in.readInt();
                this.mServiceStats.clear();
                for (int m = 0; m < numServs; ++m) {
                    String serviceName = in.readString();
                    Serv serv = new Serv(this.mBsi);
                    this.mServiceStats.put(serviceName, serv);
                    serv.readFromParcelLocked(in);
                }
            }

            void writeToParcelLocked(Parcel out) {
                int numWA = this.mWakeupAlarms.size();
                out.writeInt(numWA);
                for (int i = 0; i < numWA; ++i) {
                    out.writeString(this.mWakeupAlarms.keyAt(i));
                    this.mWakeupAlarms.valueAt(i).writeToParcel(out);
                }
                int NS = this.mServiceStats.size();
                out.writeInt(NS);
                for (int i = 0; i < NS; ++i) {
                    out.writeString(this.mServiceStats.keyAt(i));
                    Serv serv = this.mServiceStats.valueAt(i);
                    serv.writeToParcelLocked(out);
                }
            }

            @Override
            public ArrayMap<String, ? extends BatteryStats.Counter> getWakeupAlarmStats() {
                return this.mWakeupAlarms;
            }

            public void noteWakeupAlarmLocked(String tag) {
                Counter c = this.mWakeupAlarms.get(tag);
                if (c == null) {
                    c = new Counter(this.mBsi.mOnBatteryScreenOffTimeBase);
                    this.mWakeupAlarms.put(tag, c);
                }
                c.stepAtomic();
            }

            @Override
            public ArrayMap<String, ? extends BatteryStats.Uid.Pkg.Serv> getServiceStats() {
                return this.mServiceStats;
            }

            Serv newServiceStatsLocked() {
                return new Serv(this.mBsi);
            }

            public static class Serv
            extends BatteryStats.Uid.Pkg.Serv
            implements TimeBaseObs {
                protected BatteryStatsImpl mBsi;
                protected Pkg mPkg;
                protected long mStartTime;
                protected long mRunningSince;
                protected boolean mRunning;
                protected int mStarts;
                protected long mLaunchedTime;
                protected long mLaunchedSince;
                protected boolean mLaunched;
                protected int mLaunches;

                public Serv(BatteryStatsImpl bsi) {
                    this.mBsi = bsi;
                    this.mBsi.mOnBatteryTimeBase.add(this);
                }

                @Override
                public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
                }

                @Override
                public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
                }

                @Override
                public boolean reset(boolean detachIfReset) {
                    if (detachIfReset) {
                        this.detach();
                    }
                    return true;
                }

                @Override
                public void detach() {
                    this.mBsi.mOnBatteryTimeBase.remove(this);
                }

                public void readFromParcelLocked(Parcel in) {
                    this.mStartTime = in.readLong();
                    this.mRunningSince = in.readLong();
                    this.mRunning = in.readInt() != 0;
                    this.mStarts = in.readInt();
                    this.mLaunchedTime = in.readLong();
                    this.mLaunchedSince = in.readLong();
                    this.mLaunched = in.readInt() != 0;
                    this.mLaunches = in.readInt();
                }

                public void writeToParcelLocked(Parcel out) {
                    out.writeLong(this.mStartTime);
                    out.writeLong(this.mRunningSince);
                    out.writeInt(this.mRunning ? 1 : 0);
                    out.writeInt(this.mStarts);
                    out.writeLong(this.mLaunchedTime);
                    out.writeLong(this.mLaunchedSince);
                    out.writeInt(this.mLaunched ? 1 : 0);
                    out.writeInt(this.mLaunches);
                }

                public long getLaunchTimeToNowLocked(long batteryUptime) {
                    if (!this.mLaunched) {
                        return this.mLaunchedTime;
                    }
                    return this.mLaunchedTime + batteryUptime - this.mLaunchedSince;
                }

                public long getStartTimeToNowLocked(long batteryUptime) {
                    if (!this.mRunning) {
                        return this.mStartTime;
                    }
                    return this.mStartTime + batteryUptime - this.mRunningSince;
                }

                @UnsupportedAppUsage
                public void startLaunchedLocked() {
                    if (!this.mLaunched) {
                        ++this.mLaunches;
                        this.mLaunchedSince = this.mBsi.getBatteryUptimeLocked();
                        this.mLaunched = true;
                    }
                }

                @UnsupportedAppUsage
                public void stopLaunchedLocked() {
                    if (this.mLaunched) {
                        long time = this.mBsi.getBatteryUptimeLocked() - this.mLaunchedSince;
                        if (time > 0L) {
                            this.mLaunchedTime += time;
                        } else {
                            --this.mLaunches;
                        }
                        this.mLaunched = false;
                    }
                }

                @UnsupportedAppUsage
                public void startRunningLocked() {
                    if (!this.mRunning) {
                        ++this.mStarts;
                        this.mRunningSince = this.mBsi.getBatteryUptimeLocked();
                        this.mRunning = true;
                    }
                }

                @UnsupportedAppUsage
                public void stopRunningLocked() {
                    if (this.mRunning) {
                        long time = this.mBsi.getBatteryUptimeLocked() - this.mRunningSince;
                        if (time > 0L) {
                            this.mStartTime += time;
                        } else {
                            --this.mStarts;
                        }
                        this.mRunning = false;
                    }
                }

                @UnsupportedAppUsage
                public BatteryStatsImpl getBatteryStats() {
                    return this.mBsi;
                }

                @Override
                public int getLaunches(int which) {
                    return this.mLaunches;
                }

                @Override
                public long getStartTime(long now, int which) {
                    return this.getStartTimeToNowLocked(now);
                }

                @Override
                public int getStarts(int which) {
                    return this.mStarts;
                }
            }
        }

        public static class Proc
        extends BatteryStats.Uid.Proc
        implements TimeBaseObs {
            protected BatteryStatsImpl mBsi;
            final String mName;
            boolean mActive = true;
            long mUserTime;
            long mSystemTime;
            long mForegroundTime;
            int mStarts;
            int mNumCrashes;
            int mNumAnrs;
            ArrayList<BatteryStats.Uid.Proc.ExcessivePower> mExcessivePower;

            public Proc(BatteryStatsImpl bsi, String name) {
                this.mBsi = bsi;
                this.mName = name;
                this.mBsi.mOnBatteryTimeBase.add(this);
            }

            @Override
            public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            @Override
            public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            @Override
            public boolean reset(boolean detachIfReset) {
                if (detachIfReset) {
                    this.detach();
                }
                return true;
            }

            @Override
            public void detach() {
                this.mActive = false;
                this.mBsi.mOnBatteryTimeBase.remove(this);
            }

            @Override
            public int countExcessivePowers() {
                return this.mExcessivePower != null ? this.mExcessivePower.size() : 0;
            }

            @Override
            public BatteryStats.Uid.Proc.ExcessivePower getExcessivePower(int i) {
                if (this.mExcessivePower != null) {
                    return this.mExcessivePower.get(i);
                }
                return null;
            }

            public void addExcessiveCpu(long overTime, long usedTime) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                ew.type = 2;
                ew.overTime = overTime;
                ew.usedTime = usedTime;
                this.mExcessivePower.add(ew);
            }

            void writeExcessivePowerToParcelLocked(Parcel out) {
                if (this.mExcessivePower == null) {
                    out.writeInt(0);
                    return;
                }
                int N = this.mExcessivePower.size();
                out.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = this.mExcessivePower.get(i);
                    out.writeInt(ew.type);
                    out.writeLong(ew.overTime);
                    out.writeLong(ew.usedTime);
                }
            }

            void readExcessivePowerFromParcelLocked(Parcel in) {
                int N = in.readInt();
                if (N == 0) {
                    this.mExcessivePower = null;
                    return;
                }
                if (N > 10000) {
                    throw new ParcelFormatException("File corrupt: too many excessive power entries " + N);
                }
                this.mExcessivePower = new ArrayList();
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                    ew.type = in.readInt();
                    ew.overTime = in.readLong();
                    ew.usedTime = in.readLong();
                    this.mExcessivePower.add(ew);
                }
            }

            void writeToParcelLocked(Parcel out) {
                out.writeLong(this.mUserTime);
                out.writeLong(this.mSystemTime);
                out.writeLong(this.mForegroundTime);
                out.writeInt(this.mStarts);
                out.writeInt(this.mNumCrashes);
                out.writeInt(this.mNumAnrs);
                this.writeExcessivePowerToParcelLocked(out);
            }

            void readFromParcelLocked(Parcel in) {
                this.mUserTime = in.readLong();
                this.mSystemTime = in.readLong();
                this.mForegroundTime = in.readLong();
                this.mStarts = in.readInt();
                this.mNumCrashes = in.readInt();
                this.mNumAnrs = in.readInt();
                this.readExcessivePowerFromParcelLocked(in);
            }

            @UnsupportedAppUsage
            public void addCpuTimeLocked(int utime, int stime) {
                this.addCpuTimeLocked(utime, stime, this.mBsi.mOnBatteryTimeBase.isRunning());
            }

            public void addCpuTimeLocked(int utime, int stime, boolean isRunning) {
                if (isRunning) {
                    this.mUserTime += (long)utime;
                    this.mSystemTime += (long)stime;
                }
            }

            @UnsupportedAppUsage
            public void addForegroundTimeLocked(long ttime) {
                this.mForegroundTime += ttime;
            }

            @UnsupportedAppUsage
            public void incStartsLocked() {
                ++this.mStarts;
            }

            public void incNumCrashesLocked() {
                ++this.mNumCrashes;
            }

            public void incNumAnrsLocked() {
                ++this.mNumAnrs;
            }

            @Override
            public boolean isActive() {
                return this.mActive;
            }

            @Override
            @UnsupportedAppUsage
            public long getUserTime(int which) {
                return this.mUserTime;
            }

            @Override
            @UnsupportedAppUsage
            public long getSystemTime(int which) {
                return this.mSystemTime;
            }

            @Override
            @UnsupportedAppUsage
            public long getForegroundTime(int which) {
                return this.mForegroundTime;
            }

            @Override
            @UnsupportedAppUsage
            public int getStarts(int which) {
                return this.mStarts;
            }

            @Override
            public int getNumCrashes(int which) {
                return this.mNumCrashes;
            }

            @Override
            public int getNumAnrs(int which) {
                return this.mNumAnrs;
            }
        }

        public static class Sensor
        extends BatteryStats.Uid.Sensor {
            protected BatteryStatsImpl mBsi;
            protected Uid mUid;
            final int mHandle;
            DualTimer mTimer;

            public Sensor(BatteryStatsImpl bsi, Uid uid, int handle) {
                this.mBsi = bsi;
                this.mUid = uid;
                this.mHandle = handle;
            }

            private DualTimer readTimersFromParcel(TimeBase timeBase, TimeBase bgTimeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                ArrayList<StopwatchTimer> pool = this.mBsi.mSensorTimers.get(this.mHandle);
                if (pool == null) {
                    pool = new ArrayList();
                    this.mBsi.mSensorTimers.put(this.mHandle, pool);
                }
                return new DualTimer(this.mBsi.mClocks, this.mUid, 0, pool, timeBase, bgTimeBase, in);
            }

            boolean reset() {
                if (this.mTimer.reset(true)) {
                    this.mTimer = null;
                    return true;
                }
                return false;
            }

            void readFromParcelLocked(TimeBase timeBase, TimeBase bgTimeBase, Parcel in) {
                this.mTimer = this.readTimersFromParcel(timeBase, bgTimeBase, in);
            }

            void writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
                Timer.writeTimerToParcel(out, this.mTimer, elapsedRealtimeUs);
            }

            @Override
            @UnsupportedAppUsage
            public Timer getSensorTime() {
                return this.mTimer;
            }

            @Override
            public Timer getSensorBackgroundTime() {
                if (this.mTimer == null) {
                    return null;
                }
                return this.mTimer.getSubTimer();
            }

            @Override
            @UnsupportedAppUsage
            public int getHandle() {
                return this.mHandle;
            }

            public void detachFromTimeBase() {
                BatteryStatsImpl.detachIfNotNull(this.mTimer);
            }
        }

        public static class Wakelock
        extends BatteryStats.Uid.Wakelock {
            protected BatteryStatsImpl mBsi;
            protected Uid mUid;
            DualTimer mTimerPartial;
            StopwatchTimer mTimerFull;
            StopwatchTimer mTimerWindow;
            StopwatchTimer mTimerDraw;

            public Wakelock(BatteryStatsImpl bsi, Uid uid) {
                this.mBsi = bsi;
                this.mUid = uid;
            }

            private StopwatchTimer readStopwatchTimerFromParcel(int type, ArrayList<StopwatchTimer> pool, TimeBase timeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                return new StopwatchTimer(this.mBsi.mClocks, this.mUid, type, pool, timeBase, in);
            }

            private DualTimer readDualTimerFromParcel(int type, ArrayList<StopwatchTimer> pool, TimeBase timeBase, TimeBase bgTimeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                return new DualTimer(this.mBsi.mClocks, this.mUid, type, pool, timeBase, bgTimeBase, in);
            }

            boolean reset() {
                boolean wlactive = false;
                wlactive |= !BatteryStatsImpl.resetIfNotNull(this.mTimerFull, false);
                wlactive |= !BatteryStatsImpl.resetIfNotNull(this.mTimerPartial, false);
                wlactive |= !BatteryStatsImpl.resetIfNotNull(this.mTimerWindow, false);
                if (!(wlactive |= !BatteryStatsImpl.resetIfNotNull(this.mTimerDraw, false))) {
                    BatteryStatsImpl.detachIfNotNull(this.mTimerFull);
                    this.mTimerFull = null;
                    BatteryStatsImpl.detachIfNotNull(this.mTimerPartial);
                    this.mTimerPartial = null;
                    BatteryStatsImpl.detachIfNotNull(this.mTimerWindow);
                    this.mTimerWindow = null;
                    BatteryStatsImpl.detachIfNotNull(this.mTimerDraw);
                    this.mTimerDraw = null;
                }
                return !wlactive;
            }

            void readFromParcelLocked(TimeBase timeBase, TimeBase screenOffTimeBase, TimeBase screenOffBgTimeBase, Parcel in) {
                this.mTimerPartial = this.readDualTimerFromParcel(0, this.mBsi.mPartialTimers, screenOffTimeBase, screenOffBgTimeBase, in);
                this.mTimerFull = this.readStopwatchTimerFromParcel(1, this.mBsi.mFullTimers, timeBase, in);
                this.mTimerWindow = this.readStopwatchTimerFromParcel(2, this.mBsi.mWindowTimers, timeBase, in);
                this.mTimerDraw = this.readStopwatchTimerFromParcel(18, this.mBsi.mDrawTimers, timeBase, in);
            }

            void writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
                Timer.writeTimerToParcel(out, this.mTimerPartial, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerFull, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerWindow, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerDraw, elapsedRealtimeUs);
            }

            @Override
            @UnsupportedAppUsage
            public Timer getWakeTime(int type) {
                switch (type) {
                    case 1: {
                        return this.mTimerFull;
                    }
                    case 0: {
                        return this.mTimerPartial;
                    }
                    case 2: {
                        return this.mTimerWindow;
                    }
                    case 18: {
                        return this.mTimerDraw;
                    }
                }
                throw new IllegalArgumentException("type = " + type);
            }

            public void detachFromTimeBase() {
                BatteryStatsImpl.detachIfNotNull(this.mTimerPartial);
                BatteryStatsImpl.detachIfNotNull(this.mTimerFull);
                BatteryStatsImpl.detachIfNotNull(this.mTimerWindow);
                BatteryStatsImpl.detachIfNotNull(this.mTimerDraw);
            }
        }
    }

    public static class ControllerActivityCounterImpl
    extends BatteryStats.ControllerActivityCounter
    implements Parcelable {
        private final LongSamplingCounter mIdleTimeMillis;
        private final LongSamplingCounter mScanTimeMillis;
        private final LongSamplingCounter mSleepTimeMillis;
        private final LongSamplingCounter mRxTimeMillis;
        private final LongSamplingCounter[] mTxTimeMillis;
        private final LongSamplingCounter mPowerDrainMaMs;
        private final LongSamplingCounter mMonitoredRailChargeConsumedMaMs;

        public ControllerActivityCounterImpl(TimeBase timeBase, int numTxStates) {
            this.mIdleTimeMillis = new LongSamplingCounter(timeBase);
            this.mScanTimeMillis = new LongSamplingCounter(timeBase);
            this.mSleepTimeMillis = new LongSamplingCounter(timeBase);
            this.mRxTimeMillis = new LongSamplingCounter(timeBase);
            this.mTxTimeMillis = new LongSamplingCounter[numTxStates];
            for (int i = 0; i < numTxStates; ++i) {
                this.mTxTimeMillis[i] = new LongSamplingCounter(timeBase);
            }
            this.mPowerDrainMaMs = new LongSamplingCounter(timeBase);
            this.mMonitoredRailChargeConsumedMaMs = new LongSamplingCounter(timeBase);
        }

        public ControllerActivityCounterImpl(TimeBase timeBase, int numTxStates, Parcel in) {
            this.mIdleTimeMillis = new LongSamplingCounter(timeBase, in);
            this.mScanTimeMillis = new LongSamplingCounter(timeBase, in);
            this.mSleepTimeMillis = new LongSamplingCounter(timeBase, in);
            this.mRxTimeMillis = new LongSamplingCounter(timeBase, in);
            int recordedTxStates = in.readInt();
            if (recordedTxStates != numTxStates) {
                throw new ParcelFormatException("inconsistent tx state lengths");
            }
            this.mTxTimeMillis = new LongSamplingCounter[numTxStates];
            for (int i = 0; i < numTxStates; ++i) {
                this.mTxTimeMillis[i] = new LongSamplingCounter(timeBase, in);
            }
            this.mPowerDrainMaMs = new LongSamplingCounter(timeBase, in);
            this.mMonitoredRailChargeConsumedMaMs = new LongSamplingCounter(timeBase, in);
        }

        public void readSummaryFromParcel(Parcel in) {
            this.mIdleTimeMillis.readSummaryFromParcelLocked(in);
            this.mScanTimeMillis.readSummaryFromParcelLocked(in);
            this.mSleepTimeMillis.readSummaryFromParcelLocked(in);
            this.mRxTimeMillis.readSummaryFromParcelLocked(in);
            int recordedTxStates = in.readInt();
            if (recordedTxStates != this.mTxTimeMillis.length) {
                throw new ParcelFormatException("inconsistent tx state lengths");
            }
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.readSummaryFromParcelLocked(in);
            }
            this.mPowerDrainMaMs.readSummaryFromParcelLocked(in);
            this.mMonitoredRailChargeConsumedMaMs.readSummaryFromParcelLocked(in);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public void writeSummaryToParcel(Parcel dest) {
            this.mIdleTimeMillis.writeSummaryFromParcelLocked(dest);
            this.mScanTimeMillis.writeSummaryFromParcelLocked(dest);
            this.mSleepTimeMillis.writeSummaryFromParcelLocked(dest);
            this.mRxTimeMillis.writeSummaryFromParcelLocked(dest);
            dest.writeInt(this.mTxTimeMillis.length);
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.writeSummaryFromParcelLocked(dest);
            }
            this.mPowerDrainMaMs.writeSummaryFromParcelLocked(dest);
            this.mMonitoredRailChargeConsumedMaMs.writeSummaryFromParcelLocked(dest);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mIdleTimeMillis.writeToParcel(dest);
            this.mScanTimeMillis.writeToParcel(dest);
            this.mSleepTimeMillis.writeToParcel(dest);
            this.mRxTimeMillis.writeToParcel(dest);
            dest.writeInt(this.mTxTimeMillis.length);
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.writeToParcel(dest);
            }
            this.mPowerDrainMaMs.writeToParcel(dest);
            this.mMonitoredRailChargeConsumedMaMs.writeToParcel(dest);
        }

        public void reset(boolean detachIfReset) {
            this.mIdleTimeMillis.reset(detachIfReset);
            this.mScanTimeMillis.reset(detachIfReset);
            this.mSleepTimeMillis.reset(detachIfReset);
            this.mRxTimeMillis.reset(detachIfReset);
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.reset(detachIfReset);
            }
            this.mPowerDrainMaMs.reset(detachIfReset);
            this.mMonitoredRailChargeConsumedMaMs.reset(detachIfReset);
        }

        public void detach() {
            this.mIdleTimeMillis.detach();
            this.mScanTimeMillis.detach();
            this.mSleepTimeMillis.detach();
            this.mRxTimeMillis.detach();
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.detach();
            }
            this.mPowerDrainMaMs.detach();
            this.mMonitoredRailChargeConsumedMaMs.detach();
        }

        @Override
        public LongSamplingCounter getIdleTimeCounter() {
            return this.mIdleTimeMillis;
        }

        @Override
        public LongSamplingCounter getScanTimeCounter() {
            return this.mScanTimeMillis;
        }

        @Override
        public LongSamplingCounter getSleepTimeCounter() {
            return this.mSleepTimeMillis;
        }

        @Override
        public LongSamplingCounter getRxTimeCounter() {
            return this.mRxTimeMillis;
        }

        public LongSamplingCounter[] getTxTimeCounters() {
            return this.mTxTimeMillis;
        }

        @Override
        public LongSamplingCounter getPowerCounter() {
            return this.mPowerDrainMaMs;
        }

        @Override
        public LongSamplingCounter getMonitoredRailChargeConsumedMaMs() {
            return this.mMonitoredRailChargeConsumedMaMs;
        }
    }

    public abstract class OverflowArrayMap<T> {
        private static final String OVERFLOW_NAME = "*overflow*";
        final int mUid;
        final ArrayMap<String, T> mMap = new ArrayMap();
        T mCurOverflow;
        ArrayMap<String, MutableInt> mActiveOverflow;
        long mLastOverflowTime;
        long mLastOverflowFinishTime;
        long mLastClearTime;
        long mLastCleanupTime;

        public OverflowArrayMap(int uid) {
            this.mUid = uid;
        }

        public ArrayMap<String, T> getMap() {
            return this.mMap;
        }

        public void clear() {
            this.mLastClearTime = SystemClock.elapsedRealtime();
            this.mMap.clear();
            this.mCurOverflow = null;
            this.mActiveOverflow = null;
        }

        public void add(String name, T obj) {
            if (name == null) {
                name = "";
            }
            this.mMap.put(name, obj);
            if (OVERFLOW_NAME.equals(name)) {
                this.mCurOverflow = obj;
            }
        }

        public void cleanup() {
            this.mLastCleanupTime = SystemClock.elapsedRealtime();
            if (this.mActiveOverflow != null && this.mActiveOverflow.size() == 0) {
                this.mActiveOverflow = null;
            }
            if (this.mActiveOverflow == null) {
                if (this.mMap.containsKey(OVERFLOW_NAME)) {
                    Slog.wtf(BatteryStatsImpl.TAG, "Cleaning up with no active overflow, but have overflow entry " + this.mMap.get(OVERFLOW_NAME));
                    this.mMap.remove(OVERFLOW_NAME);
                }
                this.mCurOverflow = null;
            } else if (this.mCurOverflow == null || !this.mMap.containsKey(OVERFLOW_NAME)) {
                Slog.wtf(BatteryStatsImpl.TAG, "Cleaning up with active overflow, but no overflow entry: cur=" + this.mCurOverflow + " map=" + this.mMap.get(OVERFLOW_NAME));
            }
        }

        public T startObject(String name) {
            MutableInt over;
            T obj;
            if (name == null) {
                name = "";
            }
            if ((obj = this.mMap.get(name)) != null) {
                return obj;
            }
            if (this.mActiveOverflow != null && (over = this.mActiveOverflow.get(name)) != null) {
                obj = this.mCurOverflow;
                if (obj == null) {
                    Slog.wtf(BatteryStatsImpl.TAG, "Have active overflow " + name + " but null overflow");
                    this.mCurOverflow = this.instantiateObject();
                    obj = this.mCurOverflow;
                    this.mMap.put(OVERFLOW_NAME, obj);
                }
                ++over.value;
                return obj;
            }
            int N = this.mMap.size();
            if (N >= MAX_WAKELOCKS_PER_UID) {
                obj = this.mCurOverflow;
                if (obj == null) {
                    this.mCurOverflow = this.instantiateObject();
                    obj = this.mCurOverflow;
                    this.mMap.put(OVERFLOW_NAME, obj);
                }
                if (this.mActiveOverflow == null) {
                    this.mActiveOverflow = new ArrayMap();
                }
                this.mActiveOverflow.put(name, new MutableInt(1));
                this.mLastOverflowTime = SystemClock.elapsedRealtime();
                return obj;
            }
            obj = this.instantiateObject();
            this.mMap.put(name, obj);
            return obj;
        }

        public T stopObject(String name) {
            MutableInt over;
            T obj;
            if (name == null) {
                name = "";
            }
            if ((obj = this.mMap.get(name)) != null) {
                return obj;
            }
            if (this.mActiveOverflow != null && (over = this.mActiveOverflow.get(name)) != null && (obj = this.mCurOverflow) != null) {
                --over.value;
                if (over.value <= 0) {
                    this.mActiveOverflow.remove(name);
                    this.mLastOverflowFinishTime = SystemClock.elapsedRealtime();
                }
                return obj;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find object for ");
            sb.append(name);
            sb.append(" in uid ");
            sb.append(this.mUid);
            sb.append(" mapsize=");
            sb.append(this.mMap.size());
            sb.append(" activeoverflow=");
            sb.append(this.mActiveOverflow);
            sb.append(" curoverflow=");
            sb.append(this.mCurOverflow);
            long now = SystemClock.elapsedRealtime();
            if (this.mLastOverflowTime != 0L) {
                sb.append(" lastOverflowTime=");
                TimeUtils.formatDuration(this.mLastOverflowTime - now, sb);
            }
            if (this.mLastOverflowFinishTime != 0L) {
                sb.append(" lastOverflowFinishTime=");
                TimeUtils.formatDuration(this.mLastOverflowFinishTime - now, sb);
            }
            if (this.mLastClearTime != 0L) {
                sb.append(" lastClearTime=");
                TimeUtils.formatDuration(this.mLastClearTime - now, sb);
            }
            if (this.mLastCleanupTime != 0L) {
                sb.append(" lastCleanupTime=");
                TimeUtils.formatDuration(this.mLastCleanupTime - now, sb);
            }
            Slog.wtf(BatteryStatsImpl.TAG, sb.toString());
            return null;
        }

        public abstract T instantiateObject();
    }

    public static class DualTimer
    extends DurationTimer {
        private final DurationTimer mSubTimer;

        public DualTimer(Clocks clocks, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, TimeBase subTimeBase, Parcel in) {
            super(clocks, uid, type, timerPool, timeBase, in);
            this.mSubTimer = new DurationTimer(clocks, uid, type, null, subTimeBase, in);
        }

        public DualTimer(Clocks clocks, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, TimeBase subTimeBase) {
            super(clocks, uid, type, timerPool, timeBase);
            this.mSubTimer = new DurationTimer(clocks, uid, type, null, subTimeBase);
        }

        @Override
        public DurationTimer getSubTimer() {
            return this.mSubTimer;
        }

        @Override
        public void startRunningLocked(long elapsedRealtimeMs) {
            super.startRunningLocked(elapsedRealtimeMs);
            this.mSubTimer.startRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void stopRunningLocked(long elapsedRealtimeMs) {
            super.stopRunningLocked(elapsedRealtimeMs);
            this.mSubTimer.stopRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void stopAllRunningLocked(long elapsedRealtimeMs) {
            super.stopAllRunningLocked(elapsedRealtimeMs);
            this.mSubTimer.stopAllRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public boolean reset(boolean detachIfReset) {
            boolean active = false;
            active |= !this.mSubTimer.reset(false);
            return !(active |= !super.reset(detachIfReset));
        }

        @Override
        public void detach() {
            this.mSubTimer.detach();
            super.detach();
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            this.mSubTimer.writeToParcel(out, elapsedRealtimeUs);
        }

        @Override
        public void writeSummaryFromParcelLocked(Parcel out, long elapsedRealtimeUs) {
            super.writeSummaryFromParcelLocked(out, elapsedRealtimeUs);
            this.mSubTimer.writeSummaryFromParcelLocked(out, elapsedRealtimeUs);
        }

        @Override
        public void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mSubTimer.readSummaryFromParcelLocked(in);
        }
    }

    public static class StopwatchTimer
    extends Timer {
        final Uid mUid;
        final ArrayList<StopwatchTimer> mTimerPool;
        int mNesting;
        long mUpdateTime;
        long mAcquireTime = -1L;
        long mTimeout;
        @VisibleForTesting
        public boolean mInList;

        public StopwatchTimer(Clocks clocks, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, Parcel in) {
            super(clocks, type, timeBase, in);
            this.mUid = uid;
            this.mTimerPool = timerPool;
            this.mUpdateTime = in.readLong();
        }

        public StopwatchTimer(Clocks clocks, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase) {
            super(clocks, type, timeBase);
            this.mUid = uid;
            this.mTimerPool = timerPool;
        }

        public void setTimeout(long timeout) {
            this.mTimeout = timeout;
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.mUpdateTime);
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            if (this.mNesting > 0) {
                super.onTimeStopped(elapsedRealtime, baseUptime, baseRealtime);
                this.mUpdateTime = baseRealtime;
            }
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mNesting=" + this.mNesting + " mUpdateTime=" + this.mUpdateTime + " mAcquireTime=" + this.mAcquireTime);
        }

        public void startRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting++ == 0) {
                long batteryRealtime;
                this.mUpdateTime = batteryRealtime = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtime, this.mTimerPool, null);
                    this.mTimerPool.add(this);
                }
                if (this.mTimeBase.isRunning()) {
                    ++this.mCount;
                    this.mAcquireTime = this.mTotalTime;
                } else {
                    this.mAcquireTime = -1L;
                }
            }
        }

        @Override
        public boolean isRunningLocked() {
            return this.mNesting > 0;
        }

        public void stopRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting == 0) {
                return;
            }
            if (--this.mNesting == 0) {
                long batteryRealtime = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtime, this.mTimerPool, null);
                    this.mTimerPool.remove(this);
                } else {
                    this.mNesting = 1;
                    this.mTotalTime = this.computeRunTimeLocked(batteryRealtime);
                    this.mNesting = 0;
                }
                if (this.mAcquireTime >= 0L && this.mTotalTime == this.mAcquireTime) {
                    --this.mCount;
                }
            }
        }

        public void stopAllRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting > 0) {
                this.mNesting = 1;
                this.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private static long refreshTimersLocked(long batteryRealtime, ArrayList<StopwatchTimer> pool, StopwatchTimer self) {
            long selfTime = 0L;
            int N = pool.size();
            for (int i = N - 1; i >= 0; --i) {
                StopwatchTimer t = pool.get(i);
                long heldTime = batteryRealtime - t.mUpdateTime;
                if (heldTime > 0L) {
                    long myTime = heldTime / (long)N;
                    if (t == self) {
                        selfTime = myTime;
                    }
                    t.mTotalTime += myTime;
                }
                t.mUpdateTime = batteryRealtime;
            }
            return selfTime;
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime) {
            if (this.mTimeout > 0L && curBatteryRealtime > this.mUpdateTime + this.mTimeout) {
                curBatteryRealtime = this.mUpdateTime + this.mTimeout;
            }
            return this.mTotalTime + (this.mNesting > 0 ? (curBatteryRealtime - this.mUpdateTime) / (long)(this.mTimerPool != null ? this.mTimerPool.size() : 1) : 0L);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        @Override
        public boolean reset(boolean detachIfReset) {
            boolean canDetach = this.mNesting <= 0;
            super.reset(canDetach && detachIfReset);
            if (this.mNesting > 0) {
                this.mUpdateTime = this.mTimeBase.getRealtime(this.mClocks.elapsedRealtime() * 1000L);
            }
            this.mAcquireTime = -1L;
            return canDetach;
        }

        @Override
        @UnsupportedAppUsage
        public void detach() {
            super.detach();
            if (this.mTimerPool != null) {
                this.mTimerPool.remove(this);
            }
        }

        @Override
        public void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mNesting = 0;
        }

        public void setMark(long elapsedRealtimeMs) {
            long batteryRealtime = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
            if (this.mNesting > 0) {
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtime, this.mTimerPool, this);
                } else {
                    this.mTotalTime += batteryRealtime - this.mUpdateTime;
                    this.mUpdateTime = batteryRealtime;
                }
            }
            this.mTimeBeforeMark = this.mTotalTime;
        }
    }

    public static class DurationTimer
    extends StopwatchTimer {
        long mStartTimeMs = -1L;
        long mMaxDurationMs;
        long mCurrentDurationMs;
        long mTotalDurationMs;

        public DurationTimer(Clocks clocks, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, Parcel in) {
            super(clocks, uid, type, timerPool, timeBase, in);
            this.mMaxDurationMs = in.readLong();
            this.mTotalDurationMs = in.readLong();
            this.mCurrentDurationMs = in.readLong();
        }

        public DurationTimer(Clocks clocks, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase) {
            super(clocks, uid, type, timerPool, timeBase);
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.getMaxDurationMsLocked(elapsedRealtimeUs / 1000L));
            out.writeLong(this.mTotalDurationMs);
            out.writeLong(this.getCurrentDurationMsLocked(elapsedRealtimeUs / 1000L));
        }

        @Override
        public void writeSummaryFromParcelLocked(Parcel out, long elapsedRealtimeUs) {
            super.writeSummaryFromParcelLocked(out, elapsedRealtimeUs);
            out.writeLong(this.getMaxDurationMsLocked(elapsedRealtimeUs / 1000L));
            out.writeLong(this.getTotalDurationMsLocked(elapsedRealtimeUs / 1000L));
        }

        @Override
        public void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mMaxDurationMs = in.readLong();
            this.mTotalDurationMs = in.readLong();
            this.mStartTimeMs = -1L;
            this.mCurrentDurationMs = 0L;
        }

        @Override
        public void onTimeStarted(long elapsedRealtimeUs, long baseUptime, long baseRealtime) {
            super.onTimeStarted(elapsedRealtimeUs, baseUptime, baseRealtime);
            if (this.mNesting > 0) {
                this.mStartTimeMs = baseRealtime / 1000L;
            }
        }

        @Override
        public void onTimeStopped(long elapsedRealtimeUs, long baseUptime, long baseRealtimeUs) {
            super.onTimeStopped(elapsedRealtimeUs, baseUptime, baseRealtimeUs);
            if (this.mNesting > 0) {
                this.mCurrentDurationMs += baseRealtimeUs / 1000L - this.mStartTimeMs;
            }
            this.mStartTimeMs = -1L;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
        }

        @Override
        public void startRunningLocked(long elapsedRealtimeMs) {
            super.startRunningLocked(elapsedRealtimeMs);
            if (this.mNesting == 1 && this.mTimeBase.isRunning()) {
                this.mStartTimeMs = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L) / 1000L;
            }
        }

        @Override
        public void stopRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting == 1) {
                long durationMs = this.getCurrentDurationMsLocked(elapsedRealtimeMs);
                this.mTotalDurationMs += durationMs;
                if (durationMs > this.mMaxDurationMs) {
                    this.mMaxDurationMs = durationMs;
                }
                this.mStartTimeMs = -1L;
                this.mCurrentDurationMs = 0L;
            }
            super.stopRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public boolean reset(boolean detachIfReset) {
            boolean result = super.reset(detachIfReset);
            this.mMaxDurationMs = 0L;
            this.mTotalDurationMs = 0L;
            this.mCurrentDurationMs = 0L;
            this.mStartTimeMs = this.mNesting > 0 ? this.mTimeBase.getRealtime(this.mClocks.elapsedRealtime() * 1000L) / 1000L : -1L;
            return result;
        }

        @Override
        public long getMaxDurationMsLocked(long elapsedRealtimeMs) {
            long durationMs;
            if (this.mNesting > 0 && (durationMs = this.getCurrentDurationMsLocked(elapsedRealtimeMs)) > this.mMaxDurationMs) {
                return durationMs;
            }
            return this.mMaxDurationMs;
        }

        @Override
        public long getCurrentDurationMsLocked(long elapsedRealtimeMs) {
            long durationMs = this.mCurrentDurationMs;
            if (this.mNesting > 0 && this.mTimeBase.isRunning()) {
                durationMs += this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L) / 1000L - this.mStartTimeMs;
            }
            return durationMs;
        }

        @Override
        public long getTotalDurationMsLocked(long elapsedRealtimeMs) {
            return this.mTotalDurationMs + this.getCurrentDurationMsLocked(elapsedRealtimeMs);
        }
    }

    public static class BatchTimer
    extends Timer {
        final Uid mUid;
        long mLastAddedTime;
        long mLastAddedDuration;
        boolean mInDischarge;

        BatchTimer(Clocks clocks, Uid uid, int type, TimeBase timeBase, Parcel in) {
            super(clocks, type, timeBase, in);
            this.mUid = uid;
            this.mLastAddedTime = in.readLong();
            this.mLastAddedDuration = in.readLong();
            this.mInDischarge = timeBase.isRunning();
        }

        BatchTimer(Clocks clocks, Uid uid, int type, TimeBase timeBase) {
            super(clocks, type, timeBase);
            this.mUid = uid;
            this.mInDischarge = timeBase.isRunning();
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.mLastAddedTime);
            out.writeLong(this.mLastAddedDuration);
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.recomputeLastDuration(this.mClocks.elapsedRealtime() * 1000L, false);
            this.mInDischarge = false;
            super.onTimeStopped(elapsedRealtime, baseUptime, baseRealtime);
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.recomputeLastDuration(elapsedRealtime, false);
            this.mInDischarge = true;
            if (this.mLastAddedTime == elapsedRealtime) {
                this.mTotalTime += this.mLastAddedDuration;
            }
            super.onTimeStarted(elapsedRealtime, baseUptime, baseRealtime);
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mLastAddedTime=" + this.mLastAddedTime + " mLastAddedDuration=" + this.mLastAddedDuration);
        }

        private long computeOverage(long curTime) {
            if (this.mLastAddedTime > 0L) {
                return this.mLastAddedDuration - curTime;
            }
            return 0L;
        }

        private void recomputeLastDuration(long curTime, boolean abort) {
            long overage = this.computeOverage(curTime);
            if (overage > 0L) {
                if (this.mInDischarge) {
                    this.mTotalTime -= overage;
                }
                if (abort) {
                    this.mLastAddedTime = 0L;
                } else {
                    this.mLastAddedTime = curTime;
                    this.mLastAddedDuration -= overage;
                }
            }
        }

        public void addDuration(BatteryStatsImpl stats, long durationMillis) {
            long now = this.mClocks.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
            this.mLastAddedTime = now;
            this.mLastAddedDuration = durationMillis * 1000L;
            if (this.mInDischarge) {
                this.mTotalTime += this.mLastAddedDuration;
                ++this.mCount;
            }
        }

        public void abortLastDuration(BatteryStatsImpl stats) {
            long now = this.mClocks.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime) {
            long overage = this.computeOverage(this.mClocks.elapsedRealtime() * 1000L);
            if (overage > 0L) {
                this.mTotalTime = overage;
                return this.mTotalTime;
            }
            return this.mTotalTime;
        }

        @Override
        public boolean reset(boolean detachIfReset) {
            long now = this.mClocks.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
            boolean stillActive = this.mLastAddedTime == now;
            super.reset(!stillActive && detachIfReset);
            return !stillActive;
        }
    }

    public static class SamplingTimer
    extends Timer {
        int mCurrentReportedCount;
        int mUnpluggedReportedCount;
        long mCurrentReportedTotalTime;
        long mUnpluggedReportedTotalTime;
        boolean mTimeBaseRunning;
        boolean mTrackingReportedValues;
        int mUpdateVersion;

        @VisibleForTesting
        public SamplingTimer(Clocks clocks, TimeBase timeBase, Parcel in) {
            super(clocks, 0, timeBase, in);
            this.mCurrentReportedCount = in.readInt();
            this.mUnpluggedReportedCount = in.readInt();
            this.mCurrentReportedTotalTime = in.readLong();
            this.mUnpluggedReportedTotalTime = in.readLong();
            this.mTrackingReportedValues = in.readInt() == 1;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        @VisibleForTesting
        public SamplingTimer(Clocks clocks, TimeBase timeBase) {
            super(clocks, 0, timeBase);
            this.mTrackingReportedValues = false;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        public void endSample() {
            this.mTotalTime = this.computeRunTimeLocked(0L);
            this.mCount = this.computeCurrentCountLocked();
            this.mCurrentReportedTotalTime = 0L;
            this.mUnpluggedReportedTotalTime = 0L;
            this.mCurrentReportedCount = 0;
            this.mUnpluggedReportedCount = 0;
            this.mTrackingReportedValues = false;
        }

        public void setUpdateVersion(int version) {
            this.mUpdateVersion = version;
        }

        public int getUpdateVersion() {
            return this.mUpdateVersion;
        }

        public void update(long totalTime, int count) {
            if (this.mTimeBaseRunning && !this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTime = totalTime;
                this.mUnpluggedReportedCount = count;
            }
            this.mTrackingReportedValues = true;
            if (totalTime < this.mCurrentReportedTotalTime || count < this.mCurrentReportedCount) {
                this.endSample();
            }
            this.mCurrentReportedTotalTime = totalTime;
            this.mCurrentReportedCount = count;
        }

        public void add(long deltaTime, int deltaCount) {
            this.update(this.mCurrentReportedTotalTime + deltaTime, this.mCurrentReportedCount + deltaCount);
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            super.onTimeStarted(elapsedRealtime, baseUptime, baseRealtime);
            if (this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTime = this.mCurrentReportedTotalTime;
                this.mUnpluggedReportedCount = this.mCurrentReportedCount;
            }
            this.mTimeBaseRunning = true;
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            super.onTimeStopped(elapsedRealtime, baseUptime, baseRealtime);
            this.mTimeBaseRunning = false;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mCurrentReportedCount=" + this.mCurrentReportedCount + " mUnpluggedReportedCount=" + this.mUnpluggedReportedCount + " mCurrentReportedTotalTime=" + this.mCurrentReportedTotalTime + " mUnpluggedReportedTotalTime=" + this.mUnpluggedReportedTotalTime);
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime) {
            return this.mTotalTime + (this.mTimeBaseRunning && this.mTrackingReportedValues ? this.mCurrentReportedTotalTime - this.mUnpluggedReportedTotalTime : 0L);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount + (this.mTimeBaseRunning && this.mTrackingReportedValues ? this.mCurrentReportedCount - this.mUnpluggedReportedCount : 0);
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeInt(this.mCurrentReportedCount);
            out.writeInt(this.mUnpluggedReportedCount);
            out.writeLong(this.mCurrentReportedTotalTime);
            out.writeLong(this.mUnpluggedReportedTotalTime);
            out.writeInt(this.mTrackingReportedValues ? 1 : 0);
        }

        @Override
        public boolean reset(boolean detachIfReset) {
            super.reset(detachIfReset);
            this.mTrackingReportedValues = false;
            this.mUnpluggedReportedTotalTime = 0L;
            this.mUnpluggedReportedCount = 0;
            return true;
        }
    }

    public static abstract class Timer
    extends BatteryStats.Timer
    implements TimeBaseObs {
        protected final Clocks mClocks;
        protected final int mType;
        protected final TimeBase mTimeBase;
        protected int mCount;
        protected long mTotalTime;
        protected long mTimeBeforeMark;

        public Timer(Clocks clocks, int type, TimeBase timeBase, Parcel in) {
            this.mClocks = clocks;
            this.mType = type;
            this.mTimeBase = timeBase;
            this.mCount = in.readInt();
            this.mTotalTime = in.readLong();
            this.mTimeBeforeMark = in.readLong();
            timeBase.add(this);
        }

        public Timer(Clocks clocks, int type, TimeBase timeBase) {
            this.mClocks = clocks;
            this.mType = type;
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            out.writeInt(this.computeCurrentCountLocked());
            out.writeLong(this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs)));
            out.writeLong(this.mTimeBeforeMark);
        }

        protected abstract long computeRunTimeLocked(long var1);

        protected abstract int computeCurrentCountLocked();

        @Override
        public boolean reset(boolean detachIfReset) {
            this.mTimeBeforeMark = 0L;
            this.mTotalTime = 0L;
            this.mCount = 0;
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long timeBaseUptime, long baseRealtime) {
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mTotalTime = this.computeRunTimeLocked(baseRealtime);
            this.mCount = this.computeCurrentCountLocked();
        }

        @UnsupportedAppUsage
        public static void writeTimerToParcel(Parcel out, Timer timer, long elapsedRealtimeUs) {
            if (timer == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            timer.writeToParcel(out, elapsedRealtimeUs);
        }

        @Override
        @UnsupportedAppUsage
        public long getTotalTimeLocked(long elapsedRealtimeUs, int which) {
            return this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs));
        }

        @Override
        @UnsupportedAppUsage
        public int getCountLocked(int which) {
            return this.computeCurrentCountLocked();
        }

        @Override
        public long getTimeSinceMarkLocked(long elapsedRealtimeUs) {
            long val = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs));
            return val - this.mTimeBeforeMark;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount);
            pw.println(prefix + "mTotalTime=" + this.mTotalTime);
        }

        public void writeSummaryFromParcelLocked(Parcel out, long elapsedRealtimeUs) {
            long runTime = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs));
            out.writeLong(runTime);
            out.writeInt(this.computeCurrentCountLocked());
        }

        public void readSummaryFromParcelLocked(Parcel in) {
            this.mTotalTime = in.readLong();
            this.mCount = in.readInt();
            this.mTimeBeforeMark = this.mTotalTime;
        }
    }

    @VisibleForTesting
    public static class LongSamplingCounter
    extends BatteryStats.LongCounter
    implements TimeBaseObs {
        final TimeBase mTimeBase;
        private long mCount;

        public LongSamplingCounter(TimeBase timeBase, Parcel in) {
            this.mTimeBase = timeBase;
            this.mCount = in.readLong();
            timeBase.add(this);
        }

        public LongSamplingCounter(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        public void writeToParcel(Parcel out) {
            out.writeLong(this.mCount);
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
        }

        @Override
        public long getCountLocked(int which) {
            return this.mCount;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount);
        }

        public void addCountLocked(long count) {
            this.addCountLocked(count, this.mTimeBase.isRunning());
        }

        public void addCountLocked(long count, boolean isRunning) {
            if (isRunning) {
                this.mCount += count;
            }
        }

        @Override
        public boolean reset(boolean detachIfReset) {
            this.mCount = 0L;
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }

        public void writeSummaryFromParcelLocked(Parcel out) {
            out.writeLong(this.mCount);
        }

        public void readSummaryFromParcelLocked(Parcel in) {
            this.mCount = in.readLong();
        }
    }

    @VisibleForTesting
    public static class LongSamplingCounterArray
    extends BatteryStats.LongCounterArray
    implements TimeBaseObs {
        final TimeBase mTimeBase;
        public long[] mCounts;

        private LongSamplingCounterArray(TimeBase timeBase, Parcel in) {
            this.mTimeBase = timeBase;
            this.mCounts = in.createLongArray();
            timeBase.add(this);
        }

        public LongSamplingCounterArray(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        private void writeToParcel(Parcel out) {
            out.writeLongArray(this.mCounts);
        }

        @Override
        public void onTimeStarted(long elapsedRealTime, long baseUptime, long baseRealtime) {
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
        }

        @Override
        public long[] getCountsLocked(int which) {
            return this.mCounts == null ? null : Arrays.copyOf(this.mCounts, this.mCounts.length);
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCounts=" + Arrays.toString(this.mCounts));
        }

        public void addCountLocked(long[] counts) {
            this.addCountLocked(counts, this.mTimeBase.isRunning());
        }

        public void addCountLocked(long[] counts, boolean isRunning) {
            if (counts == null) {
                return;
            }
            if (isRunning) {
                if (this.mCounts == null) {
                    this.mCounts = new long[counts.length];
                }
                for (int i = 0; i < counts.length; ++i) {
                    int n = i;
                    this.mCounts[n] = this.mCounts[n] + counts[i];
                }
            }
        }

        public int getSize() {
            return this.mCounts == null ? 0 : this.mCounts.length;
        }

        @Override
        public boolean reset(boolean detachIfReset) {
            if (this.mCounts != null) {
                Arrays.fill(this.mCounts, 0L);
            }
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }

        private void writeSummaryToParcelLocked(Parcel out) {
            out.writeLongArray(this.mCounts);
        }

        private void readSummaryFromParcelLocked(Parcel in) {
            this.mCounts = in.createLongArray();
        }

        public static void writeToParcel(Parcel out, LongSamplingCounterArray counterArray) {
            if (counterArray != null) {
                out.writeInt(1);
                counterArray.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
        }

        public static LongSamplingCounterArray readFromParcel(Parcel in, TimeBase timeBase) {
            if (in.readInt() != 0) {
                return new LongSamplingCounterArray(timeBase, in);
            }
            return null;
        }

        public static void writeSummaryToParcelLocked(Parcel out, LongSamplingCounterArray counterArray) {
            if (counterArray != null) {
                out.writeInt(1);
                counterArray.writeSummaryToParcelLocked(out);
            } else {
                out.writeInt(0);
            }
        }

        public static LongSamplingCounterArray readSummaryFromParcelLocked(Parcel in, TimeBase timeBase) {
            if (in.readInt() != 0) {
                LongSamplingCounterArray counterArray = new LongSamplingCounterArray(timeBase);
                counterArray.readSummaryFromParcelLocked(in);
                return counterArray;
            }
            return null;
        }
    }

    public static class Counter
    extends BatteryStats.Counter
    implements TimeBaseObs {
        @UnsupportedAppUsage
        final AtomicInteger mCount = new AtomicInteger();
        final TimeBase mTimeBase;

        public Counter(TimeBase timeBase, Parcel in) {
            this.mTimeBase = timeBase;
            this.mCount.set(in.readInt());
            timeBase.add(this);
        }

        public Counter(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        public void writeToParcel(Parcel out) {
            out.writeInt(this.mCount.get());
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
        }

        public static void writeCounterToParcel(Parcel out, Counter counter) {
            if (counter == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            counter.writeToParcel(out);
        }

        public static Counter readCounterFromParcel(TimeBase timeBase, Parcel in) {
            if (in.readInt() == 0) {
                return null;
            }
            return new Counter(timeBase, in);
        }

        @Override
        public int getCountLocked(int which) {
            return this.mCount.get();
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount.get());
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void stepAtomic() {
            if (this.mTimeBase.isRunning()) {
                this.mCount.incrementAndGet();
            }
        }

        void addAtomic(int delta) {
            if (this.mTimeBase.isRunning()) {
                this.mCount.addAndGet(delta);
            }
        }

        @Override
        public boolean reset(boolean detachIfReset) {
            this.mCount.set(0);
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        @Override
        public void detach() {
            this.mTimeBase.remove(this);
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void writeSummaryFromParcelLocked(Parcel out) {
            out.writeInt(this.mCount.get());
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void readSummaryFromParcelLocked(Parcel in) {
            this.mCount.set(in.readInt());
        }
    }

    public static class TimeBase {
        protected final Collection<TimeBaseObs> mObservers;
        protected long mUptime;
        protected long mRealtime;
        protected boolean mRunning;
        protected long mPastUptime;
        protected long mUptimeStart;
        protected long mPastRealtime;
        protected long mRealtimeStart;
        protected long mUnpluggedUptime;
        protected long mUnpluggedRealtime;

        public void dump(PrintWriter pw, String prefix) {
            StringBuilder sb = new StringBuilder(128);
            pw.print(prefix);
            pw.print("mRunning=");
            pw.println(this.mRunning);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mUptime=");
            BatteryStats.formatTimeMs(sb, this.mUptime / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mRealtime=");
            BatteryStats.formatTimeMs(sb, this.mRealtime / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPastUptime=");
            BatteryStats.formatTimeMs(sb, this.mPastUptime / 1000L);
            sb.append("mUptimeStart=");
            BatteryStats.formatTimeMs(sb, this.mUptimeStart / 1000L);
            sb.append("mUnpluggedUptime=");
            BatteryStats.formatTimeMs(sb, this.mUnpluggedUptime / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPastRealtime=");
            BatteryStats.formatTimeMs(sb, this.mPastRealtime / 1000L);
            sb.append("mRealtimeStart=");
            BatteryStats.formatTimeMs(sb, this.mRealtimeStart / 1000L);
            sb.append("mUnpluggedRealtime=");
            BatteryStats.formatTimeMs(sb, this.mUnpluggedRealtime / 1000L);
            pw.println(sb.toString());
        }

        public TimeBase(boolean isLongList) {
            this.mObservers = isLongList ? new HashSet() : new ArrayList();
        }

        public TimeBase() {
            this(false);
        }

        public void add(TimeBaseObs observer) {
            this.mObservers.add(observer);
        }

        public void remove(TimeBaseObs observer) {
            this.mObservers.remove(observer);
        }

        public boolean hasObserver(TimeBaseObs observer) {
            return this.mObservers.contains(observer);
        }

        public void init(long uptime, long realtime) {
            this.mRealtime = 0L;
            this.mUptime = 0L;
            this.mPastUptime = 0L;
            this.mPastRealtime = 0L;
            this.mUptimeStart = uptime;
            this.mRealtimeStart = realtime;
            this.mUnpluggedUptime = this.getUptime(this.mUptimeStart);
            this.mUnpluggedRealtime = this.getRealtime(this.mRealtimeStart);
        }

        public void reset(long uptime, long realtime) {
            if (!this.mRunning) {
                this.mPastUptime = 0L;
                this.mPastRealtime = 0L;
            } else {
                this.mUptimeStart = uptime;
                this.mRealtimeStart = realtime;
                this.mUnpluggedUptime = this.getUptime(uptime);
                this.mUnpluggedRealtime = this.getRealtime(realtime);
            }
        }

        public long computeUptime(long curTime, int which) {
            return this.mUptime + this.getUptime(curTime);
        }

        public long computeRealtime(long curTime, int which) {
            return this.mRealtime + this.getRealtime(curTime);
        }

        public long getUptime(long curTime) {
            long time = this.mPastUptime;
            if (this.mRunning) {
                time += curTime - this.mUptimeStart;
            }
            return time;
        }

        public long getRealtime(long curTime) {
            long time = this.mPastRealtime;
            if (this.mRunning) {
                time += curTime - this.mRealtimeStart;
            }
            return time;
        }

        public long getUptimeStart() {
            return this.mUptimeStart;
        }

        public long getRealtimeStart() {
            return this.mRealtimeStart;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public boolean setRunning(boolean running, long uptime, long realtime) {
            if (this.mRunning != running) {
                this.mRunning = running;
                if (running) {
                    this.mUptimeStart = uptime;
                    this.mRealtimeStart = realtime;
                    long batteryUptime = this.mUnpluggedUptime = this.getUptime(uptime);
                    long batteryRealtime = this.mUnpluggedRealtime = this.getRealtime(realtime);
                    Iterator<TimeBaseObs> iter = this.mObservers.iterator();
                    while (iter.hasNext()) {
                        iter.next().onTimeStarted(realtime, batteryUptime, batteryRealtime);
                    }
                } else {
                    this.mPastUptime += uptime - this.mUptimeStart;
                    this.mPastRealtime += realtime - this.mRealtimeStart;
                    long batteryUptime = this.getUptime(uptime);
                    long batteryRealtime = this.getRealtime(realtime);
                    Iterator<TimeBaseObs> iter = this.mObservers.iterator();
                    while (iter.hasNext()) {
                        iter.next().onTimeStopped(realtime, batteryUptime, batteryRealtime);
                    }
                }
                return true;
            }
            return false;
        }

        public void readSummaryFromParcel(Parcel in) {
            this.mUptime = in.readLong();
            this.mRealtime = in.readLong();
        }

        public void writeSummaryToParcel(Parcel out, long uptime, long realtime) {
            out.writeLong(this.computeUptime(uptime, 0));
            out.writeLong(this.computeRealtime(realtime, 0));
        }

        public void readFromParcel(Parcel in) {
            this.mRunning = false;
            this.mUptime = in.readLong();
            this.mPastUptime = in.readLong();
            this.mUptimeStart = in.readLong();
            this.mRealtime = in.readLong();
            this.mPastRealtime = in.readLong();
            this.mRealtimeStart = in.readLong();
            this.mUnpluggedUptime = in.readLong();
            this.mUnpluggedRealtime = in.readLong();
        }

        public void writeToParcel(Parcel out, long uptime, long realtime) {
            long runningUptime = this.getUptime(uptime);
            long runningRealtime = this.getRealtime(realtime);
            out.writeLong(this.mUptime);
            out.writeLong(runningUptime);
            out.writeLong(this.mUptimeStart);
            out.writeLong(this.mRealtime);
            out.writeLong(runningRealtime);
            out.writeLong(this.mRealtimeStart);
            out.writeLong(this.mUnpluggedUptime);
            out.writeLong(this.mUnpluggedRealtime);
        }
    }

    public static interface TimeBaseObs {
        public void onTimeStarted(long var1, long var3, long var5);

        public void onTimeStopped(long var1, long var3, long var5);

        public boolean reset(boolean var1);

        public void detach();
    }

    public static interface ExternalStatsSync {
        public static final int UPDATE_CPU = 1;
        public static final int UPDATE_WIFI = 2;
        public static final int UPDATE_RADIO = 4;
        public static final int UPDATE_BT = 8;
        public static final int UPDATE_RPM = 16;
        public static final int UPDATE_ALL = 31;

        public Future<?> scheduleSync(String var1, int var2);

        public Future<?> scheduleCpuSyncDueToRemovedUid(int var1);

        public Future<?> scheduleReadProcStateCpuTimes(boolean var1, boolean var2, long var3);

        public Future<?> scheduleCopyFromAllUidsCpuTimes(boolean var1, boolean var2);

        public Future<?> scheduleCpuSyncDueToSettingChange();

        public Future<?> scheduleCpuSyncDueToScreenStateChange(boolean var1, boolean var2);

        public Future<?> scheduleCpuSyncDueToWakelockChange(long var1);

        public void cancelCpuSyncDueToWakelockChange();

        public Future<?> scheduleSyncDueToBatteryLevelChange(long var1);
    }

    public static class SystemClocks
    implements Clocks {
        @Override
        public long elapsedRealtime() {
            return SystemClock.elapsedRealtime();
        }

        @Override
        public long uptimeMillis() {
            return SystemClock.uptimeMillis();
        }
    }

    public static interface Clocks {
        public long elapsedRealtime();

        public long uptimeMillis();
    }

    class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            BatteryCallback cb = BatteryStatsImpl.this.mCallback;
            switch (msg.what) {
                case 1: {
                    if (cb == null) break;
                    cb.batteryNeedsCpuUpdate();
                    break;
                }
                case 2: {
                    if (cb == null) break;
                    cb.batteryPowerChanged(msg.arg1 != 0);
                    break;
                }
                case 3: {
                    String action;
                    if (cb == null) break;
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                    synchronized (batteryStatsImpl) {
                        action = BatteryStatsImpl.this.mCharging ? "android.os.action.CHARGING" : "android.os.action.DISCHARGING";
                    }
                    Intent intent = new Intent(action);
                    intent.addFlags(0x4000000);
                    cb.batterySendBroadcast(intent);
                    break;
                }
                case 4: {
                    if (cb == null) break;
                    cb.batteryStatsReset();
                }
            }
        }
    }

    public static abstract class UserInfoProvider {
        private int[] userIds;

        protected abstract int[] getUserIds();

        @VisibleForTesting
        public void refreshUserIds() {
            this.userIds = this.getUserIds();
        }

        @VisibleForTesting
        public boolean exists(int userId) {
            return this.userIds != null ? ArrayUtils.contains(this.userIds, userId) : true;
        }
    }

    public static interface RailEnergyDataCallback {
        public void fillRailDataStats(RailStats var1);
    }

    public static interface PlatformIdleStateCallback {
        public void fillLowPowerStats(RpmStats var1);

        public String getPlatformLowPowerStats();

        public String getSubsystemLowPowerStats();
    }

    public static interface BatteryCallback {
        public void batteryNeedsCpuUpdate();

        public void batteryPowerChanged(boolean var1);

        public void batterySendBroadcast(Intent var1);

        public void batteryStatsReset();
    }

    @VisibleForTesting
    public class UidToRemove {
        int startUid;
        int endUid;
        long timeAddedInQueue;

        public UidToRemove(int uid, long timestamp) {
            this(uid, uid, timestamp);
        }

        public UidToRemove(int startUid, int endUid, long timestamp) {
            this.startUid = startUid;
            this.endUid = endUid;
            this.timeAddedInQueue = timestamp;
        }

        void remove() {
            if (this.startUid == this.endUid) {
                BatteryStatsImpl.this.mCpuUidUserSysTimeReader.removeUid(this.startUid);
                BatteryStatsImpl.this.mCpuUidFreqTimeReader.removeUid(this.startUid);
                if (BatteryStatsImpl.this.mConstants.TRACK_CPU_ACTIVE_CLUSTER_TIME) {
                    BatteryStatsImpl.this.mCpuUidActiveTimeReader.removeUid(this.startUid);
                    BatteryStatsImpl.this.mCpuUidClusterTimeReader.removeUid(this.startUid);
                }
                if (BatteryStatsImpl.this.mKernelSingleUidTimeReader != null) {
                    BatteryStatsImpl.this.mKernelSingleUidTimeReader.removeUid(this.startUid);
                }
                BatteryStatsImpl.this.mNumUidsRemoved++;
            } else if (this.startUid < this.endUid) {
                BatteryStatsImpl.this.mCpuUidFreqTimeReader.removeUidsInRange(this.startUid, this.endUid);
                BatteryStatsImpl.this.mCpuUidUserSysTimeReader.removeUidsInRange(this.startUid, this.endUid);
                if (BatteryStatsImpl.this.mConstants.TRACK_CPU_ACTIVE_CLUSTER_TIME) {
                    BatteryStatsImpl.this.mCpuUidActiveTimeReader.removeUidsInRange(this.startUid, this.endUid);
                    BatteryStatsImpl.this.mCpuUidClusterTimeReader.removeUidsInRange(this.startUid, this.endUid);
                }
                if (BatteryStatsImpl.this.mKernelSingleUidTimeReader != null) {
                    BatteryStatsImpl.this.mKernelSingleUidTimeReader.removeUidsInRange(this.startUid, this.endUid);
                }
                BatteryStatsImpl.this.mNumUidsRemoved++;
            } else {
                Slog.w(BatteryStatsImpl.TAG, "End UID " + this.endUid + " is smaller than start UID " + this.startUid);
            }
        }
    }
}

