/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.view.inputmethod.ExtractedText;
import com.android.internal.inputmethod.CancellationGroup;
import com.android.internal.inputmethod.ICharSequenceResultCallback;
import com.android.internal.inputmethod.IExtractedTextResultCallback;
import com.android.internal.inputmethod.IIntResultCallback;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;

public class ResultCallbacks {
    private ResultCallbacks() {
    }

    private static <T> T unwrap(AtomicReference<WeakReference<T>> atomicRef) {
        WeakReference ref = atomicRef.getAndSet(null);
        if (ref == null) {
            return null;
        }
        Object value = ref.get();
        ref.clear();
        return value;
    }

    public static IIntResultCallback.Stub of(CancellationGroup.Completable.Int value) {
        final AtomicReference<WeakReference<CancellationGroup.Completable.Int>> atomicRef = new AtomicReference<WeakReference<CancellationGroup.Completable.Int>>(new WeakReference<CancellationGroup.Completable.Int>(value));
        return new IIntResultCallback.Stub(){

            @Override
            public void onResult(int result) {
                CancellationGroup.Completable.Int value = (CancellationGroup.Completable.Int)ResultCallbacks.unwrap(atomicRef);
                if (value == null) {
                    return;
                }
                value.onComplete(result);
            }
        };
    }

    public static ICharSequenceResultCallback.Stub of(CancellationGroup.Completable.CharSequence value) {
        final AtomicReference<WeakReference<CancellationGroup.Completable.CharSequence>> atomicRef = new AtomicReference<WeakReference<CancellationGroup.Completable.CharSequence>>(new WeakReference<CancellationGroup.Completable.CharSequence>(value));
        return new ICharSequenceResultCallback.Stub(){

            @Override
            public void onResult(CharSequence result) {
                CancellationGroup.Completable.CharSequence value = (CancellationGroup.Completable.CharSequence)ResultCallbacks.unwrap(atomicRef);
                if (value == null) {
                    return;
                }
                value.onComplete(result);
            }
        };
    }

    public static IExtractedTextResultCallback.Stub of(CancellationGroup.Completable.ExtractedText value) {
        final AtomicReference<WeakReference<CancellationGroup.Completable.ExtractedText>> atomicRef = new AtomicReference<WeakReference<CancellationGroup.Completable.ExtractedText>>(new WeakReference<CancellationGroup.Completable.ExtractedText>(value));
        return new IExtractedTextResultCallback.Stub(){

            @Override
            public void onResult(ExtractedText result) {
                CancellationGroup.Completable.ExtractedText value = (CancellationGroup.Completable.ExtractedText)ResultCallbacks.unwrap(atomicRef);
                if (value == null) {
                    return;
                }
                value.onComplete(result);
            }
        };
    }
}

