/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.PermissionChecker;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListController;
import com.android.internal.app.SimpleIconFactory;
import com.android.internal.app.chooser.DisplayResolveInfo;
import com.android.internal.app.chooser.TargetInfo;
import java.util.ArrayList;
import java.util.List;

public class ResolverListAdapter
extends BaseAdapter {
    private static final String TAG = "ResolverListAdapter";
    private final List<Intent> mIntents;
    private final Intent[] mInitialIntents;
    private final List<ResolveInfo> mBaseResolveList;
    private final PackageManager mPm;
    protected final Context mContext;
    private static ColorMatrixColorFilter sSuspendedMatrixColorFilter;
    private final int mIconDpi;
    protected ResolveInfo mLastChosen;
    private DisplayResolveInfo mOtherProfile;
    ResolverListController mResolverListController;
    private int mPlaceholderCount;
    protected final LayoutInflater mInflater;
    List<DisplayResolveInfo> mDisplayList;
    private List<ResolverActivity.ResolvedComponentInfo> mUnfilteredResolveList;
    private int mLastChosenPosition = -1;
    private boolean mFilterLastUsed;
    final ResolverListCommunicator mResolverListCommunicator;
    private Runnable mPostListReadyRunnable;
    private final boolean mIsAudioCaptureDevice;
    private boolean mIsTabLoaded;

    public ResolverListAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed, ResolverListController resolverListController, ResolverListCommunicator resolverListCommunicator, boolean isAudioCaptureDevice) {
        this.mContext = context;
        this.mIntents = payloadIntents;
        this.mInitialIntents = initialIntents;
        this.mBaseResolveList = rList;
        this.mInflater = LayoutInflater.from(context);
        this.mPm = context.getPackageManager();
        this.mDisplayList = new ArrayList<DisplayResolveInfo>();
        this.mFilterLastUsed = filterLastUsed;
        this.mResolverListController = resolverListController;
        this.mResolverListCommunicator = resolverListCommunicator;
        this.mIsAudioCaptureDevice = isAudioCaptureDevice;
        ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
        this.mIconDpi = am.getLauncherLargeIconDensity();
    }

    public void handlePackagesChanged() {
        this.mResolverListCommunicator.onHandlePackagesChanged(this);
    }

    public void setPlaceholderCount(int count) {
        this.mPlaceholderCount = count;
    }

    public int getPlaceholderCount() {
        return this.mPlaceholderCount;
    }

    public DisplayResolveInfo getFilteredItem() {
        if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
            return this.mDisplayList.get(this.mLastChosenPosition);
        }
        return null;
    }

    public DisplayResolveInfo getOtherProfile() {
        return this.mOtherProfile;
    }

    public int getFilteredPosition() {
        if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
            return this.mLastChosenPosition;
        }
        return -1;
    }

    public boolean hasFilteredItem() {
        return this.mFilterLastUsed && this.mLastChosen != null;
    }

    public float getScore(DisplayResolveInfo target) {
        return this.mResolverListController.getScore(target);
    }

    public float getScore(ComponentName componentName) {
        return this.mResolverListController.getScore(componentName);
    }

    public List<ComponentName> getTopComponentNames(int topK) {
        return this.mResolverListController.getTopComponentNames(topK);
    }

    public void updateModel(ComponentName componentName) {
        this.mResolverListController.updateModel(componentName);
    }

    public void updateChooserCounts(String packageName, String action) {
        this.mResolverListController.updateChooserCounts(packageName, this.getUserHandle().getIdentifier(), action);
    }

    List<ResolverActivity.ResolvedComponentInfo> getUnfilteredResolveList() {
        return this.mUnfilteredResolveList;
    }

    protected boolean rebuildList(boolean doPostProcessing) {
        int n;
        List<ResolverActivity.ResolvedComponentInfo> currentResolveList = null;
        this.mOtherProfile = null;
        this.mLastChosen = null;
        this.mLastChosenPosition = -1;
        this.mDisplayList.clear();
        this.mIsTabLoaded = false;
        if (this.mBaseResolveList != null) {
            this.mUnfilteredResolveList = new ArrayList<ResolverActivity.ResolvedComponentInfo>();
            currentResolveList = this.mUnfilteredResolveList;
            this.mResolverListController.addResolveListDedupe(currentResolveList, this.mResolverListCommunicator.getTargetIntent(), this.mBaseResolveList);
        } else {
            this.mUnfilteredResolveList = this.mResolverListController.getResolversForIntent(true, this.mResolverListCommunicator.shouldGetActivityMetadata(), this.mIntents);
            currentResolveList = this.mUnfilteredResolveList;
            if (currentResolveList == null) {
                this.processSortedList(currentResolveList, doPostProcessing);
                return true;
            }
            ArrayList<ResolverActivity.ResolvedComponentInfo> originalList = this.mResolverListController.filterIneligibleActivities(currentResolveList, true);
            if (originalList != null) {
                this.mUnfilteredResolveList = originalList;
            }
        }
        for (ResolverActivity.ResolvedComponentInfo info : currentResolveList) {
            ResolveInfo resolveInfo = info.getResolveInfoAt(0);
            if (resolveInfo.targetUserId == -2) continue;
            Intent pOrigIntent = this.mResolverListCommunicator.getReplacementIntent(resolveInfo.activityInfo, info.getIntentAt(0));
            Intent replacementIntent = this.mResolverListCommunicator.getReplacementIntent(resolveInfo.activityInfo, this.mResolverListCommunicator.getTargetIntent());
            this.mOtherProfile = new DisplayResolveInfo(info.getIntentAt(0), resolveInfo, resolveInfo.loadLabel(this.mPm), resolveInfo.loadLabel(this.mPm), pOrigIntent != null ? pOrigIntent : replacementIntent, this.makePresentationGetter(resolveInfo));
            currentResolveList.remove(info);
            break;
        }
        if (this.mOtherProfile == null) {
            try {
                this.mLastChosen = this.mResolverListController.getLastChosen();
            }
            catch (RemoteException re) {
                Log.d(TAG, "Error calling getLastChosenActivity\n" + re);
            }
        }
        this.setPlaceholderCount(0);
        if (currentResolveList != null && (n = currentResolveList.size()) > 0) {
            ArrayList<ResolverActivity.ResolvedComponentInfo> originalList = this.mResolverListController.filterLowPriority(currentResolveList, this.mUnfilteredResolveList == currentResolveList);
            if (originalList != null) {
                this.mUnfilteredResolveList = originalList;
            }
            if (currentResolveList.size() > 1) {
                int placeholderCount = currentResolveList.size();
                if (this.mResolverListCommunicator.useLayoutWithDefault()) {
                    --placeholderCount;
                }
                this.setPlaceholderCount(placeholderCount);
                this.createSortingTask(doPostProcessing).execute(currentResolveList);
                this.postListReadyRunnable(doPostProcessing, false);
                return false;
            }
            this.processSortedList(currentResolveList, doPostProcessing);
            return true;
        }
        this.processSortedList(currentResolveList, doPostProcessing);
        return true;
    }

    AsyncTask<List<ResolverActivity.ResolvedComponentInfo>, Void, List<ResolverActivity.ResolvedComponentInfo>> createSortingTask(final boolean doPostProcessing) {
        return new AsyncTask<List<ResolverActivity.ResolvedComponentInfo>, Void, List<ResolverActivity.ResolvedComponentInfo>>(){

            protected List<ResolverActivity.ResolvedComponentInfo> doInBackground(List<ResolverActivity.ResolvedComponentInfo> ... params) {
                ResolverListAdapter.this.mResolverListController.sort(params[0]);
                return params[0];
            }

            @Override
            protected void onPostExecute(List<ResolverActivity.ResolvedComponentInfo> sortedComponents) {
                ResolverListAdapter.this.processSortedList(sortedComponents, doPostProcessing);
                ResolverListAdapter.this.notifyDataSetChanged();
                if (doPostProcessing) {
                    ResolverListAdapter.this.mResolverListCommunicator.updateProfileViewButton();
                }
            }
        };
    }

    protected void processSortedList(List<ResolverActivity.ResolvedComponentInfo> sortedComponents, boolean doPostProcessing) {
        int n;
        if (sortedComponents != null && (n = sortedComponents.size()) != 0) {
            if (this.mInitialIntents != null) {
                for (int i = 0; i < this.mInitialIntents.length; ++i) {
                    Intent ii = this.mInitialIntents[i];
                    if (ii == null) continue;
                    ActivityInfo ai = ii.resolveActivityInfo(this.mPm, 0);
                    if (ai == null) {
                        Log.w(TAG, "No activity found for " + ii);
                        continue;
                    }
                    ResolveInfo ri = new ResolveInfo();
                    ri.activityInfo = ai;
                    UserManager userManager = (UserManager)this.mContext.getSystemService("user");
                    if (ii instanceof LabeledIntent) {
                        LabeledIntent li = (LabeledIntent)ii;
                        ri.resolvePackageName = li.getSourcePackage();
                        ri.labelRes = li.getLabelResource();
                        ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                        ri.iconResourceId = ri.icon = li.getIconResource();
                    }
                    if (userManager.isManagedProfile()) {
                        ri.noResourceId = true;
                        ri.icon = 0;
                    }
                    this.addResolveInfo(new DisplayResolveInfo(ii, ri, ri.loadLabel(this.mPm), null, ii, this.makePresentationGetter(ri)));
                }
            }
            for (ResolverActivity.ResolvedComponentInfo rci : sortedComponents) {
                ResolveInfo ri = rci.getResolveInfoAt(0);
                if (ri == null) continue;
                this.addResolveInfoWithAlternates(rci);
            }
        }
        this.mResolverListCommunicator.sendVoiceChoicesIfNeeded();
        this.postListReadyRunnable(doPostProcessing, true);
        this.mIsTabLoaded = true;
    }

    void postListReadyRunnable(final boolean doPostProcessing, final boolean rebuildCompleted) {
        if (this.mPostListReadyRunnable == null) {
            this.mPostListReadyRunnable = new Runnable(){

                @Override
                public void run() {
                    ResolverListAdapter.this.mResolverListCommunicator.onPostListReady(ResolverListAdapter.this, doPostProcessing, rebuildCompleted);
                    ResolverListAdapter.this.mPostListReadyRunnable = null;
                }
            };
            this.mContext.getMainThreadHandler().post(this.mPostListReadyRunnable);
        }
    }

    private void addResolveInfoWithAlternates(ResolverActivity.ResolvedComponentInfo rci) {
        int count = rci.getCount();
        Intent intent = rci.getIntentAt(0);
        ResolveInfo add = rci.getResolveInfoAt(0);
        Intent replaceIntent = this.mResolverListCommunicator.getReplacementIntent(add.activityInfo, intent);
        Intent defaultIntent = this.mResolverListCommunicator.getReplacementIntent(add.activityInfo, this.mResolverListCommunicator.getTargetIntent());
        DisplayResolveInfo dri = new DisplayResolveInfo(intent, add, replaceIntent != null ? replaceIntent : defaultIntent, this.makePresentationGetter(add));
        dri.setPinned(rci.isPinned());
        if (rci.isPinned()) {
            Log.i(TAG, "Pinned item: " + rci.name);
        }
        this.addResolveInfo(dri);
        if (replaceIntent == intent) {
            int n = count;
            for (int i = 1; i < n; ++i) {
                Intent altIntent = rci.getIntentAt(i);
                dri.addAlternateSourceIntent(altIntent);
            }
        }
        this.updateLastChosenPosition(add);
    }

    private void updateLastChosenPosition(ResolveInfo info) {
        if (this.mOtherProfile != null) {
            this.mLastChosenPosition = -1;
            return;
        }
        if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(info.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(info.activityInfo.name)) {
            this.mLastChosenPosition = this.mDisplayList.size() - 1;
        }
    }

    private void addResolveInfo(DisplayResolveInfo dri) {
        if (dri != null && dri.getResolveInfo() != null && dri.getResolveInfo().targetUserId == -2 && this.shouldAddResolveInfo(dri)) {
            this.mDisplayList.add(dri);
            Log.i(TAG, "Add DisplayResolveInfo component: " + dri.getResolvedComponentName() + ", intent component: " + dri.getResolvedIntent().getComponent());
        }
    }

    protected boolean shouldAddResolveInfo(DisplayResolveInfo dri) {
        for (DisplayResolveInfo existingInfo : this.mDisplayList) {
            if (!this.mResolverListCommunicator.resolveInfoMatch(dri.getResolveInfo(), existingInfo.getResolveInfo())) continue;
            return false;
        }
        return true;
    }

    public ResolveInfo resolveInfoForPosition(int position, boolean filtered) {
        TargetInfo target = this.targetInfoForPosition(position, filtered);
        if (target != null) {
            return target.getResolveInfo();
        }
        return null;
    }

    public TargetInfo targetInfoForPosition(int position, boolean filtered) {
        if (filtered) {
            return this.getItem(position);
        }
        if (this.mDisplayList.size() > position) {
            return this.mDisplayList.get(position);
        }
        return null;
    }

    @Override
    public int getCount() {
        int totalSize;
        int n = totalSize = this.mDisplayList == null || this.mDisplayList.isEmpty() ? this.mPlaceholderCount : this.mDisplayList.size();
        if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
            --totalSize;
        }
        return totalSize;
    }

    public int getUnfilteredCount() {
        return this.mDisplayList.size();
    }

    @Override
    public TargetInfo getItem(int position) {
        if (this.mFilterLastUsed && this.mLastChosenPosition >= 0 && position >= this.mLastChosenPosition) {
            ++position;
        }
        if (this.mDisplayList.size() > position) {
            return this.mDisplayList.get(position);
        }
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public int getDisplayResolveInfoCount() {
        return this.mDisplayList.size();
    }

    public DisplayResolveInfo getDisplayResolveInfo(int index) {
        return this.mDisplayList.get(index);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View view = convertView;
        if (view == null) {
            view = this.createView(parent);
        }
        this.onBindView(view, this.getItem(position), position);
        return view;
    }

    public View createView(ViewGroup parent) {
        View view = this.onCreateView(parent);
        ViewHolder holder = new ViewHolder(view);
        view.setTag(holder);
        return view;
    }

    View onCreateView(ViewGroup parent) {
        return this.mInflater.inflate(17367271, parent, false);
    }

    public void bindView(int position, View view) {
        this.onBindView(view, this.getItem(position), position);
    }

    protected void onBindView(View view, TargetInfo info, int position) {
        ViewHolder holder = (ViewHolder)view.getTag();
        if (info == null) {
            holder.icon.setImageDrawable(this.mContext.getDrawable(17303409));
            return;
        }
        if (info instanceof DisplayResolveInfo && !((DisplayResolveInfo)info).hasDisplayLabel()) {
            this.getLoadLabelTask((DisplayResolveInfo)info, holder).execute(new Void[0]);
        } else {
            holder.bindLabel(info.getDisplayLabel(), info.getExtendedInfo(), this.alwaysShowSubLabel());
        }
        if (info instanceof DisplayResolveInfo && !((DisplayResolveInfo)info).hasDisplayIcon()) {
            new LoadIconTask((DisplayResolveInfo)info, holder).execute(new Void[0]);
        } else {
            holder.bindIcon(info);
        }
    }

    protected LoadLabelTask getLoadLabelTask(DisplayResolveInfo info, ViewHolder holder) {
        return new LoadLabelTask(info, holder);
    }

    public void onDestroy() {
        if (this.mPostListReadyRunnable != null) {
            this.mContext.getMainThreadHandler().removeCallbacks(this.mPostListReadyRunnable);
            this.mPostListReadyRunnable = null;
        }
        if (this.mResolverListController != null) {
            this.mResolverListController.destroy();
        }
    }

    private static ColorMatrixColorFilter getSuspendedColorMatrix() {
        if (sSuspendedMatrixColorFilter == null) {
            int grayValue = 127;
            float scale = 0.5f;
            ColorMatrix tempBrightnessMatrix = new ColorMatrix();
            float[] mat = tempBrightnessMatrix.getArray();
            mat[0] = scale;
            mat[6] = scale;
            mat[12] = scale;
            mat[4] = grayValue;
            mat[9] = grayValue;
            mat[14] = grayValue;
            ColorMatrix matrix = new ColorMatrix();
            matrix.setSaturation(0.0f);
            matrix.preConcat(tempBrightnessMatrix);
            sSuspendedMatrixColorFilter = new ColorMatrixColorFilter(matrix);
        }
        return sSuspendedMatrixColorFilter;
    }

    ActivityInfoPresentationGetter makePresentationGetter(ActivityInfo ai) {
        return new ActivityInfoPresentationGetter(this.mContext, this.mIconDpi, ai);
    }

    ResolveInfoPresentationGetter makePresentationGetter(ResolveInfo ri) {
        return new ResolveInfoPresentationGetter(this.mContext, this.mIconDpi, ri);
    }

    Drawable loadIconForResolveInfo(ResolveInfo ri) {
        return this.makePresentationGetter(ri).getIcon(this.getUserHandle());
    }

    void loadFilteredItemIconTaskAsync(final ImageView iconView) {
        final DisplayResolveInfo iconInfo = this.getFilteredItem();
        if (iconView != null && iconInfo != null) {
            new AsyncTask<Void, Void, Drawable>(){

                protected Drawable doInBackground(Void ... params) {
                    return ResolverListAdapter.this.loadIconForResolveInfo(iconInfo.getResolveInfo());
                }

                @Override
                protected void onPostExecute(Drawable d) {
                    iconView.setImageDrawable(d);
                }
            }.execute(new Void[0]);
        }
    }

    @VisibleForTesting
    public UserHandle getUserHandle() {
        return this.mResolverListController.getUserHandle();
    }

    protected List<ResolverActivity.ResolvedComponentInfo> getResolversForUser(UserHandle userHandle) {
        return this.mResolverListController.getResolversForIntentAsUser(true, this.mResolverListCommunicator.shouldGetActivityMetadata(), this.mIntents, userHandle);
    }

    protected List<Intent> getIntents() {
        return this.mIntents;
    }

    protected boolean isTabLoaded() {
        return this.mIsTabLoaded;
    }

    protected void markTabLoaded() {
        this.mIsTabLoaded = true;
    }

    protected boolean alwaysShowSubLabel() {
        return false;
    }

    private static abstract class TargetPresentationGetter {
        private Context mCtx;
        private final int mIconDpi;
        private final boolean mHasSubstitutePermission;
        private final ApplicationInfo mAi;
        protected PackageManager mPm;

        abstract Drawable getIconSubstituteInternal();

        abstract String getAppSubLabelInternal();

        TargetPresentationGetter(Context ctx, int iconDpi, ApplicationInfo ai) {
            this.mCtx = ctx;
            this.mPm = ctx.getPackageManager();
            this.mAi = ai;
            this.mIconDpi = iconDpi;
            this.mHasSubstitutePermission = 0 == this.mPm.checkPermission("android.permission.SUBSTITUTE_SHARE_TARGET_APP_NAME_AND_ICON", this.mAi.packageName);
        }

        public Drawable getIcon(UserHandle userHandle) {
            return new BitmapDrawable(this.mCtx.getResources(), this.getIconBitmap(userHandle));
        }

        public Bitmap getIconBitmap(UserHandle userHandle) {
            Drawable dr = null;
            if (this.mHasSubstitutePermission) {
                dr = this.getIconSubstituteInternal();
            }
            if (dr == null) {
                try {
                    if (this.mAi.icon != 0) {
                        dr = this.loadIconFromResource(this.mPm.getResourcesForApplication(this.mAi), this.mAi.icon);
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if (dr == null) {
                dr = this.mAi.loadIcon(this.mPm);
            }
            SimpleIconFactory sif = SimpleIconFactory.obtain(this.mCtx);
            Bitmap icon = sif.createUserBadgedIconBitmap(dr, userHandle);
            sif.recycle();
            return icon;
        }

        public String getLabel() {
            String label = null;
            if (this.mHasSubstitutePermission) {
                label = this.getAppSubLabelInternal();
            }
            if (label == null) {
                label = (String)this.mAi.loadLabel(this.mPm);
            }
            return label;
        }

        public String getSubLabel() {
            if (this.mHasSubstitutePermission) {
                return null;
            }
            return this.getAppSubLabelInternal();
        }

        protected String loadLabelFromResource(Resources res, int resId) {
            return res.getString(resId);
        }

        protected Drawable loadIconFromResource(Resources res, int resId) {
            return res.getDrawableForDensity(resId, this.mIconDpi);
        }
    }

    @VisibleForTesting
    public static class ActivityInfoPresentationGetter
    extends TargetPresentationGetter {
        private final ActivityInfo mActivityInfo;

        public ActivityInfoPresentationGetter(Context ctx, int iconDpi, ActivityInfo activityInfo) {
            super(ctx, iconDpi, activityInfo.applicationInfo);
            this.mActivityInfo = activityInfo;
        }

        @Override
        Drawable getIconSubstituteInternal() {
            Drawable dr = null;
            try {
                if (this.mActivityInfo.icon != 0) {
                    dr = this.loadIconFromResource(this.mPm.getResourcesForApplication(this.mActivityInfo.applicationInfo), this.mActivityInfo.icon);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(ResolverListAdapter.TAG, "SUBSTITUTE_SHARE_TARGET_APP_NAME_AND_ICON permission granted but couldn't find resources for package", e);
            }
            return dr;
        }

        @Override
        String getAppSubLabelInternal() {
            return (String)this.mActivityInfo.loadLabel(this.mPm);
        }
    }

    @VisibleForTesting
    public static class ResolveInfoPresentationGetter
    extends ActivityInfoPresentationGetter {
        private final ResolveInfo mRi;

        public ResolveInfoPresentationGetter(Context ctx, int iconDpi, ResolveInfo ri) {
            super(ctx, iconDpi, ri.activityInfo);
            this.mRi = ri;
        }

        @Override
        Drawable getIconSubstituteInternal() {
            Drawable dr = null;
            try {
                if (this.mRi.resolvePackageName != null && this.mRi.icon != 0) {
                    dr = this.loadIconFromResource(this.mPm.getResourcesForApplication(this.mRi.resolvePackageName), this.mRi.icon);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(ResolverListAdapter.TAG, "SUBSTITUTE_SHARE_TARGET_APP_NAME_AND_ICON permission granted but couldn't find resources for package", e);
            }
            if (dr == null) {
                dr = super.getIconSubstituteInternal();
            }
            return dr;
        }

        @Override
        String getAppSubLabelInternal() {
            return (String)this.mRi.loadLabel(this.mPm);
        }
    }

    class LoadIconTask
    extends AsyncTask<Void, Void, Drawable> {
        protected final DisplayResolveInfo mDisplayResolveInfo;
        private final ResolveInfo mResolveInfo;
        private ViewHolder mHolder;

        LoadIconTask(DisplayResolveInfo dri, ViewHolder holder) {
            this.mDisplayResolveInfo = dri;
            this.mResolveInfo = dri.getResolveInfo();
            this.mHolder = holder;
        }

        protected Drawable doInBackground(Void ... params) {
            return ResolverListAdapter.this.loadIconForResolveInfo(this.mResolveInfo);
        }

        @Override
        protected void onPostExecute(Drawable d) {
            if (ResolverListAdapter.this.getOtherProfile() == this.mDisplayResolveInfo) {
                ResolverListAdapter.this.mResolverListCommunicator.updateProfileViewButton();
            } else {
                this.mDisplayResolveInfo.setDisplayIcon(d);
                this.mHolder.bindIcon(this.mDisplayResolveInfo);
            }
        }

        public void setViewHolder(ViewHolder holder) {
            this.mHolder = holder;
            this.mHolder.bindIcon(this.mDisplayResolveInfo);
        }
    }

    protected class LoadLabelTask
    extends AsyncTask<Void, Void, CharSequence[]> {
        private final DisplayResolveInfo mDisplayResolveInfo;
        private final ViewHolder mHolder;

        protected LoadLabelTask(DisplayResolveInfo dri, ViewHolder holder) {
            this.mDisplayResolveInfo = dri;
            this.mHolder = holder;
        }

        protected CharSequence[] doInBackground(Void ... voids) {
            ResolveInfoPresentationGetter pg = ResolverListAdapter.this.makePresentationGetter(this.mDisplayResolveInfo.getResolveInfo());
            if (ResolverListAdapter.this.mIsAudioCaptureDevice) {
                boolean hasRecordPermission;
                ActivityInfo activityInfo = this.mDisplayResolveInfo.getResolveInfo().activityInfo;
                int uid = activityInfo.applicationInfo.uid;
                String packageName = activityInfo.packageName;
                boolean bl = hasRecordPermission = PermissionChecker.checkPermissionForPreflight(ResolverListAdapter.this.mContext, "android.permission.RECORD_AUDIO", -1, uid, packageName) == 0;
                if (!hasRecordPermission) {
                    return new CharSequence[]{pg.getLabel(), ResolverListAdapter.this.mContext.getString(17041418)};
                }
            }
            return new CharSequence[]{pg.getLabel(), pg.getSubLabel()};
        }

        @Override
        protected void onPostExecute(CharSequence[] result) {
            this.mDisplayResolveInfo.setDisplayLabel(result[0]);
            this.mDisplayResolveInfo.setExtendedInfo(result[1]);
            this.mHolder.bindLabel(result[0], result[1], ResolverListAdapter.this.alwaysShowSubLabel());
        }
    }

    static class ViewHolder {
        public View itemView;
        public Drawable defaultItemViewBackground;
        public TextView text;
        public TextView text2;
        public ImageView icon;

        ViewHolder(View view) {
            this.itemView = view;
            this.defaultItemViewBackground = view.getBackground();
            this.text = (TextView)view.findViewById(16908308);
            this.text2 = (TextView)view.findViewById(16908309);
            this.icon = (ImageView)view.findViewById(16908294);
        }

        public void bindLabel(CharSequence label, CharSequence subLabel, boolean showSubLabel) {
            this.text.setText(label);
            if (TextUtils.equals(label, subLabel)) {
                subLabel = null;
            }
            this.text2.setText(subLabel);
            if (showSubLabel || subLabel != null) {
                this.text2.setVisibility(0);
            } else {
                this.text2.setVisibility(8);
            }
            this.itemView.setContentDescription(null);
        }

        public void updateContentDescription(String description) {
            this.itemView.setContentDescription(description);
        }

        public void bindIcon(TargetInfo info) {
            this.icon.setImageDrawable(info.getDisplayIcon(this.itemView.getContext()));
            if (info.isSuspended()) {
                this.icon.setColorFilter(ResolverListAdapter.getSuspendedColorMatrix());
            } else {
                this.icon.setColorFilter(null);
            }
        }
    }

    static interface ResolverListCommunicator {
        public boolean resolveInfoMatch(ResolveInfo var1, ResolveInfo var2);

        public Intent getReplacementIntent(ActivityInfo var1, Intent var2);

        public void onPostListReady(ResolverListAdapter var1, boolean var2, boolean var3);

        public void sendVoiceChoicesIfNeeded();

        public void updateProfileViewButton();

        public boolean useLayoutWithDefault();

        public boolean shouldGetActivityMetadata();

        public Intent getTargetIntent();

        public void onHandlePackagesChanged(ResolverListAdapter var1);
    }
}

