/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.window.ITaskOrganizer;
import android.window.WindowContainerToken;
import java.util.ArrayList;
import java.util.List;

public interface ITaskOrganizerController
extends IInterface {
    public void registerTaskOrganizer(ITaskOrganizer var1, int var2) throws RemoteException;

    public void unregisterTaskOrganizer(ITaskOrganizer var1) throws RemoteException;

    public ActivityManager.RunningTaskInfo createRootTask(int var1, int var2) throws RemoteException;

    public boolean deleteRootTask(WindowContainerToken var1) throws RemoteException;

    public List<ActivityManager.RunningTaskInfo> getChildTasks(WindowContainerToken var1, int[] var2) throws RemoteException;

    public List<ActivityManager.RunningTaskInfo> getRootTasks(int var1, int[] var2) throws RemoteException;

    public WindowContainerToken getImeTarget(int var1) throws RemoteException;

    public void setLaunchRoot(int var1, WindowContainerToken var2) throws RemoteException;

    public void setInterceptBackPressedOnTaskRoot(ITaskOrganizer var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskOrganizerController {
        private static final String DESCRIPTOR = "android.window.ITaskOrganizerController";
        static final int TRANSACTION_registerTaskOrganizer = 1;
        static final int TRANSACTION_unregisterTaskOrganizer = 2;
        static final int TRANSACTION_createRootTask = 3;
        static final int TRANSACTION_deleteRootTask = 4;
        static final int TRANSACTION_getChildTasks = 5;
        static final int TRANSACTION_getRootTasks = 6;
        static final int TRANSACTION_getImeTarget = 7;
        static final int TRANSACTION_setLaunchRoot = 8;
        static final int TRANSACTION_setInterceptBackPressedOnTaskRoot = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITaskOrganizerController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITaskOrganizerController) {
                return (ITaskOrganizerController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerTaskOrganizer";
                }
                case 2: {
                    return "unregisterTaskOrganizer";
                }
                case 3: {
                    return "createRootTask";
                }
                case 4: {
                    return "deleteRootTask";
                }
                case 5: {
                    return "getChildTasks";
                }
                case 6: {
                    return "getRootTasks";
                }
                case 7: {
                    return "getImeTarget";
                }
                case 8: {
                    return "setLaunchRoot";
                }
                case 9: {
                    return "setInterceptBackPressedOnTaskRoot";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    ITaskOrganizer _arg0 = ITaskOrganizer.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.registerTaskOrganizer(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ITaskOrganizer _arg0 = ITaskOrganizer.Stub.asInterface(data.readStrongBinder());
                    this.unregisterTaskOrganizer(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ActivityManager.RunningTaskInfo _result = this.createRootTask(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    WindowContainerToken _arg0 = 0 != data.readInt() ? WindowContainerToken.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.deleteRootTask(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    WindowContainerToken _arg0 = 0 != data.readInt() ? WindowContainerToken.CREATOR.createFromParcel(data) : null;
                    int[] _arg1 = data.createIntArray();
                    List<ActivityManager.RunningTaskInfo> _result = this.getChildTasks(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    List<ActivityManager.RunningTaskInfo> _result = this.getRootTasks(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    WindowContainerToken _result = this.getImeTarget(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    WindowContainerToken _arg1 = 0 != data.readInt() ? WindowContainerToken.CREATOR.createFromParcel(data) : null;
                    this.setLaunchRoot(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    ITaskOrganizer _arg0 = ITaskOrganizer.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = 0 != data.readInt();
                    this.setInterceptBackPressedOnTaskRoot(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITaskOrganizerController impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITaskOrganizerController getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITaskOrganizerController {
            private IBinder mRemote;
            public static ITaskOrganizerController sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTaskOrganizer(ITaskOrganizer organizer, int windowingMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(organizer != null ? organizer.asBinder() : null);
                    _data.writeInt(windowingMode);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerTaskOrganizer(organizer, windowingMode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTaskOrganizer(ITaskOrganizer organizer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(organizer != null ? organizer.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterTaskOrganizer(organizer);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ActivityManager.RunningTaskInfo createRootTask(int displayId, int windowingMode) throws RemoteException {
                ActivityManager.RunningTaskInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(windowingMode);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ActivityManager.RunningTaskInfo runningTaskInfo = Stub.getDefaultImpl().createRootTask(displayId, windowingMode);
                        return runningTaskInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ActivityManager.RunningTaskInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean deleteRootTask(WindowContainerToken task) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (task != null) {
                        _data.writeInt(1);
                        task.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().deleteRootTask(task);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ActivityManager.RunningTaskInfo> getChildTasks(WindowContainerToken parent, int[] activityTypes) throws RemoteException {
                ArrayList<ActivityManager.RunningTaskInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (parent != null) {
                        _data.writeInt(1);
                        parent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeIntArray(activityTypes);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<ActivityManager.RunningTaskInfo> list = Stub.getDefaultImpl().getChildTasks(parent, activityTypes);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ActivityManager.RunningTaskInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ActivityManager.RunningTaskInfo> getRootTasks(int displayId, int[] activityTypes) throws RemoteException {
                ArrayList<ActivityManager.RunningTaskInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeIntArray(activityTypes);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<ActivityManager.RunningTaskInfo> list = Stub.getDefaultImpl().getRootTasks(displayId, activityTypes);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ActivityManager.RunningTaskInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowContainerToken getImeTarget(int display) throws RemoteException {
                WindowContainerToken _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(display);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WindowContainerToken windowContainerToken = Stub.getDefaultImpl().getImeTarget(display);
                        return windowContainerToken;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WindowContainerToken.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLaunchRoot(int displayId, WindowContainerToken root) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    if (root != null) {
                        _data.writeInt(1);
                        root.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLaunchRoot(displayId, root);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInterceptBackPressedOnTaskRoot(ITaskOrganizer organizer, boolean interceptBackPressed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(organizer != null ? organizer.asBinder() : null);
                    _data.writeInt(interceptBackPressed ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setInterceptBackPressedOnTaskRoot(organizer, interceptBackPressed);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITaskOrganizerController {
        @Override
        public void registerTaskOrganizer(ITaskOrganizer organizer, int windowingMode) throws RemoteException {
        }

        @Override
        public void unregisterTaskOrganizer(ITaskOrganizer organizer) throws RemoteException {
        }

        @Override
        public ActivityManager.RunningTaskInfo createRootTask(int displayId, int windowingMode) throws RemoteException {
            return null;
        }

        @Override
        public boolean deleteRootTask(WindowContainerToken task) throws RemoteException {
            return false;
        }

        @Override
        public List<ActivityManager.RunningTaskInfo> getChildTasks(WindowContainerToken parent, int[] activityTypes) throws RemoteException {
            return null;
        }

        @Override
        public List<ActivityManager.RunningTaskInfo> getRootTasks(int displayId, int[] activityTypes) throws RemoteException {
            return null;
        }

        @Override
        public WindowContainerToken getImeTarget(int display) throws RemoteException {
            return null;
        }

        @Override
        public void setLaunchRoot(int displayId, WindowContainerToken root) throws RemoteException {
        }

        @Override
        public void setInterceptBackPressedOnTaskRoot(ITaskOrganizer organizer, boolean interceptBackPressed) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

