/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.app.RemoteAction;
import android.content.Intent;
import android.os.Bundle;
import android.view.textclassifier.TextClassification;
import java.util.ArrayList;

public class ExtrasUtils {
    private static final String ACTION_INTENT = "action-intent";
    private static final String ACTIONS_INTENTS = "actions-intents";
    private static final String FOREIGN_LANGUAGE = "foreign-language";
    private static final String ENTITY_TYPE = "entity-type";
    private static final String SCORE = "score";
    private static final String MODEL_NAME = "model-name";

    private ExtrasUtils() {
    }

    public static Bundle getForeignLanguageExtra(TextClassification classification) {
        if (classification == null) {
            return null;
        }
        return classification.getExtras().getBundle(FOREIGN_LANGUAGE);
    }

    public static Intent getActionIntent(Bundle container) {
        return (Intent)container.getParcelable(ACTION_INTENT);
    }

    public static ArrayList<Intent> getActionsIntents(TextClassification classification) {
        if (classification == null) {
            return null;
        }
        return classification.getExtras().getParcelableArrayList(ACTIONS_INTENTS);
    }

    private static RemoteAction findAction(TextClassification classification, String intentAction) {
        if (classification == null || intentAction == null) {
            return null;
        }
        ArrayList<Intent> actionIntents = ExtrasUtils.getActionsIntents(classification);
        if (actionIntents != null) {
            int size = actionIntents.size();
            for (int i = 0; i < size; ++i) {
                Intent intent = actionIntents.get(i);
                if (intent == null || !intentAction.equals(intent.getAction())) continue;
                return classification.getActions().get(i);
            }
        }
        return null;
    }

    public static RemoteAction findTranslateAction(TextClassification classification) {
        return ExtrasUtils.findAction(classification, "android.intent.action.TRANSLATE");
    }

    public static String getEntityType(Bundle extra) {
        if (extra == null) {
            return null;
        }
        return extra.getString(ENTITY_TYPE);
    }

    public static float getScore(Bundle extra) {
        int defaultValue = -1;
        if (extra == null) {
            return -1.0f;
        }
        return extra.getFloat(SCORE, -1.0f);
    }

    public static String getModelName(Bundle extra) {
        if (extra == null) {
            return null;
        }
        return extra.getString(MODEL_NAME);
    }
}

