/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.animation.HasNativeInterpolator;
import android.graphics.animation.NativeInterpolator;
import android.graphics.animation.NativeInterpolatorFactory;
import android.util.AttributeSet;
import android.util.PathParser;
import android.view.InflateException;
import android.view.animation.BaseInterpolator;
import com.android.internal.R;

@HasNativeInterpolator
public class PathInterpolator
extends BaseInterpolator
implements NativeInterpolator {
    private static final float PRECISION = 0.002f;
    private float[] mX;
    private float[] mY;

    public PathInterpolator(Path path) {
        this.initPath(path);
    }

    public PathInterpolator(float controlX, float controlY) {
        this.initQuad(controlX, controlY);
    }

    public PathInterpolator(float controlX1, float controlY1, float controlX2, float controlY2) {
        this.initCubic(controlX1, controlY1, controlX2, controlY2);
    }

    public PathInterpolator(Context context, AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    public PathInterpolator(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.PathInterpolator, 0, 0) : res.obtainAttributes(attrs, R.styleable.PathInterpolator);
        this.parseInterpolatorFromTypeArray(a);
        this.setChangingConfiguration(a.getChangingConfigurations());
        a.recycle();
    }

    private void parseInterpolatorFromTypeArray(TypedArray a) {
        if (a.hasValue(4)) {
            String pathData = a.getString(4);
            Path path = PathParser.createPathFromPathData(pathData);
            if (path == null) {
                throw new InflateException("The path is null, which is created from " + pathData);
            }
            this.initPath(path);
        } else {
            boolean hasY2;
            if (!a.hasValue(0)) {
                throw new InflateException("pathInterpolator requires the controlX1 attribute");
            }
            if (!a.hasValue(1)) {
                throw new InflateException("pathInterpolator requires the controlY1 attribute");
            }
            float x1 = a.getFloat(0, 0.0f);
            float y1 = a.getFloat(1, 0.0f);
            boolean hasX2 = a.hasValue(2);
            if (hasX2 != (hasY2 = a.hasValue(3))) {
                throw new InflateException("pathInterpolator requires both controlX2 and controlY2 for cubic Beziers.");
            }
            if (!hasX2) {
                this.initQuad(x1, y1);
            } else {
                float x2 = a.getFloat(2, 0.0f);
                float y2 = a.getFloat(3, 0.0f);
                this.initCubic(x1, y1, x2, y2);
            }
        }
    }

    private void initQuad(float controlX, float controlY) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.quadTo(controlX, controlY, 1.0f, 1.0f);
        this.initPath(path);
    }

    private void initCubic(float x1, float y1, float x2, float y2) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.cubicTo(x1, y1, x2, y2, 1.0f, 1.0f);
        this.initPath(path);
    }

    private void initPath(Path path) {
        float[] pointComponents = path.approximate(0.002f);
        int numPoints = pointComponents.length / 3;
        if (pointComponents[1] != 0.0f || pointComponents[2] != 0.0f || pointComponents[pointComponents.length - 2] != 1.0f || pointComponents[pointComponents.length - 1] != 1.0f) {
            throw new IllegalArgumentException("The Path must start at (0,0) and end at (1,1)");
        }
        this.mX = new float[numPoints];
        this.mY = new float[numPoints];
        float prevX = 0.0f;
        float prevFraction = 0.0f;
        int componentIndex = 0;
        for (int i = 0; i < numPoints; ++i) {
            float fraction2 = pointComponents[componentIndex++];
            float x = pointComponents[componentIndex++];
            float y = pointComponents[componentIndex++];
            if (fraction2 == prevFraction && x != prevX) {
                throw new IllegalArgumentException("The Path cannot have discontinuity in the X axis.");
            }
            if (x < prevX) {
                throw new IllegalArgumentException("The Path cannot loop back on itself.");
            }
            this.mX[i] = x;
            this.mY[i] = y;
            prevX = x;
            prevFraction = fraction2;
        }
    }

    @Override
    public float getInterpolation(float t) {
        if (t <= 0.0f) {
            return 0.0f;
        }
        if (t >= 1.0f) {
            return 1.0f;
        }
        int startIndex = 0;
        int endIndex = this.mX.length - 1;
        while (endIndex - startIndex > 1) {
            int midIndex = (startIndex + endIndex) / 2;
            if (t < this.mX[midIndex]) {
                endIndex = midIndex;
                continue;
            }
            startIndex = midIndex;
        }
        float xRange = this.mX[endIndex] - this.mX[startIndex];
        if (xRange == 0.0f) {
            return this.mY[startIndex];
        }
        float tInRange = t - this.mX[startIndex];
        float fraction2 = tInRange / xRange;
        float startY = this.mY[startIndex];
        float endY = this.mY[endIndex];
        return startY + fraction2 * (endY - startY);
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactory.createPathInterpolator(this.mX, this.mY);
    }
}

