/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.BridgeInflater;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutInflater_Delegate {
    private static final String TAG_MERGE = "merge";
    private static final String ATTR_LAYOUT = "layout";
    private static final int[] ATTRS_THEME = new int[]{0x1010000};
    public static boolean sIsInInclude = false;

    @LayoutlibDelegate
    static void rInflate(LayoutInflater thisInflater, XmlPullParser parser, View parent, Context context, AttributeSet attrs, boolean finishInflate) throws XmlPullParserException, IOException {
        if (!finishInflate && thisInflater instanceof BridgeInflater) {
            ((BridgeInflater)thisInflater).setIsInMerge(true);
        }
        thisInflater.rInflate_Original(parser, parent, context, attrs, finishInflate);
        if (!finishInflate && thisInflater instanceof BridgeInflater) {
            ((BridgeInflater)thisInflater).setIsInMerge(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    public static void parseInclude(LayoutInflater thisInflater, XmlPullParser parser, Context context, View parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        if (parent instanceof ViewGroup) {
            String value;
            boolean hasThemeOverride;
            TypedArray ta = context.obtainStyledAttributes(attrs, ATTRS_THEME);
            int themeResId = ta.getResourceId(0, 0);
            boolean bl = hasThemeOverride = themeResId != 0;
            if (hasThemeOverride) {
                context = new ContextThemeWrapper(context, themeResId);
            }
            ta.recycle();
            int layout2 = attrs.getAttributeResourceValue(null, ATTR_LAYOUT, 0);
            if (layout2 == 0) {
                value = attrs.getAttributeValue(null, ATTR_LAYOUT);
                if (value == null || value.length() <= 0) {
                    Bridge.getLog().error("broken", "You must specify a layout in the include tag: <include layout=\"@layout/layoutID\" />", null, null);
                    LayoutInflater.consumeChildElements(parser);
                    return;
                }
                layout2 = context.getResources().getIdentifier(value.substring(1), null, null);
            }
            if (layout2 != 0) {
                TypedValue tempValue = new TypedValue();
                if (context.getTheme().resolveAttribute(layout2, tempValue, true)) {
                    layout2 = tempValue.resourceId;
                }
            }
            if (layout2 == 0) {
                value = attrs.getAttributeValue(null, ATTR_LAYOUT);
                if (value == null) {
                    Bridge.getLog().error("broken", "You must specify a layout in the include tag: <include layout=\"@layout/layoutID\" />", null, null);
                } else {
                    Bridge.getLog().error("broken", "You must specify a valid layout reference. The layout ID " + value + " is not valid.", null, null);
                }
            } else {
                try (XmlResourceParser childParser = thisInflater.getContext().getResources().getLayout(layout2);){
                    int type;
                    AttributeSet childAttrs = Xml.asAttributeSet(childParser);
                    while ((type = childParser.next()) != 2 && type != 1) {
                    }
                    if (type != 2) {
                        Bridge.getLog().error("broken", childParser.getPositionDescription() + ": No start tag found!", null, null);
                        LayoutInflater.consumeChildElements(parser);
                        return;
                    }
                    String childName = childParser.getName();
                    if (TAG_MERGE.equals(childName)) {
                        thisInflater.rInflate(childParser, parent, context, childAttrs, false);
                    }
                    View view = thisInflater.createViewFromTag(parent, childName, context, childAttrs, hasThemeOverride);
                    ViewGroup group = (ViewGroup)parent;
                    TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Include);
                    int id2 = a.getResourceId(0, -1);
                    int visibility = a.getInt(1, -1);
                    a.recycle();
                    ViewGroup.LayoutParams params = null;
                    try {
                        sIsInInclude = true;
                        params = group.generateLayoutParams(attrs);
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        sIsInInclude = false;
                    }
                    if (params == null) {
                        params = group.generateLayoutParams(childAttrs);
                    }
                    view.setLayoutParams(params);
                    thisInflater.rInflateChildren(childParser, view, childAttrs, true);
                    if (id2 != -1) {
                        view.setId(id2);
                    }
                    switch (visibility) {
                        case 0: {
                            view.setVisibility(0);
                            break;
                        }
                        case 1: {
                            view.setVisibility(4);
                            break;
                        }
                        case 2: {
                            view.setVisibility(8);
                        }
                    }
                    group.addView(view);
                }
            }
        } else {
            Bridge.getLog().error("broken", "<include /> can only be used inside of a ViewGroup", null, null);
        }
        LayoutInflater.consumeChildElements(parser);
    }

    @LayoutlibDelegate
    static void initPrecompiledViews(LayoutInflater thisInflater) {
        LayoutInflater_Delegate.initPrecompiledViews(thisInflater, false);
    }

    @LayoutlibDelegate
    static void initPrecompiledViews(LayoutInflater thisInflater, boolean enablePrecompiledViews) {
        thisInflater.initPrecompiledViews_Original(enablePrecompiledViews);
    }
}

