/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.InsetsController;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.function.Supplier;

public class InsetsSourceConsumer {
    protected final InsetsController mController;
    protected boolean mRequestedVisible;
    protected final InsetsState mState;
    protected final int mType;
    private static final String TAG = "InsetsSourceConsumer";
    private final Supplier<SurfaceControl.Transaction> mTransactionSupplier;
    private InsetsSourceControl mSourceControl;
    private boolean mHasWindowFocus;
    private Rect mPendingFrame;
    private Rect mPendingVisibleFrame;
    private boolean mIsAnimationPending;

    public InsetsSourceConsumer(int type, InsetsState state, Supplier<SurfaceControl.Transaction> transactionSupplier, InsetsController controller) {
        this.mType = type;
        this.mState = state;
        this.mTransactionSupplier = transactionSupplier;
        this.mController = controller;
        this.mRequestedVisible = InsetsState.getDefaultVisibility(type);
    }

    public void setControl(InsetsSourceControl control, int[] showTypes, int[] hideTypes) {
        if (this.mSourceControl == control) {
            return;
        }
        SurfaceControl oldLeash = this.mSourceControl != null ? this.mSourceControl.getLeash() : null;
        InsetsSourceControl lastControl = this.mSourceControl;
        this.mSourceControl = control;
        if (control != null) {
            // empty if block
        }
        if (this.mSourceControl == null) {
            this.mController.notifyControlRevoked(this);
            this.mState.getSource(this.getType()).setVisible(this.mController.getLastDispatchedState().getSource(this.getType()).isVisible());
            this.applyLocalVisibilityOverride();
        } else {
            boolean needAnimation;
            boolean requestedVisible = this.isRequestedVisibleAwaitingControl();
            boolean bl = needAnimation = requestedVisible != this.mState.getSource(this.mType).isVisible();
            if (control.getLeash() != null && (needAnimation || this.mIsAnimationPending)) {
                if (requestedVisible) {
                    showTypes[0] = showTypes[0] | InsetsState.toPublicType(this.getType());
                } else {
                    hideTypes[0] = hideTypes[0] | InsetsState.toPublicType(this.getType());
                }
                this.mIsAnimationPending = false;
            } else {
                if (needAnimation) {
                    this.mIsAnimationPending = true;
                }
                if (this.applyLocalVisibilityOverride()) {
                    this.mController.notifyVisibilityChanged();
                }
                SurfaceControl newLeash = this.mSourceControl.getLeash();
                if (oldLeash == null || newLeash == null || !oldLeash.isSameSurface(newLeash)) {
                    this.applyHiddenToControl();
                }
                if (!requestedVisible && !this.mIsAnimationPending) {
                    this.removeSurface();
                }
            }
        }
        if (lastControl != null) {
            lastControl.release(SurfaceControl::release);
        }
    }

    @VisibleForTesting
    public InsetsSourceControl getControl() {
        return this.mSourceControl;
    }

    protected boolean isRequestedVisibleAwaitingControl() {
        return this.isRequestedVisible();
    }

    int getType() {
        return this.mType;
    }

    @VisibleForTesting
    public void show(boolean fromIme) {
        this.setRequestedVisible(true);
    }

    @VisibleForTesting
    public void hide() {
        this.setRequestedVisible(false);
    }

    void hide(boolean animationFinished, int animationType) {
        this.hide();
    }

    public void onWindowFocusGained() {
        this.mHasWindowFocus = true;
    }

    public void onWindowFocusLost() {
        this.mHasWindowFocus = false;
    }

    boolean hasWindowFocus() {
        return this.mHasWindowFocus;
    }

    boolean applyLocalVisibilityOverride() {
        InsetsSource source = this.mState.peekSource(this.mType);
        boolean isVisible = source != null ? source.isVisible() : InsetsState.getDefaultVisibility(this.mType);
        boolean hasControl = this.mSourceControl != null;
        this.mController.updateCompatSysUiVisibility(this.mType, hasControl || source == null ? this.mRequestedVisible : isVisible, hasControl);
        if (!hasControl) {
            return false;
        }
        if (isVisible == this.mRequestedVisible) {
            return false;
        }
        this.mState.getSource(this.mType).setVisible(this.mRequestedVisible);
        return true;
    }

    @VisibleForTesting
    public boolean isRequestedVisible() {
        return this.mRequestedVisible;
    }

    @VisibleForTesting
    public int requestShow(boolean fromController) {
        return 0;
    }

    public void onPerceptible(boolean perceptible) {
    }

    void notifyHidden() {
    }

    public void removeSurface() {
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void updateSource(InsetsSource newSource, int animationType) {
        InsetsSource source = this.mState.peekSource(this.mType);
        if (source == null || animationType == -1 || source.getFrame().equals(newSource.getFrame())) {
            this.mPendingFrame = null;
            this.mPendingVisibleFrame = null;
            this.mState.addSource(newSource);
            return;
        }
        newSource = new InsetsSource(newSource);
        this.mPendingFrame = new Rect(newSource.getFrame());
        this.mPendingVisibleFrame = newSource.getVisibleFrame() != null ? new Rect(newSource.getVisibleFrame()) : null;
        newSource.setFrame(source.getFrame());
        newSource.setVisibleFrame(source.getVisibleFrame());
        this.mState.addSource(newSource);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean notifyAnimationFinished() {
        if (this.mPendingFrame != null) {
            InsetsSource source = this.mState.getSource(this.mType);
            source.setFrame(this.mPendingFrame);
            source.setVisibleFrame(this.mPendingVisibleFrame);
            this.mPendingFrame = null;
            this.mPendingVisibleFrame = null;
            return true;
        }
        return false;
    }

    protected void setRequestedVisible(boolean requestedVisible) {
        if (this.mRequestedVisible != requestedVisible) {
            this.mRequestedVisible = requestedVisible;
            this.mIsAnimationPending = false;
        }
        if (this.applyLocalVisibilityOverride()) {
            this.mController.notifyVisibilityChanged();
        }
    }

    private void applyHiddenToControl() {
        if (this.mSourceControl == null || this.mSourceControl.getLeash() == null) {
            return;
        }
        SurfaceControl.Transaction t = this.mTransactionSupplier.get();
        if (this.mRequestedVisible) {
            t.show(this.mSourceControl.getLeash());
        } else {
            t.hide(this.mSourceControl.getLeash());
        }
        t.apply();
        this.onPerceptible(this.mRequestedVisible);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ShowResult {
        public static final int SHOW_IMMEDIATELY = 0;
        public static final int IME_SHOW_DELAYED = 1;
        public static final int IME_SHOW_FAILED = 2;
    }
}

