/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public abstract class InputEventSender {
    private static final String TAG = "InputEventSender";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private long mSenderPtr;
    private InputChannel mInputChannel;
    private MessageQueue mMessageQueue;

    private static long nativeInit(WeakReference<InputEventSender> weakReference, InputChannel inputChannel, MessageQueue messageQueue) {
        return OverrideMethod.invokeL("android.view.InputEventSender#nativeInit(Ljava/lang/ref/WeakReference;Landroid/view/InputChannel;Landroid/os/MessageQueue;)J", true, null);
    }

    private static void nativeDispose(long l) {
        OverrideMethod.invokeV("android.view.InputEventSender#nativeDispose(J)V", true, null);
    }

    private static boolean nativeSendKeyEvent(long l, int n, KeyEvent keyEvent) {
        return OverrideMethod.invokeI("android.view.InputEventSender#nativeSendKeyEvent(JILandroid/view/KeyEvent;)Z", true, null) != 0;
    }

    private static boolean nativeSendMotionEvent(long l, int n, MotionEvent motionEvent) {
        return OverrideMethod.invokeI("android.view.InputEventSender#nativeSendMotionEvent(JILandroid/view/MotionEvent;)Z", true, null) != 0;
    }

    public InputEventSender(InputChannel inputChannel, Looper looper) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mInputChannel = inputChannel;
        this.mMessageQueue = looper.getQueue();
        this.mSenderPtr = InputEventSender.nativeInit(new WeakReference<InputEventSender>(this), inputChannel, this.mMessageQueue);
        this.mCloseGuard.open("dispose");
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        this.dispose(false);
    }

    private void dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mSenderPtr != 0L) {
            InputEventSender.nativeDispose(this.mSenderPtr);
            this.mSenderPtr = 0L;
        }
        this.mInputChannel = null;
        this.mMessageQueue = null;
    }

    public void onInputEventFinished(int seq, boolean handled) {
    }

    public boolean sendInputEvent(int seq, InputEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (this.mSenderPtr == 0L) {
            Log.w(TAG, "Attempted to send an input event but the input event sender has already been disposed.");
            return false;
        }
        if (event instanceof KeyEvent) {
            return InputEventSender.nativeSendKeyEvent(this.mSenderPtr, seq, (KeyEvent)event);
        }
        return InputEventSender.nativeSendMotionEvent(this.mSenderPtr, seq, (MotionEvent)event);
    }

    @UnsupportedAppUsage
    private void dispatchInputEventFinished(int seq, boolean handled) {
        this.onInputEventFinished(seq, handled);
    }
}

