/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.os.incremental.IncrementalManager;
import android.os.incremental.V4Signature;
import android.util.Pair;
import android.util.apk.ApkSigningBlockUtils;
import android.util.apk.SignatureNotFoundException;
import android.util.apk.VerbatimX509Certificate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class ApkSignatureSchemeV4Verifier {
    public static VerifiedSigner extractCertificates(String apkFile) throws SignatureNotFoundException, SecurityException {
        V4Signature.SigningInfo signingInfo;
        V4Signature.HashingInfo hashingInfo;
        File apk = new File(apkFile);
        byte[] signatureBytes = IncrementalManager.unsafeGetFileSignature(apk.getAbsolutePath());
        if (signatureBytes == null || signatureBytes.length == 0) {
            throw new SignatureNotFoundException("Failed to obtain signature bytes from IncFS.");
        }
        try {
            V4Signature signature = V4Signature.readFrom(signatureBytes);
            if (!signature.isVersionSupported()) {
                throw new SecurityException("v4 signature version " + signature.version + " is not supported");
            }
            hashingInfo = V4Signature.HashingInfo.fromByteArray(signature.hashingInfo);
            signingInfo = V4Signature.SigningInfo.fromByteArray(signature.signingInfo);
        }
        catch (IOException e) {
            throw new SignatureNotFoundException("Failed to read V4 signature.", e);
        }
        byte[] signedData = V4Signature.getSigningData(apk.length(), hashingInfo, signingInfo);
        return ApkSignatureSchemeV4Verifier.verifySigner(signingInfo, signedData);
    }

    private static VerifiedSigner verifySigner(V4Signature.SigningInfo signingInfo, byte[] signedData) throws SecurityException {
        X509Certificate certificate;
        CertificateFactory certFactory;
        boolean sigVerified;
        if (!ApkSigningBlockUtils.isSupportedSignatureAlgorithm(signingInfo.signatureAlgorithmId)) {
            throw new SecurityException("No supported signatures found");
        }
        int signatureAlgorithmId = signingInfo.signatureAlgorithmId;
        byte[] signatureBytes = signingInfo.signature;
        byte[] publicKeyBytes = signingInfo.publicKey;
        byte[] encodedCert = signingInfo.certificate;
        String keyAlgorithm = ApkSigningBlockUtils.getSignatureAlgorithmJcaKeyAlgorithm(signatureAlgorithmId);
        Pair<String, ? extends AlgorithmParameterSpec> signatureAlgorithmParams = ApkSigningBlockUtils.getSignatureAlgorithmJcaSignatureAlgorithm(signatureAlgorithmId);
        String jcaSignatureAlgorithm = (String)signatureAlgorithmParams.first;
        AlgorithmParameterSpec jcaSignatureAlgorithmParams = (AlgorithmParameterSpec)signatureAlgorithmParams.second;
        try {
            PublicKey publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
            sig.initVerify(publicKey);
            if (jcaSignatureAlgorithmParams != null) {
                sig.setParameter(jcaSignatureAlgorithmParams);
            }
            sig.update(signedData);
            sigVerified = sig.verify(signatureBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new SecurityException("Failed to verify " + jcaSignatureAlgorithm + " signature", e);
        }
        if (!sigVerified) {
            throw new SecurityException(jcaSignatureAlgorithm + " signature did not verify");
        }
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        try {
            certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedCert));
        }
        catch (CertificateException e) {
            throw new SecurityException("Failed to decode certificate", e);
        }
        certificate = new VerbatimX509Certificate(certificate, encodedCert);
        byte[] certificatePublicKeyBytes = certificate.getPublicKey().getEncoded();
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            throw new SecurityException("Public key mismatch between certificate and signature record");
        }
        return new VerifiedSigner(new Certificate[]{certificate}, signingInfo.apkDigest);
    }

    public static class VerifiedSigner {
        public final Certificate[] certs;
        public byte[] apkDigest;

        public VerifiedSigner(Certificate[] certs, byte[] apkDigest) {
            this.certs = certs;
            this.apkDigest = apkDigest;
        }
    }
}

