/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.Notification;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.metrics.LogMaker;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import com.android.internal.logging.InstanceId;
import java.util.ArrayList;

public class StatusBarNotification
implements Parcelable {
    static final int MAX_LOG_TAG_LENGTH = 36;
    @UnsupportedAppUsage
    private final String pkg;
    @UnsupportedAppUsage
    private final int id;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final String tag;
    private final String key;
    private String groupKey;
    private String overrideGroupKey;
    @UnsupportedAppUsage
    private final int uid;
    private final String opPkg;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final int initialPid;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final Notification notification;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final UserHandle user;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final long postTime;
    private InstanceId mInstanceId;
    private Context mContext;
    public static final Parcelable.Creator<StatusBarNotification> CREATOR = new Parcelable.Creator<StatusBarNotification>(){

        @Override
        public StatusBarNotification createFromParcel(Parcel parcel) {
            return new StatusBarNotification(parcel);
        }

        public StatusBarNotification[] newArray(int size) {
            return new StatusBarNotification[size];
        }
    };

    public StatusBarNotification(String pkg, String opPkg, int id2, String tag, int uid, int initialPid, Notification notification, UserHandle user, String overrideGroupKey, long postTime) {
        if (pkg == null) {
            throw new NullPointerException();
        }
        if (notification == null) {
            throw new NullPointerException();
        }
        this.pkg = pkg;
        this.opPkg = opPkg;
        this.id = id2;
        this.tag = tag;
        this.uid = uid;
        this.initialPid = initialPid;
        this.notification = notification;
        this.user = user;
        this.postTime = postTime;
        this.overrideGroupKey = overrideGroupKey;
        this.key = this.key();
        this.groupKey = this.groupKey();
    }

    @Deprecated
    public StatusBarNotification(String pkg, String opPkg, int id2, String tag, int uid, int initialPid, int score, Notification notification, UserHandle user, long postTime) {
        if (pkg == null) {
            throw new NullPointerException();
        }
        if (notification == null) {
            throw new NullPointerException();
        }
        this.pkg = pkg;
        this.opPkg = opPkg;
        this.id = id2;
        this.tag = tag;
        this.uid = uid;
        this.initialPid = initialPid;
        this.notification = notification;
        this.user = user;
        this.postTime = postTime;
        this.key = this.key();
        this.groupKey = this.groupKey();
    }

    public StatusBarNotification(Parcel in) {
        this.pkg = in.readString();
        this.opPkg = in.readString();
        this.id = in.readInt();
        this.tag = in.readInt() != 0 ? in.readString() : null;
        this.uid = in.readInt();
        this.initialPid = in.readInt();
        this.notification = new Notification(in);
        this.user = UserHandle.readFromParcel(in);
        this.postTime = in.readLong();
        if (in.readInt() != 0) {
            this.overrideGroupKey = in.readString();
        }
        if (in.readInt() != 0) {
            this.mInstanceId = InstanceId.CREATOR.createFromParcel(in);
        }
        this.key = this.key();
        this.groupKey = this.groupKey();
    }

    private String key() {
        String sbnKey = this.user.getIdentifier() + "|" + this.pkg + "|" + this.id + "|" + this.tag + "|" + this.uid;
        if (this.overrideGroupKey != null && this.getNotification().isGroupSummary()) {
            sbnKey = sbnKey + "|" + this.overrideGroupKey;
        }
        return sbnKey;
    }

    private String groupKey() {
        if (this.overrideGroupKey != null) {
            return this.user.getIdentifier() + "|" + this.pkg + "|g:" + this.overrideGroupKey;
        }
        String group = this.getNotification().getGroup();
        String sortKey = this.getNotification().getSortKey();
        if (group == null && sortKey == null) {
            return this.key;
        }
        return this.user.getIdentifier() + "|" + this.pkg + "|" + (group == null ? "c:" + this.notification.getChannelId() : "g:" + group);
    }

    public boolean isGroup() {
        return this.overrideGroupKey != null || this.isAppGroup();
    }

    public boolean isAppGroup() {
        return this.getNotification().getGroup() != null || this.getNotification().getSortKey() != null;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.pkg);
        out.writeString(this.opPkg);
        out.writeInt(this.id);
        if (this.tag != null) {
            out.writeInt(1);
            out.writeString(this.tag);
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.uid);
        out.writeInt(this.initialPid);
        this.notification.writeToParcel(out, flags);
        this.user.writeToParcel(out, flags);
        out.writeLong(this.postTime);
        if (this.overrideGroupKey != null) {
            out.writeInt(1);
            out.writeString(this.overrideGroupKey);
        } else {
            out.writeInt(0);
        }
        if (this.mInstanceId != null) {
            out.writeInt(1);
            this.mInstanceId.writeToParcel(out, flags);
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public StatusBarNotification cloneLight() {
        Notification no = new Notification();
        this.notification.cloneInto(no, false);
        return this.cloneShallow(no);
    }

    public StatusBarNotification clone() {
        return this.cloneShallow(this.notification.clone());
    }

    StatusBarNotification cloneShallow(Notification notification) {
        StatusBarNotification result = new StatusBarNotification(this.pkg, this.opPkg, this.id, this.tag, this.uid, this.initialPid, notification, this.user, this.overrideGroupKey, this.postTime);
        result.setInstanceId(this.mInstanceId);
        return result;
    }

    public String toString() {
        return String.format("StatusBarNotification(pkg=%s user=%s id=%d tag=%s key=%s: %s)", this.pkg, this.user, this.id, this.tag, this.key, this.notification);
    }

    public boolean isOngoing() {
        return (this.notification.flags & 2) != 0;
    }

    public boolean isClearable() {
        return (this.notification.flags & 2) == 0 && (this.notification.flags & 0x20) == 0;
    }

    @Deprecated
    public int getUserId() {
        return this.user.getIdentifier();
    }

    public int getNormalizedUserId() {
        int userId = this.getUserId();
        if (userId == -1) {
            userId = 0;
        }
        return userId;
    }

    public String getPackageName() {
        return this.pkg;
    }

    public int getId() {
        return this.id;
    }

    public String getTag() {
        return this.tag;
    }

    public int getUid() {
        return this.uid;
    }

    public String getOpPkg() {
        return this.opPkg;
    }

    @UnsupportedAppUsage
    public int getInitialPid() {
        return this.initialPid;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public UserHandle getUser() {
        return this.user;
    }

    public long getPostTime() {
        return this.postTime;
    }

    public String getKey() {
        return this.key;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public String getGroup() {
        if (this.overrideGroupKey != null) {
            return this.overrideGroupKey;
        }
        return this.getNotification().getGroup();
    }

    public void setOverrideGroupKey(String overrideGroupKey) {
        this.overrideGroupKey = overrideGroupKey;
        this.groupKey = this.groupKey();
    }

    public String getOverrideGroupKey() {
        return this.overrideGroupKey;
    }

    public void clearPackageContext() {
        this.mContext = null;
    }

    public InstanceId getInstanceId() {
        return this.mInstanceId;
    }

    public void setInstanceId(InstanceId instanceId) {
        this.mInstanceId = instanceId;
    }

    @UnsupportedAppUsage
    public Context getPackageContext(Context context) {
        if (this.mContext == null) {
            try {
                ApplicationInfo ai = context.getPackageManager().getApplicationInfoAsUser(this.pkg, 8192, this.getUserId());
                this.mContext = context.createApplicationContext(ai, 4);
            }
            catch (PackageManager.NameNotFoundException e) {
                this.mContext = null;
            }
        }
        if (this.mContext == null) {
            this.mContext = context;
        }
        return this.mContext;
    }

    public LogMaker getLogMaker() {
        LogMaker logMaker = new LogMaker(0).setPackageName(this.getPackageName()).addTaggedData(796, this.getId()).addTaggedData(797, this.getTag()).addTaggedData(857, this.getChannelIdLogTag()).addTaggedData(946, this.getGroupLogTag()).addTaggedData(947, this.getNotification().isGroupSummary() ? 1 : 0).addTaggedData(1641, this.getNotification().category);
        if (this.getNotification().extras != null) {
            ArrayList people;
            String template = this.getNotification().extras.getString("android.template");
            if (template != null && !template.isEmpty()) {
                logMaker.addTaggedData(1745, template.hashCode());
            }
            if ((people = this.getNotification().extras.getParcelableArrayList("android.people.list")) != null && !people.isEmpty()) {
                logMaker.addTaggedData(1744, people.size());
            }
        }
        return logMaker;
    }

    public String getShortcutId() {
        return this.getNotification().getShortcutId();
    }

    public String getGroupLogTag() {
        return this.shortenTag(this.getGroup());
    }

    public String getChannelIdLogTag() {
        if (this.notification.getChannelId() == null) {
            return null;
        }
        return this.shortenTag(this.notification.getChannelId());
    }

    private String shortenTag(String logTag) {
        if (logTag == null || logTag.length() <= 36) {
            return logTag;
        }
        String hash = Integer.toHexString(logTag.hashCode());
        return logTag.substring(0, 36 - hash.length() - 1) + "-" + hash;
    }
}

